/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.eo;

import com.suncode.plugin.P0045Tools;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.assignment.AssignmentService;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@ScheduledTask
public class P0045PlannedTaskVerifyMaterialPlanner {
    public static Logger log = Logger.getLogger(P0045PlannedTaskVerifyMaterialPlanner.class);
    private static ArrayList<String> columns = new ArrayList();
    private static String _separator = ";";

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("planned-task-verify-material-planner")).name("Weryfikacja planistow materialowych")).description("Weryfikacja planistow materialowych")).cancelable().parameter().id("xlsFilePath").name("Sciezka pliku XLS").description("Sciezka pliku XLS").type((Type)Types.STRING).create()).parameter().id("daysToClose").name("Liczba dni do zamkniecia zadania").description("Liczba dni do zamkniecia zadania").type((Type)Types.INTEGER).create();
    }

    public void execute(@Param(value="xlsFilePath") String xlsFilePath, @Param(value="daysToClose") int daysToClose) {
        try {
            log.debug((Object)"Starting verification of tasks with empty material planner...");
            ArrayList<Object> allTasksToUpdate = new ArrayList();
            allTasksToUpdate = P0045Tools.findOpenActivitiesForId("sub_logi", "logistics");
            ActivityService as = ServiceFactory.getActivityService();
            ActivityFinder af = FinderFactory.getActivityFinder();
            UserFinder uf = FinderFactory.getUserFinder();
            AssignmentService ass = (AssignmentService)SpringContext.getBean(AssignmentService.class);
            columns.addAll(Arrays.asList("Item", "Description", "Item Sigs", "Item Signal", "Vendor", "Vendor name", "Lead Time", "Sourcing Responsible Code", "Sourcing Responsible Person", "Purchase Price", "Purchase Currency", "Planning Responsible Code", "Planning Responsible Name", "Stock", "Stock Value"));
            ArrayList<Map<String, String>> data = P0045Tools.importDataFromItemTable(columns);
            log.debug((Object)("Rows imported:" + data.size()));
            Map<String, Object> ctx = new HashMap();
            String assignments = "";
            String newPerson = "";
            String logisticsCode = "";
            String main_process_id = "";
            Map returnedRecord = new HashMap();
            Date created = null;
            Date checkDate = null;
            Date today = new Date();
            log.debug((Object)("Tasks at logistics: " + allTasksToUpdate.size()));
            block2: for (Activity activity : allTasksToUpdate) {
                String[] new_item_no;
                log.debug((Object)("Processing: " + activity.getActivityId()));
                assignments = "";
                StringBuilder responsible_logistics = new StringBuilder();
                StringBuilder responsible_logistics_name = new StringBuilder();
                logisticsCode = "";
                created = activity.getCreatedTime();
                checkDate = this.substractDate(today, daysToClose);
                ctx = as.getActivityContext(activity.getProcessId(), activity.getActivityId());
                main_process_id = (String)ctx.get("main_process_id");
                assignments = (String)ctx.get("logistic_assignments");
                log.debug((Object)activity.getResourceId());
                log.debug((Object)assignments);
                if (!StringUtils.isBlank((CharSequence)activity.getResourceId()) || !StringUtils.isBlank((CharSequence)assignments) && !assignments.contains("admin")) continue;
                log.debug((Object)"Checking items...");
                for (String item : new_item_no = ctx.get("new_item_no").toString().split(";")) {
                    log.debug((Object)item);
                    returnedRecord = data.stream().filter(oneMap -> item.toLowerCase().equals(((String)oneMap.get("Item")).trim().toLowerCase())).findFirst().orElse(null);
                    if (returnedRecord == null || returnedRecord.isEmpty()) continue block2;
                    logisticsCode = (String)returnedRecord.get("Planning Responsible Code");
                    if (StringUtils.isBlank((CharSequence)logisticsCode)) {
                        logisticsCode = "X";
                    }
                    User logisticsUser = (User)uf.findOneByProperty("number", (Object)logisticsCode, new String[0]);
                    log.debug((Object)logisticsUser);
                    if (logisticsUser != null) {
                        responsible_logistics.append(logisticsUser.getUserName()).append(_separator);
                        responsible_logistics_name.append(logisticsUser.getFullName()).append(_separator);
                        continue;
                    }
                    if (checkDate.compareTo(created) < 0) continue block2;
                    log.debug((Object)"Check date true - rejecting item");
                    ctx.put("akcja", "reject");
                    String sError = "Item " + item + " has been rejected due to lack of material planner.";
                    List wfActivities = af.findOpenedActivities(main_process_id);
                    CommentService cs = ServiceFactory.getCommentService();
                    Date dDate = new Date();
                    Long lTime = dDate.getTime();
                    Comment comment = new Comment();
                    comment.setProcessId(main_process_id);
                    comment.setUserId("admin");
                    comment.setComment(sError);
                    comment.setTimestamp(lTime);
                    if (wfActivities.size() > 0) {
                        comment.setActivityId(((Activity)wfActivities.get(0)).getActivityId());
                        cs.createComment(comment);
                    }
                    Comment commentSubProcess = new Comment();
                    commentSubProcess.setProcessId(activity.getProcessId());
                    commentSubProcess.setUserId("admin");
                    commentSubProcess.setComment(sError);
                    commentSubProcess.setTimestamp(lTime);
                    commentSubProcess.setActivityId(activity.getActivityId());
                    cs.createComment(commentSubProcess);
                    P0045Tools.acceptActivity(activity.getProcessId(), activity.getActivityId(), ctx, "reject");
                }
                ctx.put("responsible_logistics_login", P0045Tools.removeLastChar(responsible_logistics.toString()));
                ctx.put("responsible_logistics", P0045Tools.removeLastChar(responsible_logistics_name.toString()));
                log.debug((Object)"Change assignment");
                ass.assignActivityToUser(activity.getProcessId(), activity.getActivityId(), P0045Tools.removeLastChar(responsible_logistics.toString()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error when processing items...");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private Date substractDate(Date date, int daysToSubstract) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, daysToSubstract * -1);
        return cal.getTime();
    }
}

