/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.eo;

import com.plusmpm.CUF.util.extension.InternalDataBase;
import com.suncode.plugin.P0045Tools;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessFinder;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@ScheduledTask
public class P0045PlannedTaskUpdateEoProcess {
    public static Logger log = Logger.getLogger(P0045PlannedTaskUpdateEoProcess.class);

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("planned-task-update-eo-process")).name("Aktualizacja procesu EO")).description("Aktualizacja procesu EO")).cancelable();
    }

    public void execute() {
        log.trace((Object)"*************** eo.P0045PlannedTaskUpdateEoProcess ********");
        try {
            HashMap hmAdSearchVar = new HashMap();
            String taskName = "localization_bufer";
            ArrayList<String> activeProcVar = new ArrayList<String>();
            activeProcVar.add("localization_process_id");
            List<Map<String, Object>> processesOnLocalization = P0045PlannedTaskUpdateEoProcess.findProcessOrTask("proces_eo", taskName, activeProcVar, true);
            if (processesOnLocalization != null) {
                activeProcVar = new ArrayList();
                for (Map<String, Object> oneProcess : processesOnLocalization) {
                    List<Map<String, Object>> localizationProcesses;
                    String localizationProcessId = (String)oneProcess.get("localization_process_id");
                    boolean isLocalizationRunning = false;
                    if (localizationProcessId.compareTo("") != 0 && (localizationProcesses = P0045PlannedTaskUpdateEoProcess.findProcessOrTask("localization", "", activeProcVar, true)) != null && localizationProcesses.size() != 0) {
                        for (Map<String, Object> oneLocalization : localizationProcesses) {
                            String string = (String)oneLocalization.get("processId");
                            if (string.compareTo(localizationProcessId) != 0) continue;
                            isLocalizationRunning = true;
                            break;
                        }
                    }
                    String eoProcessId = (String)oneProcess.get("processId");
                    String eoActivityId = (String)oneProcess.get("activityId");
                    if (!isLocalizationRunning) {
                        P0045PlannedTaskUpdateEoProcess.closeBuforTask(eoProcessId, eoActivityId, "localization");
                        continue;
                    }
                    log.debug((Object)"Istnieje niezamkni\u0119ty process Localization dla procesu EO o id: ".concat(eoProcessId));
                }
            }
            taskName = "Scrap and Rework bufor";
            activeProcVar = new ArrayList();
            activeProcVar.add("scrap_process_id");
            activeProcVar.add("rework_process_id");
            List<Map<String, Object>> processesOnScrapOrRework = P0045PlannedTaskUpdateEoProcess.findProcessOrTask("proces_eo", taskName, activeProcVar, true);
            if (processesOnScrapOrRework != null) {
                hmAdSearchVar = new HashMap();
                activeProcVar = new ArrayList();
                for (Map<String, Object> oneProcess : processesOnScrapOrRework) {
                    List<Map<String, Object>> scrapProcesses;
                    String scrapProcessId;
                    List<Map<String, Object>> reworkProcesses;
                    boolean isReworkOrScrapRunning = false;
                    String reworkProcessId = (String)oneProcess.get("rework_process_id");
                    if (reworkProcessId.compareTo("") != 0 && (reworkProcesses = P0045PlannedTaskUpdateEoProcess.findProcessOrTask("rework", "", activeProcVar, true)) != null && reworkProcesses.size() != 0) {
                        for (Map map : reworkProcesses) {
                            String openProcessId = (String)map.get("processId");
                            if (openProcessId.compareTo(reworkProcessId) != 0) continue;
                            isReworkOrScrapRunning = true;
                            break;
                        }
                    }
                    if ((scrapProcessId = (String)oneProcess.get("scrap_process_id")).compareTo("") != 0 && (scrapProcesses = P0045PlannedTaskUpdateEoProcess.findProcessOrTask("sa", "", activeProcVar, true)) != null && scrapProcesses.size() != 0) {
                        for (Map<String, Object> oneScrap : scrapProcesses) {
                            String openProcessId = (String)oneScrap.get("processId");
                            if (openProcessId.compareTo(scrapProcessId) != 0) continue;
                            isReworkOrScrapRunning = true;
                            break;
                        }
                    }
                    String eoProcessId = (String)oneProcess.get("processId");
                    String string = (String)oneProcess.get("activityId");
                    if (!isReworkOrScrapRunning) {
                        P0045PlannedTaskUpdateEoProcess.closeBuforTask(eoProcessId, string, "scrap_rework");
                        continue;
                    }
                    log.debug((Object)"Istnieje niezamkni\u0119ty process Scrap albo Rework dla procesu EO o id: ".concat(eoProcessId));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Wyst\u0105pi\u0142 b\u0142\u0105d podczas przetwarzania zada\u0144 buforowych proces\u00f3w EO.");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.trace((Object)"*************** eo.P0045PlannedTaskUpdateEoProcess finished********");
    }

    private static List<Map<String, Object>> findProcessOrTask(String procDefId, String taskName, ArrayList<String> activeProcVar, Boolean onlyActive) throws Exception {
        ArrayList<Map<String, Object>> results = null;
        results = new ArrayList<Map<String, Object>>();
        ProcessService ps = ServiceFactory.getProcessService();
        ActivityService as = ServiceFactory.getActivityService();
        ProcessFinder pf = FinderFactory.getProcessFinder();
        ActivityFinder af = FinderFactory.getActivityFinder();
        List allProcessesByDefId = pf.findByProcessDefinitionId(procDefId);
        block2: for (Process oneProcess : allProcessesByDefId) {
            List allOpenAct = af.findOpenedActivities(oneProcess.getProcessId());
            for (Activity activity : allOpenAct) {
                if (activity.getActivityId().contains(taskName)) {
                    Map activityContext = as.getActivityContext(activity.getProcessId(), activity.getActivityId());
                    results.add(activityContext);
                    continue block2;
                }
                if (!StringUtils.isBlank((CharSequence)taskName)) continue;
                Map processContext = ps.getProcessContext(activity.getProcessId());
                results.add(processContext);
                continue block2;
            }
        }
        log.debug((Object)("Ilosc znalezionych proces\u00f3w: " + results.size()));
        return results;
    }

    private static void closeBuforTask(String processId, String activityId, String whichBuffer) throws Exception {
        log.debug((Object)"Zamykanie zadania buforowego o ID: ".concat(activityId));
        ActivityService as = ServiceFactory.getActivityService();
        Map activityContext = as.getActivityContext(processId, activityId);
        String itemStatus = (String)activityContext.get("item_status");
        String akcja = "";
        if (whichBuffer.compareTo("localization") == 0) {
            akcja = "estimate_costs";
            akcja = itemStatus.replace("Localization", "Waiting for implementation");
        } else if (whichBuffer.compareTo("scrap_rework") == 0) {
            akcja = "estimate_costs_after_scrap_and_rework";
            itemStatus = itemStatus.replace("Scrap", "Waiting for implementation").replace("Rework", "Waiting for implementation");
        } else {
            throw new Exception("Niekre\u015blona akcja, nie mo\u017cna kontynuowa\u0107.");
        }
        activityContext.put("akcja", akcja);
        activityContext.put("item_status", itemStatus);
        P0045PlannedTaskUpdateEoProcess.getFinishedProcessCost(whichBuffer, activityContext);
        as.setActivityContext(processId, activityId, activityContext);
        P0045Tools.acceptActivity(processId, activityId, activityContext, akcja);
        log.debug((Object)"Zadanie buforowe zamkni\u0119te.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getFinishedProcessCost(String whichBuffer, Map<String, Object> activityContext) {
        Connection con = null;
        try {
            con = InternalDataBase.connect();
            String query = "";
            String localizationProcessId = (String)activityContext.get("localization_process_id");
            String scrapProcessId = (String)activityContext.get("scrap_process_id");
            String reworkProcessId = (String)activityContext.get("rework_process_id");
            if (whichBuffer.compareTo("localization") == 0) {
                if (localizationProcessId.compareTo("") != 0) {
                    // empty if block
                }
            } else if (whichBuffer.compareTo("scrap_rework") == 0) {
                String value;
                ArrayList listOfData;
                if (reworkProcessId.compareTo("") != 0) {
                    // empty if block
                }
                if (scrapProcessId.compareTo("") != 0 && (listOfData = InternalDataBase.executeQuery((Connection)con, (String)(query = "SELECT DISTINCT Grand_Total as processCost FROM pm_idx_sa WHERE processId='".concat(scrapProcessId).concat("'")))) != null && listOfData.size() == 1 && (value = ((String)((HashMap)listOfData.get(0)).get("processCost")).replace(",", ".")).compareTo("") != 0) {
                    activityContext.put("scrap_cost", Double.valueOf(value));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (con != null) {
                try {
                    InternalDataBase.distconnect((Connection)con);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

