/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.eo;

import com.suncode.plugin.P0045Tools;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@ScheduledTask
public class P0045PlannedTaskAcceptToDo {
    public static Logger log = Logger.getLogger(P0045PlannedTaskAcceptToDo.class);
    private static ArrayList<String> columns = new ArrayList();
    private static String _separator = ";";

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("planned-task-close-todo")).name("Akceptacja zada\u0144 TODO-DONE")).description("Akceptacja zada\u0144 TODO-DONE")).cancelable().parameter().id("xlsFilePath").name("\u015acie\u017cka do XLS").description("\u015acie\u017cka do XLS").type((Type)Types.STRING).create();
    }

    public void execute(@Param(value="xlsFilePath") String xlsFilePath) {
        log.debug((Object)"closeToDoTasks starting...");
        ArrayList allTasksToUpdate = new ArrayList();
        ArrayList<Object> allTasksDone = new ArrayList();
        ArrayList<Object> allTasksToDo = new ArrayList();
        ActivityService as = ServiceFactory.getActivityService();
        allTasksToDo = P0045Tools.findOpenActivitiesForId("eo", "sourcing_localization_to_do");
        allTasksDone = P0045Tools.findOpenActivitiesForId("eo", "sourcing_localization_done");
        allTasksToUpdate.addAll(allTasksToDo);
        allTasksToUpdate.addAll(allTasksDone);
        columns.addAll(Arrays.asList("Item", "Item Signal", "Description", "Item Sigs", "Item Signal", "Vendor", "Vendor name", "Lead Time", "Sourcing Responsible Code", "Sourcing Responsible Person", "Purchase Price", "Purchase Currency", "Planning Responsible Code", "Planning Responsible Name", "Stock", "Stock Value"));
        ArrayList<Map<String, String>> data = P0045Tools.importDataFromItemTable(columns);
        log.debug((Object)("Rows imported:" + data.size()));
        Map<String, Object> activityCtx = new HashMap();
        block2: for (Activity oneAct : allTasksToUpdate) {
            log.debug((Object)("Analysis for task: " + oneAct.getActivityId()));
            activityCtx = as.getActivityContext(oneAct.getProcessId(), oneAct.getActivityId());
            String itemNo = (String)activityCtx.get("new_item_no");
            String sigs = (String)activityCtx.get("sigs");
            String vendorName = (String)activityCtx.get("vendor_name");
            String vendorNumber = (String)activityCtx.get("vendor_no");
            String responsibles = (String)activityCtx.get("responsible_sourcing");
            String[] tItemNo = itemNo.split(";", -1);
            String[] tSigs = sigs.split(";", -1);
            String[] tVendorName = vendorName.split(";", -1);
            String[] tVendorNumber = vendorNumber.split(";", -1);
            String[] tResponsibles = responsibles.split(";", -1);
            Map oneResult = new HashMap();
            int x = 0;
            for (String item : tItemNo) {
                try {
                    log.debug((Object)"XLS DATA");
                    oneResult = data.stream().filter(oneMap -> item.equals(((String)oneMap.get("Item")).trim())).findFirst().orElse(null);
                    if (((String)oneResult.get("Item Signal")).compareTo("GN1") == 0 || ((String)oneResult.get("Item Signal")).compareTo("OSI") == 0 || ((String)oneResult.get("Item Signal")).compareTo("LNI") == 0) continue block2;
                    tSigs[x] = (String)oneResult.get("Item Sigs");
                    tVendorName[x] = (String)oneResult.get("Vendor name");
                    tVendorNumber[x] = (String)oneResult.get("Vendor");
                    tResponsibles[x] = (String)oneResult.get("Sourcing Responsible Person");
                }
                catch (NullPointerException e) {
                    log.debug((Object)("Item " + item + " not found in XLS data..."));
                    ++x;
                    continue;
                }
                ++x;
            }
            for (int i = 0; i < tSigs.length; ++i) {
                if (!StringUtils.isBlank((CharSequence)tSigs[i]) && !StringUtils.isBlank((CharSequence)tVendorName[i]) && !StringUtils.isBlank((CharSequence)tVendorNumber[i]) && !StringUtils.isBlank((CharSequence)tResponsibles[i])) continue;
                log.warn((Object)"One of fields (Sigs, vendor name, vendor number, responsible) is blank. Continue... ");
                continue block2;
            }
            log.debug((Object)"Approving task");
            activityCtx.put("sigs", this.getArrayVariableString(tSigs));
            activityCtx.put("vendor_name", this.getArrayVariableString(tVendorName));
            activityCtx.put("vendor_no", this.getArrayVariableString(tVendorNumber));
            activityCtx.put("responsible_sourcing", this.getArrayVariableString(tResponsibles));
            activityCtx.put("akcja", "action");
            P0045Tools.acceptActivity(oneAct.getProcessId(), oneAct.getActivityId(), activityCtx, "confirm");
        }
    }

    private String getArrayVariableString(String[] tab) {
        String result = "";
        for (String item : tab) {
            result = result.concat(item).concat(";");
        }
        if (result.endsWith(";")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

