/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.eo;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.suncode.plugin.categories.Categories;
import com.suncode.plugin.eo.DynamicTableColumns;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.util.ProcessBuilderDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

@Application
public class P0045GenerateScrapAndReworkProcesses {
    public static Logger log = Logger.getLogger(P0045GenerateScrapAndReworkProcesses.class);

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("generateScrapAndReworkProcesses")).name("Generate Scrap And Rework process")).icon((Icon)SilkIconPack.APPLICATION_CASCADE)).description("Generate Scrap And Rework process")).category(new Category[]{Categories.CARGOTEC})).parameter().id("processId").name("processId").description("processId").type((Type)Types.STRING).create()).parameter().id("activityId").name("activityId").description("activityId").type((Type)Types.STRING).create();
    }

    public static void execute(@Param(value="processId") String processId, @Param(value="activityId") String activityId, ActivityContextMap activityCtxMap) throws Exception {
        Map tableRows;
        log.trace((Object)"*************** eo.P0045GenerateScrapAndReworkProcesses ********");
        String[] COL_IDS = DynamicTableColumns.getColumns();
        String sProcessId = processId;
        String sActivityId = activityId;
        ProcessService ps = ServiceFactory.getProcessService();
        ActivityService as = ServiceFactory.getActivityService();
        ActivityFinder af = FinderFactory.getActivityFinder();
        Map processContext = ps.getProcessContext(sProcessId);
        List listOfRows = DynamicTableFunctions.convertFromMapToListOfMaps((Map)processContext, (String[])COL_IDS);
        ArrayList<Map> rowsForScrap = new ArrayList<Map>();
        ArrayList<Map> rowsForRework = new ArrayList<Map>();
        for (Map oneRow : listOfRows) {
            String decision = (String)oneRow.get("decision");
            if (decision.compareTo("") == 0 || decision.compareTo("No issue") == 0) {
                oneRow.put("item_status", "Waiting for implementation");
                continue;
            }
            if (decision.compareTo("Scrap") == 0) {
                oneRow.put("item_status", "Scrap");
                rowsForScrap.add(oneRow);
                continue;
            }
            if (decision.compareTo("Rework") != 0) continue;
            oneRow.put("item_status", "Rework");
            rowsForRework.add(oneRow);
        }
        if (rowsForScrap.size() > 0) {
            tableRows = DynamicTableFunctions.convertFromListOfMapsToMap(rowsForScrap, (String[])COL_IDS);
            String scrapProcessId = P0045GenerateScrapAndReworkProcesses.generateScrapProcess(processContext, tableRows);
            if (scrapProcessId == null) {
                throw new Exception("Scrap process was not generated, an error has occured.");
            }
            processContext.put("scrap_process_id", scrapProcessId);
        }
        if (rowsForRework.size() > 0) {
            tableRows = DynamicTableFunctions.convertFromListOfMapsToMap(rowsForRework, (String[])COL_IDS);
            String reworkProcessId = P0045GenerateScrapAndReworkProcesses.generateReworkProcess(processContext, tableRows);
            if (reworkProcessId == null) {
                throw new Exception("Rework process was not generated, an error has occured.");
            }
            processContext.put("rework_process_id", reworkProcessId);
        }
        Map tableRowsMap = DynamicTableFunctions.convertFromListOfMapsToMap((List)listOfRows, (String[])COL_IDS);
        for (int i = 0; i < COL_IDS.length; ++i) {
            processContext.put(COL_IDS[i], tableRowsMap.get(COL_IDS[i]));
        }
        ps.setProcessContext(sProcessId, processContext);
        log.trace((Object)"*************** eo.P0045GenerateScrapAndReworkProcesses finished ********");
    }

    private static String generateReworkProcess(Map<String, Object> processContext, Map<String, Object> rowsForRework) {
        return "";
    }

    private static Double sumColumn(String value) {
        Long answer = 0L;
        String[] sVal = value.split(";", -1);
        if (sVal.length > 0) {
            for (int i = 0; i < sVal.length; ++i) {
                try {
                    Double val = Double.valueOf(sVal[i]);
                    answer = answer + Math.round(val * 100.0);
                    continue;
                }
                catch (NumberFormatException e) {
                    log.error((Object)"Warto\u015b\u0107 nie jest liczb\u0105: ".concat(sVal[i]));
                }
            }
        }
        return (double)answer.longValue() / 100.0;
    }

    private static String divideColumnByColumn(String value, String quantity) {
        String[] sQty;
        String answer = "";
        String[] sVal = value.split(";", -1);
        if (sVal.length == (sQty = quantity.split(";", -1)).length) {
            for (int i = 0; i < sVal.length; ++i) {
                Double result = 0.0;
                try {
                    Double val = Double.valueOf(sVal[i]);
                    Double qty = Double.valueOf(sQty[i]);
                    result = Double.valueOf(Math.round(val * 100.0)) / Double.valueOf(Math.round(qty * 100.0));
                    result = (double)Math.round(result * 100.0) / 100.0;
                }
                catch (NumberFormatException e) {
                    log.error((Object)"Jedna z warto\u015bci nie jest liczb\u0105: ".concat(sVal[i]).concat("; ").concat(sQty[i]));
                }
                answer = i == 0 ? String.valueOf(result) : answer.concat(";").concat(String.valueOf(result));
            }
        }
        return answer;
    }

    private static String generateScrapProcess(Map<String, Object> processContext, Map<String, Object> rowsForScrap) {
        String processIdToReturn = null;
        try {
            String processDefId = "sa";
            String packageId = "eo";
            ProcessService ps = ServiceFactory.getProcessService();
            log.debug((Object)"generateScrapProcess - creating process...");
            String creator = SystemProperties.getString((String)"BUFOR.LOGIN");
            String passwd = SystemProperties.getString((String)"BUFOR.PASSWORD");
            log.debug((Object)(creator + " " + passwd));
            ProcessBuilderDefinition definition = new ProcessBuilderDefinition();
            definition.setPackageId(packageId);
            definition.setCreator(creator);
            definition.setCreatorPassword(passwd);
            definition.setProcessDefId(processDefId);
            HashMap variables = new HashMap();
            definition.setVariables(variables);
            processIdToReturn = ps.createProcess(definition);
            log.debug((Object)("Process created with id: " + processIdToReturn));
            Map createdProcessContext = ps.getProcessContext(processIdToReturn);
            String createdProcessId = (String)createdProcessContext.get("ProccessId");
            String[] old_items = rowsForScrap.get("old_item_no").toString().split(";", -1);
            String[] new_items = rowsForScrap.get("new_item_no").toString().split(";", -1);
            String scrap_items = "";
            for (int i = 0; i < old_items.length; ++i) {
                if (old_items[i].compareTo("") == 0) {
                    if (scrap_items.compareTo("") != 0) {
                        scrap_items = scrap_items.concat(";");
                    }
                    scrap_items = scrap_items.concat(new_items[i]);
                    continue;
                }
                if (scrap_items.compareTo("") != 0) {
                    scrap_items = scrap_items.concat(";");
                }
                scrap_items = scrap_items.concat(old_items[i]);
            }
            createdProcessContext.put("item_number", scrap_items);
            String qty = (String)rowsForScrap.get("stock_in_mau");
            String value = (String)rowsForScrap.get("stock_value_in_mau");
            createdProcessContext.put("Quantity", qty);
            createdProcessContext.put("Total_Value", value);
            String price = P0045GenerateScrapAndReworkProcesses.divideColumnByColumn(value, qty);
            createdProcessContext.put("Item_Value", price);
            Double sum = P0045GenerateScrapAndReworkProcesses.sumColumn(value);
            createdProcessContext.put("Grand_Total", sum);
            ps.setProcessContext(processIdToReturn, createdProcessContext);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            processIdToReturn = null;
        }
        return processIdToReturn;
    }
}

