/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLTools {
    public static Logger log = Logger.getLogger(XMLTools.class);
    public static String _xmlExtension = ".xml";

    public static String generateOTMResponse(String filePath, Map<String, String> data) {
        String pathToXML = "";
        try {
            String fileName = "invoice-response-".concat(data.get("otm_invoice_id"));
            String timestamp = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
            fileName = fileName.concat("-").concat(timestamp);
            pathToXML = filePath.concat(fileName).concat(_xmlExtension);
            log.debug((Object)("XML_TOOLS: rozpoczynam generowanie pliku dla OTM: " + pathToXML));
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("WorkflowInvoiceResponse");
            rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:win", "http://xmlns.workflow.com/invoice");
            doc.appendChild(rootElement);
            Element otmInvoiceId = doc.createElement("OtmInvoiceId");
            Element otmVoucherId = doc.createElement("OtmVoucherId");
            Element otmDomainName = doc.createElement("OtmDomainName");
            Element workflowInvoiceId = doc.createElement("WorkflowInvoiceId");
            Element importStatus = doc.createElement("ImportStatus");
            Element approvalStatus = doc.createElement("ApprovalStatus");
            Element errorLog = doc.createElement("ErrorLog");
            rootElement.appendChild(otmInvoiceId);
            rootElement.appendChild(otmVoucherId);
            rootElement.appendChild(otmDomainName);
            rootElement.appendChild(workflowInvoiceId);
            rootElement.appendChild(importStatus);
            rootElement.appendChild(approvalStatus);
            rootElement.appendChild(errorLog);
            otmInvoiceId.appendChild(doc.createTextNode(data.get("otm_invoice_id")));
            otmVoucherId.appendChild(doc.createTextNode(data.get("otm_voucher_id")));
            otmDomainName.appendChild(doc.createTextNode(data.get("otm_domain_name")));
            workflowInvoiceId.appendChild(doc.createTextNode(data.get("workflow_invoice_id")));
            importStatus.appendChild(doc.createTextNode(data.get("import_status")));
            approvalStatus.appendChild(doc.createTextNode(data.get("approval_status")));
            errorLog.appendChild(doc.createTextNode(data.get("error_log")));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(pathToXML).getAbsolutePath());
            transformer.transform(source, result);
            log.debug((Object)"XML_TOOLS: zakonczono generowanie pliku dla OTM");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return pathToXML;
    }
}

