/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin;

import com.suncode.plugin.InternalDataBase;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.LogicOperator;
import com.suncode.pwfl.search.sql.GroupSQLFilter;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.search.sql.SimpleSQLFilter;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.assignment.AssignmentService;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.util.ProcessBuilderDefinition;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class P0045Tools {
    public static Logger log = Logger.getLogger(P0045Tools.class);
    private static Map<String, Map<String, String>> rates = new HashMap<String, Map<String, String>>();

    public static String cutLastChar(String sIn) {
        if (sIn.length() > 0) {
            sIn = sIn.substring(0, sIn.length() - 1);
        }
        return sIn;
    }

    public static String PobierzOsobyPoRoli(String packageId, String processDefId, String idRoli) {
        Object answer = "";
        PositionFinder pf = FinderFactory.getPositionFinder();
        RoleService rs = ServiceFactory.getRoleService();
        Role role = rs.getRole(packageId, processDefId, idRoli);
        User user = null;
        if (role != null) {
            List allPositionsWithUsers = pf.findByRole(role.getId(), new String[]{"user"});
            for (int i = 0; i < allPositionsWithUsers.size(); ++i) {
                if (allPositionsWithUsers.get(i) == null) continue;
                user = ((Position)allPositionsWithUsers.get(i)).getUser();
                if (((String)answer).compareTo("") != 0 && user != null) {
                    answer = (String)answer + ";" + user.getUserName();
                    continue;
                }
                if (user == null) continue;
                answer = (String)answer + user.getUserName();
            }
        }
        return answer;
    }

    public static ArrayList<String> PobierzOsobyPoRoliLista(String packageId, String processDefId, String idRoli) {
        ArrayList<String> answer = new ArrayList<String>();
        PositionFinder pf = FinderFactory.getPositionFinder();
        RoleService rs = ServiceFactory.getRoleService();
        Role role = rs.getRole(packageId, processDefId, idRoli);
        User user = null;
        if (role != null) {
            List allPositionsWithUsers = pf.findByRole(role.getId(), new String[]{"user"});
            for (int i = 0; i < allPositionsWithUsers.size(); ++i) {
                if (allPositionsWithUsers.get(i) == null || (user = ((Position)allPositionsWithUsers.get(i)).getUser()) == null) continue;
                answer.add(user.getUserName());
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String PobierzOsobeZastepowanaWZadaniu(String idZastepujacego, String activityId) {
        String answer = "";
        try {
            log.debug((Object)("Checking delegations for activity : " + activityId + " and user " + idZastepujacego));
            SQLFinder finder = FinderFactory.getSQLFinder();
            SQLBuilder builder = new SQLBuilder();
            String sQuery = "SELECT userid FROM pm_delegatedactivities";
            builder.setQuery(sQuery);
            builder.addScalar("userid", (Type)StandardBasicTypes.STRING);
            builder.addFilter((SQLFilter)new SimpleSQLFilter("activityid", (Object)activityId, FilterOperator.EQ));
            builder.addFilter((SQLFilter)new SimpleSQLFilter("delegateduser", (Object)idZastepujacego, FilterOperator.EQ));
            log.debug((Object)("sQuery: " + sQuery));
            List data = finder.find(builder);
            if (data.size() > 0) {
                Map oneRec = (Map)data.get(0);
                answer = (String)oneRec.get("userid");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return answer;
    }

    public static SharkTransaction setSharkTransaction() {
        SharkTransaction st = null;
        try {
            st = Shark.getInstance().createTransaction();
        }
        catch (Exception e) {
            log.error((Object)"Nie uda\u0142o si\u0119 utworzy\u0107 transakcji shark");
        }
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean commitSharkTransaction(SharkTransaction st) {
        Boolean answer = true;
        try {
            st.commit();
        }
        catch (Throwable throwable) {
            answer = false;
            log.error((Object)throwable.getMessage(), throwable);
            try {
                Shark.getInstance().emptyCaches(st);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                st.rollback();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        finally {
            try {
                Shark.getInstance().unlockProcesses(st);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                st.release();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        return answer;
    }

    public static void copyCommentsFromOneProcessToAnother(String from_processId, String to_processId) {
        log.debug((Object)("Copy comments from " + from_processId + " to " + to_processId));
        CommentService cs = ServiceFactory.getCommentService();
        ActivityFinder af = FinderFactory.getActivityFinder();
        List allComments = cs.getCommentsForProcess(from_processId);
        List allActivities = af.findOpenedActivities(to_processId);
        boolean exists = false;
        if (allActivities.size() > 0) {
            log.debug((Object)("Base process comments: " + allComments.size()));
            String sActivityId = ((Activity)allActivities.get(0)).getActivityId();
            List allExistingComments = cs.getCommentsForProcess(to_processId);
            log.debug((Object)("To process comments: " + allExistingComments.size()));
            for (int i = 0; i < allComments.size(); ++i) {
                exists = false;
                Comment comment = (Comment)allComments.get(i);
                if (allExistingComments.size() > 0) {
                    Date commentDate = comment.getCommentDate();
                    for (Comment oneItem : allExistingComments) {
                        log.debug((Object)(commentDate.toString() + " | " + comment.getComment()));
                        log.debug((Object)(oneItem.getCommentDate().toString() + " | " + oneItem.getComment()));
                        if (oneItem.getCommentDate().compareTo(commentDate) == 0) {
                            log.debug((Object)"Comment exists...");
                            exists = true;
                            break;
                        }
                        log.debug((Object)"Comment does not exist...");
                    }
                    if (exists) continue;
                    log.debug((Object)"Adding comment...");
                    comment.setProcessId(to_processId);
                    comment.setActivityId(sActivityId);
                    cs.createComment(comment);
                    continue;
                }
                log.debug((Object)"Adding comment...");
                comment.setProcessId(to_processId);
                comment.setActivityId(sActivityId);
                cs.createComment(comment);
            }
        }
    }

    public static List<Map<String, String>> getSortedDCResults(List<Map<String, String>> result, String sOrderProperty) {
        if (result.size() > 0) {
            // empty if block
        }
        return result;
    }

    public static void acceptActivity(String sProcessId, String sActivityDefinitionId, Map<String, Object> valuesToSet, String actionName) {
        log.info((Object)("Akceptacja zadania " + sActivityDefinitionId + " procesu: " + sProcessId));
        try {
            ActivityFinder af = FinderFactory.getActivityFinder();
            ActivityService as = ServiceFactory.getActivityService();
            AssignmentService ass = (AssignmentService)SpringContext.getBean(AssignmentService.class);
            String creator = SystemProperties.getString((String)"BUFOR.LOGIN");
            String passwd = SystemProperties.getPassword((String)"BUFOR.PASSWORD");
            List activities = af.findOpenedActivities(sProcessId);
            for (Activity activity : activities) {
                String sActivityId = activity.getActivityId();
                if (!sActivityId.contains(sActivityDefinitionId)) continue;
                log.debug((Object)("Proba akceptacji zadania" + sActivityId + " z akcja: " + actionName));
                ass.assignActivityToUser(sProcessId, sActivityId, creator);
                as.openActivity(creator, passwd, sProcessId, sActivityId);
                AcceptationDefinition acceptation = new AcceptationDefinition(sProcessId, sActivityId, creator, actionName);
                acceptation.setIgnoreOwnerShip(Boolean.valueOf(true));
                acceptation.setContextMap(valuesToSet);
                as.acceptActivity(acceptation);
                log.debug((Object)("Zadanie " + sActivityId + " zostalo zatwierdzone..."));
            }
        }
        catch (Exception e) {
            log.error((Object)"Nie udalo sie zaakceptowac zadania!");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void copyDocumentsFromOneProcessToAnother(String proccessId, String mainProcessId) {
        ProcessService ps = ServiceFactory.getProcessService();
        ActivityService as = ServiceFactory.getActivityService();
        ActivityFinder af = FinderFactory.getActivityFinder();
        DocumentService ds = ServiceFactory.getDocumentService();
        DocumentFinder df = FinderFactory.getDocumentFinder();
        List allDocuments = df.getDocumentsFromProcess(proccessId, new String[0]);
        List wfActivities = af.findOpenedActivities(mainProcessId);
        if (wfActivities.size() > 0) {
            for (Activity activity : wfActivities) {
                for (WfDocument doc : allDocuments) {
                    ds.attachDocumentToProcess(doc, "admin", mainProcessId, activity.getActivityId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Map<String, String>> importDataFromXlsxFile(String path, ArrayList<String> columns, int sheetNumber) {
        ArrayList<Map<String, String>> listOfRows = new ArrayList<Map<String, String>>();
        XSSFWorkbook wbk = null;
        try {
            FileInputStream f = new FileInputStream(path);
            wbk = new XSSFWorkbook((InputStream)f);
            XSSFSheet sheet = wbk.getSheetAt(sheetNumber);
            Iterator rowIter = sheet.rowIterator();
            Boolean foundTableHeaderRow = false;
            HashMap<String, int[]> columnLocalizations = new HashMap<String, int[]>();
            while (rowIter.hasNext() && !foundTableHeaderRow.booleanValue()) {
                Row row = (Row)rowIter.next();
                Iterator cellIterator = row.cellIterator();
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    String cellValue = null;
                    CellType cellType = cell.getCellType();
                    if (cellType == CellType.STRING) {
                        cellValue = cell.getStringCellValue();
                    } else if (cellType == CellType.NUMERIC) {
                        cellValue = String.valueOf(cell.getNumericCellValue());
                    } else if (cellType == CellType.FORMULA) {
                        cellValue = cell.getCellFormula();
                    }
                    if (cellValue == null) continue;
                    for (String columnName : columns) {
                        if (cellValue.compareTo(columnName) != 0) continue;
                        foundTableHeaderRow = true;
                        int[] localization = new int[]{cell.getRowIndex(), cell.getColumnIndex()};
                        columnLocalizations.put(columnName, localization);
                    }
                }
            }
            while (rowIter.hasNext()) {
                HashMap<String, String> oneResult = new HashMap<String, String>();
                Row row = (Row)rowIter.next();
                Boolean rowHasData = false;
                for (String columnName : columns) {
                    int[] localization = (int[])columnLocalizations.get(columnName);
                    if (localization == null) {
                        oneResult.put(columnName, "");
                        continue;
                    }
                    Cell cell = row.getCell(localization[1]);
                    String cellValue = null;
                    if (cell == null) {
                        cellValue = "";
                    } else {
                        CellType cellType = cell.getCellType();
                        if (cellType == CellType.STRING) {
                            cellValue = cell.getStringCellValue();
                        } else {
                            cell.setCellType(CellType.STRING);
                            cellValue = cell.getStringCellValue();
                        }
                    }
                    if (cellValue == null || cellValue.compareTo("") == 0) {
                        oneResult.put(columnName, "");
                        continue;
                    }
                    rowHasData = true;
                    oneResult.put(columnName, cellValue);
                }
                if (!rowHasData.booleanValue()) continue;
                listOfRows.add(oneResult);
            }
            log.debug((Object)"Finished");
        }
        catch (Exception e) {
            log.error((Object)"B\u0139\u201a\u00c4\u2026d przetwarzania pliku.");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                wbk.close();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return listOfRows;
    }

    public static ArrayList<Map<String, String>> importDataFromItemTable(ArrayList<String> columns) {
        ArrayList<Map<String, String>> listOfRows = new ArrayList<Map<String, String>>();
        SQLFinder finder = FinderFactory.getSQLFinder();
        SQLBuilder builder = new SQLBuilder();
        String sQuery = "select item as \"Item\", description as \"Description\", item_sigs as \"Item Sigs\", item_signal as \"Item Signal\",vendor as \"Vendor\",vendor_name as \"Vendor name\",lead_time as \"Lead Time\",sourcing_responsible_code as \"Sourcing Responsible Code\",sourcing_responsible_person as \"Sourcing Responsible Person\",purchase_price as \"Purchase Price\",purchase_currency as \"Purchase Currency\",planning_responsible_code as \"Planning Responsible Code\",planning_responsible_name as \"Planning Responsible Name\",stock as \"Stock\",stock_value as \"Stock Value\",estimated_cost_price as \"Estimated Cost\" from pm_cust_eo_items";
        builder.setQuery(sQuery);
        builder.addScalar("Item", (Type)StandardBasicTypes.STRING);
        builder.addScalar("Description", (Type)StandardBasicTypes.STRING);
        builder.addScalar("Item Sigs", (Type)StandardBasicTypes.STRING);
        builder.addScalar("Item Signal", (Type)StandardBasicTypes.STRING);
        builder.addScalar("Vendor", (Type)StandardBasicTypes.STRING);
        builder.addScalar("Vendor name", (Type)StandardBasicTypes.STRING);
        builder.addScalar("Lead Time", (Type)StandardBasicTypes.STRING);
        builder.addScalar("Sourcing Responsible Code", (Type)StandardBasicTypes.STRING);
        builder.addScalar("Sourcing Responsible Person", (Type)StandardBasicTypes.STRING);
        builder.addScalar("Purchase Price", (Type)StandardBasicTypes.STRING);
        builder.addScalar("Purchase Currency", (Type)StandardBasicTypes.STRING);
        builder.addScalar("Planning Responsible Code", (Type)StandardBasicTypes.STRING);
        builder.addScalar("Planning Responsible Name", (Type)StandardBasicTypes.STRING);
        builder.addScalar("Stock Value", (Type)StandardBasicTypes.STRING);
        builder.addScalar("Estimated Cost", (Type)StandardBasicTypes.STRING);
        List itemsList = finder.find(builder);
        for (Map oneMap : itemsList) {
            HashMap<String, String> newMap = new HashMap<String, String>();
            for (Map.Entry entry : oneMap.entrySet()) {
                newMap.put((String)entry.getKey(), entry.getValue().toString());
            }
            listOfRows.add(newMap);
        }
        return listOfRows;
    }

    public static ArrayList<Activity> findOpenActivitiesForId(String processDefId, String activityDefId) {
        ArrayList<Activity> allTasks = new ArrayList<Activity>();
        try {
            ActivityFinder af = FinderFactory.getActivityFinder();
            SQLFinder finder = FinderFactory.getSQLFinder();
            SQLBuilder builder = new SQLBuilder();
            String sQuery = "select id from processes";
            builder.setQuery(sQuery);
            builder.addScalar("id", (Type)StandardBasicTypes.STRING);
            builder.addFilter((SQLFilter)new SimpleSQLFilter("id", (Object)("%" + processDefId + "%"), FilterOperator.LIKE));
            builder.addFilter((SQLFilter)new SimpleSQLFilter("state", (Object)1000000, FilterOperator.EQ));
            log.debug((Object)("sQuery: " + sQuery));
            List openProcesses = finder.find(builder);
            String processId = "";
            for (Map oneProcess : openProcesses) {
                processId = (String)oneProcess.get("id");
                List listOfAct = af.findOpenedActivities(processId);
                for (Activity oneAct : listOfAct) {
                    if (!oneAct.getActivityId().contains(activityDefId)) continue;
                    allTasks.add(oneAct);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return allTasks;
    }

    public static String removeLastChar(String str) {
        if (!StringUtils.isBlank((CharSequence)str)) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String PobierzOsobyPoRoli(String idRoli) {
        Object answer = "";
        PositionFinder pf = FinderFactory.getPositionFinder();
        RoleService rs = ServiceFactory.getRoleService();
        Role role = rs.getRole("cargotec", null, idRoli);
        Long roleId = null;
        if (role != null) {
            roleId = role.getId();
        }
        List allPositionsWithRole = pf.findByRole(roleId, new String[]{"user"});
        for (int i = 0; i < allPositionsWithRole.size(); ++i) {
            Position position = (Position)allPositionsWithRole.get(i);
            User user = position.getUser();
            if (user == null) continue;
            answer = ((String)answer).compareTo("") != 0 ? (String)answer + ";" + user.getUserName() : (String)answer + user.getUserName();
        }
        return answer;
    }

    public static Map<String, String> getAcceptanceAssignmentsForCC(String sCostCenter) throws Exception {
        HashMap<String, String> results = null;
        SQLBuilder builder = new SQLBuilder();
        SQLFinder finder = FinderFactory.getSQLFinder();
        builder.setQuery("SELECT col_company FROM pm_cust_cost_centers");
        builder.addScalar("col_company", (Type)StandardBasicTypes.STRING);
        builder.addFilter((SQLFilter)new SimpleSQLFilter("cost_center", (Object)sCostCenter, FilterOperator.EQ));
        List alRec = finder.find(builder);
        log.debug((Object)alRec.size());
        if (alRec != null && alRec.size() > 0) {
            String company = (String)((Map)alRec.get(0)).get("col_company");
            SQLBuilder builderAccAss = new SQLBuilder();
            builderAccAss.setQuery("SELECT col_fc, col_fcm, col_gm, cc_confirmation FROM pm_cust_acceptance_assignments");
            builderAccAss.addScalar("col_fc", (Type)StandardBasicTypes.STRING);
            builderAccAss.addScalar("col_fcm", (Type)StandardBasicTypes.STRING);
            builderAccAss.addScalar("col_gm", (Type)StandardBasicTypes.STRING);
            builderAccAss.addScalar("cc_confirmation", (Type)StandardBasicTypes.STRING);
            builderAccAss.addFilter((SQLFilter)new SimpleSQLFilter("col_company", (Object)company, FilterOperator.EQ));
            List alAss = finder.find(builderAccAss);
            if (alAss != null && alAss.size() > 0) {
                Map ass = (Map)alAss.get(0);
                String assFc = (String)ass.get("col_fc");
                String assFcm = (String)ass.get("col_fcm");
                String assGm = (String)ass.get("col_gm");
                String ccConfirm = (String)ass.get("cc_confirmation");
                if (assFc != null && assFcm != null && assGm != null && ccConfirm != null) {
                    results = new HashMap<String, String>();
                    results.put("company", company);
                    results.put("assignment_fc", assFc);
                    results.put("assignment_fcm", assFcm);
                    results.put("assignment_gm", assGm);
                    results.put("cc_confirmation", ccConfirm);
                }
            }
        }
        if (results == null) {
            throw new Exception("Nie uda\u0142o si\u0119 ustali\u0107 os\u00f3b odpowiedzialnych za akceptacj\u0119 kosztu dla CC " + sCostCenter);
        }
        return results;
    }

    public static String joinTableValues(Object[] tab) {
        return StringUtils.join((Object[])tab, (String)";");
    }

    public static double getRate(String sCurrency) {
        int iMiesiac = Calendar.getInstance().get(2);
        int iRok = Calendar.getInstance().get(1);
        String sResult = "";
        try {
            sResult = P0045Tools.getExchangeRate(sCurrency, iMiesiac, iRok);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return 0.0;
        }
        return Double.valueOf(sResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExchangeRate(String currency, int month, int year) throws SQLException {
        Connection con = null;
        String answer = "";
        String sQuery = "SELECT * FROM pm_cust_exchange_rates WHERE currency = '" + currency + "' AND year = '" + String.valueOf(year) + "'";
        String[] sMonths = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jly", "aug", "sep", "oct", "nov", "dece"};
        try {
            HashMap<String, String> hmResult;
            con = InternalDataBase.connect();
            answer = month == 0 ? P0045Tools.getExchangeRate(currency, 11, year - 1) : ((hmResult = InternalDataBase.executeOneResultQuery(con, sQuery)).get(sMonths[month - 1]).isEmpty() ? P0045Tools.getExchangeRate(currency, month - 1, year) : hmResult.get(sMonths[month - 1]));
        }
        catch (Exception e) {
            log.error((Object)"Wyst\u0105pi\u0142 b\u0142\u0105d podczas pobierania kursu walut.");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            InternalDataBase.distconnect(con);
        }
        return answer;
    }

    public static String PR_checkUserAcceptationRoles(String activityId, String userName, String acceptancePath, String costCenter) {
        log.debug((Object)"PR_CheckUserAcceptationRoles");
        String sActivityId = activityId;
        log.debug((Object)sActivityId);
        String sTaskUserName = userName;
        String sAcceptationPath = acceptancePath;
        String[] sAcceptingUsers = sAcceptationPath.split(";", -1);
        ArrayList<Object> alUsers = new ArrayList<Object>();
        log.debug((Object)("sAcceptingUsers: " + String.valueOf(sAcceptingUsers)));
        for (String s : sAcceptingUsers) {
            if (s.compareTo("") == 0) continue;
            alUsers.add(s);
        }
        Object sPermissions = "";
        boolean bHasRole = false;
        String hasDmRole = "";
        for (String string : alUsers) {
            log.debug((Object)("Check role for " + string));
            hasDmRole = P0045Tools.PobierzOsobyPoRoli("department_manager");
            if (hasDmRole.indexOf(string) >= 0) {
                bHasRole = true;
                break;
            }
            log.debug((Object)("Result " + bHasRole));
        }
        log.debug((Object)("IF: " + bHasRole + " | " + (hasDmRole.indexOf(sTaskUserName) >= 0)));
        sPermissions = bHasRole || hasDmRole.indexOf(sTaskUserName) >= 0 ? (String)sPermissions + "true;" : (String)sPermissions + ";";
        log.debug((Object)("Result sPermissions: " + (String)sPermissions));
        try {
            Map<String, String> permittedUsers = P0045Tools.getAcceptanceAssignmentsForCC(costCenter);
            bHasRole = false;
            for (String string : alUsers) {
                log.debug((Object)("Check assignment_fc for " + string));
                if (string.compareTo(permittedUsers.get("assignment_fc")) == 0) {
                    bHasRole = true;
                    break;
                }
                log.debug((Object)("Result " + bHasRole));
            }
            log.debug((Object)("IF: " + bHasRole + " | " + (sTaskUserName.compareTo(permittedUsers.get("assignment_fc")) == 0)));
            sPermissions = bHasRole || sTaskUserName.compareTo(permittedUsers.get("assignment_fc")) == 0 ? (String)sPermissions + "true;" : (String)sPermissions + ";";
            log.debug((Object)("Result sPermissions: " + (String)sPermissions));
            bHasRole = false;
            for (String string : alUsers) {
                log.debug((Object)("Check assignment_fcm for " + string));
                if (string.compareTo(permittedUsers.get("assignment_fcm")) == 0) {
                    bHasRole = true;
                    break;
                }
                log.debug((Object)("Result " + bHasRole));
            }
            log.debug((Object)("IF: " + bHasRole + " | " + (sTaskUserName.compareTo(permittedUsers.get("assignment_fcm")) == 0)));
            sPermissions = bHasRole || sTaskUserName.compareTo(permittedUsers.get("assignment_fcm")) == 0 ? (String)sPermissions + "true;" : (String)sPermissions + ";";
            log.debug((Object)("Result sPermissions: " + (String)sPermissions));
            bHasRole = false;
            for (String string : alUsers) {
                log.debug((Object)("Check assignment_fcm for " + string));
                if (string.compareTo(permittedUsers.get("assignment_gm")) == 0) {
                    bHasRole = true;
                    break;
                }
                log.debug((Object)("Result " + bHasRole));
            }
            log.debug((Object)("IF: " + bHasRole + " | " + (sTaskUserName.compareTo(permittedUsers.get("assignment_gm")) == 0)));
            sPermissions = bHasRole || sTaskUserName.compareTo(permittedUsers.get("assignment_gm")) == 0 ? (String)sPermissions + "true" : (String)sPermissions;
            log.debug((Object)("Result sPermissions: " + (String)sPermissions));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sPermissions;
    }

    public static Double getCurrencyRateFromNbp(String currency, String currencyDate) {
        Double kurs;
        block23: {
            SimpleDateFormat workflowDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat nbpDateFormat = new SimpleDateFormat("dd-MM-yyyy");
            SimpleDateFormat nbpListDateFormat = new SimpleDateFormat("yyMMdd");
            kurs = null;
            try {
                if (currency.compareTo("PLN") != 0) {
                    String currencyRate;
                    Map<String, String> dailyRates = rates.get(currencyDate);
                    if (dailyRates != null && (currencyRate = dailyRates.get(currency)) != null && currencyRate.compareTo("null") != 0) {
                        log.debug((Object)("Kurs pobrany z mapy:" + currencyRate));
                        kurs = Double.valueOf(currencyRate.replace(",", "."));
                    }
                    if (kurs == null) {
                        URL oURL;
                        ArrayList<String> lista_xml;
                        Calendar cal = Calendar.getInstance();
                        Integer nCurrentYear = cal.get(1);
                        cal.setTime(workflowDateFormat.parse(currencyDate));
                        cal.add(5, -1);
                        Integer nSearchYear = cal.get(1);
                        String szukana_data = nbpListDateFormat.format(cal.getTime());
                        String data_ustalenia_kursu = workflowDateFormat.format(cal.getTime());
                        String sURL = "https://static.nbp.pl/dane/kursy/xml/dir";
                        Object sURLWithYear = sURL;
                        if (nCurrentYear > nSearchYear) {
                            sURLWithYear = (String)sURLWithYear + nSearchYear.toString();
                        }
                        if ((lista_xml = P0045Tools.getXMLCurrencyList(oURL = new URL((String)(sURLWithYear = (String)sURLWithYear + ".txt")))).size() != 0) {
                            try {
                                Object url = "https://static.nbp.pl/dane/kursy/xml/";
                                boolean nieznaleziono = true;
                                while (nieznaleziono) {
                                    boolean bChangeYear = false;
                                    log.debug((Object)szukana_data);
                                    for (int i = 0; i < lista_xml.size(); ++i) {
                                        if (lista_xml.get(i).toString().indexOf(szukana_data) == -1) continue;
                                        url = (String)url + lista_xml.get(i) + ".xml";
                                        nieznaleziono = false;
                                        break;
                                    }
                                    cal.add(5, -1);
                                    if (cal.get(1) < nSearchYear) {
                                        if (bChangeYear) break;
                                        Integer i = nSearchYear;
                                        nSearchYear = nSearchYear - 1;
                                        sURLWithYear = sURL + nSearchYear.toString() + ".txt";
                                        oURL = new URL((String)sURLWithYear);
                                        lista_xml = P0045Tools.getXMLCurrencyList(oURL);
                                        if (lista_xml.isEmpty()) break;
                                        bChangeYear = true;
                                    }
                                    szukana_data = nbpListDateFormat.format(cal.getTime());
                                    log.debug((Object)("Szukana data w pliku NBP: " + szukana_data));
                                    data_ustalenia_kursu = workflowDateFormat.format(cal.getTime());
                                }
                                if (!nieznaleziono) {
                                    String kurs_sprzedazy = "";
                                    String przelicznik = "";
                                    try {
                                        String thisLine;
                                        URL u = new URL((String)url);
                                        DataInputStream theHTML = new DataInputStream(u.openStream());
                                        String szukana_linia = "<kod_waluty>" + currency + "</kod_waluty>";
                                        while ((thisLine = theHTML.readLine()) != null) {
                                            if (thisLine.toString().indexOf("<przelicznik>") != -1) {
                                                przelicznik = thisLine.replace("</przelicznik>", "");
                                                przelicznik = przelicznik.replace("<przelicznik>", "");
                                                przelicznik = przelicznik.trim();
                                                przelicznik = przelicznik.replace(",", ".");
                                            }
                                            if (thisLine.toString().indexOf(szukana_linia) == -1) continue;
                                            thisLine = theHTML.readLine();
                                            kurs_sprzedazy = thisLine.replace("</kurs_sredni>", "");
                                            kurs_sprzedazy = kurs_sprzedazy.replace("<kurs_sredni>", "");
                                            kurs_sprzedazy = kurs_sprzedazy.trim();
                                            kurs_sprzedazy = kurs_sprzedazy.replace(",", ".");
                                            break;
                                        }
                                        if (kurs_sprzedazy.compareTo("") != 0 && przelicznik.compareTo("") != 0) {
                                            kurs = Double.valueOf(kurs_sprzedazy) / Double.valueOf(przelicznik);
                                        }
                                        log.debug((Object)("Zakonczenie pobierania kursu " + currency + " z dnia " + currencyDate + "(" + data_ustalenia_kursu + ")"));
                                    }
                                    catch (Exception e) {
                                        log.error((Object)("B\u0142\u0105d podczas pobierania kursu " + currency + " z NBP"));
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    try {
                        Date dCurrentDate = new Date();
                        Date dCurrencyDate = workflowDateFormat.parse(currencyDate);
                        if (dCurrencyDate.getTime() <= dCurrentDate.getTime()) {
                            if (dailyRates == null) {
                                dailyRates = new HashMap<String, String>();
                            }
                            DecimalFormat formatter = new DecimalFormat("#.####");
                            if (kurs != null) {
                                dailyRates.put(currency, formatter.format(kurs));
                                rates.put(currencyDate, dailyRates);
                            }
                        }
                        break block23;
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    break block23;
                }
                kurs = 1.0;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return kurs;
    }

    public static ArrayList<String> getXMLCurrencyList(URL url) {
        ArrayList<String> lista_xml = new ArrayList<String>();
        try {
            String thisLine;
            log.debug((Object)url.toString());
            DataInputStream theHTML = new DataInputStream(url.openStream());
            while ((thisLine = theHTML.readLine()) != null) {
                int test = thisLine.substring(0, 1).compareTo("a");
                if (test != 0) continue;
                lista_xml.add(thisLine);
            }
            log.debug((Object)"Zakonczenie pobierania listy XML z NBP");
        }
        catch (Exception e) {
            log.error((Object)"B\u0142\u0105d podczas pobierania listy XML z NBP");
        }
        return lista_xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getBpDataFromDb(String bpNumber) {
        log.debug((Object)("Pobieram BP: " + bpNumber));
        String[] bpData = new String[3];
        try {
            SQLFinder finder = FinderFactory.getSQLFinder();
            String queryBp = "SELECT bp_name, tax_code, address_street, address_postal_code, address_city, address_country_short FROM pm_cust_kontrahenci WHERE bp_partner = '" + bpNumber + "'";
            SQLBuilder builderBp = new SQLBuilder();
            builderBp.setQuery(queryBp);
            builderBp.addScalar("bp_name", (Type)StandardBasicTypes.STRING);
            builderBp.addScalar("tax_code", (Type)StandardBasicTypes.STRING);
            builderBp.addScalar("address_street", (Type)StandardBasicTypes.STRING);
            builderBp.addScalar("address_postal_code", (Type)StandardBasicTypes.STRING);
            builderBp.addScalar("address_city", (Type)StandardBasicTypes.STRING);
            builderBp.addScalar("address_country_short", (Type)StandardBasicTypes.STRING);
            List allRecBp = finder.find(builderBp);
            if (allRecBp.size() > 0) {
                String bpName = (String)((Map)allRecBp.get(0)).get("bp_name");
                String bpTaxCode = (String)((Map)allRecBp.get(0)).get("tax_code");
                String bpAddressStreet = (String)((Map)allRecBp.get(0)).get("address_street");
                String bpAddressPostalCode = (String)((Map)allRecBp.get(0)).get("address_postal_code");
                String bpAddressCity = (String)((Map)allRecBp.get(0)).get("address_city");
                String bpCountry = (String)((Map)allRecBp.get(0)).get("address_country_short");
                String bpAddress = bpAddressStreet + "\n" + bpAddressPostalCode + " " + bpAddressCity + " (" + bpCountry + ")";
                bpData[0] = bpName;
                bpData[1] = bpTaxCode;
                bpData[2] = bpAddressStreet + "\n" + bpAddressPostalCode + " " + bpAddressCity + " (" + bpCountry + ")";
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return bpData;
    }

    public static String getCCName(String ccNo) {
        String ccName = "";
        SQLBuilder builder = new SQLBuilder();
        SQLFinder finder = FinderFactory.getSQLFinder();
        builder.setQuery("SELECT descr FROM pm_cust_cost_centers");
        builder.addScalar("descr", (Type)StandardBasicTypes.STRING);
        builder.addFilter((SQLFilter)new SimpleSQLFilter("cost_center", (Object)ccNo, FilterOperator.EQ));
        List allRec = finder.find(builder);
        if (allRec.size() > 0) {
            ccName = (String)((Map)allRec.get(0)).get("descr");
        }
        return ccName;
    }

    public static String getCCHolder(String ccNo) {
        String ccHolder = "";
        SQLBuilder builder = new SQLBuilder();
        SQLFinder finder = FinderFactory.getSQLFinder();
        builder.setQuery("SELECT responsible FROM pm_cust_cost_centers");
        builder.addScalar("responsible", (Type)StandardBasicTypes.STRING);
        builder.addFilter((SQLFilter)new SimpleSQLFilter("cost_center", (Object)ccNo, FilterOperator.EQ));
        List allRec = finder.find(builder);
        if (allRec.size() > 0) {
            ccHolder = (String)((Map)allRec.get(0)).get("responsible");
        }
        return ccHolder;
    }

    public static Set<User> getUserFromGroup(String groupName) {
        UserGroupFinder ugf = FinderFactory.getUserGroupFinder();
        UserGroup group = (UserGroup)ugf.findOneByProperty("name", (Object)groupName, new String[]{"users"});
        return group.getUsers();
    }

    public static String createPrProcess(HashMap<String, Object> ctx) {
        String prNo = "";
        ProcessService ps = ServiceFactory.getProcessService();
        String creator = SystemProperties.getString((String)"BUFOR.LOGIN");
        String passwd = SystemProperties.getPassword((String)"BUFOR.PASSWORD");
        ProcessBuilderDefinition definition = new ProcessBuilderDefinition();
        definition.setPackageId("cargotec");
        definition.setCreator(creator);
        definition.setCreatorPassword(passwd);
        definition.setProcessDefId("pr_po");
        definition.setVariables(ctx);
        String sCreatedProcessId = ps.createProcess(definition);
        log.debug((Object)("Process created with id: " + sCreatedProcessId));
        Map prCtx = ps.getProcessContext(sCreatedProcessId);
        prNo = (String)prCtx.get("pr_no");
        log.debug((Object)("PR no: " + sCreatedProcessId));
        return prNo;
    }

    public static String createPrProcessReturnId(HashMap<String, Object> ctx) {
        String prNo = "";
        ProcessService ps = ServiceFactory.getProcessService();
        String creator = SystemProperties.getString((String)"BUFOR.LOGIN");
        String passwd = SystemProperties.getPassword((String)"BUFOR.PASSWORD");
        ProcessBuilderDefinition definition = new ProcessBuilderDefinition();
        definition.setPackageId("cargotec");
        definition.setCreator(creator);
        definition.setCreatorPassword(passwd);
        definition.setProcessDefId("pr_po");
        definition.setVariables(ctx);
        String sCreatedProcessId = ps.createProcess(definition);
        log.debug((Object)("Process created with id: " + sCreatedProcessId));
        Map prCtx = ps.getProcessContext(sCreatedProcessId);
        prNo = (String)prCtx.get("pr_no");
        log.debug((Object)("PR no: " + sCreatedProcessId));
        return sCreatedProcessId;
    }

    public static String[] getGlDataByNumber(String glAccount) {
        String[] glData = new String[2];
        SQLBuilder builder = new SQLBuilder();
        SQLFinder finder = FinderFactory.getSQLFinder();
        builder.setQuery("SELECT distinct type_of_cost, gl_descr FROM pm_cust_gl_accounts");
        builder.addScalar("type_of_cost", (Type)StandardBasicTypes.STRING);
        builder.addScalar("gl_descr", (Type)StandardBasicTypes.STRING);
        builder.addFilter((SQLFilter)new SimpleSQLFilter("gl_no", (Object)glAccount, FilterOperator.EQ));
        List rec = finder.find(builder);
        if (rec != null && rec.size() > 0) {
            glData[0] = (String)((Map)rec.get(0)).get("gl_descr");
            glData[1] = (String)((Map)rec.get(0)).get("type_of_cost");
        }
        return glData;
    }

    public static String[] getGlDataByNumberForPO(String glAccount, String colCompany) {
        String[] glData = new String[2];
        SQLBuilder builder = new SQLBuilder();
        SQLFinder finder = FinderFactory.getSQLFinder();
        builder.setQuery("SELECT distinct type_of_cost, gl_descr FROM pm_cust_gl_accounts");
        builder.addScalar("type_of_cost", (Type)StandardBasicTypes.STRING);
        builder.addScalar("gl_descr", (Type)StandardBasicTypes.STRING);
        GroupSQLFilter mainFilter = new GroupSQLFilter(LogicOperator.AND);
        mainFilter.addFilter(new SQLFilter[]{new SimpleSQLFilter("gl_no", (Object)glAccount, FilterOperator.EQ)});
        mainFilter.addFilter(new SQLFilter[]{new SimpleSQLFilter("col_company", (Object)colCompany, FilterOperator.EQ)});
        builder.addFilter((SQLFilter)mainFilter);
        List rec = finder.find(builder);
        log.debug((Object)("GlDataByNumberForPO: " + rec.toString()));
        if (rec != null && rec.size() > 0) {
            glData[0] = (String)((Map)rec.get(0)).get("gl_descr");
            glData[1] = (String)((Map)rec.get(0)).get("type_of_cost");
        }
        return glData;
    }

    public static String getProductName(String productCode) {
        String productName = "";
        SQLBuilder builder = new SQLBuilder();
        SQLFinder finder = FinderFactory.getSQLFinder();
        builder.setQuery("select distinct col_product_name from pm_cust_purchase_products");
        builder.addScalar("col_product_name", (Type)StandardBasicTypes.STRING);
        builder.addFilter((SQLFilter)new SimpleSQLFilter("col_product_code", (Object)productCode, FilterOperator.EQ));
        List rec = finder.find(builder);
        if (rec != null && rec.size() > 0) {
            productName = (String)((Map)rec.get(0)).get("col_product_name");
        }
        return productName;
    }

    public static String getDefaultSourcingResponsible() {
        String sourcingResponsible = "";
        SQLBuilder builder = new SQLBuilder();
        SQLFinder finder = FinderFactory.getSQLFinder();
        builder.setQuery("SELECT user_no FROM pm_cust_eo_default_sourcing_user");
        builder.addScalar("user_no", (Type)StandardBasicTypes.STRING);
        List rec = finder.find(builder);
        if (rec != null && rec.size() > 0) {
            sourcingResponsible = (String)((Map)rec.get(0)).get("user_no");
        }
        return sourcingResponsible;
    }

    public static File[] getOrderedListOfFiles(File directory) {
        File[] files = directory.listFiles();
        log.debug((Object)("Found files: " + files.length));
        for (File f : files) {
            log.debug((Object)f.getName());
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
            }
        });
        log.debug((Object)"Sorted list...");
        for (File f : files) {
            log.debug((Object)(f.getName() + ", " + f.lastModified()));
        }
        return files;
    }
}

