function DM_goToActivity(sActivityId, sProcessId) {
  document.location.href =
    Suncode.getContextPath() +
    "/ProcesActivity.do?activityId=" +
    sActivityId +
    "&processKey=" +
    sProcessId;
}

function DM_goToHistoryView(sActivityId, sProcessId) {
  document.location.href =
    Suncode.getContextPath() +
    "/ShowDetailHistory.do?ProcessId=" +
    sProcessId +
    "&histActivityId=" +
    sActivityId;
}

function DM_errorMsg(txt) {
  Ext.Msg.show({
    title: DM.translator.m("error"),
    msg: txt,
    buttons: Ext.Msg.OK,
    icon: Ext.Msg.ERROR,
  });
}

function DM_warningMsg(txt) {
  Ext.Msg.show({
    title: DM.translator.m("attention"),
    msg: txt,
    buttons: Ext.Msg.OK,
    icon: Ext.Msg.WARNING,
  });
}

function DM_infoMsg(txt) {
  Ext.Msg.show({
    title: DM.translator.m("attention"),
    msg: txt,
    buttons: Ext.Msg.OK,
    icon: Ext.Msg.INFO,
  });
}

// z modułu PZ - wyswietla napis o tresci msg gdy uruchomione jest jakies
// zadanie
function DM_showLoadingMask(id, msg) {
  var maskDiv = Ext.DomHelper.append(
    Ext.getBody(),
    {
      tag: "div",
      id: id,
    },
    true
  );
  maskDiv.setStyle({
    position: "fixed",
    left: 0,
    top: 0,
    width: "100%",
    height: "100%",
    "z-index": 20000,
  });

  var mask = new Ext.LoadMask(maskDiv, {
    msg: msg,
  });
  mask.show();
}

// z modułu PZ
function DM_removeLoadingMask(id) {
  Ext.get(id).remove();
}

function DM_clone(destination, source) {
  for (var property in source) {
    if (
      typeof source[property] === "object" &&
      source[property] !== null &&
      destination[property]
    ) {
      clone(destination[property], source[property]);
    } else {
      destination[property] = source[property];
    }
  }
}

function DM_swap_wyjazd_przyjazd(form_data) {
  if (
    typeof form_data.wyjazd_kraj !== "undefined" &&
    form_data.wyjazd_kraj !== null
  ) {
    var kraj_buf = form_data.wyjazd_kraj;
    form_data.wyjazd_kraj = form_data.przyjazd_kraj;
    form_data.przyjazd_kraj = kraj_buf;
  }

  var miejscowosc_buf = form_data.wyjazd_miejscowosc;
  form_data.wyjazd_miejscowosc = form_data.przyjazd_miejscowosc;
  form_data.przyjazd_miejscowosc = miejscowosc_buf;

  var data_buf = form_data.wyjazd_data;
  form_data.wyjazd_data = form_data.przyjazd_data;
  form_data.przyjazd_data = data_buf;

  var godzina_buf = form_data.wyjazd_godzina;
  form_data.wyjazd_godzina = form_data.przyjazd_godzina;
  form_data.przyjazd_godzina = godzina_buf;
}

function DM_clean_przyjazd(form_data) {
  if (
    typeof form_data.przyjazd_kraj !== "undefined" &&
    form_data.przyjazd_kraj !== null
  ) {
    form_data.przyjazd_kraj = "";
  }
  form_data.przyjazd_miejscowosc = "";
  form_data.przyjazd_data = "";
  form_data.przyjazd_godzina = "";
}

function DM_set_przyjazd_like_wyjazd(form_data, source_data) {
  if (typeof source_data === "undefined" || source_data === null) {
    source_data = form_data;
  }
  if (
    typeof form_data.wyjazd_kraj !== "undefined" &&
    form_data.wyjazd_kraj !== null
  ) {
    form_data.przyjazd_kraj = source_data.wyjazd_kraj;
  }
  form_data.przyjazd_miejscowosc = source_data.wyjazd_miejscowosc;
  form_data.przyjazd_data = source_data.wyjazd_data;
  form_data.przyjazd_godzina = source_data.wyjazd_godzina;
}

function DM_set_default_to_zero(value) {
  if (
    typeof value === "undefined" ||
    value === null ||
    isNaN(value) ||
    value === "null"
  ) {
    value = 0.0;
  }
  return value;
}

function DM_date_to_string(date) {
  var day = date.getDate();
  var day_str = "";
  if (day < 10) {
    day_str = "0" + new String(day);
  } else {
    day_str = new String(day);
  }

  var month = date.getMonth() + 1;
  var month_str = "";
  if (month < 10) {
    month_str = "0" + new String(month);
  } else {
    month_str = new String(month);
  }

  var year = date.getFullYear();

  return year + "-" + month_str + "-" + day_str;
}

function DM_isNumber(n) {
  return !isNaN(parseFloat(n)) && isFinite(n);
}

function DM_createDate(date_string, hour, min, sec, ms) {
  hour = hour == null ? 0 : hour;
  min = min == null ? 0 : min;
  sec = sec == null ? 0 : sec;
  ms = ms == null ? 0 : ms;

  if (
    typeof date_string === "object" &&
    typeof date_string.getMonth === "function"
  ) {
    date_string.setHours(hour, min, sec, ms);
    return date_string;
  }

  var yyyy_mm_dd = /^\s*(\d{4})-(\d\d)-(\d\d)\s*$/;
  var parts = yyyy_mm_dd.exec(date_string);
  if (parts) {
    var month = parseInt(parts[2], 10);
    return new Date(parts[1], month - 1, parts[3], hour, min, sec, ms);
  }
  return null;
}
