/**
 * Okno do dodawania nowego i modyfikacji istniejącego wydatku.
 */
(function () {
  var isForeignTrip = DM.data.typ_delegacji == 'zagranica' ? true : false;

  DM.form.nowy_wydatek_items = [
    {
      id: 'DM.form.nowy_wydatek.nazwa_wydatku',
      xtype: 'textfield',
      fieldLabel: DM.translator.m('spendings.name.column'),
      name: DM.fields.wydatki[0],
      allowBlank: DM.windowsFieldsToHide.spendings.isSpendingNameHidden,
      validator: DM_semicolonValidation,
      hidden: DM.windowsFieldsToHide.spendings.isSpendingNameHidden,
      hideLabel: DM.windowsFieldsToHide.spendings.isSpendingNameHidden,
    },
    {
      xtype: 'combo',
      id: 'DM.form.nowy_wydatek.rodzaj_wydatku',
      fieldLabel: DM.translator.m('spendings.type.column'),
      name: DM.fields.wydatki[1],
      typeAhead: true,
      triggerAction: 'all',
      lazyRender: true,
      editable: false,
      hidden: DM.windowsFieldsToHide.spendings.isSpendingTypeHidden,
      hideLabel: DM.windowsFieldsToHide.spendings.isSpendingTypeHidden,
      mode: 'local',
      allowBlank: DM.windowsFieldsToHide.spendings.isSpendingTypeHidden,
      validator: DM_addmod_wydatki_rodzaj_wydatku_valid_text,
      store: new Ext.data.ArrayStore({
        fields: ['rodzaj_wydatku_text'],
        data: DM.conf.actionConf.spendingTypes,
      }),
      valueField: 'rodzaj_wydatku_text',
      displayField: 'rodzaj_wydatku_text',
    },
    {
      xtype: 'combo',
      id: 'DM.form.nowy_wydatek.paymentMethod',
      fieldLabel: DM.translator.m('spendings.payment.method.column'),
      name: DM.fields.wydatki[2],
      typeAhead: true,
      triggerAction: 'all',
      lazyRender: true,
      editable: false,
      hidden: DM.windowsFieldsToHide.spendings.isPaymentMethodsHidden,
      hideLabel: DM.windowsFieldsToHide.spendings.isPaymentMethodsHidden,
      mode: 'local',
      allowBlank: DM.windowsFieldsToHide.spendings.isPaymentMethodsHidden,
      validator: DM_addmod_spendings_payment_method_valid_text,
      store: new Ext.data.ArrayStore({
        fields: ['paymentMethod_text'],
        data: DM.conf.actionConf.paymentMethods,
      }),
      valueField: 'paymentMethod_text',
      displayField: 'paymentMethod_text',
    },
    {
      xtype: 'combo',
      id: 'DM.form.nowy_wydatek.documentType',
      fieldLabel: DM.translator.m('spendings.documentType.column'),
      name: DM.fields.wydatki[6],
      typeAhead: true,
      triggerAction: 'all',
      lazyRender: true,
      editable: false,
      hidden: DM.windowsFieldsToHide.spendings.isDocumentTypeHidden,
      hideLabel: DM.windowsFieldsToHide.spendings.isDocumentTypeHidden,
      mode: 'local',
      allowBlank: DM.windowsFieldsToHide.spendings.isDocumentTypeHidden,
      validator: DM_addmod_spendings_documentType_valid_text,
      store: new Ext.data.ArrayStore({
        fields: ['documentType_text'],
        data: DM.conf.actionConf.documentTypes,
      }),
      valueField: 'documentType_text',
      displayField: 'documentType_text',
    },
    {
      id: 'DM.form.nowy_wydatek.koszt',
      xtype: 'numberfield',
      fieldLabel: DM.translator.m('cost'),
      name: DM.fields.wydatki[3],
      allowBlank: false,
      decimalSeparator: DM.conf.decimalseparator,
      validator: DM_addmod_wydatki_koszt_valid_number,
      format: DM.conf.getNumberViewFormat(DM.conf.decimalseparator),
    },
    {
      id: 'DM.form.nowy_wydatek.waluta',
      xtype: 'combo',
      fieldLabel: DM.translator.m('currency'),
      name: DM.fields.wydatki[4],
      typeAhead: true,
      triggerAction: 'all',
      lazyRender: true,
      editable: false,
      hidden: !isForeignTrip,
      hideLabel: !isForeignTrip,
      mode: 'local',
      allowBlank: !isForeignTrip,
      validator: DM_addmod_wydatki_waluta_valid_text,
      store: new Ext.data.ArrayStore({
        fields: ['waluta_text'],
        data: DM.conf.jsonConf.wydatki_waluty,
      }),
      valueField: 'waluta_text',
      displayField: 'waluta_text',
    },
    {
      id: 'DM.form.nowy_wydatek.data',
      xtype: 'datefield',
      data: 'Y-m-d',
      name: DM.fields.wydatki[5],
      fieldLabel: DM.translator.m('date'),
      allowBlank: DM.windowsFieldsToHide.spendings.isSpendingDateHidden,
      validator: DM_addmod_wydatki_data_valid_date,
      hidden: DM.windowsFieldsToHide.spendings.isSpendingDateHidden,
      hideLabel: DM.windowsFieldsToHide.spendings.isSpendingDateHidden,
    },
    {
      id: 'DM.form.nowy_wydatek.rateFromDayBefore',
      xtype: 'checkbox',
      name: DM.fields.wydatki[7],
      fieldLabel: DM.translator.m('spendings.rateFromDayBefore.column'),
      hidden: !isForeignTrip || DM.conf.jsonConf.zagranica.ukryj_kurs_wydatku_z_dnia_poprzedzajacego_wystawienie_faktury,
      hideLabel: !isForeignTrip || DM.conf.jsonConf.zagranica.ukryj_kurs_wydatku_z_dnia_poprzedzajacego_wystawienie_faktury
    },

    {
      id: 'DM.form.nowy_wydatek.wydatek_id',
      xtype: 'textfield',
      name: DM.fields.wydatki[8],
      hidden: true,
      hideLabel: true,
      allowBlank: true,
    },
  ];

  DM.form.nowy_wydatek = new Ext.form.FormPanel({
    id: 'DM.form.nowy_wydatek',
    autoWidth: true,
    autoHeight: true,
    labelWidth: 180,
    bodyPadding: 5,
    frame: false,
    border: false,
    style: {
      marginTop: '5px',
      marginLeft: '10px',
      marginRight: '10px',
    },
    defaults: {
      allowBlank: false,
      value: '',
      width: 160,
      anchor: '99%',
    },

    items: DM.form.nowy_wydatek_items,

    buttons: [
      {
        text: DM.translator.m('change'),
        id: 'DM.form.nowy_wydatek.button.change',
        autoWidth: true,
        handler: DM_nowy_wydatek_change_btn_handler,
      },
      {
        text: DM.translator.m('add'),
        id: 'DM.form.nowy_wydatek.button.add',
        formBind: true,
        handler: DM_nowy_wydatek_new_btn_handler,
      },
      {
        text: DM.translator.m('cancel'),
        id: 'DM.form.nowy_wydatek.button.cancel',
        autoWidth: true,
        handler: function (b, e) {
          DM.win.okno_wydatki.hide();
        },
      },
    ],
  });

  DM.win.okno_wydatki = new Ext.Window({
    layout: 'fit',
    width: 550,
    autoScroll: true,
    closeAction: 'hide',
    modal: true,
    items: DM.form.nowy_wydatek,
    listeners: {
      show: function (win) {
        win.findByType('form')[0].getForm().clearInvalid();
      },
      afterlayout: function() {
        DM_setHeightOnSmallerScreens(this);
      }
    },
  });

  //*******************************************
  // Walidatory pól na formularzu
  //*******************************************
  function DM_addmod_wydatki_rodzaj_wydatku_valid_text(value) {
    return true;
  }

  function DM_addmod_spendings_payment_method_valid_text(value) {
    return true;
  }

  function DM_addmod_spendings_documentType_valid_text(value) {
    return true;
  }

  function DM_addmod_wydatki_koszt_valid_number(value) {
    if (parseFloat(value.replace(',', '.')) <= 0) {
      return DM.translator.m('spendings.cost.validatorMsg');
    }
    return true;
  }

  function DM_addmod_wydatki_waluta_valid_text(value) {
    return true;
  }

  function DM_addmod_wydatki_data_valid_date(value) {
    return true;
  }

  //*******************************************
  // Obsługa przycisków
  //*******************************************
  function DM_nowy_wydatek_new_btn_handler(b, e) {
    var form = DM.form.nowy_wydatek;
    if (!form.getForm().isValid()) {
      return;
    }
    var daneNowegoWydatku = new Ext.data.Record(Ext.getCmp('DM.form.nowy_wydatek').getForm().getFieldValues());
    DM.store.wydatki.add(daneNowegoWydatku);

    DM.store.wydatki.commitChanges();
    DM.win.okno_wydatki.hide();
  }

  function DM_nowy_wydatek_change_btn_handler(b, e) {
    var form = DM.form.nowy_wydatek;
    if (!form.getForm().isValid()) {
      return;
    } else {
      var sm = DM.grid.wydatki.getSelectionModel();
      var dane_z_formularza = {};
      DM_clone(dane_z_formularza, Ext.getCmp('DM.form.nowy_wydatek').getForm().getFieldValues());
      DM.store.wydatki.getAt(sm.lastActive).data = dane_z_formularza;
      DM.store.wydatki.getAt(sm.lastActive).commit();
      DM.win.okno_wydatki.hide();
    }
  }
})();
