var delegacje_wydatki = new (function Delegacje_wydatki() {
  this.wlacz_tabele_wydatkow = function () {
    if (!DM.conf.actionConf.otherParams.isSpendingTableVisible) {
      return;
    }
    var panelTitle =
      DM.data.typ_delegacji == 'zagranica' ? DM.translator.m('spendings.foreign.title') : DM.translator.m('spendings.poland.title');

    DM.vp.items.get(0).items.get(1).add({
      xtype: 'panel',
      hidden: true,
      layout: 'fit',
      title: panelTitle,
      header: true,
      items: DM.grid.wydatki,
    });

    DM.vp.items.get(0).items.get(1).doLayout();
  };
})();

(function () {
  DM.fields.wydatki = ['nazwa_wydatku', 'rodzaj_wydatku', 'paymentMethod', 'koszt', 'waluta', 'data', 'documentType', 'rateFromDayBefore', 'wydatek_id'];
  DM.windowsFieldsToHide.spendings.isSpendingNameHidden = DM_isFieldToHide(DM.fields.wydatki[0]);
  DM.windowsFieldsToHide.spendings.isSpendingTypeHidden =
    DM.conf.actionConf.spendingTypes.length < 1 || DM_isFieldToHide(DM.fields.wydatki[1]) ? true : false;
  DM.windowsFieldsToHide.spendings.isPaymentMethodsHidden =
    DM.conf.actionConf.paymentMethods.length < 1 || DM_isFieldToHide(DM.fields.wydatki[2]) ? true : false;
  DM.windowsFieldsToHide.spendings.isSpendingDateHidden = DM_isFieldToHide(DM.fields.wydatki[5]);
  DM.windowsFieldsToHide.spendings.isDocumentTypeHidden =
    DM.conf.actionConf.documentTypes.length < 1 || DM_isFieldToHide(DM.fields.wydatki[6]) ? true : false;

  DM.columns.wydatki = [
    {
      header: DM.translator.m('spendings.name.column'),
      dataIndex: DM.fields.wydatki[0],
      width: 60,
      editable: false,
      hidden: DM.windowsFieldsToHide.spendings.isSpendingNameHidden,
    },
    {
      header: DM.translator.m('spendings.type.column'),
      dataIndex: DM.fields.wydatki[1],
      width: 80,
      editable: false,
      hidden: DM.windowsFieldsToHide.spendings.isSpendingTypeHidden,
    },
    {
      header: DM.translator.m('spendings.payment.method.column'),
      dataIndex: DM.fields.wydatki[2],
      width: 80,
      editable: false,
      hidden: DM.windowsFieldsToHide.spendings.isPaymentMethodsHidden,
    },
    {
      header: DM.translator.m('spendings.documentType.column'),
      dataIndex: DM.fields.wydatki[6],
      width: 80,
      editable: false,
      hidden: DM.windowsFieldsToHide.spendings.isDocumentTypeHidden,
    },
    {
      header: DM.translator.m('cost'),
      dataIndex: DM.fields.wydatki[3],
      width: 60,
      editable: false,
      xtype: 'numbercolumn',
      format: DM.conf.getNumberViewFormat(DM.conf.decimalseparator),
    },
    {
      header: DM.translator.m('currency'),
      dataIndex: DM.fields.wydatki[4],
      width: 80,
      editable: false,
      hidden: DM.data.typ_delegacji != 'zagranica',
    },
    {
      header: DM.translator.m('date'),
      dataIndex: DM.fields.wydatki[5],
      width: 100,
      editable: false,
      xtype: 'datecolumn',
      format: 'Y-m-d',
      hidden: DM.windowsFieldsToHide.spendings.isSpendingDateHidden,
    },
    {
      header: DM.translator.m('spendings.rateFromDayBefore.columnName'),
      dataIndex: DM.fields.wydatki[7],
      width: 100,
      editable: false,
      hidden: DM.data.typ_delegacji != 'zagranica' || DM.conf.jsonConf.zagranica.ukryj_kurs_wydatku_z_dnia_poprzedzajacego_wystawienie_faktury,
      renderer: function( value ) {
        if ( value ) {
          return DM.translator.m('Tak');
        } else {
          return DM.translator.m('Nie');
        }
      }

    },
  ];

  DM.store.wydatki = new Ext.data.JsonStore({
    autoSave: false,
    storeId: 'rozdel_grid_wydatki_store',
    fields: DM.fields.wydatki,
  });

  DM.grid.wydatki = new Ext.grid.GridPanel({
    frame: false,
    columnLines: true,
    stripeRows: true,
    store: DM.store.wydatki,
    border: false,
    colModel: new Ext.grid.ColumnModel({
      defaults: {
        sortable: false,
        menuDisabled: true,
        align: 'left',
        editable: true,
      },
      columns: DM.columns.wydatki,
    }),
    viewConfig: {
      forceFit: true,
      getRowClass: function(record, index) {
        return DM.conf.actionConf.otherParams.isGridValuesCentered ? 'settlement-column-center' : '';
      },
    },
    buttons: [
      {
        id: 'dodaj_wydatek',
        iconCls: "dvnt-icon-table-add",
        text: DM.translator.m('spendings.change.button.add'),
        autoWidth: true,
        handler: DM_nowy_wydatek,
        hidden: DM.conf.actionConf.otherParams.isReadOnlyMode,
      },
      {
        id: 'modyfikuj_wydatek',
        iconCls: "dvnt-icon-table-edit",
        text: DM.translator.m('spendings.change.button.change'),
        autoWidth: true,
        handler: DM_modyfikuj_wydatek,
        hidden: DM.conf.actionConf.otherParams.isReadOnlyMode,
      },
      {
        id: 'usun_wydatek',
        iconCls: "dvnt-icon-table-row-delete",
        text: DM.translator.m('spendings.change.button.delete'),
        autoWidth: true,
        handler: DM_usun_wydatek,
        hidden: DM.conf.actionConf.otherParams.isReadOnlyMode,
      },
    ],
    listeners: {
      afteredit: function (val) {
        val.record.commit();
      },
    },
    autoScroll: true,
  });

  // *******************************************
  // Otwarcie okna do dodawania wydatku
  // *******************************************
  function DM_nowy_wydatek() {
    // Ustawienie zmiennej akcji
    DM.typform_addmod = 'add';
    // Wyczyszczenie formularza
    Ext.getCmp('DM.form.nowy_wydatek').getForm().reset();
    Ext.getCmp('DM.form.nowy_wydatek').getForm().items.items[7].setValue(DM.conf.jsonConf.zagranica.kurs_wydatku_z_dnia_poprzedzajacego_wystawienie_faktury);
    // Wyłączenie przycisku zmiany
    Ext.getCmp('DM.form.nowy_wydatek.button.add').setVisible(true);
    Ext.getCmp('DM.form.nowy_wydatek.button.change').setVisible(false);
    DM.win.okno_wydatki.setTitle(DM.translator.m('spendings.change.button.add'));
    // Otwarcie okna
    DM.win.okno_wydatki.show();
  }

  // *******************************************
  // Otwarie okna do modyfikacji wydatku
  // *******************************************
  function DM_modyfikuj_wydatek() {
    var selectionModel = DM.grid.wydatki.getSelectionModel();
    if (typeof selectionModel.lastActive === 'undefined' || selectionModel.lastActive === null || selectionModel.lastActive === false) {
      DM_infoMsg(DM.translator.m('spendings.change.changeInfoMsg'));
      return;
    } else {
      // Ustawienie zmiennej akcji
      DM.typform_addmod = 'mod';
      Ext.getCmp('DM.form.nowy_wydatek').getForm().reset();
      // Wyłączenie/wyłączanie przycisków
      Ext.getCmp('DM.form.nowy_wydatek.button.add').setVisible(false);
      Ext.getCmp('DM.form.nowy_wydatek.button.change').setVisible(true);
      DM.win.okno_wydatki.setTitle(DM.translator.m('spendings.change.title'));
      // Otwarcie okna
      DM.win.okno_wydatki.show();
      // Pobranie danych do formularza
      Ext.getCmp('DM.form.nowy_wydatek').getForm().loadRecord(selectionModel.getSelected());
    }
  }

  // *******************************************
  // Usuwanie zaznaczonego wydatku
  // *******************************************
  function DM_usun_wydatek() {
    var sm = DM.grid.wydatki.getSelectionModel();
    if (typeof sm.lastActive === 'undefined' || sm.lastActive === null || sm.lastActive === false) {
      DM_infoMsg(DM.translator.m('spendings.change.deleteInfoMsg'));
      return;
    } else {
      // Pobranie i usunięcie zaznaczonego rekordu
      DM.store.wydatki.remove(sm.getSelections());
      // Odświeżenie tabeli
      DM.grid.wydatki.getView().refresh();
    }
  }
})();
