(function () {
  // okno wyswietalace wyniki rozliczenia
  DM.grid.rozliczenie_columnmodel = new Ext.grid.ColumnModel({
    defaults: {
      sortable: false,
      menuDisabled: true,
      align: 'left',
      autoWidth: true,
    },
    columns: [
      {
        header: DM.translator.m('name'),
        dataIndex: 'nazwa',
        width: 470,
      },
      {
        header: DM.translator.m('value'),
        dataIndex: 'wartosc',
        width: 240,
      },
    ],
  });

  DM.store.rozliczenie_ogolne = new Ext.data.JsonStore({
    autoSave: false,
    fields: ['nazwa', 'wartosc'],
  });

  DM.store.rozliczenie_kraj = new Ext.data.JsonStore({
    autoSave: false,
    fields: ['nazwa', 'wartosc'],
  });

  DM.store.rozliczenie_zagranica = new Ext.data.JsonStore({
    autoSave: false,
    fields: ['nazwa', 'wartosc'],
  });

  DM.store.rozliczenie_wydatkow = new Ext.data.JsonStore({
    autoSave: false,
    fields: ['nazwa', 'wartosc'],
  });

  DM.grid.rozliczenie_ogolne = new Ext.grid.GridPanel({
    store: DM.store.rozliczenie_ogolne,
    frame: false,
    autoHeight: true,
    autoWidth: true,
    hideHeaders: true,
    enableHdMenu: false,
    title: DM.translator.m('settlement.general.grid.title'),
    colModel: DM.grid.rozliczenie_columnmodel,
    // viewConfig : {
    // forceFit : true
    // },
    autoScroll: true,
    disableSelection: true,
  });

  DM.grid.rozliczenie_kraj = new Ext.grid.GridPanel({
    store: DM.store.rozliczenie_kraj,
    frame: false,
    autoHeight: true,
    autoWidth: true,
    hideHeaders: true,
    enableHdMenu: false,
    title: DM.translator.m('settlement.poland.grid.title'),
    colModel: DM.grid.rozliczenie_columnmodel,
    // viewConfig : {
    // forceFit : true
    // },
    autoScroll: true,
    disableSelection: true,
  });

  DM.grid.rozliczenie_zagranica = new Ext.grid.GridPanel({
    store: DM.store.rozliczenie_zagranica,
    frame: false,
    autoHeight: true,
    autoWidth: true,
    hideHeaders: true,
    enableHdMenu: false,
    title: DM.translator.m('settlement.foreign.grid.title'),
    colModel: DM.grid.rozliczenie_columnmodel,
    // viewConfig : {
    // forceFit : true
    // },
    autoScroll: true,
    disableSelection: true,
  });

  //Wyświetlenie wydatków w zależności od rodzaju delegacji (krajowa/zagraniczna)
  DM.grid.rozliczenie_wydatkow = new Ext.grid.GridPanel({
    store: DM.store.rozliczenie_wydatkow,
    frame: false,
    autoHeight: true,
    autoWidth: true,
    hideHeaders: true,
    enableHdMenu: false,
    title: DM.translator.m('spendings.grid.title'),
    colModel: DM.grid.rozliczenie_columnmodel,
    autoScroll: true,
    disableSelection: true,
  });

  DM.win.rozliczenie = new Ext.Window({
    // autoWidth : true,
    id: 'DM_settlementResultsWindow',
    layout: 'fit',
    autoScroll: true,
    width: 700,
    padding: 20,
    // height : 300,
    resizable: false,
    closeAction: 'hide',
    modal: true,
    title: DM.translator.m('settlement.title'),
    bodyStyle: {
      'overflow-y': 'auto'
    },
    items: [
      DM.grid.rozliczenie_ogolne,
      DM.grid.rozliczenie_kraj,
      DM.grid.rozliczenie_zagranica,
      DM.grid.rozliczenie_wydatkow,
      {
        xtype: 'label',
        id: 'DM.rozliczenie.win.label.suma',
        style: {
          marginLeft: '5px',
          fontWeight: 'bold',
        },
        text: DM.translator.m('settlement.summary.text', '0.00', getUnitTranslation()),
      },
    ],
    buttons: [
      {
        text: DM.translator.m('ok'),
        formBind: true,
        autoWidth: true,
        handler: function (b, e) {
          DM_zapisz_rozl_na_mapie_generujPdf_i_przejdz_do_procesu();
        },
      },
    ],
    listeners: {
      afterlayout: function() {
        DM_setHeightOnSmallerScreens(this);
      }
    },
  });
})();
