if (!shouldOpenDelegation) {
  var msgBox = Ext.Msg.show({
    title: DM.translator.m("error"),
    msg:
      DM.translator.m("cannotResolveRateDate") +
      " " +
      DM.translator.m(errorMessage),
    buttons: {
      ok: Ext.Msg.OK,
    },
    fn: function (buttonId) {
      DM_goToActivity(
        DM.data.zm_procesu.activity_id,
        DM.data.zm_procesu.process_id
      );
    },
    icon: Ext.Msg.ERROR,
  });
  DM_removeLoadingMask(loadingConfMaskId);
} else {
  Ext.onReady(function () {
    DM.fields.podstawowe = [
      "nr_delegacji",
      "imie_nazwisko",
      "cel_delegacji",
      "data_odjazdu",
      "data_powrotu",
      "kraje_docelowe",
      "miasto_docelowe",
      "czy_przekroczono_dystans_dla_diety",
      "data_kursu",
      "podstawowy_srodek_transportu",
      "data_wydania_zaliczki",
    ];
    // panel z przekazanymi danymi
    DM.form.podstawowe = new Ext.form.FormPanel({
      title: DM.translator.m("baseData.panel.title"),
      width: 400,
      bodyPadding: 5,
      labelWidth: 200,
      autoWidth: false,
      border: false,
      listeners: {
        afterlayout: function (form) {
          form.getForm().items.each(function (item) {
            if (item.hidden) {
              jQuery("#" + item.id)
                .closest(".x-form-item")
                .css("margin-bottom", "0px");
            }
          });
        },
      },
      defaults: {
        disabled: true,
        width: 175,
        anchor: "99%",
      },
      items: [
        {
          xtype: "textfield",
          fieldLabel: DM.translator.m("baseData.id.item"),
          name: DM.fields.podstawowe[0],
          id: "DM.podst.nr_delegacji",
          value: DM.data.zm_procesu.nr_delegacji,
          width: 207,
          hidden: DM_isFieldToHide(DM.fields.podstawowe[0]),
          hideLabel: DM_isFieldToHide(DM.fields.podstawowe[0]),
        },
        {
          xtype: "textfield",
          fieldLabel: DM.translator.m("baseData.nameAndSurname.item"),
          name: DM.fields.podstawowe[1],
          value: DM.data.zm_procesu.imie_nazwisko,
          hidden: DM_isFieldToHide(DM.fields.podstawowe[1]),
          hideLabel: DM_isFieldToHide(DM.fields.podstawowe[1]),
        },
        {
          xtype: "textfield",
          fieldLabel: DM.translator.m("baseData.goal.item"),
          name: DM.fields.podstawowe[2],
          value: DM.data.zm_procesu.cel_delegacji,
          hidden: DM_isFieldToHide(DM.fields.podstawowe[2]),
          hideLabel: DM_isFieldToHide(DM.fields.podstawowe[2]),
        },
        {
          xtype: "datefield",
          fieldLabel: DM.translator.m("baseData.startDate.item"),
          name: DM.fields.podstawowe[3],
          id: "DM.podst.data_odjazdu",
          value: DM.data.zm_procesu.data_odjazdu,
          hidden: DM_isFieldToHide(DM.fields.podstawowe[3]),
          hideLabel: DM_isFieldToHide(DM.fields.podstawowe[3]),
          format: "Y-m-d",
        },
        {
          xtype: "datefield",
          fieldLabel: DM.translator.m("baseData.finishDate.item"),
          name: DM.fields.podstawowe[4],
          id: "DM.podst.data_powrotu",
          value: DM.data.zm_procesu.data_powrotu,
          hidden: DM_isFieldToHide(DM.fields.podstawowe[4]),
          hideLabel: DM_isFieldToHide(DM.fields.podstawowe[4]),
          format: "Y-m-d",
        },
        {
          xtype: "textfield",
          fieldLabel: DM.translator.m("baseData.targetCountry.item"),
          name: DM.fields.podstawowe[5],
          value: DM.data.zm_procesu.kraje_docelowe,
          hidden: DM_isFieldToHide(DM.fields.podstawowe[5]),
          hideLabel: DM_isFieldToHide(DM.fields.podstawowe[5]),
        },
        {
          xtype: "textfield",
          fieldLabel: DM.translator.m("baseData.targetCity.item"),
          name: DM.fields.podstawowe[6],
          value: DM.data.zm_procesu.miasto_docelowe,
          hidden: DM_isFieldToHide(DM.fields.podstawowe[6]),
          hideLabel: DM_isFieldToHide(DM.fields.podstawowe[6]),
        },
        {
          xtype: "combo",
          disabled: false,
          fieldLabel: DM.translator.m("baseData.calculateDietForMinDistance.item") + ' ' + DM.conf.jsonConf.minimum_distance_for_diet_calculation + ' km?',
          name: DM.fields.podstawowe[7],
          value: DM.data.zm_procesu.czy_przekroczono_dystans_dla_diety,
          typeAhead: true,
          triggerAction: "all",
          lazyRender: true,
          editable: true,
          allowBlank: true,
          forceSelection: true,
          mode: "local",
          valueField: "czy_przekroczon_dystans_dla_diety_rach_text",
          displayField: "display",
          store: new Ext.data.ArrayStore({
            fields: ["czy_przekroczon_dystans_dla_diety_rach_text", "display"],
            data: [
              [
                null,
                "",
              ],
              [
                true,
                DM.translator.m("Tak"),
              ],
              [
                false,
                DM.translator.m("Nie"),
              ],
            ],
          }),
          listeners: {
            afterrender: function(combo) {
              if (combo.getValue() === '') {
                combo.setValue(null);
              }
            }
          },
          hidden: DM_isFieldToHide(DM.fields.podstawowe[7]) || DM.conf.jsonConf.minimum_distance_for_diet_calculation < 1,
          hideLabel: DM_isFieldToHide(DM.fields.podstawowe[7]) || DM.conf.jsonConf.minimum_distance_for_diet_calculation < 1,
        },
        {
          xtype: "datefield",
          fieldLabel: DM.translator.m("baseData.rateDate.item"),
          name: DM.fields.podstawowe[8],
          value: DM.data.rateDate,
          hidden: DM_isFieldToHide(DM.fields.podstawowe[8]),
          hideLabel: DM_isFieldToHide(DM.fields.podstawowe[8]),
          format: "Y-m-d",
        },
        {
          xtype: "textfield",
          fieldLabel: DM.translator.m("baseData.transportType.item"),
          name: DM.fields.podstawowe[9],
          value: DM.data.zm_procesu.srodek_transportu,
          hidden: DM_isFieldToHide(DM.fields.podstawowe[9]),
          hideLabel: DM_isFieldToHide(DM.fields.podstawowe[9]),
        },
        {
          //pole tylko na potrzeby obliczenia delegacji, aby wartość była z powrotem przesłana na serwer
          xtype: "datefield",
          fieldLabel: "Data wydania zaliczki",
          name: DM.fields.podstawowe[10],
          value: DM.data.zm_procesu.data_wydania_zaliczki,
          hidden: true,
          hideLabel: true,
          format: "Y-m-d",
        },
      ],
    });

    DM.fields.ewidencja = [
      "koszty_paliwa",
      "sr_lokomocji",
      "marka_pojazdu",
      "nr_rejestracyjny",
      "adres_uzytkownika_pojazdu",
      "pojemnosc_silnika",
      "stawka_za_1_km",
      "laczna_ilosc_przejechanych_km",
    ];
    // ewidencja pojazdu - do obliczania kilometrowki (ryczalt za
    // dojazdy)
    DM.form.ewidencja = new Ext.form.FormPanel({
      title: DM.translator.m("transportCard.panel.title"),
      bodyPadding: 5,
      labelWidth: 200,
      width: 400,
      border: false,
      style: {
        margin: "0 0 0 40px",
      },
      defaults: {
        width: 175,
        disabled: DM.conf.actionConf.otherParams.isReadOnlyMode,
        anchor: "99%",
      },
      items: [
        {
          xtype: "combo",
          fieldLabel: DM.translator.m("transportCard.fuelBill.item"),
          name: DM.fields.ewidencja[0],
          hiddenName: DM.fields.ewidencja[0],
          typeAhead: true,
          triggerAction: "all",
          lazyRender: true,
          editable: true,
          allowBlank: true,
          forceSelection: true,
          mode: "local",
          valueField: "przedstawiono_rach_text",
          displayField: "display",
          store: new Ext.data.ArrayStore({
            fields: ["przedstawiono_rach_text", "display"],
            data: [
              [
                "Nie przedstawiono",
                DM.translator.m("transportCard.fuelBill.item.notpresented"),
              ],
              [
                "Przedstawiono",
                DM.translator.m("transportCard.fuelBill.item.presented"),
              ],
            ],
          }),
          hidden: DM_isFieldToHide(DM.fields.ewidencja[0]),
          hideLabel: DM_isFieldToHide(DM.fields.ewidencja[0]),
        },
        {
          xtype: "combo",
          id: "DM.ewidencja.form.sr_lokomocji",
          fieldLabel: DM.translator.m("transportCard.transportType.item"),
          name: DM.fields.ewidencja[1],
          hiddenName: DM.fields.ewidencja[1],
          value: DM.data.zm_procesu.sr_lokomocji,
          typeAhead: true,
          triggerAction: "all",
          lazyRender: true,
          editable: true,
          allowBlank: true,
          forceSelection: true,
          mode: "local",
          store: new Ext.data.ArrayStore({
            fields: ["srodek_lok_text", "km", "display"],
            data: DM.conf.jsonConf.kilometrowka,
          }),
          valueField: "srodek_lok_text",
          displayField: "display",
          listeners: {
            select: function (combo, record, index) {
              var selected = DM.conf.jsonConf.kilometrowka[index];
              var stawka = selected[1].replace(".", DM.conf.decimalseparator);
              Ext.getCmp("DM.ewidencja.form.stawka_za_1_km").setValue(stawka);
            },
            blur: function (combo) {
              if (combo.getValue() == "") {
                Ext.getCmp("DM.ewidencja.form.stawka_za_1_km").setValue(0);
              }

              if (
                Ext.getCmp("DM.ewidencja.form.pojemnosc_silnika").value !== ""
              ) {
                if (DM_addmod_trasa_czy_wymog_ewidencji_pojazdu()) {
                  if (!DM_valid_form_ewidencja_pojazdu_pojemnosc()) {
                    DM_errorMsg(
                      DM.translator.m(
                        "main.panel.button.settle.wrong.engine.capacity"
                      )
                    );
                  }
                }
              }
            },
          },
          hidden: DM_isFieldToHide(DM.fields.ewidencja[1]),
          hideLabel: DM_isFieldToHide(DM.fields.ewidencja[1]),
          validator: function (val) {
            if (DM.data.zm_procesu.sr_lokomocji) {
              this.setReadOnly(true);
              this.getEl().setStyle("color", "gray");
              this.getEl().setStyle("opacity", "0.6");
            }
          },
        },
        {
          xtype: "textfield",
          fieldLabel: DM.translator.m("transportCard.carBrand.item"),
          width: 212,
          name: DM.fields.ewidencja[2],
          value: DM.data.zm_procesu.marka_pojazdu,
          hidden: DM_isFieldToHide(DM.fields.ewidencja[2]),
          hideLabel: DM_isFieldToHide(DM.fields.ewidencja[2]),
          validator: function (val) {
            if (DM.data.zm_procesu.marka_pojazdu) {
              this.setReadOnly(true);
              this.getEl().setStyle("color", "gray");
              this.getEl().setStyle("opacity", "0.6");
            }
            return DM_semicolonValidation(val);
          },
        },
        {
          xtype: "textfield",
          fieldLabel: DM.translator.m("transportCard.registrationNumber.item"),
          name: DM.fields.ewidencja[3],
          value: DM.data.zm_procesu.nr_rejestracyjny,
          hidden: DM_isFieldToHide(DM.fields.ewidencja[3]),
          hideLabel: DM_isFieldToHide(DM.fields.ewidencja[3]),
          validator: function (val) {
            if (DM.data.zm_procesu.nr_rejestracyjny) {
              this.setReadOnly(true);
              this.getEl().setStyle("color", "gray");
              this.getEl().setStyle("opacity", "0.6");
            }
            return DM_semicolonValidation(val);
          },
        },
        {
          xtype: "textfield",
          fieldLabel: DM.translator.m("transportCard.personAdress.item"),
          name: DM.fields.ewidencja[4],
          value: DM.data.zm_procesu.adres_uzytkownika_pojazdu,
          hidden: DM_isFieldToHide(DM.fields.ewidencja[4]),
          hideLabel: DM_isFieldToHide(DM.fields.ewidencja[4]),
          validator: function (val) {
            if (DM.data.zm_procesu.adres_uzytkownika_pojazdu) {
              this.setReadOnly(true);
              this.getEl().setStyle("color", "gray");
              this.getEl().setStyle("opacity", "0.6");
            }
            return DM_semicolonValidation(val);
          },
        },
        {
          xtype: "numberfield",
          id: "DM.ewidencja.form.pojemnosc_silnika",
          fieldLabel: DM.translator.m("transportCard.engineCapacity.item"),
          name: DM.fields.ewidencja[5],
          value: DM.data.zm_procesu.pojemnosc_silnika,
          allowNegative: false,
          allowDecimals: false,
          hidden: DM_isFieldToHide(DM.fields.ewidencja[5]),
          hideLabel: DM_isFieldToHide(DM.fields.ewidencja[5]),
          listeners: {
            blur: function (combo) {
              if (DM_addmod_trasa_czy_wymog_ewidencji_pojazdu()) {
                if (!DM_valid_form_ewidencja_pojazdu_pojemnosc()) {
                  DM_errorMsg(
                    DM.translator.m(
                      "main.panel.button.settle.wrong.engine.capacity"
                    )
                  );
                }
              }
            },
          },
          validator: function (val) {
            if (DM.data.zm_procesu.pojemnosc_silnika) {
              this.setReadOnly(true);
              this.getEl().setStyle("color", "gray");
              this.getEl().setStyle("opacity", "0.6");
            }
          },
        },
        {
          xtype: "textfield",
          id: "DM.ewidencja.form.stawka_za_1_km",
          fieldLabel: DM.translator.m("transportCard.kilometerRate.item"),
          name: DM.fields.ewidencja[6],
          disabled: true,
          hidden: DM_isFieldToHide(DM.fields.ewidencja[6]),
          hideLabel: DM_isFieldToHide(DM.fields.ewidencja[6]),
        },
        {
          xtype: "textfield",
          id: "DM.ewidencja.form.laczna_ilosc_przejechanych_km",
          fieldLabel: DM.translator.m(
            "transportCard.totalDrivenKilometers.item"
          ),
          name: DM.fields.ewidencja[7],
          disabled: true,
          hidden: DM_isFieldToHide(DM.fields.ewidencja[7]),
          hideLabel: DM_isFieldToHide(DM.fields.ewidencja[7]),
        },
      ],
    });

    DM.fields.uwagi = ["uwagi"];
    // panel z przekazanymi danymi
    DM.form.uwagi = new Ext.form.FormPanel({
      title: DM.translator.m("comments.panel.title"),
      bodyPadding: 5,
      width: 400,
      height: 365,
      border: false,
      style: {
        margin: "0 0 0 80px",
      },
      layout: "vbox",
      defaults: {
        anchor: "99%",
      },
      items: [
        {
          xtype: "label",
          text: DM.translator.m("comments"),
        },
        {
          xtype: "box",
          height: 5,
        },
        {
          xtype: "textarea",
          id: "DM.form.inne.uwagi",
          enableKeyEvents: true,
          flex: 1,
          name: DM.fields.uwagi[0],
          maxLength: 1000,
          maxLengthText: DM.translator.m("comments.item.maxLenghtText"),
          width: 390,
          disabled: DM.conf.actionConf.otherParams.isReadOnlyMode,
          hidden: DM_isFieldToHide(DM.fields.uwagi[0]),
          hideLabel: true,
          listeners: {
            keypress: function (f, e) {
              var val = f.getValue();
              if (event.keyCode != 8 && event.keyCode != 46) {
                // backspace
                // delete
                if (val.length >= 1000) {
                  e.stopEvent();
                }
              }
              return;
            },
          },
        },
      ],
    });

    // panel z buttonami obliczanie/zapisywanie/anulowania rozliczenia
    // delegacji
    DM.panel.main_buttons = new Ext.Panel({
      align: "right",
      border: false,
      buttons: [
        {
          id: "settleCalcBtn",
          iconCls: "dvnt-icon-calculator",
          text: DM.translator.m("settle"),
          handler: function () {
            if (DM.conf.jsonConf.minimum_distance_for_diet_calculation > 0 && DM.form.podstawowe.getForm().findField('czy_przekroczono_dystans_dla_diety').getValue() == null) {
              DM_errorMsg(
                  DM.translator.m(
                      "main.panel.button.settle.wrong.minimumDistanceForDiet"
                  )
              );
              return false;
            }
            if (!DM_valid_spendings_types()){
              DM_errorMsg(
                  DM.translator.m(
                      "main.panel.button.settle.wrong.spendings.type"
                  )
              );
              return false;
            }
            if (!DM_valid_spendings_payment_methods()){
              DM_errorMsg(
                  DM.translator.m(
                      "main.panel.button.settle.wrong.spendings.paymentMethod"
                  )
              );
              return false;
            }
            if (!DM_valid_spendings_document_types()){
              DM_errorMsg(
                  DM.translator.m(
                      "main.panel.button.settle.wrong.spendings.documentType"
                  )
              );
              return false;
            }
            if (DM_addmod_trasa_czy_wymog_ewidencji_pojazdu()) {
              if (!DM_valid_form_ewidencja_pojazdu_nie_puste()) {
                DM_errorMsg(
                  DM.translator.m("main.panel.button.settle.errorMsg1")
                );
                DM_removeLoadingMask(calculateMaskId);
                return false;
              }
              if (!DM_valid_form_ewidencja_pojazdu_pojemnosc()) {
                DM_errorMsg(
                  DM.translator.m(
                    "main.panel.button.settle.wrong.engine.capacity"
                  )
                );
                DM_removeLoadingMask("DM_calculate_mask_id");
                return false;
              }
            }
            if (DM.data.typ_delegacji === "zagranica") {
              if (!DM_del_kraj_docelowy_wymog_min_dwoch_krajow()) {
                DM_errorMsg(
                  DM.translator.m("main.panel.button.settle.errorMsg2")
                );
                DM_removeLoadingMask(calculateMaskId);
                return false;
              }

              if (!DM_del_polska_nie_ma_komunikacji_z_do_dworca()) {
                DM_errorMsg(
                  DM.translator.m('main.panel.button.settle.wrong.commutingToStation.poland')
                );
                return false;
              }
            }
            var calculateMaskId = "DM_calculate_mask_id";
            DM_showLoadingMask(
              calculateMaskId,
              DM.translator.m("main.panel.button.settle.loadingText")
            );
            setTimeout(
              function () {
                if (!DM_zapisanieDanych(DM, true)) {
                  DM_removeLoadingMask(calculateMaskId);
                  return false;
                }
                DM_removeLoadingMask(calculateMaskId);

                if (DM.conf.actionConf.otherParams.isSettlementWindowVisible) {
                  DM.win.rozliczenie.show();

                  /* wyśrodkowanie okna z rozliczeniem, timeout jest niezbędny */
                  setTimeout(function () {
                    DM.win.rozliczenie.center();
                  }, 10);
                } else {
                  DM_zapisz_rozl_na_mapie_generujPdf_i_przejdz_do_procesu();
                }
              },
              1,
              this
            );
          },
          hidden: DM.conf.actionConf.otherParams.isReadOnlyMode,
        },
        {
          id: "settleSaveBtn",
          text: DM.translator.m("save"),
          iconCls: 'dvnt-icon-save',
          handler: function () {
            var savingMaskId = "DM_save_mask_id";
            DM_showLoadingMask(
              savingMaskId,
              DM.translator.m("save.loadingText")
            );
            setTimeout(
              function () {
                const success = DM_zapisanieDanych(DM, false);
                if (success) {
                  PW.ui.Message.show(
                    DM.translator.m("save.successMsg"),
                    "success"
                  );
                }
                DM_removeLoadingMask(savingMaskId);
              },
              1,
              this
            );
          },
          hidden: DM.conf.actionConf.otherParams.isReadOnlyMode,
        },
        {
          text: DM.translator.m("exit"),
          iconCls: "dvnt-icon-x-symbol",
          handler: function () {
            if (DM.conf.actionConf.otherParams.isReadOnlyMode == true) {
                DM_closeModule();
              if (DM.conf.actionConf.otherParams.itsHistoryView === true) {
                DM_goToHistoryView(
                  DM.data.zm_procesu.activity_id,
                  DM.data.zm_procesu.process_id
                );
              } else {
                DM_goToActivity(
                  DM.data.zm_procesu.activity_id,
                  DM.data.zm_procesu.process_id
                );
              }
            } else {
              var msgBox = Ext.Msg.show({
                title: DM.translator.m("exit.title"),
                msg: DM.translator.m("main.panel.button.exit.msg"),
                buttons: {
                  yes: DM.translator.m("Tak"),
                  no: DM.translator.m("Nie"),
                },
                fn: function (buttonId) {
                  if (buttonId === "yes") {
                      DM_closeModule();
                      DM_goToActivity(
                      DM.data.zm_procesu.activity_id,
                      DM.data.zm_procesu.process_id
                    );
                  }
                },
                icon: Ext.Msg.QUESTION,
              });
            }
          },
        },
      ],
    });

    // ustawienie podpowiedzi przy walidacji
    Ext.QuickTips.init();

    // viewport zawiera wszystkie panele wczesniej zdefiniowane
    DM.vp = new Ext.Viewport({
      autoEI: "div",
      layout: "border",
      hideBorders: true,
      items: [
        {
          xtype: "panel",
          id: "viewportInnerPanel",
          region: "center",
          layout: {
            type: "vbox",
            align: "stretch",
          },
          hideBorders: true,
          items: [
            {
              // lub
              // layout: 'column', gdy jest w regionie center
              layout: "hbox",
              autoHeight: true,
              frame: false,
              padding: 5,
              layoutConfig: {
                pack: "start",
              },
              defaults: {
                frame: false,
                padding: 5,
                autoWidth: true,
              },
              items: [DM.form.podstawowe, DM.form.ewidencja, DM.form.uwagi],
            },
            {
              xtype: "tabpanel",
              activeTab: 0,
              frame: false,
              padding: 5,
              height: 500,
              items: [
                {
                  xtype: "panel",
                  layout: "fit",
                  title: DM.translator.m("settlement.countries.panel.title"),
                  header: true,
                  items: DM.grid.ilosciowe,
                },
              ],
            },
            {
              xtype: "panel",
              height: 60,
              frame: false,
              padding: "0 15px 0 0",
              items: {
                layout: "fit",
                align: "right",
                border: false,
                items: DM.panel.main_buttons,
              },
            },
          ],
        },
      ],
    });

    // odczytanych jesli istnieja w bazie
    DM_odczytanieDanych(DM);

    // ustawienie danych poczatkowych na formularzu np. stawka za km
    DM_ustawienieStawkiZaKm();

    // ustawienia dot. tabel
    DM_dodaj_macierzysty_ilosciowa(DM.store.ilosciowe);
    DM_obliczLacznaIloscKm(DM.store.trasa);

    // ustawienia przyciskow
    if (DM.store.przeliczona) {
      DM_setButtonsForSettledDelegation();
    }

    DM.vp.show();

    business_trip_routs.business_trip_routs_add();
    delegacje_wydatki.wlacz_tabele_wydatkow();

    DM_removeLoadingMask(loadingConfMaskId);
  });
}
