PW.EventActions.register('run-business-trip-event', function (context) {
    var argsArray = Array.prototype.slice.call(arguments, 1);
    
    function createArgsFromArray(paramOrder) {
        var args = {};
        paramOrder.forEach(function(paramName, index) {
            args[paramName] = argsArray[index];
        });
        return args;
    }

    var paramOrder = [
        'settlementCountry',
        'shouldVariablesBeSave',
        'isReadOnlyMode',
        'isSpendingTableVisible',
        'isWarningIfDatesNotSynchronized',
        'isSettlementWindowVisible',
        'itsHistoryView',
        'isGridValuesCentered',
        'spendingTypes',
        'paymentMethods',
        'documentTypes',
        'exchangeForForeignBusinessTripsSettlement_stageWithContinuouslyRefreshedExchange',
        'exchangeForForeignBusinessTripsSettlement_refreshExchangeRates',
        'exchangeForForeignBusinessTripsSettlement_refreshingTodayOrFromField',
        'exchangeForForeignBusinessTripsSettlement_exchangeRateDateType',
        'exchangeForForeignBusinessTripsSettlement_idReadFieldName',
        'exchangeForForeignBusinessTripsSettlement_exchangeRateSource',
        'exchangeForForeignBusinessTripsSettlement_exchangeRateDataSourceId',
        'exchangeForForeignBusinessTripsSettlement_datasourceInputParametersId',
        'exchangeForForeignBusinessTripsSettlement_datasourceInputParametersValue',
        'generatingSettlementSummaryPdf_run',
        'generatingSettlementSummaryPdf_documentClass',
        'generatingSettlementSummaryPdf_templateName',
        'generatingCarCardPdf_run',
        'generatingCarCardPdf_documentClass',
        'generatingCarCardPdf_templateName',
        'fieldsToHide',
        // Input parameters
        'id',
        'type',
        'personName',
        'goal',
        'startDate',
        'finishDate',
        'city',
        'country',
        'transportType',
        'advanceDate',
        'transport',
        'vehicleBrand',
        'registrationNumber',
        'vehicleUserAddress',
        'engineCapacity',
        // Advances parameters
        'advanceAmounts',
        'advanceCurrencies',
        // Additional activity variables parameter
        'activityVariableParams',
        // Output parameters - tables
        'spendingsTable_nr_delegacji',
        'spendingsTable_wydatek_id',
        'spendingsTable_nazwa_wydatku',
        'spendingsTable_koszt',
        'spendingsTable_waluta',
        'spendingsTable_data',
        'spendingsTable_rodzaj_wydatku',
        'spendingsTable_paymentMethod',
        'spendingsTable_documentType',
        'spendingsTable_kurs_waluty',
        'spendingsTable_wspolczynnik_waluty',
        'summaryTable_nr_delegacji',
        'summaryTable_wyjazd_data',
        'summaryTable_wyjazd_godzina',
        'summaryTable_przyjazd_data',
        'summaryTable_przyjazd_godzina',
        'summaryTable_wyjazd_miejscowosc',
        'summaryTable_przyjazd_miejscowosc',
        'summaryTable_kraj_delegacji',
        'summaryTable_nr_rejestracyjny',
        'summaryTable_srodek_transportu',
        'summaryTable_cel_delegacji',
        'summaryTable_suma_dni_w_delegacji',
        'summaryTable_suma_ilosci_godzin_w_delegacji',
        'summaryTable_suma_ilosci_niezapewnionych_dob_komunikacji_miejskiej',
        'summaryTable_suma_ilosci_niezapewnionych_noclegow',
        'summaryTable_suma_ilosci_niezapewnionych_sniadan',
        'summaryTable_suma_ilosci_niezapewnionych_obiadow',
        'summaryTable_suma_ilosci_niezapewnionych_kolacji',
        'summaryTable_suma_ilosci_zapewnionych_dob_calodobowe_wyzywienie',
        'summaryTable_suma_ilosci_niezapewnionych_dob_calodobowe_wyzywienie',
        'summaryTable_suma_ilosci_niezapewnionych_przejazdow_do_z_dworca',
        'summaryTable_suma_ilosci_diet_kraj',
        'summaryTable_suma_ilosci_diet_zagranica',
        'summaryTable_suma_wydatkow',
        'summaryTable_miasto_docelowe',
        'costsTable_nr_delegacji',
        'costsTable_opis_linii',
        'costsTable_kwota_w_walucie',
        'costsTable_waluta',
        'costsTable_kurs_waluty',
        'costsTable_wspolczynnik_waluty'
    ];

    var args = createArgsFromArray(paramOrder);
    
    if (args.shouldVariablesBeSave) {
        ServiceFactory.getFormService().save({
            scope: this,
            success: function() {
                openBusinessTrip(args);
            },
        });
    } else {
        openBusinessTrip(args);
    }
});

function openBusinessTrip(args) {
    var url = "plugin/com.suncode.plugin-business-trip/businessTrip/open";
    var pdfItems = ["run", "documentClass", "templateName"];
    var refreshExchangeItems = [
        "stageWithContinuouslyRefreshedExchange",
        "refreshingTodayOrFromField",
        "idReadFieldName",
        "refreshExchangeRates",
        "exchangeRateDateType",
        "exchangeRateSource",
        "exchangeRateDataSourceId",
        "datasourceInputParametersId",
        "datasourceInputParametersValue",
    ];
    var otherParamsItems = [
        "settlementCountry",
        "isReadOnlyMode",
        "isSpendingTableVisible",
        "isWarningIfDatesNotSynchronized",
        "isSettlementWindowVisible",
        "itsHistoryView",
        "isGridValuesCentered",
    ];
    var actionConfDto = {
        inputParams: getInputParametersValues(args),
        outputParams: getOutputParameters(args),
        generatingSettlementSummaryPdf: getParamsSetting(
            pdfItems,
            "generatingSettlementSummaryPdf",
            args
        ),
        generatingCarCardPdf: getParamsSetting(
            pdfItems,
            "generatingCarCardPdf",
            args
        ),
        exchangeForForeignBusinessTripsSettlement:
            getExchangeForForeignBusinessTripsSettlement(refreshExchangeItems, args),
        spendingTypes: getArrayParamSetting("spendingTypes", args),
        paymentMethods: getArrayParamSetting("paymentMethods", args),
        documentTypes: getArrayParamSetting("documentTypes", args),
        otherParams: getParamsSetting(otherParamsItems, "", args),
        fieldsToHide: args.fieldsToHide,
        advanceAmounts: getParamCurrentArrayValues("advanceAmounts", args),
        advanceCurrencies: getParamCurrentArrayValues("advanceCurrencies", args),
        activityVariableParams: getArrayParamCurrentValues(
            "activityVariableParams",
            args
        ),
    };

    if (window.isHistory) {
        actionConfDto.otherParams.isReadOnlyMode = true;
        actionConfDto.otherParams.itsHistoryView = true;
    }

    DM = {
        translator: {
            m: PW.I18N.createT("com.suncode.plugin-business-trip"),
        },
    };

    if (!actionConfDto.inputParams.id) {
        msgError("action.runDelegation.variable.id.error");
        return false;
    }
    if (
        actionConfDto.inputParams.startDate > actionConfDto.inputParams.finishDate
    ) {
        msgError(
            "action.runDelegation.variable.startDateAndFinishDate.error"
        );
        return false;
    }

    var $form = jQuery("<form>").attr({
        method: "POST",
        action: url,
        "accept-charset": "utf-8",
    });
    var $input = jQuery("<input>").attr({
        type: "hidden",
        name: "actionConf",
        value: JSON.stringify(actionConfDto),
    });
    $form.append($input);

    var $csrfToken = jQuery("<input>").attr({
        type: "hidden",
        name: Suncode.getCsrfParameterName(),
        value: Suncode.getCsrfToken(),
    });
    $form.append($csrfToken);

    jQuery("body").append($form);
    $form.submit();
}

function getInputParametersValues(args) {
    var paramNames = [
        "type",
        "id",
        "personName",
        "goal",
        "startDate",
        "finishDate",
        "city",
        "country",
        "transportType",
        "advanceDate",
        "transport",
        "vehicleBrand",
        "registrationNumber",
        "vehicleUserAddress",
        "engineCapacity",
    ];
    var result = getCurrentInputParametersValues(paramNames, args);
    var activityInfoService = ServiceFactory.getActivityInfoService();
    result["processId"] = activityInfoService.getProcessId();
    result["activityId"] = activityInfoService.getActivityId();

    return result;
}

function getCurrentInputParametersValues(paramNames, args) {
    var result = {};
    
    PW.each(
        paramNames,
        function (param) {
            var value = args[param];
            if (Ext.isDate(value)) {
                value = Ext4.Date.format(value, "Y-m-d");
            }
            result[param] = value;
        }
    );

    return result;
}

function getOutputParameters(args) {
    var spendingsTableItems = [
        "nr_delegacji",
        "wydatek_id",
        "nazwa_wydatku",
        "koszt",
        "waluta",
        "data",
        "rodzaj_wydatku",
        "paymentMethod",
        "documentType",
        "kurs_waluty",
        "wspolczynnik_waluty",
    ];
    var summaryTableParamItems = [
        "nr_delegacji",
        "wyjazd_data",
        "wyjazd_godzina",
        "przyjazd_data",
        "przyjazd_godzina",
        "wyjazd_miejscowosc",
        "przyjazd_miejscowosc",
        "kraj_delegacji",
        "nr_rejestracyjny",
        "srodek_transportu",
        "cel_delegacji",
        "suma_dni_w_delegacji",
        "suma_ilosci_godzin_w_delegacji",
        "suma_ilosci_niezapewnionych_dob_komunikacji_miejskiej",
        "suma_ilosci_niezapewnionych_noclegow",
        "suma_ilosci_niezapewnionych_sniadan",
        "suma_ilosci_niezapewnionych_obiadow",
        "suma_ilosci_niezapewnionych_kolacji",
        "suma_ilosci_zapewnionych_dob_calodobowe_wyzywienie",
        "suma_ilosci_niezapewnionych_dob_calodobowe_wyzywienie",
        "suma_ilosci_niezapewnionych_przejazdow_do_z_dworca",
        "suma_ilosci_diet_kraj",
        "suma_ilosci_diet_zagranica",
        "suma_wydatkow",
        "miasto_docelowe",
    ];
    var costsTableParamItems = [
        "nr_delegacji",
        "opis_linii",
        "kwota_w_walucie",
        "waluta",
        "kurs_waluty",
        "wspolczynnik_waluty",
    ];
    var result = {
        spendingsTableParams: getTableItemsIds(
            "spendingsTable",
            spendingsTableItems,
            args
        ),
        summaryTableParams: getTableItemsIds(
            "summaryTable",
            summaryTableParamItems,
            args
        ),
        costsTableParams: getTableItemsIds(
            "costsTable",
            costsTableParamItems,
            args
        ),
    };
    return result;
}

function getTableItemsIds(tableName, tableItems, args) {
    var result = {};
    
    PW.each(
        tableItems,
        function (param) {
            var v = args[tableName + "_" + param];
            if (v) {
                result[param] = v.id;
            }
        }
    );

    return result;
}

function getParamsSetting(items, groupName, args) {
    var result = {};
    
    PW.each(
        items,
        function (param) {
            let v = groupName ? args[groupName + "_" + param] :args[param];
            if (v != null) {
                result[param] = v;
            }
        }
    );

    return result;
}

function getArrayParamSetting(item, args) {
    var result = [];
    var values = args[item];
    if (values && values[0]) {
        PW.each(
            values,
            function (value) {
                result.push([value]);
            }
        );
    }

    return result;
}

function getParamCurrentArrayValues(paramName, args) {
    var result = [];
    var values = args[paramName];
    PW.each(
        values,
        function (value) {
            PW.each(
                value.getValue(),
                function (v) {
                    result.push([v]);
                }
            );
        }
    );

    return result;
}

function getArrayParamCurrentValues(arrayParamName, args) {
    var values = {};
    var types = {};
    var params = args[arrayParamName];
    PW.each(
        params,
        function (param) {
            if (param) {
                types[param.id] = param.getType().name;
                values[param.id] = getArrayValues(
                    param.getValue(),
                    param.getType()
                );
            }
        }
    );
    return {values: values, types: types};
}

function getArrayValues(values, type) {
    var result = [];
    PW.each(
        values,
        function (v) {
            if (
                type.is("date") ||
                type.is("date[]") ||
                type.is("datetime") ||
                type.is("datetime[]")
            ) {
                result.push(v ? v.getTime() : null);
            } else {
                result.push(v);
            }
        }
    );
    if (result.length == 0) {
        result = [null];
    }
    return result;
}

function msgError(msgKey) {
    Ext.Msg.show({
        title: DM.translator.m("error"),
        msg: DM.translator.m(msgKey),
        buttons: Ext.Msg.OK,
        icon: Ext.Msg.ERROR,
    });
}

function getExchangeForForeignBusinessTripsSettlement(items, args) {
    var result = {};
    
    PW.each(
        items,
        function (param) {
            var v = args["exchangeForForeignBusinessTripsSettlement_" + param];
            if (v != null) {
                result[param] = v;
            }
        }
    );
    
    if (result["exchangeForForeignBusinessTripsSettlement_refreshExchangeRates"]) {
        result["exchangeForForeignBusinessTripsSettlement_stageWithContinuouslyRefreshedExchange"] = activityInfoService.getActivityDefId();
    }
    return result;
}
