/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.suncode.businesstrip.config.data.RateKey;
import com.suncode.businesstrip.dto.ExchangeDto;
import com.suncode.businesstrip.dto.RateDto;
import com.suncode.businesstrip.util.ExchangeRateSource;
import com.suncode.businesstrip.util.ExchangeService;
import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.util.exception.ServiceException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service(value="exchangeService")
public class ExchangeServiceImpl
implements ExchangeService {
    private static final Logger log = LoggerFactory.getLogger(ExchangeServiceImpl.class);
    @Autowired
    private DataSourceService dataSourceService;
    private RestTemplate restTemplate = new RestTemplate();
    private LoadingCache<RateKey, RateDto> loadingCache = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(key -> this.getLastExchange((RateKey)key, ExchangeRateSource.NBP)));
    private LoadingCache<RateKey, RateDto> ECBCache = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(key -> this.getLastExchange((RateKey)key, ExchangeRateSource.ECB)));

    @Override
    public HashMap<String, RateDto> getLastNbpExchanges(Set<String> exchangesSymbols, LocalDate date, String domesticCurrencyName) throws Exception {
        log.debug("Wybrana data: {}.", (Object)date);
        HashMap<String, RateDto> results = new HashMap<String, RateDto>();
        for (String symbol : exchangesSymbols) {
            RateDto lastExchange = null;
            if (symbol.equalsIgnoreCase(domesticCurrencyName)) {
                lastExchange = new RateDto();
                lastExchange.setEffectiveDate(date.toString());
                lastExchange.setExchangeSymbol(symbol);
                lastExchange.setMid(1.0);
            } else {
                lastExchange = this.getLastNbpExchange(symbol, date);
            }
            if (lastExchange == null) continue;
            results.put(symbol, lastExchange);
        }
        return results;
    }

    @Override
    public RateDto getLastNbpExchange(String exchangeSymbol, LocalDate date) throws Exception {
        try {
            RateKey rateKey = new RateKey(exchangeSymbol, date.toString());
            if (date.isBefore(LocalDate.now())) {
                return (RateDto)this.loadingCache.get((Object)rateKey);
            }
            return this.getLastExchange(rateKey, ExchangeRateSource.NBP);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public HashMap<String, RateDto> getLastECBExchanges(Set<String> exchangesSymbols, LocalDate date, String domesticCurrencyName) throws Exception {
        log.debug("Wybrana data: {}.", (Object)date);
        HashMap<String, RateDto> results = new HashMap<String, RateDto>();
        for (String symbol : exchangesSymbols) {
            RateDto lastExchange = null;
            if (symbol.equalsIgnoreCase(domesticCurrencyName)) {
                lastExchange = new RateDto();
                lastExchange.setEffectiveDate(date.toString());
                lastExchange.setExchangeSymbol(symbol);
                lastExchange.setMid(1.0);
            } else {
                lastExchange = this.getLastECBExchange(symbol, date);
            }
            if (lastExchange == null) continue;
            results.put(symbol, lastExchange);
        }
        return results;
    }

    @Override
    public RateDto getLastECBExchange(String exchangeSymbol, LocalDate date) {
        try {
            RateKey rateKey = new RateKey(exchangeSymbol, date.toString());
            if (date.isBefore(LocalDate.now())) {
                return (RateDto)this.ECBCache.get((Object)rateKey);
            }
            return this.getLastExchange(rateKey, ExchangeRateSource.ECB);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public HashMap<String, RateDto> getRateFromDataSource(String dataSourceId, Map<String, String> dataSourceInputParameters, Set<String> exchangesSymbols, LocalDate date) {
        HashMap<String, RateDto> results = new HashMap<String, RateDto>();
        DataSourceInstance dataSource = this.dataSourceService.getDataSource(dataSourceId);
        if (dataSource == null) {
            throw new IllegalArgumentException("Data supplier with id " + dataSourceId + " does not exist");
        }
        for (String symbol : exchangesSymbols) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("symbol", symbol);
            parameters.put("date", date.toString());
            parameters.putAll(dataSourceInputParameters);
            for (Map.Entry entry2 : parameters.entrySet()) {
                log.debug("DataSource input parameter " + (String)entry2.getKey() + "=" + (String)entry2.getValue());
            }
            CountedResult result = dataSource.execute(parameters, null);
            if (result.getData().size() == 0) {
                throw new ServiceException("DataSource '" + dataSourceId + "' did not return any data for parameters: " + parameters.entrySet().stream().map(entry -> "  " + (String)entry.getKey() + "=" + (String)entry.getValue() + "  ").collect(Collectors.joining()));
            }
            RateDto rate = new RateDto();
            rate.setEffectiveDate(((Map)result.getData().get(0)).get("date").toString());
            rate.setExchangeSymbol(((Map)result.getData().get(0)).get("symbol").toString());
            rate.setMid(Double.valueOf(((Map)result.getData().get(0)).get("rate").toString()));
            results.put(symbol, rate);
        }
        return results;
    }

    private RateDto getLastExchange(RateKey rateKey, ExchangeRateSource exchangeRateSource) {
        if (exchangeRateSource == ExchangeRateSource.DATA_SOURCE) {
            throw new IllegalArgumentException("Unsupported ExchangeRateSource: " + String.valueOf((Object)exchangeRateSource));
        }
        LocalDate date = LocalDate.parse(rateKey.getDate());
        ExchangeDto ex = this.getTenDaysExchanges(rateKey.getExchangeSymbol(), date, exchangeRateSource);
        if (ex == null) {
            throw new IllegalArgumentException();
        }
        RateDto result = this.selectLastExchange(ex, date);
        result.setExchangeSymbol(ex.getCode());
        return result;
    }

    private ExchangeDto getTenDaysExchanges(String exchangeSymbol, LocalDate endDate, ExchangeRateSource exchangeRateSource) {
        HashMap<String, String> urlVariables = new HashMap<String, String>();
        urlVariables.put("exchangeSymbol", exchangeSymbol);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        urlVariables.put("startDate", endDate.minusDays(9L).format(formatter));
        urlVariables.put("endDate", endDate.format(formatter));
        urlVariables.put("table", "A");
        ExchangeDto result = switch (exchangeRateSource) {
            case ExchangeRateSource.NBP -> this.getPeriodNbpExchanges(urlVariables);
            default -> this.getECBExchanges(urlVariables);
        };
        if (result == null) {
            urlVariables.put("table", "B");
            result = this.getPeriodNbpExchanges(urlVariables);
        }
        return result;
    }

    private ExchangeDto getPeriodNbpExchanges(Map<String, String> urlVariables) {
        ExchangeDto result;
        String url = "http://api.nbp.pl/api/exchangerates/rates/{table}/{exchangeSymbol}/{startDate}/{endDate}?format=json";
        try {
            result = (ExchangeDto)this.restTemplate.getForObject(url, ExchangeDto.class, urlVariables);
        }
        catch (RestClientException e) {
            log.warn("Not received NBP exchanges for table : {}, symbol: {}, from: {},  to: {}, due to : {}", new Object[]{urlVariables.get("table"), urlVariables.get("exchangeSymbol"), urlVariables.get("startDate"), urlVariables.get("endDate"), e.getLocalizedMessage()});
            result = null;
        }
        return result;
    }

    private ExchangeDto getECBExchanges(Map<String, String> urlVariables) {
        try {
            String exchangeSymbol = urlVariables.get("exchangeSymbol");
            String url = this.buildEcbExchangeUrl(urlVariables);
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept(Arrays.asList(MediaType.APPLICATION_XML));
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            String xmlContent = (String)response.getBody();
            if (xmlContent == null || xmlContent.isEmpty()) {
                log.warn("Not received ECB exchanges for symbol: {}, from: {}, to: {}, empty response", new Object[]{exchangeSymbol, urlVariables.get("startDate"), urlVariables.get("endDate")});
                return null;
            }
            return ExchangeDto.parseECBXml(xmlContent, exchangeSymbol);
        }
        catch (RestClientException e) {
            log.warn("Not received ECB exchanges for symbol: {}, from: {}, to: {}, due to: {}", new Object[]{urlVariables.get("exchangeSymbol"), urlVariables.get("startDate"), urlVariables.get("endDate"), e.getLocalizedMessage()});
            return null;
        }
        catch (Exception e) {
            log.error("Error parsing ECB XML for symbol: {}, from: {}, to: {}", new Object[]{urlVariables.get("exchangeSymbol"), urlVariables.get("startDate"), urlVariables.get("endDate"), e});
            return null;
        }
    }

    private String buildEcbExchangeUrl(Map<String, String> urlVariables) {
        String baseUrl = "https://data-api.ecb.europa.eu/service/data/EXR/D.";
        String exchangeSymbol = urlVariables.get("exchangeSymbol");
        String startDate = urlVariables.get("startDate");
        String endDate = urlVariables.get("endDate");
        String encodedSymbol = URLEncoder.encode(exchangeSymbol, StandardCharsets.UTF_8);
        String encodedStartDate = URLEncoder.encode(startDate, StandardCharsets.UTF_8);
        String encodedEndDate = URLEncoder.encode(endDate, StandardCharsets.UTF_8);
        return String.format("%s%s.EUR.SP00.A?startPeriod=%s&endPeriod=%s&format=sdmx-xml", baseUrl, encodedSymbol, encodedStartDate, encodedEndDate);
    }

    private RateDto selectLastExchange(ExchangeDto exchanges, LocalDate date) {
        if (exchanges == null) {
            return null;
        }
        List<RateDto> rates = exchanges.getRates();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        for (int i = 0; i <= 9; ++i) {
            LocalDate dateToCheck = date.minusDays(i);
            ListIterator<RateDto> it = rates.listIterator(rates.size());
            while (it.hasPrevious()) {
                RateDto rate = it.previous();
                LocalDate rateDate = LocalDate.parse(rate.getEffectiveDate(), formatter);
                if (!dateToCheck.equals(rateDate)) continue;
                return rate;
            }
        }
        return null;
    }
}

