/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.util;

import com.plusmpm.CUF.util.extension.SharkClientFunctions;
import com.suncode.businesstrip.config.Configuration;
import com.suncode.businesstrip.config.data.ActionConf;
import com.suncode.businesstrip.config.data.JsonConf;
import com.suncode.businesstrip.database.model.BusinessTrip;
import com.suncode.businesstrip.database.model.BusinessTripQuantities;
import com.suncode.businesstrip.util.ExchangeRateDateType;
import com.suncode.businesstrip.util.ExchangeService;
import com.suncode.businesstrip.util.Tools;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Exchange {
    private static final Logger log = LoggerFactory.getLogger(Exchange.class);
    public static ExchangeService exchangeService;
    private static SimpleDateFormat sdf;

    @Autowired
    public void setExchangeService(ExchangeService exchangeService) {
        Exchange.exchangeService = exchangeService;
    }

    private static Date getMaxFromRateDate(BusinessTrip trip, String domesticCountryName) {
        try {
            return trip.getIlosci().stream().filter(k -> !k.getKraj().equalsIgnoreCase("") && !k.getKraj().equalsIgnoreCase(domesticCountryName)).map(k -> {
                try {
                    return sdf.parse(k.getData_kursu());
                }
                catch (ParseException e) {
                    return null;
                }
            }).max(Date::compareTo).get();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean checkIfDelegationSettled(BusinessTrip trip, String domesticCountryName) {
        return trip.getIlosci().stream().anyMatch(i -> !i.getKraj().equalsIgnoreCase("") && !i.getKraj().equalsIgnoreCase(domesticCountryName) && i.getData_kursu() != null && !i.getData_kursu().equals(""));
    }

    private static Date getExchangeRateDateFromSettlement(BusinessTrip trip, String domesticCountryName) {
        return Exchange.getMaxFromRateDate(trip, domesticCountryName);
    }

    public static Set<String> getCurrencyNamesForTrip(BusinessTrip trip, JsonConf config) {
        Set<String> currencyNames = trip.getIlosci().stream().map(i -> i.getKraj()).filter(country -> !country.isBlank() && !country.equalsIgnoreCase(config.getDomesticCountryName())).map(kraj -> config.getZagranica().getDieta().get(kraj)[0]).collect(Collectors.toSet());
        currencyNames.addAll(trip.getWydatki().stream().filter(i -> !i.getWaluta().equalsIgnoreCase(config.getCurrencyName())).map(i -> i.getWaluta()).collect(Collectors.toSet()));
        return currencyNames;
    }

    public static Date selectExchangeRateDate(BusinessTrip trip, Date advanceDate, String processId, String activityId, String delegationNr) {
        ActionConf actionConf = Configuration.getActionConf(delegationNr);
        Boolean readOnly = actionConf.getOtherParams().getIsReadOnlyMode();
        JsonConf jsonConf = trip != null && trip.getData_powrotu() != null ? Configuration.getJsonConfigForDate(delegationNr, trip.getData_powrotu()) : Configuration.getActualJsonConfig(delegationNr);
        if (readOnly.booleanValue()) {
            return Exchange.getExchangeRateDateFromSettlement(trip, jsonConf.getDomesticCountryName());
        }
        boolean delegationSettled = trip != null && Exchange.checkIfDelegationSettled(trip, jsonConf.getDomesticCountryName());
        ExchangeRateDateType dateType = Exchange.getExchangeRateDateType(trip, advanceDate, activityId, processId, actionConf, jsonConf);
        switch (dateType) {
            case FROM_ADVANCE: {
                if (advanceDate != null) {
                    return advanceDate;
                }
                if (delegationSettled) {
                    return Exchange.getExchangeRateDateFromSettlement(trip, jsonConf.getDomesticCountryName());
                }
                return Exchange.getActualRateDate(delegationNr);
            }
            case FROM_FIELD: {
                String fieldId = actionConf.getExchangeSettings().getIdReadFieldName();
                if (StringUtils.isBlank((String)fieldId)) {
                    log.error("Brak ustawienia warto\u015bci parametru akcji 'idReadFieldName', potrzebnego do pobrania kursu waluty.");
                    throw new IllegalArgumentException("exchange.errorMsg.blankParamDate");
                }
                try {
                    Date dataFromField = sdf.parse((String)SharkClientFunctions.getActivityContextMap((String)processId, (String)activityId).get(fieldId));
                    log.debug("data z pola: " + String.valueOf(dataFromField));
                    int minusDays = -1;
                    try {
                        minusDays = Integer.parseInt(jsonConf.getZagranica().getKurs_do_obliczen().get("ile_dni_odjac_od_daty_pola"));
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        throw new IllegalArgumentException("exchange.errorMsg.incorrectParamDays");
                    }
                    log.debug("Pobieranie  daty kursu z pola " + fieldId + " - ile dni odj\u0105\u0107: " + minusDays);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(dataFromField);
                    cal.add(5, minusDays);
                    return cal.getTime();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    log.error("Niepoprawna data w zmiennej '" + fieldId + "', kt\u00f3ra jest potrzebna do pobrania kursu waluty.");
                    throw new IllegalArgumentException("exchange.errorMsg.incorrectDateInVar");
                }
            }
            case FROM_SETTLEMENT: {
                Date settlementRateDate = Exchange.getExchangeRateDateFromSettlement(trip, jsonConf.getDomesticCountryName());
                return settlementRateDate != null ? settlementRateDate : Exchange.getActualRateDate(delegationNr);
            }
        }
        return Exchange.getActualRateDate(delegationNr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ExchangeRateDateType getExchangeRateDateType(BusinessTrip trip, Date advanceDate, String processId, String activityId, ActionConf actionConf, JsonConf jsonConfig) {
        ExchangeRateDateType dateType = ExchangeRateDateType.ACTUAL;
        String dateTypeFromConf = actionConf.getExchangeSettings().getExchangeRateDateType();
        if (!StringUtils.isNotEmpty((String)dateTypeFromConf)) return Exchange.getRateDateTypeForOldVersionsPlugin(trip, advanceDate, activityId, processId, actionConf, jsonConfig.getDomesticCountryName(), jsonConfig);
        if (ExchangeRateDateType.contains(dateTypeFromConf)) {
            return ExchangeRateDateType.valueOf(dateTypeFromConf);
        }
        log.error("Brak ustawienia lub b\u0142\u0119dna wato\u015b\u0107 parametru akcji 'exchangeRateDateType', potrzebnego do pobrania kursu waluty. Ustawiono warto\u015b\u0107: " + dateTypeFromConf);
        throw new IllegalArgumentException("exchange.errorMsg.wrongExchangeRateDateTypeParam");
    }

    private static Date getActualRateDate(String delegationId) {
        int minusDays = -1;
        try {
            minusDays = Integer.parseInt(Configuration.getActualJsonConfig(delegationId).getZagranica().getKurs_do_obliczen().get("odswiezanie_ile_dni_odjac_od_dzisiaj"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("exchange.errorMsg.incorrectParamDays");
        }
        log.debug("Pobieranie aktualnej daty kursu - ile dni odj\u0105\u0107: " + minusDays);
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, minusDays);
        return cal.getTime();
    }

    public static ExchangeRateDateType getRateDateTypeForOldVersionsPlugin(BusinessTrip trip, Date advanceDate, String activityId, String processId, ActionConf actionConf, String domesticCountryName, JsonConf jsonConfig) {
        ExchangeRateDateType dateType = ExchangeRateDateType.ACTUAL;
        boolean czy_rozliczenie_z_etapu_z_ciaglym_odswiezaniem_kursu = Exchange.czyEtapZCiaglymOdswiezaniemKursu(activityId, actionConf);
        boolean czy_delegacja_byla_juz_rozliczana = Exchange.sprawdzCzyDelegacjaZagranicznaBylaJuzRozliczana(trip, domesticCountryName);
        boolean czy_pakiet_odpowiedni_do_odswiezania = czy_rozliczenie_z_etapu_z_ciaglym_odswiezaniem_kursu ? Exchange.czyPakietJestOdpowiedniDoOdswiezenia(processId, trip.getData_powrotu(), jsonConfig) : false;
        log.debug("czy_etap_z_ciaglym_odswiezaniem_kursu: " + czy_rozliczenie_z_etapu_z_ciaglym_odswiezaniem_kursu + ", czy_pakiet_odpowiedni_do_odswiezania: " + czy_pakiet_odpowiedni_do_odswiezania + ", czy_delegacja_byla_juz_rozliczana" + czy_delegacja_byla_juz_rozliczana);
        if (!actionConf.getExchangeSettings().getStageWithContinuouslyRefreshedExchange().equals("") && czy_rozliczenie_z_etapu_z_ciaglym_odswiezaniem_kursu && czy_pakiet_odpowiedni_do_odswiezania) {
            log.debug("ciagle odswiezanie kursu");
            if (actionConf.getExchangeSettings().getRefreshingTodayOrFromField().equals("dzisiaj")) {
                dateType = ExchangeRateDateType.ACTUAL;
            } else if (StringUtils.isNotBlank((String)actionConf.getExchangeSettings().getRefreshingTodayOrFromField()) && !actionConf.getExchangeSettings().getRefreshingTodayOrFromField().equals("dzisiaj")) {
                dateType = ExchangeRateDateType.FROM_FIELD;
            }
        } else {
            dateType = jsonConfig.getZagranica().getKurs_do_obliczen().get("czy_czytac_z_pola").equals("true") ? ExchangeRateDateType.FROM_FIELD : (jsonConfig.getZagranica().getKurs_do_obliczen().get("czy_obslugiwac_date_zaliczki").equals("true") && advanceDate != null ? (jsonConfig.getZagranica().getKurs_do_obliczen().get("czy_data_zaliczki_wazniejsza_od_daty_z_rozliczenia").equals("true") ? ExchangeRateDateType.FROM_ADVANCE : (czy_delegacja_byla_juz_rozliczana ? ExchangeRateDateType.FROM_SETTLEMENT : ExchangeRateDateType.ACTUAL)) : (czy_delegacja_byla_juz_rozliczana ? ExchangeRateDateType.FROM_SETTLEMENT : ExchangeRateDateType.ACTUAL));
        }
        log.debug("wybor: " + dateType.toString());
        return dateType;
    }

    @Deprecated
    private static boolean czyEtapZCiaglymOdswiezaniemKursu(String activity_id, ActionConf actionConf) {
        boolean czy_proces_na_tym_etapie;
        String def_id;
        boolean answer = false;
        if (actionConf != null && actionConf.getExchangeSettings() != null && !(def_id = actionConf.getExchangeSettings().getStageWithContinuouslyRefreshedExchange()).equals("") && (czy_proces_na_tym_etapie = Tools.czyProcesNaEtapie(activity_id, def_id))) {
            answer = true;
        }
        log.debug("return: " + answer);
        return answer;
    }

    @Deprecated
    private static boolean czyPakietJestOdpowiedniDoOdswiezenia(String proc_id, String delegationFinishDate, JsonConf jsonConf) {
        Integer powyzej_wersji = -1;
        try {
            String powyzej_wersji_string = jsonConf.getZagranica().getKurs_do_obliczen().get("odswiezanie_kursu_na_etapie_od_wer_pakietu");
            if (powyzej_wersji_string == null || powyzej_wersji_string.equals("")) {
                powyzej_wersji_string = "0";
            }
            powyzej_wersji = Integer.parseInt(powyzej_wersji_string);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        int wersja_pakietu = Tools.pobierzWersjePakietu(proc_id);
        log.debug("wersja_pakietu: " + wersja_pakietu + ", powyzej_wersji: " + powyzej_wersji);
        boolean czy_wymagana_wersja_pakietu = false;
        if (wersja_pakietu >= powyzej_wersji) {
            czy_wymagana_wersja_pakietu = true;
        }
        log.debug("czy_wymagana_wersja_pakietu: " + czy_wymagana_wersja_pakietu);
        return czy_wymagana_wersja_pakietu;
    }

    @Deprecated
    private static boolean sprawdzCzyDelegacjaZagranicznaBylaJuzRozliczana(BusinessTrip zagranica, String domesticCountryName) {
        boolean czy_delegacja_zagraniczna_byla_juz_rozliczana = false;
        if (zagranica != null) {
            for (BusinessTripQuantities i : zagranica.getIlosci()) {
                if (i.getKraj().equalsIgnoreCase("") || i.getKraj().equalsIgnoreCase(domesticCountryName) || i.getData_kursu() == null || i.getData_kursu().equals("")) continue;
                czy_delegacja_zagraniczna_byla_juz_rozliczana = true;
                break;
            }
        }
        return czy_delegacja_zagraniczna_byla_juz_rozliczana;
    }

    static {
        sdf = new SimpleDateFormat("yyyy-MM-dd");
    }
}

