/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.upgrade;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.suncode.businesstrip.config.data.JsonConf;
import com.suncode.businesstrip.exception.DMException;
import com.suncode.businesstrip.util.BusinessTripSpringContext;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginStore;
import com.suncode.plugin.framework.PluginStoreResource;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.model.FileType;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;

public class CreateBusinessTripConfigCustomChange
implements CustomTaskChange {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();

    public void execute(Database database) {
        Plugin plugin;
        ConfigurationFileService configurationFileService;
        JsonConf customConfig = this.getCustomConfig();
        if (customConfig != null && !(configurationFileService = BusinessTripSpringContext.getBean(ConfigurationFileService.class)).doesFileExist((plugin = BusinessTripSpringContext.getBean(Plugin.class)).getKey(), "config")) {
            configurationFileService.createFile(plugin.getKey(), "config", FileType.JSON);
            String config = this.getOldConfigFileContent(plugin, customConfig);
            configurationFileService.saveFile(plugin.getKey(), "config", (InputStream)new ByteArrayInputStream(config.getBytes(StandardCharsets.UTF_8)));
        }
    }

    private String getOldConfigFileContent(Plugin plugin, JsonConf customConfig) throws IOException, DMException {
        JsonConf config = this.getDefaultConfig(plugin);
        config.overWriteWithoutTranslations(customConfig);
        return this.gson.toJson((Object)config);
    }

    private JsonConf getDefaultConfig(Plugin plugin) throws DMException, IOException {
        Resource resource = plugin.getResource("config/businessTripDefaultConfig.json");
        if (resource == null) {
            return null;
        }
        return this.readConfig(resource.getInputStream());
    }

    private JsonConf readConfig(InputStream input) {
        JsonConf jsonConf;
        block8: {
            InputStream in = input;
            try {
                String file_str = IOUtils.toString((InputStream)in).replace("\t", "").replace("\n", "");
                jsonConf = (JsonConf)this.gson.fromJson(file_str, JsonConf.class);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            in.close();
        }
        return jsonConf;
    }

    private JsonConf getCustomConfig() throws IOException {
        PluginStore pluginStore = BusinessTripSpringContext.getBean(PluginStore.class);
        PluginStoreResource resource = pluginStore.read("config/businessTripCustomConfig.json");
        if (resource == null) {
            return null;
        }
        return this.readConfig(resource.getInputStream());
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

