/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.settlement.poland;

import com.suncode.businesstrip.config.Configuration;
import com.suncode.businesstrip.config.data.JsonConf;
import com.suncode.businesstrip.database.model.BusinessTrip;
import com.suncode.businesstrip.database.model.BusinessTripQuantities;
import com.suncode.businesstrip.exception.DMException;
import com.suncode.businesstrip.settlement.SettlementCountry;
import com.suncode.businesstrip.settlement.TripTimeCalculator;
import com.suncode.businesstrip.settlement.poland.PolandAbstractSettlementService;
import com.suncode.businesstrip.util.Tools;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="polandDomesticSettlementService")
public class PolandDomesticSettlementServiceImpl
extends PolandAbstractSettlementService {
    private static final Logger log = LoggerFactory.getLogger(PolandDomesticSettlementServiceImpl.class);

    @Override
    public void calculate(BusinessTrip businessTrip, String exchangeDate) throws DMException {
        JsonConf config = Configuration.getJsonConfigForDate(SettlementCountry.POLAND, businessTrip.getData_powrotu());
        long minutesInDelegation = TripTimeCalculator.calculateMinutesDomesticDelegation(businessTrip.getTrasa());
        double dietRate = config.getKraj().getDieta();
        double kilometrageAllowance = this.calculateKilometrageAllowance(businessTrip);
        Boolean distanceForDietExceeded = businessTrip.getCzy_przekroczono_dystans_dla_diety();
        for (BusinessTripQuantities k : businessTrip.getIlosci()) {
            if (!config.getDomesticCountryName().equalsIgnoreCase(k.getKraj())) continue;
            double tripFullReward = 0.0;
            if (distanceForDietExceeded == null || distanceForDietExceeded.booleanValue()) {
                tripFullReward = this.calculateDomesticDietFullAmount(minutesInDelegation, businessTrip.getData_powrotu());
            }
            double tripRewardDeductions = this.calculateDomesticDietDeductions(k, tripFullReward, businessTrip.getData_powrotu(), config);
            double diet = this.calculateDiet(k, tripFullReward, tripRewardDeductions, dietRate);
            double publicTransport = this.calculateDomesticPublicTransportAllowance(k, businessTrip.getData_powrotu());
            double accommodation = this.calculateDomesticAccommodationAllowance(k, businessTrip.getData_powrotu());
            log.debug("Obliczona dieta = " + diet + " ryczalt srodki miejskie " + publicTransport + "  ryczalt za noclegi " + accommodation);
            businessTrip.setMinuty_w_delegacji(minutesInDelegation);
            businessTrip.setDieta_kraj(Tools.round2(diet));
            businessTrip.setRyczalt_srodki_miejskie_kraj(Tools.round2(publicTransport));
            businessTrip.setRyczalt_noclegi_kraj(Tools.round2(accommodation));
            businessTrip.setKilometrowka(Tools.round2(kilometrageAllowance));
            k.setStawka_diety(dietRate);
            k.setTripRewardDeductions(Tools.round2(tripRewardDeductions));
            k.setTripFullReward(Tools.round2(tripFullReward));
            k.setMinuty_w_delegacji(minutesInDelegation);
            String waluta = config.getCurrencyName();
            if (StringUtils.isBlank((CharSequence)waluta)) {
                waluta = config.getNazwaPolskiejWaluty();
            }
            k.setWaluta(waluta);
            k.setRyczalt_doby_kom_miejskiej(Tools.round2(publicTransport));
            k.setRyczalt_noclegi(Tools.round2(accommodation));
            break;
        }
        double sumOfSpendings = businessTrip.getWydatki().stream().mapToDouble(s -> {
            s.setKurs(1.0);
            s.setKoszt_pln(s.getKoszt());
            return s.getKoszt_pln();
        }).sum();
        businessTrip.setSuma_wydatki(Tools.round2(sumOfSpendings));
    }
}

