/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.settlement.poland;

import com.suncode.businesstrip.config.Configuration;
import com.suncode.businesstrip.database.model.BusinessTripQuantities;
import com.suncode.businesstrip.settlement.AbstractSettlementService;
import com.suncode.businesstrip.settlement.SettlementCountry;
import com.suncode.businesstrip.util.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="settlementService")
public abstract class PolandAbstractSettlementService
extends AbstractSettlementService {
    private static final Logger log = LoggerFactory.getLogger(PolandAbstractSettlementService.class);

    @Override
    public Double calculateDomesticDietFullAmount(long tripMinutes, String delegationFinishDate) {
        double rate = Configuration.getJsonConfigForDate(SettlementCountry.POLAND, delegationFinishDate).getKraj().getDieta();
        return this.calculateDietAmount(tripMinutes, rate);
    }

    @Override
    public Double calculateDomesticDietFullAmount(double dietCount, String delegationFinishDate) {
        double rate = Configuration.getJsonConfigForDate(SettlementCountry.POLAND, delegationFinishDate).getKraj().getDieta();
        return dietCount * rate;
    }

    private double calculateDietAmount(long minutes, double rate) {
        long allDays = minutes / 1440L;
        long remainingMinutes = minutes % 1440L;
        double diet = (double)allDays * rate;
        if (allDays > 0L) {
            if (remainingMinutes > 0L && remainingMinutes <= 480L) {
                diet += Tools.round2(rate / 2.0);
            }
            if (remainingMinutes > 480L) {
                diet += rate;
            }
        } else {
            if (remainingMinutes >= 480L && remainingMinutes <= 720L) {
                diet = Tools.round2(rate / 2.0);
            }
            if (remainingMinutes > 720L) {
                diet = rate;
            }
        }
        return diet;
    }

    @Override
    public double calculateDomesticPublicTransportAllowance(BusinessTripQuantities country, String delegationFinishDate) {
        int nonProvided = 0;
        if (country.getKraj().equalsIgnoreCase("polska")) {
            nonProvided = country.getNiezapewnione_doby_komunikacji_miejskiej();
        }
        double amount = (double)nonProvided * Configuration.getJsonConfigForDate(SettlementCountry.POLAND, delegationFinishDate).getKraj().getRyczalt_komunikacja_miejska();
        return Tools.round2(amount);
    }

    @Override
    public double calculateDomesticAccommodationAllowance(BusinessTripQuantities country, String delegationFinishDate) {
        int nonProvided = 0;
        if (country.getKraj().equalsIgnoreCase("polska")) {
            nonProvided = country.getNiezapewnione_noclegi();
        }
        double amount = (double)nonProvided * Configuration.getJsonConfigForDate(SettlementCountry.POLAND, delegationFinishDate).getKraj().getRyczalt_nocleg();
        return Tools.round2(amount);
    }
}

