/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.settlement.croatia;

import com.suncode.businesstrip.config.Configuration;
import com.suncode.businesstrip.config.data.ActionConf;
import com.suncode.businesstrip.config.data.JsonConf;
import com.suncode.businesstrip.database.model.BusinessTrip;
import com.suncode.businesstrip.database.model.BusinessTripQuantities;
import com.suncode.businesstrip.database.model.BusinessTripRoute;
import com.suncode.businesstrip.dto.RateDto;
import com.suncode.businesstrip.exception.DMException;
import com.suncode.businesstrip.settlement.SettlementCountry;
import com.suncode.businesstrip.settlement.TripTimeCalculator;
import com.suncode.businesstrip.settlement.croatia.CroatiaAbstractSettlementService;
import com.suncode.businesstrip.util.Exchange;
import com.suncode.businesstrip.util.ExchangeRateSource;
import com.suncode.businesstrip.util.Tools;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="croatiaForeignSettlementService")
public class CroatiaForeignSettlementServiceImpl
extends CroatiaAbstractSettlementService {
    private static final Logger log = LoggerFactory.getLogger(CroatiaForeignSettlementServiceImpl.class);

    @Override
    public void calculate(BusinessTrip businessTrip, String currencyExchangeDate) throws Exception {
        HashMap<String, RateDto> exchangeRates;
        JsonConf config = Configuration.getJsonConfigForDate(SettlementCountry.CROATIA, businessTrip.getData_powrotu());
        ActionConf actionConfig = Configuration.getActionConf(businessTrip.getNr_delegacji());
        Set<String> destinationCountries = businessTrip.getIlosci().stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getKraj())).map(c -> c.getKraj()).collect(Collectors.toSet());
        Set<String> currencyNames = Exchange.getCurrencyNamesForTrip(businessTrip, config);
        String exchangeRateSource = actionConfig.getExchangeSettings().getExchangeRateSource();
        if (ExchangeRateSource.DATA_SOURCE.name().equals(exchangeRateSource)) {
            String dataSourceId = actionConfig.getExchangeSettings().getExchangeRateDataSourceId();
            exchangeRates = this.exchangeService.getRateFromDataSource(dataSourceId, this.getDataSourceInputParameters(businessTrip.getNr_delegacji()), currencyNames, CroatiaForeignSettlementServiceImpl.parseDate(currencyExchangeDate));
        } else {
            exchangeRates = this.exchangeService.getLastECBExchanges(currencyNames, CroatiaForeignSettlementServiceImpl.parseDate(currencyExchangeDate), config.getCurrencyName());
        }
        Map<String, List<Long>> minutesInCountries = TripTimeCalculator.calculateMinutesForeignDelegation(businessTrip.getTrasa(), destinationCountries, businessTrip.getData_powrotu(), config);
        this.subtractTwoHoursFromDeparturePlaneTravelInCroatia(businessTrip.getTrasa(), config, minutesInCountries);
        for (String country : minutesInCountries.keySet()) {
            if (!destinationCountries.contains(country)) {
                log.debug("UWAGA ZOSTAL ROZLICZONY KRAJ KTORY NIE JEST DOCELOWYM. KRAJ " + country);
            }
            log.debug("Kraj = " + country + ", ilosc minut = " + minutesInCountries.get(country).stream().mapToLong(l -> l).sum());
        }
        long minutesInDelegation = minutesInCountries.values().stream().flatMap(Collection::stream).mapToLong(Long::longValue).sum();
        long minutesInForeignDelegation = minutesInCountries.entrySet().stream().filter(entry -> !((String)entry.getKey()).equalsIgnoreCase(config.getDomesticCountryName())).flatMap(entry -> ((List)entry.getValue()).stream()).mapToLong(Long::longValue).sum();
        double allDietCount = this.calculateDietCountFromMinutes(minutesInDelegation);
        double foreignDietCount = this.calculateDietCountFromMinutes(minutesInForeignDelegation);
        double domesticDietCount = allDietCount - foreignDietCount;
        double foreignDiet = 0.0;
        String destinationCountry = businessTrip.getKraje_docelowe();
        if (!minutesInCountries.keySet().contains(destinationCountry)) {
            throw new DMException("Kraj docelowy nie znajduje si\u0119 na odcinkach tras");
        }
        Double dietCountInDestinationCountry = this.calculateDietCountFromMinutes(minutesInCountries.get(destinationCountry).stream().mapToLong(Long::longValue).sum());
        Double remainingDietsCount = foreignDietCount - dietCountInDestinationCountry;
        String countryWithLowestRateExcludingDestinationCountry = minutesInCountries.entrySet().stream().filter(countryDiet -> !config.getDomesticCountryName().equalsIgnoreCase((String)countryDiet.getKey()) && !((String)countryDiet.getKey()).equals(destinationCountry)).map(e -> Map.entry((String)e.getKey(), ((List)e.getValue()).stream().mapToLong(Long::longValue).sum())).filter(entry -> (Long)entry.getValue() > 720L).map(e -> Map.entry((String)e.getKey(), Tools.round2(Tools.parseDouble(config.getZagranica().getDieta().get(e.getKey())[1])))).min(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(destinationCountry);
        for (BusinessTripQuantities countryPart : businessTrip.getIlosci()) {
            String countryName = countryPart.getKraj();
            if (StringUtils.isBlank((CharSequence)countryName)) continue;
            log.debug("Rozliczenia kraju " + countryName);
            List<Long> minutes = minutesInCountries.get(countryName);
            if (CollectionUtils.isEmpty(minutes)) {
                minutes = Arrays.asList(0L);
            }
            Long minutesInCountry = minutes.stream().mapToLong(l -> l).sum();
            countryPart.setMinuty_w_delegacji(minutesInCountry);
            Boolean distanceForDietExceeded = businessTrip.getCzy_przekroczono_dystans_dla_diety();
            log.debug("Rozliczenie diety dla kraju " + countryName + " ilosc minut " + String.valueOf(minutes));
            if (!config.getDomesticCountryName().equalsIgnoreCase(countryName)) {
                String currencyName = config.getZagranica().getDieta().get(countryName)[0];
                if (exchangeRates.get(currencyName) == null) {
                    throw new DMException("Brak kursu potrzebnego do rozliczenia waluty " + currencyName);
                }
                RateDto exchangeRate = exchangeRates.get(currencyName);
                log.debug("Rozliczenie kraju zagranicznego, nazwa waluty: " + currencyName + " kurs walutowy: " + exchangeRate.getMid());
                countryPart.setWaluta(currencyName);
                countryPart.setKurs_walutowy(exchangeRate.getMid());
                countryPart.setData_kursu(exchangeRate.getEffectiveDate());
                double dietRateInCurrency = Tools.round2(Tools.parseDouble(config.getZagranica().getDieta().get(countryName)[1]));
                countryPart.setStawka_diety(dietRateInCurrency);
                log.debug("Stawka diety zagranicznej dla kraju " + countryName + " stawka = " + dietRateInCurrency);
                double foreignDietFullReward = 0.0;
                if (distanceForDietExceeded == null || distanceForDietExceeded.booleanValue()) {
                    if (countryName.equals(destinationCountry)) {
                        foreignDietFullReward += dietCountInDestinationCountry * dietRateInCurrency;
                    }
                    if (countryName.equals(countryWithLowestRateExcludingDestinationCountry)) {
                        foreignDietFullReward += remainingDietsCount * dietRateInCurrency;
                    }
                }
                countryPart.setTripFullReward(Tools.round2(foreignDietFullReward));
                double foreignDietRewardDeductions = this.calculateForeignCountryDeductions(config, countryPart, foreignDietFullReward, dietRateInCurrency);
                countryPart.setTripRewardDeductions(Tools.round2(foreignDietRewardDeductions));
                double foreignDietInCurrency = this.calculateDiet(countryPart, foreignDietFullReward, foreignDietRewardDeductions, dietRateInCurrency);
                log.debug("Dieta w walucie " + foreignDietInCurrency + ", dieta w walucie " + (foreignDiet += Tools.convertCurrency(foreignDietInCurrency, exchangeRate.getMid()).doubleValue()));
                continue;
            }
            double dietRate = config.getKraj().getDieta();
            countryPart.setStawka_diety(dietRate);
            double tripFullReward = 0.0;
            if (distanceForDietExceeded == null || distanceForDietExceeded.booleanValue()) {
                tripFullReward = this.calculateDomesticDietFullAmount(domesticDietCount, businessTrip.getData_powrotu());
            }
            double tripRewardDeductions = this.calculateDomesticDietDeductions(countryPart, tripFullReward, businessTrip.getData_powrotu(), config);
            double diet = this.calculateDiet(countryPart, tripFullReward, tripRewardDeductions, dietRate);
            log.debug("Dieta krajowa " + diet + " stawka " + dietRate);
            businessTrip.setDieta_kraj(Tools.round2(diet));
            countryPart.setTripFullReward(Tools.round2(tripFullReward));
            countryPart.setTripRewardDeductions(Tools.round2(tripRewardDeductions));
            String waluta = config.getCurrencyName();
            countryPart.setWaluta(waluta);
        }
        log.debug("Obliczona dieta zagraniczna = " + foreignDiet + " dieta krajowa " + businessTrip.getDieta_kraj());
        double kilometrageAllowance = this.calculateKilometrageAllowance(businessTrip);
        businessTrip.setMinuty_w_delegacji(minutesInDelegation);
        businessTrip.setKraje_minuty(minutesInCountries.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().mapToLong(Long::longValue).sum())));
        businessTrip.setDieta_zagranica(Tools.round2(foreignDiet));
        businessTrip.setKilometrowka(Tools.round2(kilometrageAllowance));
        double sumOfSpendings = businessTrip.getWydatki().stream().mapToDouble(s -> {
            if (s.getWaluta().equalsIgnoreCase("EUR")) {
                s.setKurs(1.0);
                s.setKoszt_pln(s.getKoszt());
            } else {
                Double exchangeRate;
                if (s.getRateFromDayBefore() != null && s.getRateFromDayBefore().booleanValue()) {
                    if (ExchangeRateSource.DATA_SOURCE.name().equals(exchangeRateSource)) {
                        String dataSourceId = Configuration.getActionConf(businessTrip.getNr_delegacji()).getExchangeSettings().getExchangeRateDataSourceId();
                        exchangeRate = this.exchangeService.getRateFromDataSource(dataSourceId, this.getDataSourceInputParameters(businessTrip.getNr_delegacji()), currencyNames, CroatiaForeignSettlementServiceImpl.parseDate(s.getData()).minusDays(1L)).get(s.getWaluta()).getMid();
                    } else {
                        try {
                            HashMap<String, RateDto> rates = this.exchangeService.getLastECBExchanges(currencyNames, CroatiaForeignSettlementServiceImpl.parseDate(s.getData()).minusDays(1L), config.getCurrencyName());
                            if (rates == null || rates.isEmpty()) {
                                throw new DMException("Brak kursu potrzebnego do rozliczenia");
                            }
                            exchangeRate = rates.get(s.getWaluta()).getMid();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e.getMessage());
                        }
                    }
                } else {
                    exchangeRate = ((RateDto)exchangeRates.get(s.getWaluta())).getMid();
                }
                s.setKurs(exchangeRate);
                s.setKoszt_pln(Tools.convertCurrency(s.getKoszt(), exchangeRate));
            }
            return s.getKoszt_pln();
        }).sum();
        businessTrip.setSuma_wydatki(Tools.round2(sumOfSpendings));
    }

    private void subtractTwoHoursFromDeparturePlaneTravelInCroatia(SortedSet<BusinessTripRoute> trip, JsonConf config, Map<String, List<Long>> minutesInCountries) {
        if (trip == null || config == null || minutesInCountries == null) {
            return;
        }
        String domesticCountryName = config.getDomesticCountryName();
        String planeTransportName = config.getSrodekTransportuSamolotNazwa();
        if (StringUtils.isBlank((CharSequence)domesticCountryName) || StringUtils.isBlank((CharSequence)planeTransportName)) {
            return;
        }
        long minutesToSubtract = 120L;
        for (BusinessTripRoute route : trip) {
            List<Long> arrivalCountryMinutes;
            if (route == null) continue;
            String wyjazdKraj = route.getWyjazd_kraj();
            String srodekTransportu = route.getSrodek_transportu();
            String przyjazdKraj = route.getPrzyjazd_kraj();
            if (!StringUtils.isNotBlank((CharSequence)wyjazdKraj) || !wyjazdKraj.equalsIgnoreCase(domesticCountryName) || !StringUtils.isNotBlank((CharSequence)srodekTransportu) || !srodekTransportu.equalsIgnoreCase(planeTransportName) || !StringUtils.isNotBlank((CharSequence)przyjazdKraj)) continue;
            List<Long> domesticMinutes = minutesInCountries.get(domesticCountryName);
            if (domesticMinutes != null && !domesticMinutes.isEmpty()) {
                long totalDomesticMinutes = domesticMinutes.stream().mapToLong(Long::longValue).sum();
                if (totalDomesticMinutes >= 120L) {
                    long remainingToSubtract = 120L;
                    for (int i = 0; i < domesticMinutes.size() && remainingToSubtract > 0L; ++i) {
                        long currentValue = domesticMinutes.get(i);
                        if (currentValue >= remainingToSubtract) {
                            domesticMinutes.set(i, currentValue - remainingToSubtract);
                            remainingToSubtract = 0L;
                            continue;
                        }
                        domesticMinutes.set(i, 0L);
                        remainingToSubtract -= currentValue;
                    }
                } else {
                    for (int i = 0; i < domesticMinutes.size(); ++i) {
                        domesticMinutes.set(i, 0L);
                    }
                }
            }
            if ((arrivalCountryMinutes = minutesInCountries.get(przyjazdKraj)) == null || arrivalCountryMinutes.isEmpty()) {
                arrivalCountryMinutes = new ArrayList<Long>();
                arrivalCountryMinutes.add(120L);
                minutesInCountries.put(przyjazdKraj, arrivalCountryMinutes);
            } else {
                arrivalCountryMinutes.set(0, arrivalCountryMinutes.get(0) + 120L);
            }
            log.debug("Odj\u0119to 120 minut z kraju " + domesticCountryName + " i dodano do kraju " + przyjazdKraj + " dla odcinka trasy samolotem");
        }
    }

    private static LocalDate parseDate(String date) {
        try {
            return LocalDate.parse(date, DateTimeFormatter.ofPattern("yy-MM-dd"));
        }
        catch (Exception e) {
            return LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
    }

    private Double calculateForeignCountryDeductions(JsonConf config, BusinessTripQuantities bt, double tripFullReward, double dietRate) {
        double deductions = 0.0;
        if (Tools.isTak(bt.getCalodobowe_wyzywienie())) {
            log.debug("Pracodawaca zapewni\u0142 ca\u0142odobowe wyzywyenie dla kraju " + String.valueOf(bt));
            Double wysokosc_diety_gdy_zapewniony_posilek = config.getZagranica().getWysokosc_diety_gdy_pracodawca_zapewnil_posilek();
            deductions = (double)Math.round(tripFullReward * (1.0 - wysokosc_diety_gdy_zapewniony_posilek) * 100.0) / 100.0;
        } else {
            log.debug("Standardowe odliczenie ilo\u015bci zapewnionych posi\u0142k\u00f3w dla kraju " + String.valueOf(bt));
            Integer percentageReductionForBreakfast = config.getZagranica().getProcentowe_zmniejszenie_diety_za_zapewnione_sniadanie();
            if (percentageReductionForBreakfast == null) {
                percentageReductionForBreakfast = 15;
            }
            deductions = (double)bt.getZapewnione_sniadania().intValue() * Tools.round2((double)percentageReductionForBreakfast.intValue() / 100.0 * dietRate);
            Integer percentageReductionForDinner = config.getZagranica().getProcentowe_zmniejszenie_diety_za_zapewniony_obiad();
            if (percentageReductionForDinner == null) {
                percentageReductionForDinner = 30;
            }
            deductions += (double)bt.getZapewnione_obiady().intValue() * Tools.round2((double)percentageReductionForDinner.intValue() / 100.0 * dietRate);
            Integer percentageReductionForSupper = config.getZagranica().getProcentowe_zmniejszenie_diety_za_zapewniona_kolacje();
            if (percentageReductionForSupper == null) {
                percentageReductionForSupper = 30;
            }
            deductions += (double)bt.getZapewnione_kolacje().intValue() * Tools.round2((double)percentageReductionForSupper.intValue() / 100.0 * dietRate);
        }
        return deductions;
    }
}

