/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.settlement.croatia;

import com.suncode.businesstrip.config.Configuration;
import com.suncode.businesstrip.database.model.BusinessTripQuantities;
import com.suncode.businesstrip.settlement.AbstractSettlementService;
import com.suncode.businesstrip.settlement.SettlementCountry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public abstract class CroatiaAbstractSettlementService
extends AbstractSettlementService {
    private static final Logger log = LoggerFactory.getLogger(CroatiaAbstractSettlementService.class);

    @Override
    public double calculateDomesticPublicTransportAllowance(BusinessTripQuantities country, String delegationFinishDate) {
        return 0.0;
    }

    @Override
    public double calculateDomesticAccommodationAllowance(BusinessTripQuantities k, String delegationFinishDate) {
        return 0.0;
    }

    @Override
    public Double calculateDomesticDietFullAmount(double dietCount, String delegationFinishDate) {
        double rate = Configuration.getJsonConfigForDate(SettlementCountry.CROATIA, delegationFinishDate).getKraj().getDieta();
        return dietCount * rate;
    }

    @Override
    public Double calculateDomesticDietFullAmount(long tripMinutes, String delegationFinishDate) {
        throw new UnsupportedOperationException("Unsupported calculation for domestic delegation given in minutes in Croatia");
    }

    protected double calculateDietCountFromMinutes(long minutes) {
        long allDays = minutes / 1440L;
        long remainingMinutes = minutes % 1440L;
        double dietCount = allDays;
        if (remainingMinutes > 0L) {
            if (remainingMinutes > 480L && remainingMinutes <= 720L) {
                dietCount += 0.5;
            } else if (remainingMinutes > 720L) {
                dietCount += 1.0;
            }
        }
        return dietCount;
    }
}

