/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.settlement;

import com.suncode.businesstrip.exception.DMException;
import com.suncode.businesstrip.settlement.SettlementCountry;
import com.suncode.businesstrip.settlement.SettlementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SettlementServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(SettlementServiceFactory.class);
    @Autowired
    @Qualifier(value="polandDomesticSettlementService")
    private SettlementService polandSettlementService;
    @Autowired
    @Qualifier(value="polandForeignSettlementService")
    private SettlementService foreignSettlementService;
    @Autowired
    @Qualifier(value="croatiaDomesticSettlementService")
    private SettlementService croatiaSettlementService;
    @Autowired
    @Qualifier(value="croatiaForeignSettlementService")
    private SettlementService croatiaForeignSettlementService;

    public SettlementService getSettlementService(String delegationType, SettlementCountry countryCode) throws DMException {
        if (delegationType == null || countryCode == null) {
            throw new DMException("Typ delegacji i kraj nie mog\u0105 by\u0107 null");
        }
        log.debug("Wybieranie serwisu rozliczeniowego dla typu: {} i kraju: {}", (Object)delegationType, (Object)countryCode);
        if ("kraj".equalsIgnoreCase(delegationType)) {
            return this.getDomesticSettlementService(countryCode);
        }
        if ("zagranica".equalsIgnoreCase(delegationType)) {
            return this.getForeignSettlementService(countryCode);
        }
        throw new DMException("Nieznany typ delegacji: " + delegationType);
    }

    private SettlementService getDomesticSettlementService(SettlementCountry countryCode) throws DMException {
        switch (countryCode) {
            case POLAND: {
                return this.polandSettlementService;
            }
            case CROATIA: {
                return this.croatiaSettlementService;
            }
        }
        throw new DMException("Nieobs\u0142ugiwany kraj dla delegacji krajowych: " + String.valueOf((Object)countryCode));
    }

    private SettlementService getForeignSettlementService(SettlementCountry countryCode) throws DMException {
        switch (countryCode) {
            case POLAND: {
                return this.foreignSettlementService;
            }
            case CROATIA: {
                return this.croatiaForeignSettlementService;
            }
        }
        throw new DMException("Nieobs\u0142ugiwany kraj dla delegacji zagranicznych: " + String.valueOf((Object)countryCode));
    }
}

