/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.settlement;

import com.suncode.businesstrip.config.Configuration;
import com.suncode.businesstrip.config.data.ActionConf;
import com.suncode.businesstrip.config.data.JsonConf;
import com.suncode.businesstrip.database.model.BusinessTrip;
import com.suncode.businesstrip.database.model.BusinessTripActivityVariableValue;
import com.suncode.businesstrip.database.model.BusinessTripAdvance;
import com.suncode.businesstrip.database.model.BusinessTripQuantities;
import com.suncode.businesstrip.database.model.BusinessTripRoute;
import com.suncode.businesstrip.database.model.BusinessTripSpendings;
import com.suncode.businesstrip.dto.BaseDataDto;
import com.suncode.businesstrip.dto.BusinessTripDto;
import com.suncode.businesstrip.dto.QuantityDataDto;
import com.suncode.businesstrip.dto.RateDto;
import com.suncode.businesstrip.dto.RouteDto;
import com.suncode.businesstrip.dto.SpendingDto;
import com.suncode.businesstrip.dto.TransportDataDto;
import com.suncode.businesstrip.exception.DMException;
import com.suncode.businesstrip.settlement.SettlementCountry;
import com.suncode.businesstrip.settlement.SettlementService;
import com.suncode.businesstrip.util.BusinessTripUtil;
import com.suncode.businesstrip.util.Exchange;
import com.suncode.businesstrip.util.ExchangeRateSource;
import com.suncode.businesstrip.util.ExchangeService;
import com.suncode.businesstrip.util.RouteCostDetails;
import com.suncode.businesstrip.util.Tools;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settlementService")
public abstract class AbstractSettlementService
implements SettlementService {
    private static final Logger log = LoggerFactory.getLogger(AbstractSettlementService.class);
    protected static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    protected ExchangeService exchangeService;

    protected abstract void calculate(BusinessTrip var1, String var2) throws Exception;

    @Override
    public BusinessTrip settle(BusinessTrip businessTrip, BusinessTripDto dataToSettle, SettlementCountry settlementCountry) throws Exception {
        Object data_dla_kursow = "";
        Set<String> uniqueCurrencies = this.getUniqueNotDomesticCurrencies(dataToSettle);
        if (dataToSettle.getType().equalsIgnoreCase("zagranica") || uniqueCurrencies.size() > 0) {
            Date advanceDate = businessTrip == null || StringUtils.isBlank((String)businessTrip.getData_wydania_zaliczki()) ? null : sdf.parse(businessTrip.getData_wydania_zaliczki());
            Date rateDate = Exchange.selectExchangeRateDate(businessTrip, advanceDate, dataToSettle.getProcessId(), dataToSettle.getActivityId(), dataToSettle.getBaseData().getNr_delegacji());
            String[] data_czesci = Tools.zmienDateNaString(rateDate);
            data_dla_kursow = data_czesci[0] + "-" + data_czesci[1] + "-" + data_czesci[2];
        }
        log.debug("data_dla_kursow: " + (String)data_dla_kursow);
        businessTrip.setTyp_delegacji(dataToSettle.getType());
        this.dodajPodstawowe(businessTrip, dataToSettle.getBaseData());
        this.dodajEwidencje(businessTrip, dataToSettle.getTransportData(), settlementCountry);
        this.dodajKomentarz(businessTrip, dataToSettle.getComments());
        this.dodajTrase(businessTrip, dataToSettle.getRouteData());
        this.tripRoutesValidation(businessTrip);
        JsonConf config = Configuration.getJsonConfigForDate(businessTrip.getNr_delegacji(), businessTrip.getData_powrotu());
        this.dodajIlosciowe(businessTrip, dataToSettle.getQuantitiesData(), config.getDomesticCountryName());
        this.dodajWydatki(businessTrip, dataToSettle, businessTrip.getNr_delegacji(), settlementCountry);
        businessTrip.setDaty_zgodne_z_wnioskiem(this.walidacjaDatTrasy(businessTrip.getTrasa(), businessTrip.getData_odjazdu(), businessTrip.getData_powrotu()));
        if (dataToSettle.getCalculate().equalsIgnoreCase("TAK")) {
            log.debug("Obliczanie delegacji o numerze wniosku = " + businessTrip.getNr_delegacji());
            this.calculate(businessTrip, (String)data_dla_kursow);
        }
        this.addAdvances(businessTrip, dataToSettle, uniqueCurrencies, (String)data_dla_kursow);
        this.addVariables(businessTrip, dataToSettle);
        return businessTrip;
    }

    private void dodajPodstawowe(BusinessTrip businessTrip, BaseDataDto podstawowe) {
        businessTrip.setNr_delegacji(podstawowe.getNr_delegacji());
        businessTrip.setImie_nazwisko(podstawowe.getImie_nazwisko());
        String cel_delegacji = podstawowe.getCel_delegacji();
        businessTrip.setCel_delegacji(cel_delegacji == null || cel_delegacji.equals("") ? "" : cel_delegacji);
        businessTrip.setData_odjazdu(podstawowe.getData_odjazdu() == null ? "" : sdf.format(podstawowe.getData_odjazdu()));
        businessTrip.setData_powrotu(podstawowe.getData_powrotu() == null ? "" : sdf.format(podstawowe.getData_powrotu()));
        String miasto_docelowe = podstawowe.getMiasto_docelowe();
        businessTrip.setMiasto_docelowe(miasto_docelowe == null || miasto_docelowe.equals("") ? "" : miasto_docelowe);
        Date data_wydania_zaliczki = podstawowe.getData_wydania_zaliczki();
        businessTrip.setData_wydania_zaliczki(data_wydania_zaliczki == null ? "" : sdf.format(data_wydania_zaliczki));
        String kraje = podstawowe.getKraje_docelowe();
        businessTrip.setKraje_docelowe(kraje == null || kraje.equals("") ? "" : kraje);
        Boolean czy_przekroczono_dystans_dla_diety = podstawowe.getCzy_przekroczono_dystans_dla_diety();
        businessTrip.setCzy_przekroczono_dystans_dla_diety(czy_przekroczono_dystans_dla_diety);
        String srodek_transportu = podstawowe.getPodstawowy_srodek_transportu();
        businessTrip.setSrodek_transportu(srodek_transportu == null || srodek_transportu.equals("") ? "" : srodek_transportu);
    }

    private void dodajEwidencje(BusinessTrip delegacja, TransportDataDto ewidencja_pojazdu, SettlementCountry settlementCountry) throws DMException {
        delegacja.setKoszty_paliwa(ewidencja_pojazdu.getKoszty_paliwa());
        delegacja.setSr_lokomocji(ewidencja_pojazdu.getSr_lokomocji());
        delegacja.setMarka_pojazdu(ewidencja_pojazdu.getMarka_pojazdu());
        delegacja.setNr_rejestracyjny(ewidencja_pojazdu.getNr_rejestracyjny());
        delegacja.setAdres_uzytkownika_pojazdu(ewidencja_pojazdu.getAdres_uzytkownika_pojazdu());
        delegacja.setPojemnosc_silnika(Tools.walidacjaDouble(ewidencja_pojazdu.getPojemnosc_silnika(), "Niepoprawna warto\u015b\u0107 pola pojemno\u015b\u0107 silnika."));
        double stawka = BusinessTripUtil.getStawkaKilometrowkiDlaPojazdu(delegacja.getSr_lokomocji(), delegacja.getData_powrotu(), settlementCountry);
        delegacja.setStawka_za_1_km(stawka);
    }

    private void dodajKomentarz(BusinessTrip delegacja, String uwagi) throws DMException {
        delegacja.setUwagi(uwagi);
    }

    private BusinessTrip dodajTrase(BusinessTrip delegacja, SortedSet<RouteDto> trasa) throws DMException {
        int i = 0;
        String city = null;
        String coutry = null;
        delegacja.getTrasa().clear();
        for (RouteDto path : trasa) {
            if (i == 0) {
                city = path.getWyjazd_miejscowosc();
                coutry = path.getWyjazd_kraj();
            }
            BusinessTripRoute businessTripRoute = new BusinessTripRoute();
            businessTripRoute.setLp(Tools.walidacjaInteger(path.getLp(), "Niepoprawna warto\u015bci pola lp."));
            businessTripRoute.setWyjazd_miejscowosc(path.getWyjazd_miejscowosc());
            businessTripRoute.setWyjazd_data(path.getWyjazd_data());
            businessTripRoute.setWyjazd_godzina(path.getWyjazd_godzina());
            businessTripRoute.setPrzyjazd_miejscowosc(path.getPrzyjazd_miejscowosc());
            businessTripRoute.setPrzyjazd_data(path.getPrzyjazd_data());
            businessTripRoute.setPrzyjazd_godzina(path.getPrzyjazd_godzina());
            businessTripRoute.setSrodek_transportu(path.getSrodek_transportu());
            businessTripRoute.setKm(Tools.walidacjaDouble(path.getKm(), "Niepoprawna warto\u015b\u0107 pola ilo\u015bci kilometr\u00f3w w tabeli trasy."));
            if (delegacja.getTyp_delegacji().equalsIgnoreCase("kraj") && city != null) {
                businessTripRoute.setWyjazd_kraj("");
                businessTripRoute.setPrzyjazd_kraj("");
                businessTripRoute.setData_przekroczenia_granicy("");
                businessTripRoute.setGodzina_przekroczenia_granicy("");
            } else if (coutry != null) {
                businessTripRoute.setWyjazd_kraj(path.getWyjazd_kraj());
                businessTripRoute.setPrzyjazd_kraj(path.getPrzyjazd_kraj());
                businessTripRoute.setData_przekroczenia_granicy(path.getData_przekroczenia_granicy());
                businessTripRoute.setGodzina_przekroczenia_granicy(path.getGodzina_przekroczenia_granicy());
            }
            delegacja.getTrasa().add(businessTripRoute);
            ++i;
        }
        return delegacja;
    }

    private void tripRoutesValidation(BusinessTrip trip) throws DMException {
        if (trip.getTrasa().size() > 0) {
            for (BusinessTripRoute route : trip.getTrasa()) {
                DateTime departureDate = DateTime.parse((String)(route.getWyjazd_data() + " " + route.getWyjazd_godzina()), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm"));
                DateTime arrivalDate = DateTime.parse((String)(route.getPrzyjazd_data() + " " + route.getPrzyjazd_godzina()), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm"));
                if (!arrivalDate.isBefore((ReadableInstant)departureDate)) continue;
                throw new DMException("Data wyjazdu jest wi\u0119ksza od daty przyjazdu w wierszu " + route.getLp());
            }
        }
    }

    private BusinessTrip dodajIlosciowe(BusinessTrip delegacja, Set<QuantityDataDto> ilosciowe, String domesticCountryName) throws DMException {
        delegacja.getIlosci().clear();
        if (delegacja.getTyp_delegacji().equalsIgnoreCase("kraj") && ilosciowe.size() > 1) {
            throw new DMException("Za du\u017co wierszy w tabeli z ilo\u015bciowymi danymi dla delegacji krajowej nr " + delegacja.getNr_delegacji());
        }
        for (QuantityDataDto i : ilosciowe) {
            BusinessTripQuantities new_ilosc = new BusinessTripQuantities();
            new_ilosc.setNiezapewnione_doby_komunikacji_miejskiej(Tools.walidacjaInteger(i.getNiezapewnione_doby_komunikacji_miejskiej(), "Niepoprawna warto\u015b\u0107 pola niezapewnionych d\u00f3b komunikacji miejskiej."));
            new_ilosc.setNiezapewnione_noclegi(Tools.walidacjaInteger(i.getNiezapewnione_noclegi(), "Niepoprawna warto\u015b\u0107 pola niezapewnionych nocleg\u00f3w."));
            new_ilosc.setZapewnione_sniadania(Tools.walidacjaInteger(i.getZapewnione_sniadania(), "Niepoprawna warto\u015b\u0107 pola zapewnionych \u015bniada\u0144."));
            new_ilosc.setZapewnione_obiady(Tools.walidacjaInteger(i.getZapewnione_obiady(), "Niepoprawna warto\u015b\u0107 pola zapewnionych obiad\u00f3w."));
            new_ilosc.setZapewnione_kolacje(Tools.walidacjaInteger(i.getZapewnione_kolacje(), "Niepoprawna warto\u015b\u0107 pola zapewnionych kolacji."));
            new_ilosc.setCalodobowe_wyzywienie(Tools.walidacjaTakNie(i.getCalodobowe_wyzywienie(), "Niepoprawna warto\u015b\u0107 pola ilo\u015bci miast w kt\u00f3rych niezapewnione przejazd\u00f3w do lub z dworca."));
            if (delegacja.getTyp_delegacji().equalsIgnoreCase("kraj")) {
                new_ilosc.setNiezapewnione_przejazdy_do_z_dworca(0.0);
                new_ilosc.setKraj(domesticCountryName);
            } else {
                new_ilosc.setNiezapewnione_przejazdy_do_z_dworca(Tools.walidacjaDouble(i.getNiezapewnione_przejazdy_do_z_dworca(), "Niepoprawna warto\u015b\u0107 pola ilo\u015bci miast w kt\u00f3rych niezapewnione przejazd\u00f3w do lub z dworca."));
                new_ilosc.setKraj(i.getKraj());
            }
            delegacja.getIlosci().add(new_ilosc);
        }
        return delegacja;
    }

    private void dodajWydatki(BusinessTrip businessTrip, BusinessTripDto dataToSettle, String delegationNr, SettlementCountry settlementCountry) throws DMException {
        boolean cleanSpendings = true;
        for (SpendingDto spending : dataToSettle.getSpendingsData()) {
            if (spending.getNazwa_wydatku() == null || !Configuration.getActionConf(delegationNr).getOtherParams().getIsSpendingTableVisible().booleanValue()) continue;
            this.dodajWydatek(businessTrip, dataToSettle.getSpendingsData(), settlementCountry);
            cleanSpendings = false;
            break;
        }
        if (cleanSpendings) {
            businessTrip.getWydatki().clear();
        }
    }

    private BusinessTrip dodajWydatek(BusinessTrip delegacja, List<SpendingDto> wydatki, SettlementCountry settlementCountry) {
        delegacja.getWydatki().removeIf(baseSpending -> wydatki.stream().noneMatch(newSpending -> baseSpending.getId().equals(newSpending.getWydatek_id())));
        for (SpendingDto spending : wydatki) {
            Optional<BusinessTripSpendings> existingSpendingOptional;
            String waluta = "";
            if (delegacja.getTyp_delegacji().compareTo("kraj") == 0) {
                waluta = Configuration.getJsonConfigForDate(settlementCountry, delegacja.getData_powrotu()).getCurrencyName();
                if (StringUtils.isBlank((String)waluta)) {
                    waluta = Configuration.getJsonConfigForDate(settlementCountry, delegacja.getData_powrotu()).getNazwaPolskiejWaluty();
                }
            } else {
                waluta = spending.getWaluta();
            }
            if ((existingSpendingOptional = delegacja.getWydatki().stream().filter(baseSpending -> spending.getWydatek_id() != null && baseSpending.getId().equals(spending.getWydatek_id())).findAny()).isPresent()) {
                BusinessTripSpendings existingSpending = existingSpendingOptional.get();
                this.copySpendingValues(spending, waluta, existingSpending);
                continue;
            }
            BusinessTripSpendings new_wydatki = new BusinessTripSpendings();
            this.copySpendingValues(spending, waluta, new_wydatki);
            delegacja.getWydatki().add(new_wydatki);
        }
        return delegacja;
    }

    private void copySpendingValues(SpendingDto spending, String waluta, BusinessTripSpendings existingSpending) {
        existingSpending.setNazwa_wydatku(spending.getNazwa_wydatku());
        existingSpending.setRodzaj_wydatku(spending.getRodzaj_wydatku());
        existingSpending.setPaymentMethod(spending.getPaymentMethod());
        existingSpending.setDocumentType(spending.getDocumentType());
        existingSpending.setKoszt(spending.getKoszt());
        existingSpending.setWaluta(waluta);
        existingSpending.setData(spending.getData());
        existingSpending.setRateFromDayBefore(spending.getRateFromDayBefore());
    }

    private boolean walidacjaDatTrasy(Set<BusinessTripRoute> routes, String departureDate, String arrivalDate) {
        log.debug("Walidacja dat");
        if (routes.isEmpty()) {
            return true;
        }
        if (StringUtils.isBlank((String)departureDate) || StringUtils.isBlank((String)arrivalDate)) {
            return false;
        }
        try {
            BusinessTripRoute beginingPoint = null;
            BusinessTripRoute finishPoint = new BusinessTripRoute();
            for (BusinessTripRoute routePoint : routes) {
                if (beginingPoint == null) {
                    beginingPoint = routePoint;
                }
                finishPoint = routePoint;
            }
            String dataWyjazduStr = beginingPoint.getWyjazd_data();
            log.debug("Data wyjazdu " + dataWyjazduStr + ", data wyjazdu(wniosek) " + departureDate);
            Date d1 = sdf.parse(dataWyjazduStr);
            Date data_wy = sdf.parse(departureDate);
            if (d1.getTime() < data_wy.getTime()) {
                log.debug("data wyjazdu " + d1.getTime() + " data_wyjazdu(wniosek) " + data_wy.getTime());
                return false;
            }
            String dataPowrotuStr = finishPoint.getPrzyjazd_data();
            log.debug("Data powrotu " + dataPowrotuStr + ", data powrotu(wniosek) " + arrivalDate);
            Date d2 = sdf.parse(dataPowrotuStr);
            Date data_pow = sdf.parse(arrivalDate);
            if (d2.getTime() > data_pow.getTime()) {
                log.debug("data przyjazdu(wniosek) " + data_pow.getTime() + " data_przyjazdu " + d2.getTime());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private void addAdvances(BusinessTrip businessTrip, BusinessTripDto dataToSettle, Set<String> uniqueCurrencies, String exchangeDate) throws Exception {
        businessTrip.getAdvances().clear();
        Double[][] advanceAmounts = dataToSettle.getAdvanceAmounts();
        String[][] advanceCurrencies = dataToSettle.getAdvanceCurrencies();
        if (advanceAmounts == null || advanceAmounts.length < 1) {
            return;
        }
        HashMap<String, RateDto> exchanges = this.getExchanges(exchangeDate, uniqueCurrencies, businessTrip.getNr_delegacji());
        for (int i = 0; i < advanceAmounts.length; ++i) {
            this.addAdvance(businessTrip, exchanges, advanceAmounts[i][0], advanceCurrencies[i][0]);
        }
    }

    private HashMap<String, RateDto> getExchanges(String exchangeDate, Set<String> uniqueCurrencies, String delegationNr) throws Exception {
        HashMap<String, RateDto> exchanges = null;
        if (uniqueCurrencies != null && uniqueCurrencies.size() > 0) {
            LocalDate convExchangeDate = null;
            try {
                convExchangeDate = LocalDate.parse(exchangeDate, java.time.format.DateTimeFormatter.ofPattern("yy-MM-dd"));
            }
            catch (DateTimeParseException dtpe) {
                throw new DMException("Data pobrania kurs\u00f3w waluty [" + exchangeDate + "] jest niepoprawna.");
            }
            ActionConf actionConf = Configuration.getActionConf(delegationNr);
            JsonConf jsonConf = Configuration.getActualJsonConfig(delegationNr);
            String exchangeRateSource = actionConf.getExchangeSettings().getExchangeRateSource();
            if (ExchangeRateSource.DATA_SOURCE.name().equals(exchangeRateSource)) {
                String dataSourceId = actionConf.getExchangeSettings().getExchangeRateDataSourceId();
                exchanges = this.exchangeService.getRateFromDataSource(dataSourceId, this.getDataSourceInputParameters(delegationNr), uniqueCurrencies, convExchangeDate);
            } else {
                SettlementCountry settlementCountry = actionConf.getOtherParams().getSettlementCountry();
                switch (settlementCountry) {
                    case POLAND: {
                        exchanges = this.exchangeService.getLastNbpExchanges(uniqueCurrencies, convExchangeDate, jsonConf.getCurrencyName());
                        break;
                    }
                    default: {
                        exchanges = this.exchangeService.getLastECBExchanges(uniqueCurrencies, convExchangeDate, jsonConf.getCurrencyName());
                    }
                }
            }
            if (exchanges == null) {
                throw new DMException("Brak potrzebnego do rozliczenia kursu waluty ");
            }
        }
        return exchanges;
    }

    private void addAdvance(BusinessTrip businessTrip, HashMap<String, RateDto> exchanges, Double amount, String currency) {
        BusinessTripAdvance advance = new BusinessTripAdvance();
        advance.setAmount(amount);
        advance.setCurrency(currency);
        if (currency.equalsIgnoreCase("PLN")) {
            advance.setPlnAmount(amount);
            advance.setExchange(1.0);
        } else {
            RateDto exchange;
            RateDto rateDto = exchange = exchanges != null ? exchanges.get(currency) : null;
            if (exchange != null) {
                advance.setExchange(exchange.getMid());
            }
            advance.setPlnAmount(exchange != null ? Tools.convertCurrency(amount, exchange.getMid()) : 0.0);
        }
        businessTrip.getAdvances().add(advance);
    }

    private void addVariables(BusinessTrip businessTrip, BusinessTripDto dataToSettle) {
        businessTrip.getVariables().clear();
        Map varValues = (Map)dataToSettle.getActivityVariableParams().get("values");
        Map varTypes = (Map)dataToSettle.getActivityVariableParams().get("types");
        if (varValues != null && varTypes != null) {
            for (Map.Entry othersEntry : varValues.entrySet()) {
                for (Object othersValue : (ArrayList)othersEntry.getValue()) {
                    this.addVariable(businessTrip, (String)othersEntry.getKey(), othersValue, varTypes.get(othersEntry.getKey()));
                }
            }
        }
    }

    private void addVariable(BusinessTrip businessTrip, String name, Object value, Object type) {
        BusinessTripActivityVariableValue variable = new BusinessTripActivityVariableValue();
        variable.setVariableId(name);
        variable.setVariableType(type.toString());
        variable.setValue(value);
        businessTrip.getVariables().add(variable);
    }

    public double calculateDiet(BusinessTripQuantities bt, double tripFullReward, double tripRewardDeductions, double rate) {
        double diet = tripFullReward - tripRewardDeductions;
        if (diet < 0.0) {
            diet = 0.0;
        }
        bt.setIlosc_diet_bez_rycz(Tools.round2(diet / rate));
        bt.setDieta_w_walucie_kraju_bez_rycz(diet);
        bt.setIlosc_diet(Tools.round2(diet / rate));
        bt.setDieta_w_walucie_kraju(diet);
        return Tools.round2(diet);
    }

    protected Map<String, String> getDataSourceInputParameters(String delegationNr) {
        String[] paramNames = Configuration.getActionConf(delegationNr).getExchangeSettings().getDatasourceInputParametersId();
        String[] paramValues = Configuration.getActionConf(delegationNr).getExchangeSettings().getDatasourceInputParametersValue();
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (int i = 0; i < paramNames.length; ++i) {
            parameters.put(paramNames[i], paramValues[i]);
        }
        return parameters;
    }

    @Override
    public Double calculateDomesticDietDeductions(BusinessTripQuantities bt, double tripFullReward, String delegationFinishDate, JsonConf config) {
        double dietRate = config.getKraj().getDieta();
        double deductions = 0.0;
        if (config.getDomesticCountryName().equalsIgnoreCase(bt.getKraj())) {
            if (bt.getCalodobowe_wyzywienie().equalsIgnoreCase("tak")) {
                log.debug("Pracodawaca zapewni\u0142 ca\u0142odobowe wyzywienie dla kraju " + bt.getKraj());
                Double wysokosc_diety_gdy_zapewniony_posilek = config.getKraj().getWysokosc_diety_gdy_pracodawca_zapewnil_posilek();
                deductions = (double)Math.round(tripFullReward * (1.0 - wysokosc_diety_gdy_zapewniony_posilek) * 100.0) / 100.0;
            } else {
                Integer percentageReductionForBreakfast = config.getKraj().getProcentowe_zmniejszenie_diety_za_zapewnione_sniadanie();
                if (percentageReductionForBreakfast == null) {
                    percentageReductionForBreakfast = 25;
                }
                deductions = (double)bt.getZapewnione_sniadania().intValue() * ((double)percentageReductionForBreakfast.intValue() / 100.0) * dietRate;
                Integer percentageReductionForDinner = config.getKraj().getProcentowe_zmniejszenie_diety_za_zapewniony_obiad();
                if (percentageReductionForDinner == null) {
                    percentageReductionForDinner = 50;
                }
                deductions += (double)bt.getZapewnione_obiady().intValue() * ((double)percentageReductionForDinner.intValue() / 100.0) * dietRate;
                Integer percentageReductionForSupper = config.getKraj().getProcentowe_zmniejszenie_diety_za_zapewniona_kolacje();
                if (percentageReductionForSupper == null) {
                    percentageReductionForSupper = 25;
                }
                deductions += (double)bt.getZapewnione_kolacje().intValue() * ((double)percentageReductionForSupper.intValue() / 100.0) * dietRate;
            }
        }
        return deductions;
    }

    @Override
    public double calculateKilometrageAllowance(BusinessTrip trip) throws DMException {
        double kmAllowance = 0.0;
        if (!trip.getKoszty_paliwa().equalsIgnoreCase("przedstawiono") && !trip.getSr_lokomocji().equalsIgnoreCase("")) {
            List<RouteCostDetails> routeCostDetails = BusinessTripUtil.getRoutesCostDetails(trip.getTrasa(), trip.getSr_lokomocji(), trip.getNr_delegacji());
            kmAllowance = Tools.round2(routeCostDetails.stream().mapToDouble(routeCostDetail -> routeCostDetail.getKilometersCount() * routeCostDetail.getRate()).sum());
        }
        log.debug("kilometrowka = " + kmAllowance);
        return kmAllowance;
    }

    protected Set<String> getUniqueNotDomesticCurrencies(BusinessTripDto dataToSettle) {
        String finishDate = sdf.format(dataToSettle.getBaseData().getData_powrotu());
        JsonConf jsonConfig = Configuration.getJsonConfigForDate(dataToSettle.getBaseData().getNr_delegacji(), finishDate);
        String domesticCurrencyName = jsonConfig.getCurrencyName();
        String[][] advanceCurrencies = dataToSettle.getAdvanceCurrencies();
        Double[][] advanceAmounts = dataToSettle.getAdvanceAmounts();
        HashSet<String> uniqueCurrencies = new HashSet<String>();
        if (advanceCurrencies != null) {
            for (int i = 0; i < advanceCurrencies.length; ++i) {
                if (!StringUtils.isNotBlank((String)advanceCurrencies[i][0]) || domesticCurrencyName.equalsIgnoreCase(advanceCurrencies[i][0]) || !(advanceAmounts[i][0] > 0.0)) continue;
                uniqueCurrencies.add(advanceCurrencies[i][0]);
            }
        }
        return uniqueCurrencies;
    }

    public void setExchangeService(ExchangeService exchangeService) {
        this.exchangeService = exchangeService;
    }
}

