/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.dto;

import com.suncode.businesstrip.dto.RateDto;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ExchangeDto {
    private static final Logger log = LoggerFactory.getLogger(ExchangeDto.class);
    private String table;
    private String currency;
    private String code;
    private List<RateDto> rates = new ArrayList<RateDto>();

    public static ExchangeDto parseECBXml(String xmlContent, String exchangeSymbol) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlContent)));
            ExchangeDto exchangeDto = new ExchangeDto();
            exchangeDto.setCode(exchangeSymbol);
            exchangeDto.setCurrency(exchangeSymbol);
            NodeList seriesList = doc.getElementsByTagNameNS("http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/generic", "Series");
            if (seriesList.getLength() == 0) {
                log.warn("No Series element found in ECB XML for symbol: {}", (Object)exchangeSymbol);
                return null;
            }
            Element series = (Element)seriesList.item(0);
            NodeList seriesKeyList = series.getElementsByTagNameNS("http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/generic", "SeriesKey");
            if (seriesKeyList.getLength() > 0) {
                Element seriesKey = (Element)seriesKeyList.item(0);
                NodeList valueList = seriesKey.getElementsByTagNameNS("http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/generic", "Value");
                for (int i = 0; i < valueList.getLength(); ++i) {
                    Element value = (Element)valueList.item(i);
                    String id = value.getAttribute("id");
                    if (!"CURRENCY".equals(id)) continue;
                    String currency = value.getAttribute("value");
                    exchangeDto.setCode(currency);
                    exchangeDto.setCurrency(currency);
                    break;
                }
            }
            NodeList obsList = series.getElementsByTagNameNS("http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/generic", "Obs");
            DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("yyyy-MM");
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            for (int i = 0; i < obsList.getLength(); ++i) {
                Element obs = (Element)obsList.item(i);
                NodeList obsDimensionList = obs.getElementsByTagNameNS("http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/generic", "ObsDimension");
                if (obsDimensionList.getLength() == 0) continue;
                Element obsDimension = (Element)obsDimensionList.item(0);
                String periodValue = obsDimension.getAttribute("value");
                NodeList obsValueList = obs.getElementsByTagNameNS("http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/generic", "ObsValue");
                if (obsValueList.getLength() == 0) continue;
                Element obsValue = (Element)obsValueList.item(0);
                BigDecimal ratePerEur = new BigDecimal(obsValue.getAttribute("value"));
                Double rateValue = BigDecimal.ONE.divide(ratePerEur, 10, RoundingMode.HALF_UP).doubleValue();
                if (periodValue == null || periodValue.isEmpty()) continue;
                RateDto rateDto = new RateDto();
                try {
                    LocalDate date;
                    if (periodValue.length() == 10) {
                        date = LocalDate.parse(periodValue, dateFormatter);
                    } else if (periodValue.length() == 7) {
                        YearMonth yearMonth = YearMonth.parse(periodValue, monthFormatter);
                        date = yearMonth.atDay(1);
                    } else {
                        log.warn("Unknown date format: {} for symbol: {}", (Object)periodValue, (Object)exchangeSymbol);
                        continue;
                    }
                    rateDto.setEffectiveDate(date.format(dateFormatter));
                }
                catch (Exception e) {
                    log.warn("Could not parse period value: {} for symbol: {}", new Object[]{periodValue, exchangeSymbol, e});
                    continue;
                }
                try {
                    rateDto.setMid(rateValue);
                }
                catch (NumberFormatException e) {
                    log.warn("Could not parse rate value: {} for symbol: {}", (Object)rateValue, (Object)exchangeSymbol);
                    continue;
                }
                rateDto.setExchangeSymbol(exchangeDto.getCode());
                exchangeDto.getRates().add(rateDto);
            }
            if (exchangeDto.getRates().isEmpty()) {
                log.warn("No rates found in ECB XML for symbol: {}", (Object)exchangeSymbol);
                return null;
            }
            return exchangeDto;
        }
        catch (Exception e) {
            log.error("Error parsing ECB XML for symbol: {}", (Object)exchangeSymbol, (Object)e);
            return null;
        }
    }

    public String getTable() {
        return this.table;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getCode() {
        return this.code;
    }

    public List<RateDto> getRates() {
        return this.rates;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setRates(List<RateDto> rates) {
        this.rates = rates;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExchangeDto)) {
            return false;
        }
        ExchangeDto other = (ExchangeDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        List<RateDto> this$rates = this.getRates();
        List<RateDto> other$rates = other.getRates();
        return !(this$rates == null ? other$rates != null : !((Object)this$rates).equals(other$rates));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExchangeDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        List<RateDto> $rates = this.getRates();
        result = result * 59 + ($rates == null ? 43 : ((Object)$rates).hashCode());
        return result;
    }

    public String toString() {
        return "ExchangeDto(table=" + this.getTable() + ", currency=" + this.getCurrency() + ", code=" + this.getCode() + ", rates=" + String.valueOf(this.getRates()) + ")";
    }
}

