/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.document;

import com.suncode.businesstrip.BusinessTripService;
import com.suncode.businesstrip.config.Configuration;
import com.suncode.businesstrip.config.data.ActionConf;
import com.suncode.businesstrip.config.data.PdfConf;
import com.suncode.businesstrip.database.model.BusinessTrip;
import com.suncode.businesstrip.database.model.BusinessTripActivityVariableValue;
import com.suncode.businesstrip.database.model.BusinessTripAdvance;
import com.suncode.businesstrip.database.model.BusinessTripQuantities;
import com.suncode.businesstrip.database.model.BusinessTripRoute;
import com.suncode.businesstrip.database.model.BusinessTripSpendings;
import com.suncode.businesstrip.document.BusinessTripDocument;
import com.suncode.businesstrip.document.BusinessTripDocumentDao;
import com.suncode.businesstrip.document.BusinessTripDocumentService;
import com.suncode.businesstrip.exception.DMException;
import com.suncode.businesstrip.util.BusinessTripUtil;
import com.suncode.businesstrip.util.Tools;
import com.suncode.cuf.template.WordTemplateService;
import com.suncode.cuf.util.TemporaryFile;
import com.suncode.cuf.util.template.WordTemplateUtil;
import com.suncode.cuf.web.dto.template.DocumentInfo;
import com.suncode.cuf.web.dto.template.WordTemplateForm;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.util.EditableServiceImpl;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BusinessTripDocumentServiceImpl
extends EditableServiceImpl<BusinessTripDocument, String, BusinessTripDocumentDao>
implements BusinessTripDocumentService {
    private static final Logger log = LoggerFactory.getLogger(BusinessTripDocumentServiceImpl.class);
    @Autowired
    public BusinessTripService businessTripService;
    private WordTemplateService wordTemplateService = (WordTemplateService)SpringContext.getBean(WordTemplateService.class);

    @Autowired
    public void setDao(BusinessTripDocumentDao dao) {
        this.dao = dao;
    }

    @Override
    @Transactional
    public void prepareAndAttachPdfs(String processId, String activityId, String businessTripId) throws Exception {
        BusinessTrip busnTrip = (BusinessTrip)this.businessTripService.get((Serializable)((Object)businessTripId));
        if (busnTrip == null) {
            throw new DMException("read.errorMsg");
        }
        BusinessTripDocument assignedPdfDocuments = this.getDocument(businessTripId, busnTrip);
        ActionConf actionConf = Configuration.getActionConf(businessTripId);
        this.removePreviousVersionDocument(processId, this.getDocumentClassName(actionConf.getSummaryPdf()), assignedPdfDocuments.getDoc_id_podsumowanie());
        this.removePreviousVersionDocument(processId, this.getDocumentClassName(actionConf.getCardPdf()), assignedPdfDocuments.getDoc_id_karta_ewidencji());
        Map<String, Object> pdfDataContent = this.prepareDataForPdfDocument(busnTrip);
        WordTemplateForm config = this.prepareWordTemplateConfig(processId, activityId);
        this.generateSettlementSummaryPdfDocument(processId, activityId, actionConf.getSummaryPdf(), busnTrip, assignedPdfDocuments, pdfDataContent, config);
        this.generateTransportCardPdfDocument(processId, activityId, actionConf.getCardPdf(), busnTrip, assignedPdfDocuments, pdfDataContent, config);
        try {
            this.save(assignedPdfDocuments);
        }
        catch (Exception e) {
            log.error("B\u0142\u0105d ", (Throwable)e);
            throw new DMException("document.generate.errorMsg.incorrectSave");
        }
    }

    private void generateTransportCardPdfDocument(String processId, String activityId, PdfConf pdfTransportCard, BusinessTrip busnTrip, BusinessTripDocument assignedDocuments, Map<String, Object> pdfDataContent, WordTemplateForm config) throws Exception {
        String newDocId = null;
        if (pdfTransportCard != null && pdfTransportCard.getRun().booleanValue()) {
            boolean isPrivateCar = BusinessTripUtil.sprawdzCzyPojazdKilometrowkaNaTrasie(busnTrip.getTrasa(), busnTrip.getData_powrotu(), busnTrip.getNr_delegacji());
            if (!isPrivateCar) {
                log.debug("Karty ewidencji pojazdu nie jest generowana, poniewa\u017c brak przejazdu pojazdem z kilometr\u00f3wk\u0105.");
                return;
            }
            String documentTemplate = pdfTransportCard.getTemplateName();
            if (documentTemplate == null) {
                throw new DMException("document.generate.errorMsg.blankTemplateName");
            }
            config.setTemplate(documentTemplate);
            config.setDocumentClass(this.getDocumentClassName(pdfTransportCard));
            this.addRouteDataToContent(pdfDataContent, busnTrip.getTrasa(), true, busnTrip.getData_powrotu(), busnTrip.getNr_delegacji());
            config.setMappings(pdfDataContent);
            if (log.isTraceEnabled()) {
                for (String k : pdfDataContent.keySet()) {
                    log.trace(k + " = " + String.valueOf(pdfDataContent.get(k)));
                }
            }
            newDocId = String.valueOf(this.generateAndAttach(config));
            log.debug("Docid wygenerowanej karty ewidencji: " + newDocId);
        }
        assignedDocuments.setDoc_id_karta_ewidencji(newDocId);
    }

    private void generateSettlementSummaryPdfDocument(String processId, String activityId, PdfConf pdfSettlementSummary, BusinessTrip busnTrip, BusinessTripDocument assignedDocuments, Map<String, Object> pdfDataContent, WordTemplateForm config) throws Exception {
        String newDocId = null;
        if (pdfSettlementSummary != null && pdfSettlementSummary.getRun().booleanValue()) {
            String documentTemplate = pdfSettlementSummary.getTemplateName();
            if (documentTemplate == null) {
                throw new DMException("document.generate.errorMsg.incorrectTemplateName");
            }
            config.setTemplate(documentTemplate);
            config.setDocumentClass(this.getDocumentClassName(pdfSettlementSummary));
            this.addRouteDataToContent(pdfDataContent, busnTrip.getTrasa(), false, busnTrip.getData_powrotu(), busnTrip.getNr_delegacji());
            config.setMappings(pdfDataContent);
            if (log.isTraceEnabled()) {
                for (String k : pdfDataContent.keySet()) {
                    log.trace(k + " = " + String.valueOf(pdfDataContent.get(k)));
                }
            }
            newDocId = String.valueOf(this.generateAndAttach(config));
            log.debug("Docid wygenerowanego podsumowania: " + newDocId);
        }
        assignedDocuments.setDoc_id_podsumowanie(newDocId);
    }

    private String getDocumentClassName(PdfConf pdfConf) throws Exception {
        String documentClassName = null;
        if (pdfConf != null) {
            documentClassName = pdfConf.getDocumentClass();
        }
        if (pdfConf.getRun().booleanValue() && StringUtils.isBlank((CharSequence)documentClassName)) {
            throw new DMException("document.generate.errorMsg.blankClassName");
        }
        return documentClassName;
    }

    private BusinessTripDocument getDocument(String businessTripId, BusinessTrip busnTrip) {
        BusinessTripDocument dokument = (BusinessTripDocument)this.get((Serializable)((Object)businessTripId));
        if (dokument == null) {
            dokument = new BusinessTripDocument();
            dokument.setNr_delegacji(busnTrip.getNr_delegacji());
        }
        return dokument;
    }

    private void removePreviousVersionDocument(String processId, String documentClassName, String poprzedni_id) throws Exception {
        if (StringUtils.isBlank((CharSequence)poprzedni_id)) {
            return;
        }
        DocumentService documentService = ServiceFactory.getDocumentService();
        Long documentId = null;
        try {
            documentId = documentService.getDocument(Long.valueOf(Long.parseLong(poprzedni_id))).getId();
        }
        catch (Exception e) {
            log.debug("Dokument ju\u017c nie istnia\u0142", (Throwable)e);
            return;
        }
        DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
        DocumentClass documentClass = documentClassService.getDocumentClass(documentClassName, new String[0]);
        if (documentClass == null) {
            throw new DMException("document.generate.errorMsg.incorrectClassName");
        }
        documentService.detachDocumentFromProcess(documentId, documentClass.getId(), processId);
        documentService.deleteDocument(documentId, documentClass.getId());
    }

    private Map<String, Object> prepareDataForPdfDocument(BusinessTrip delegacja) throws Exception {
        HashMap<String, Object> pdfDataContent = new HashMap<String, Object>();
        this.addBaseDataToContent(pdfDataContent, delegacja);
        this.addQuantitiesDataToContent(pdfDataContent, delegacja);
        this.addCarDataToContent(pdfDataContent, delegacja);
        this.addSettlementDataToContent(pdfDataContent, delegacja);
        this.addSpendingsDataToContent(pdfDataContent, delegacja.getWydatki());
        this.addOtherDataToContent(pdfDataContent, delegacja);
        this.addAdvancesDataToContent(pdfDataContent, delegacja.getAdvances());
        this.addActivityVariablesDataToContent(pdfDataContent, delegacja.getVariables());
        return pdfDataContent;
    }

    private void addBaseDataToContent(Map<String, Object> contentData, BusinessTrip delegacja) {
        contentData.put("typ_del", delegacja.getTyp_delegacji());
        contentData.put("nr_delegacji", delegacja.getNr_delegacji());
        contentData.put("imie_nazwisko", delegacja.getImie_nazwisko());
        contentData.put("cel_delegacji", delegacja.getCel_delegacji());
        contentData.put("data_odjazdu", Tools.getDateSubstring(delegacja.getData_odjazdu()));
        contentData.put("data_powrotu", Tools.getDateSubstring(delegacja.getData_powrotu()));
        contentData.put("miasto_docelowe", delegacja.getMiasto_docelowe());
        contentData.put("czy_przekroczono_dystans_dla_diety", delegacja.getCzy_przekroczono_dystans_dla_diety());
        contentData.put("srodek_transportu", delegacja.getSrodek_transportu());
        contentData.put("kraj_docelowy", delegacja.getKraje_docelowe());
        contentData.put("data_wydania_zaliczki", Tools.getDateSubstring(delegacja.getData_wydania_zaliczki()));
    }

    private void addCarDataToContent(Map<String, Object> contentData, BusinessTrip delegacja) {
        contentData.put("koszty_paliwa", delegacja.getKoszty_paliwa());
        contentData.put("sr_lokomocji", delegacja.getSr_lokomocji());
        contentData.put("marka_pojazdu", delegacja.getMarka_pojazdu());
        contentData.put("nr_rejestracyjny", delegacja.getNr_rejestracyjny());
        contentData.put("adres_uzytkownika_pojazdu", delegacja.getAdres_uzytkownika_pojazdu());
        contentData.put("pojemnosc_silnika", Tools.formatKwota(delegacja.getPojemnosc_silnika(), true));
        contentData.put("stawka_za_1_km", Tools.formatKurs(delegacja.getStawka_za_1_km(), true));
    }

    private void addQuantitiesDataToContent(Map<String, Object> contentData, BusinessTrip delegacja) {
        Double del_sum = 0.0;
        StringBuilder kraj = new StringBuilder();
        StringBuilder niezapewnione_doby_komunikacji_miejskiej = new StringBuilder();
        StringBuilder niezapewnione_noclegi = new StringBuilder();
        StringBuilder zapewnione_sniadania = new StringBuilder();
        StringBuilder zapewnione_obiady = new StringBuilder();
        StringBuilder zapewnione_kolacje = new StringBuilder();
        StringBuilder niezapewnione_przejazdy_do_z_dworca = new StringBuilder();
        StringBuilder dieta_w_walucie_kraju = new StringBuilder();
        StringBuilder tab_wartosc_del_w_pln = new StringBuilder();
        StringBuilder waluta = new StringBuilder();
        StringBuilder kurs_walutowy = new StringBuilder();
        StringBuilder data_kursu = new StringBuilder();
        StringBuilder godziny_w_delegacji = new StringBuilder();
        StringBuilder tab_ryczalt_za_niezapewnione = new StringBuilder();
        StringBuilder tab_zapewnione_cal_dz = new StringBuilder();
        StringBuilder tab_dni_w_delegacji = new StringBuilder();
        StringBuilder tab_stawka_diety = new StringBuilder();
        StringBuilder tab_ryczalt_sam_pryw = new StringBuilder();
        StringBuilder dieta_w_walucie_kraju_bez_rycz = new StringBuilder();
        StringBuilder ilosci_diet = new StringBuilder();
        StringBuilder tripFullReward = new StringBuilder();
        StringBuilder tripRewardDeductions = new StringBuilder();
        StringBuilder countryTotal = new StringBuilder();
        StringBuilder countryTotalPln = new StringBuilder();
        String separator = "";
        String domesticCountryName = Configuration.getJsonConfigForDate(delegacja.getNr_delegacji(), delegacja.getData_powrotu()).getDomesticCountryName();
        for (BusinessTripQuantities row : delegacja.getIlosci()) {
            if (row == null || row.getKraj() == null || row.getKraj().equals("")) continue;
            if (separator.length() > 0) {
                kraj.append(";");
                niezapewnione_doby_komunikacji_miejskiej.append(";");
                niezapewnione_noclegi.append(";");
                zapewnione_sniadania.append(";");
                zapewnione_obiady.append(";");
                zapewnione_kolacje.append(";");
                niezapewnione_przejazdy_do_z_dworca.append(";");
                dieta_w_walucie_kraju.append(";");
                tab_wartosc_del_w_pln.append(";");
                waluta.append(";");
                kurs_walutowy.append(";");
                data_kursu.append(";");
                godziny_w_delegacji.append(";");
                tab_zapewnione_cal_dz.append(";");
                tab_ryczalt_za_niezapewnione.append(";");
                tab_dni_w_delegacji.append(";");
                tab_stawka_diety.append(";");
                tab_ryczalt_sam_pryw.append(";");
                dieta_w_walucie_kraju_bez_rycz.append(";");
                ilosci_diet.append(";");
                tripFullReward.append(";");
                tripRewardDeductions.append(";");
                countryTotal.append(";");
                countryTotalPln.append(";");
            }
            kraj.append(row.getKraj());
            niezapewnione_doby_komunikacji_miejskiej.append(Tools.formatIlosc(row.getNiezapewnione_doby_komunikacji_miejskiej(), true));
            niezapewnione_noclegi.append(Tools.formatIlosc(row.getNiezapewnione_noclegi(), true));
            zapewnione_sniadania.append(Tools.formatIlosc(row.getZapewnione_sniadania(), true));
            zapewnione_obiady.append(Tools.formatIlosc(row.getZapewnione_obiady(), true));
            zapewnione_kolacje.append(Tools.formatIlosc(row.getZapewnione_kolacje(), true));
            niezapewnione_przejazdy_do_z_dworca.append(Tools.formatIlosc(row.getNiezapewnione_przejazdy_do_z_dworca(), true));
            dieta_w_walucie_kraju.append(Tools.formatKwota(row.getDieta_w_walucie_kraju(), true));
            dieta_w_walucie_kraju_bez_rycz.append(Tools.formatKwota(row.getDieta_w_walucie_kraju_bez_rycz(), true));
            waluta.append(Tools.returnEmptyIfNull(row.getWaluta()));
            if (!row.getKraj().equalsIgnoreCase(domesticCountryName)) {
                kurs_walutowy.append(Tools.formatKurs(row.getKurs_walutowy(), true));
                data_kursu.append(Tools.changeDateFormat(row.getData_kursu()));
                Double dieta_w_pln = Tools.convertCurrency(row.getDieta_w_walucie_kraju(), row.getKurs_walutowy());
                del_sum = del_sum + dieta_w_pln;
                tab_wartosc_del_w_pln.append(Tools.formatKwota(dieta_w_pln, true));
            } else {
                tab_ryczalt_sam_pryw.append(Tools.formatKwota(delegacja.getKilometrowka(), true));
                del_sum = del_sum + row.getDieta_w_walucie_kraju();
                tab_wartosc_del_w_pln.append(Tools.formatKwota(row.getDieta_w_walucie_kraju(), true));
            }
            godziny_w_delegacji.append(Tools.zmienMinutyNaGodziny(row.getMinuty_w_delegacji()));
            long ryczalt_za_niezapewnione = 0L;
            if (row.getRyczalt_doby_kom_miejskiej() != null) {
                ryczalt_za_niezapewnione += Math.round(row.getRyczalt_doby_kom_miejskiej() * 100.0);
            }
            if (row.getRyczalt_noclegi() != null) {
                ryczalt_za_niezapewnione += Math.round(row.getRyczalt_noclegi() * 100.0);
            }
            if (row.getRyczalt_przejazdy_do_z_dworca() != null) {
                ryczalt_za_niezapewnione += Math.round(row.getRyczalt_przejazdy_do_z_dworca() * 100.0);
            }
            tab_ryczalt_za_niezapewnione.append(Tools.formatKwota((double)ryczalt_za_niezapewnione / 100.0, true));
            if (row.getCalodobowe_wyzywienie() != null) {
                tab_zapewnione_cal_dz.append(Tools.isTak(row.getCalodobowe_wyzywienie()) ? "X" : "");
            }
            tab_dni_w_delegacji.append(Tools.zmienMinutyNaDni(row.getMinuty_w_delegacji()));
            tab_stawka_diety.append(Tools.formatKwota(row.getStawka_diety(), true));
            ilosci_diet.append(Tools.formatKwota(row.getIlosc_diet(), true));
            tripFullReward.append(Tools.formatKwota(row.getTripFullReward(), true));
            tripRewardDeductions.append(Tools.formatKwota(row.getTripRewardDeductions(), true));
            Double carKmReward = row.getKraj().equalsIgnoreCase(domesticCountryName) ? delegacja.getKilometrowka() : 0.0;
            Double total = row.getDieta_w_walucie_kraju() + (double)ryczalt_za_niezapewnione / 100.0 + carKmReward;
            countryTotal.append(Tools.formatKwota(total, true));
            Double exchange = row.getKraj().equalsIgnoreCase(domesticCountryName) ? 1.0 : row.getKurs_walutowy();
            Double totalPln = Tools.convertCurrency(total, exchange);
            countryTotalPln.append(Tools.formatKwota(totalPln, true));
            separator = ";";
        }
        contentData.put("tab_kraj", kraj.toString());
        contentData.put("tab_niezapewnione_doby_komunikacji_miejskiej", niezapewnione_doby_komunikacji_miejskiej.toString());
        contentData.put("tab_niezapewnione_noclegi", niezapewnione_noclegi.toString());
        contentData.put("tab_zapewnione_sniadania", zapewnione_sniadania.toString());
        contentData.put("tab_zapewnione_obiady", zapewnione_obiady.toString());
        contentData.put("tab_zapewnione_kolacje", zapewnione_kolacje.toString());
        contentData.put("tab_niezapewnione_przejazdy_do_z_dworca", niezapewnione_przejazdy_do_z_dworca.toString());
        contentData.put("tab_dieta_w_walucie_kraju", dieta_w_walucie_kraju_bez_rycz.toString());
        contentData.put("tab_wartosc_del_w_wal", dieta_w_walucie_kraju.toString());
        contentData.put("tab_wartosc_del_w_pln", tab_wartosc_del_w_pln.toString());
        contentData.put("tab_waluta", waluta.toString());
        contentData.put("tab_kurs_walutowy", kurs_walutowy.toString());
        contentData.put("tab_data_kursu", data_kursu.toString());
        contentData.put("tab_godziny_w_delegacji", godziny_w_delegacji.toString());
        contentData.put("tab_ryczalt_za_niezapewnione", tab_ryczalt_za_niezapewnione.toString());
        contentData.put("tab_zapewnione_cal_dz", tab_zapewnione_cal_dz.toString());
        contentData.put("tab_dni_w_delegacji", tab_dni_w_delegacji.toString());
        contentData.put("tab_stawka_diety", tab_stawka_diety.toString());
        contentData.put("tab_ryczalt_sam_pryw", tab_ryczalt_sam_pryw.toString());
        contentData.put("tab_ilosci_diet", ilosci_diet);
        contentData.put("tab_dieta_pelna", tripFullReward.toString());
        contentData.put("tab_dieta_potracenia", tripRewardDeductions.toString());
        contentData.put("tab_suma_kraj", countryTotal.toString());
        contentData.put("tab_suma_kraj_pln", countryTotalPln.toString());
        contentData.put("del_sum", Tools.formatKwota(del_sum, true));
    }

    private void addSettlementDataToContent(Map<String, Object> contentData, BusinessTrip delegacja) {
        contentData.put("ryczalt_srodki_miejskie_kraj", "");
        contentData.put("ryczalt_noclegi_kraj", "");
        contentData.put("dieta_zagranica", "");
        contentData.put("ryczalt_srodki_miejskie_zagranica", "");
        contentData.put("ryczalt_noclegi_zagranica", "");
        contentData.put("ryczalt_za_przejazdy_do_z_dworca", "");
        contentData.put("dieta_kraj", Tools.formatKwota(delegacja.getDieta_kraj(), true));
        if (delegacja.getRyczalt_srodki_miejskie_kraj() != null) {
            contentData.put("ryczalt_srodki_miejskie_kraj", Tools.formatKwota(delegacja.getRyczalt_srodki_miejskie_kraj(), true));
        }
        if (delegacja.getRyczalt_noclegi_kraj() != null) {
            contentData.put("ryczalt_noclegi_kraj", Tools.formatKwota(delegacja.getRyczalt_noclegi_kraj(), true));
        }
        Double ryczaltSrodkiMiejskieKraj = delegacja.getRyczalt_srodki_miejskie_kraj() != null ? delegacja.getRyczalt_srodki_miejskie_kraj() : 0.0;
        Double ryczaltNoclegiKraj = delegacja.getRyczalt_noclegi_kraj() != null ? delegacja.getRyczalt_noclegi_kraj() : 0.0;
        Double totalTripReward = delegacja.getDieta_kraj() + ryczaltSrodkiMiejskieKraj + ryczaltNoclegiKraj;
        if (!delegacja.getTyp_delegacji().equalsIgnoreCase("kraj")) {
            contentData.put("dieta_zagranica", Tools.formatKwota(delegacja.getDieta_zagranica(), true));
            if (delegacja.getRyczalt_srodki_miejskie_zagranica() != null) {
                contentData.put("ryczalt_srodki_miejskie_zagranica", Tools.formatKwota(delegacja.getRyczalt_srodki_miejskie_zagranica(), true));
            }
            if (delegacja.getRyczalt_noclegi_zagranica() != null) {
                contentData.put("ryczalt_noclegi_zagranica", Tools.formatKwota(delegacja.getRyczalt_noclegi_zagranica(), true));
            }
            if (delegacja.getRyczalt_za_przejazdy_do_z_dworca() != null) {
                contentData.put("ryczalt_za_przejazdy_do_z_dworca", Tools.formatKwota(delegacja.getRyczalt_za_przejazdy_do_z_dworca(), true));
            }
            Double ryczaltSrodkiMiejskieZagranica = delegacja.getRyczalt_srodki_miejskie_zagranica() != null ? delegacja.getRyczalt_srodki_miejskie_zagranica() : 0.0;
            Double ryczaltNoclegiZagranica = delegacja.getRyczalt_noclegi_zagranica() != null ? delegacja.getRyczalt_noclegi_zagranica() : 0.0;
            Double ryczaltZaPrzejazdyDoZDworca = delegacja.getRyczalt_za_przejazdy_do_z_dworca() != null ? delegacja.getRyczalt_za_przejazdy_do_z_dworca() : 0.0;
            totalTripReward = totalTripReward + (delegacja.getDieta_zagranica() + ryczaltSrodkiMiejskieZagranica + ryczaltNoclegiZagranica + ryczaltZaPrzejazdyDoZDworca);
        }
        Double suma_km_pojazd_prywatny = BusinessTripUtil.obliczIloscKmPrzejechanychWlasnymPojazdem(delegacja.getTrasa(), delegacja.getData_powrotu(), delegacja.getNr_delegacji());
        contentData.put("suma_km_pojazd_prywatny", Tools.formatKwota(Tools.round2(suma_km_pojazd_prywatny), true));
        contentData.put("kilometrowka", Tools.formatKwota(delegacja.getKilometrowka(), true));
        totalTripReward = totalTripReward + delegacja.getKilometrowka();
        Double totalPlnSpendings = 0.0;
        for (BusinessTripSpendings spending : delegacja.getWydatki()) {
            totalPlnSpendings = totalPlnSpendings + spending.getKoszt_pln();
        }
        totalTripReward = totalTripReward + totalPlnSpendings;
        Double totalPlnAdvances = 0.0;
        for (BusinessTripAdvance advance : delegacja.getAdvances()) {
            totalPlnAdvances = totalPlnAdvances + advance.getPlnAmount();
        }
        contentData.put("calkowita_wartosc_delegacji_pln", Tools.formatKwota(totalTripReward, true));
        contentData.put("wartosc_do_wyplaty_pracownikowi_pln", Tools.formatKwota(totalTripReward - totalPlnAdvances, true));
    }

    private void addSpendingsDataToContent(Map<String, Object> contentData, Set<BusinessTripSpendings> spendings) {
        StringBuilder lp = new StringBuilder();
        StringBuilder spendingType = new StringBuilder();
        StringBuilder spendingName = new StringBuilder();
        StringBuilder spendingPlnAmount = new StringBuilder();
        StringBuilder spendingAmount = new StringBuilder();
        StringBuilder spendingCurrency = new StringBuilder();
        StringBuilder spendingExchangeRate = new StringBuilder();
        StringBuilder spendingDate = new StringBuilder();
        StringBuilder spendingPaymentMethod = new StringBuilder();
        StringBuilder spendingDocumentType = new StringBuilder();
        String separator = "";
        Double dWydatki_sum_pln = 0.0;
        int rowNr = 1;
        for (BusinessTripSpendings spending : spendings) {
            lp.append(separator).append(rowNr);
            spendingType.append(separator).append(spending.getRodzaj_wydatku());
            spendingName.append(separator).append(spending.getNazwa_wydatku());
            spendingPlnAmount.append(separator).append(Tools.formatKwota(spending.getKoszt_pln(), true));
            spendingAmount.append(separator).append(Tools.formatKwota(spending.getKoszt(), true));
            spendingCurrency.append(separator).append(spending.getWaluta());
            spendingExchangeRate.append(separator).append(Tools.formatKurs(spending.getKurs(), true));
            spendingDate.append(separator).append(Tools.getDateSubstring(spending.getData()));
            spendingPaymentMethod.append(separator).append(spending.getPaymentMethod());
            spendingDocumentType.append(separator).append(spending.getDocumentType());
            separator = ";";
            ++rowNr;
            Double wydatki_w_pln = spending.getKoszt_pln();
            dWydatki_sum_pln = dWydatki_sum_pln + wydatki_w_pln;
        }
        contentData.put("tab_wydatki_lp", lp.toString());
        contentData.put("tab_rodzaj_wydatku", spendingType);
        contentData.put("tab_nazwa_wydatku", spendingName);
        contentData.put("tab_kwota_wydatku_pln", spendingPlnAmount);
        contentData.put("tab_kwota_wydatku", spendingAmount);
        contentData.put("tab_waluta_wydatku", spendingCurrency);
        contentData.put("tab_kurs_waluty_wydatku", spendingExchangeRate);
        contentData.put("tab_data_wydatku", spendingDate);
        contentData.put("tab_forma_platnosci_wydatku", spendingPaymentMethod);
        contentData.put("tab_typ_dokumentu_wydatku", spendingDocumentType);
        contentData.put("wydatki_sum", Tools.formatKwota(dWydatki_sum_pln, true));
    }

    private void addOtherDataToContent(Map<String, Object> contentData, BusinessTrip delegacja) {
        contentData.put("uwagi", delegacja.getUwagi());
        contentData.put("daty_zgodne_z_wnioskiem", delegacja.getDaty_zgodne_z_wnioskiem() != false ? "zgodne z wnioskiem" : "niezgodne z wnioskiem");
    }

    private void addRouteDataToContent(Map<String, Object> contentData, Set<BusinessTripRoute> trasa_org, boolean czyTylkoPrywatny, String finishDelegationDate, String delegationNr) throws Exception {
        int rowNr = 1;
        Set<BusinessTripRoute> trasa = null;
        if (czyTylkoPrywatny) {
            trasa = new HashSet<BusinessTripRoute>(trasa_org.size());
            for (BusinessTripRoute i : trasa_org) {
                if (!Configuration.getJsonConfigForDate(delegationNr, finishDelegationDate).getKilometrowkaDla().contains(i.getSrodek_transportu())) continue;
                trasa.add(i);
            }
        } else {
            trasa = trasa_org;
        }
        StringBuilder lp = new StringBuilder();
        StringBuilder wyjazd_miejscowosc = new StringBuilder();
        StringBuilder wyjazd_data = new StringBuilder();
        StringBuilder wyjazd_godzina = new StringBuilder();
        StringBuilder przyjazd_miejscowosc = new StringBuilder();
        StringBuilder przyjazd_data = new StringBuilder();
        StringBuilder przyjazd_godzina = new StringBuilder();
        StringBuilder srodek_transportu = new StringBuilder();
        StringBuilder borderDate = new StringBuilder();
        StringBuilder borderHour = new StringBuilder();
        StringBuilder km = new StringBuilder();
        String separator = "";
        for (BusinessTripRoute odcinek : trasa) {
            lp.append(separator).append(rowNr);
            wyjazd_miejscowosc.append(separator).append(Tools.returnEmptyIfNull(odcinek.getWyjazd_miejscowosc()));
            wyjazd_data.append(separator).append(Tools.returnEmptyIfNull(odcinek.getWyjazd_data()));
            wyjazd_godzina.append(separator).append(Tools.returnEmptyIfNull(odcinek.getWyjazd_godzina()));
            przyjazd_miejscowosc.append(separator).append(Tools.returnEmptyIfNull(odcinek.getPrzyjazd_miejscowosc()));
            przyjazd_data.append(separator).append(Tools.returnEmptyIfNull(odcinek.getPrzyjazd_data()));
            przyjazd_godzina.append(separator).append(Tools.returnEmptyIfNull(odcinek.getPrzyjazd_godzina()));
            srodek_transportu.append(separator).append(Tools.returnEmptyIfNull(odcinek.getSrodek_transportu()));
            km.append(separator).append(Tools.formatKwota(odcinek.getKm(), true));
            borderDate.append(separator).append(Tools.returnEmptyIfNull(odcinek.getData_przekroczenia_granicy()));
            borderHour.append(separator).append(Tools.returnEmptyIfNull(odcinek.getGodzina_przekroczenia_granicy()));
            ++rowNr;
            separator = ";";
        }
        contentData.put("tab_lp", lp.toString());
        contentData.put("tab_wyjazd_miejscowosc", wyjazd_miejscowosc.toString());
        contentData.put("tab_wyjazd_data", wyjazd_data.toString());
        contentData.put("tab_wyjazd_godzina", wyjazd_godzina.toString());
        contentData.put("tab_przyjazd_miejscowosc", przyjazd_miejscowosc.toString());
        contentData.put("tab_przyjazd_data", przyjazd_data.toString());
        contentData.put("tab_przyjazd_godzina", przyjazd_godzina.toString());
        contentData.put("tab_srodek_transportu", srodek_transportu.toString());
        contentData.put("tab_km", km.toString());
        contentData.put("tab_przekroczenie_granicy_data", borderDate.toString());
        contentData.put("tab_przekroczenie_granicy_godzina", borderHour.toString());
    }

    private void addAdvancesDataToContent(Map<String, Object> pdfDataContent, Set<BusinessTripAdvance> advances) {
        StringBuilder advanceAmount = new StringBuilder();
        StringBuilder advanceCurrency = new StringBuilder();
        StringBuilder advancePlnAmount = new StringBuilder();
        StringBuilder advanceExchange = new StringBuilder();
        String separator = "";
        for (BusinessTripAdvance advance : advances) {
            advanceAmount.append(separator).append(Tools.formatKwota(advance.getAmount(), true));
            advanceCurrency.append(separator).append(advance.getCurrency());
            advancePlnAmount.append(separator).append(Tools.formatKwota(advance.getPlnAmount(), true));
            advanceExchange.append(separator).append(Tools.formatKurs(advance.getExchange(), true));
            separator = ";";
        }
        pdfDataContent.put("tab_zaliczka_kwota", advanceAmount);
        pdfDataContent.put("tab_zaliczka_symbol_waluty", advanceCurrency);
        pdfDataContent.put("tab_zaliczka_kwota_pln", advancePlnAmount);
        pdfDataContent.put("tab_zaliczka_kurs", advanceExchange);
    }

    private void addActivityVariablesDataToContent(Map<String, Object> pdfDataContent, Set<BusinessTripActivityVariableValue> variables) {
        String prefix = "PWFL.";
        HashSet<String> uniqueVariablesIds = new HashSet<String>();
        for (BusinessTripActivityVariableValue variable : variables) {
            uniqueVariablesIds.add(variable.getVariableId());
        }
        for (String id : uniqueVariablesIds) {
            pdfDataContent.put(prefix + id, this.getStringVariableValues(variables, id));
        }
    }

    private String getStringVariableValues(Set<BusinessTripActivityVariableValue> variables, String id) {
        String separator = "";
        StringBuilder value = new StringBuilder();
        for (BusinessTripActivityVariableValue variable : variables) {
            if (!variable.getVariableId().equals(id)) continue;
            value.append(separator);
            value.append(variable.getFormattedStringValue());
            separator = ";";
        }
        return value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long generateAndAttach(WordTemplateForm config) throws Exception {
        DocumentInfo doc = new DocumentInfo();
        File document = TemporaryFile.create();
        try {
            this.wordTemplateService.generateForProcess(document, config.getTemplate(), config.getProcessId(), config.getMappings(), config.getFormat());
            WfDocument wfDoc = WordTemplateUtil.archiveAndAttachToProcess((File)document, (String)config.getProcessId(), (String)config.getActivityId(), (String)config.getDocumentClass(), (String)config.getTemplate(), (WordTemplateService.OutputFormat)config.getFormat(), (boolean)config.isAttachToProcess(), (boolean)config.isNewVersion());
            doc.setId(Long.valueOf(wfDoc.getFile().getId()));
        }
        finally {
            FileUtils.deleteQuietly((File)document);
        }
        return doc.getId();
    }

    private WordTemplateForm prepareWordTemplateConfig(String processId, String activityId) throws Exception {
        WordTemplateForm config = new WordTemplateForm();
        config.setProcessId(processId);
        config.setActivityId(activityId);
        config.setFormat(WordTemplateService.OutputFormat.PDF);
        config.setAttachToArchive(true);
        config.setAttachToProcess(true);
        config.setNewVersion(false);
        return config;
    }
}

