/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.database.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.suncode.businesstrip.database.model.BusinessTrip;
import com.suncode.businesstrip.util.Tools;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.hibernate.annotations.Index;

@Entity
@Table(name="roz_del_wartosci_zmiennych")
@SequenceGenerator(name="id", sequenceName="roz_del_wartosci_zmiennych_seq")
public class BusinessTripActivityVariableValue {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="id")
    private Long id;
    @ManyToOne
    @JoinColumn(name="nr_delegacji", insertable=false, updatable=false)
    @JsonBackReference
    @Index(name="idxVariablesValues")
    private BusinessTrip db_roz_del;
    @Column
    @Index(name="idxVariablesIds")
    private String variableId;
    @Column
    private String variableType;
    @Column
    private Double floatVal;
    @Column
    private String stringVal;
    @Column
    private Integer integerVal;
    @Column
    private Date dateVal;
    @Column
    private Boolean boolVal;

    @Transient
    public void setVariableType(String type) {
        if (type == null) {
            return;
        }
        this.variableType = type.replace("[]", "").toUpperCase();
    }

    @Transient
    public void setValue(Object value) {
        if (value == null) {
            return;
        }
        switch (this.variableType) {
            case "BOOLEAN": {
                this.boolVal = (Boolean)value;
                return;
            }
            case "INTEGER": {
                this.integerVal = (Integer)value;
                return;
            }
            case "FLOAT": {
                if (value instanceof Integer) {
                    value = new Double(((Integer)value).intValue());
                }
                this.floatVal = (Double)value;
                return;
            }
            case "DATE": {
                this.dateVal = new Date((Long)value);
                return;
            }
            case "DATETIME": {
                this.dateVal = new Date((Long)value);
                return;
            }
            case "STRING": {
                this.stringVal = value.toString();
            }
        }
        this.stringVal = value.toString();
    }

    @Transient
    public Object getValue() {
        switch (this.variableType) {
            case "BOOLEAN": {
                return this.boolVal;
            }
            case "INTEGER": {
                return this.integerVal;
            }
            case "FLOAT": {
                return this.floatVal;
            }
            case "DOUBLE": {
                return this.floatVal;
            }
            case "DATE": {
                return this.dateVal;
            }
            case "DATETIME": {
                return this.dateVal;
            }
            case "STRING": {
                return this.stringVal;
            }
        }
        return this.stringVal;
    }

    @Transient
    public Object getFormattedStringValue() {
        Object val = this.getValue();
        if (val == null) {
            return "";
        }
        switch (this.variableType) {
            case "FLOAT": 
            case "DOUBLE": {
                return Tools.formatKwota(this.floatVal, true);
            }
            case "INTEGER": {
                return Tools.formatIlosc(this.integerVal, true);
            }
            case "DATE": {
                return new SimpleDateFormat("yyyy-MM-dd").format(this.dateVal);
            }
            case "DATETIME": {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm").format(this.dateVal);
            }
        }
        return val.toString();
    }

    public Long getId() {
        return this.id;
    }

    public BusinessTrip getDb_roz_del() {
        return this.db_roz_del;
    }

    public String getVariableId() {
        return this.variableId;
    }

    public String getVariableType() {
        return this.variableType;
    }

    public Double getFloatVal() {
        return this.floatVal;
    }

    public String getStringVal() {
        return this.stringVal;
    }

    public Integer getIntegerVal() {
        return this.integerVal;
    }

    public Date getDateVal() {
        return this.dateVal;
    }

    public Boolean getBoolVal() {
        return this.boolVal;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDb_roz_del(BusinessTrip db_roz_del) {
        this.db_roz_del = db_roz_del;
    }

    public void setVariableId(String variableId) {
        this.variableId = variableId;
    }

    public void setFloatVal(Double floatVal) {
        this.floatVal = floatVal;
    }

    public void setStringVal(String stringVal) {
        this.stringVal = stringVal;
    }

    public void setIntegerVal(Integer integerVal) {
        this.integerVal = integerVal;
    }

    public void setDateVal(Date dateVal) {
        this.dateVal = dateVal;
    }

    public void setBoolVal(Boolean boolVal) {
        this.boolVal = boolVal;
    }
}

