/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Objects;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.suncode.businesstrip.config.ConfigurationService;
import com.suncode.businesstrip.config.data.JsonConf;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.initconfiguration.InitConfigurationDto;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.initconfiguration.InitConfigurationProvider;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.model.FileType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;

public class InitConfigurationProviderImpl
implements InitConfigurationProvider {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    private final List<DefaultConfig> defaultConfigs = Arrays.asList(new DefaultConfig(null, "businessTripDefaultConfig.json"), new DefaultConfig(null, "Config-2022-07-28.json"), new DefaultConfig(null, "Config-2022-11-29.json"), new DefaultConfig("2023-01-01", "Config-2023-01-01.json"), new DefaultConfig("2023-01-17", "Config-2023-01-17.json"));
    @Autowired
    private Plugin plugin;
    @Autowired
    private ConfigurationService configurationService;

    public List<InitConfigurationDto> getInitConfigurations() {
        try {
            JsonConf lastPCMConfig = this.getLastPCMConfig();
            if (lastPCMConfig == null) {
                return Arrays.asList(this.getBaseConfigInitConfiguration(), this.getLastConfigInitConfigurationDto());
            }
            if (this.isLastConfigActual(lastPCMConfig)) {
                return new ArrayList<InitConfigurationDto>();
            }
            List defaultConfigsWithSameEffectiveDate = this.defaultConfigs.stream().filter(conf -> Objects.equal((Object)conf.getEffectiveDate(), (Object)lastPCMConfig.getEffectiveDate())).collect(Collectors.toList());
            for (DefaultConfig defaultConfig : defaultConfigsWithSameEffectiveDate) {
                JsonConf defaultConfigWithSameDate = this.getDefaultConfig(defaultConfig.getConfigFileName());
                if (!this.configToString(lastPCMConfig).equals(this.configToString(defaultConfigWithSameDate))) continue;
                return Arrays.asList(this.getLastConfigInitConfigurationDto());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ArrayList<InitConfigurationDto>();
    }

    private boolean isLastConfigActual(JsonConf lastPCMConfig) {
        DefaultConfig lastDefaultConfig = this.defaultConfigs.get(this.defaultConfigs.size() - 1);
        return lastDefaultConfig.getEffectiveDate().equals((Object)lastPCMConfig.getEffectiveDate());
    }

    private String configToString(JsonConf config) {
        return this.gson.toJson((Object)config);
    }

    private JsonConf getDefaultConfig(String configFileName) throws IOException {
        InputStream inputStream = this.plugin.getResource("config/" + configFileName).getInputStream();
        String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        return (JsonConf)new ObjectMapper().readValue(content, JsonConf.class);
    }

    private InputStream getDefaultConfigInputStream(String configFileName) throws IOException {
        return this.plugin.getResource("config/" + configFileName).getInputStream();
    }

    private JsonConf getLastPCMConfig() throws IOException {
        List<JsonConf> allConfigs = this.configurationService.getAllConfigs();
        if (allConfigs.size() == 0) {
            return null;
        }
        if (allConfigs.size() == 1) {
            return allConfigs.get(0);
        }
        return this.configurationService.getAllConfigs().stream().filter(config -> config.getEffectiveDate() != null).min(Comparator.comparing(JsonConf::getEffectiveDate)).orElseThrow(NoSuchElementException::new);
    }

    private InitConfigurationDto getBaseConfigInitConfiguration() throws IOException {
        InputStream baseDefaultConfigInputStream = this.getDefaultConfigInputStream("Config-2022-11-29.json");
        return new InitConfigurationDto("config", FileType.JSON, baseDefaultConfigInputStream);
    }

    private InitConfigurationDto getLastConfigInitConfigurationDto() throws IOException {
        String lastDefaultConfigFileName = this.defaultConfigs.get(this.defaultConfigs.size() - 1).getConfigFileName();
        InputStream lastDefaultConfigInputStream = this.getDefaultConfigInputStream(lastDefaultConfigFileName);
        return new InitConfigurationDto(lastDefaultConfigFileName, FileType.JSON, lastDefaultConfigInputStream);
    }

    final class DefaultConfig {
        private final LocalDate effectiveDate;
        private final String configFileName;

        public DefaultConfig(String effectiveDate, String configFileName) {
            this.effectiveDate = effectiveDate != null ? LocalDate.parse((String)effectiveDate) : null;
            this.configFileName = configFileName;
        }

        public LocalDate getEffectiveDate() {
            return this.effectiveDate;
        }

        public String getConfigFileName() {
            return this.configFileName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefaultConfig)) {
                return false;
            }
            DefaultConfig other = (DefaultConfig)o;
            LocalDate this$effectiveDate = this.getEffectiveDate();
            LocalDate other$effectiveDate = other.getEffectiveDate();
            if (this$effectiveDate == null ? other$effectiveDate != null : !this$effectiveDate.equals(other$effectiveDate)) {
                return false;
            }
            String this$configFileName = this.getConfigFileName();
            String other$configFileName = other.getConfigFileName();
            return !(this$configFileName == null ? other$configFileName != null : !this$configFileName.equals(other$configFileName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LocalDate $effectiveDate = this.getEffectiveDate();
            result = result * 59 + ($effectiveDate == null ? 43 : $effectiveDate.hashCode());
            String $configFileName = this.getConfigFileName();
            result = result * 59 + ($configFileName == null ? 43 : $configFileName.hashCode());
            return result;
        }

        public String toString() {
            return "InitConfigurationProviderImpl.DefaultConfig(effectiveDate=" + String.valueOf(this.getEffectiveDate()) + ", configFileName=" + this.getConfigFileName() + ")";
        }
    }
}

