/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.config;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.suncode.businesstrip.config.NoActionConfigurationForDelegationException;
import com.suncode.businesstrip.config.NoConfigurationForCountryException;
import com.suncode.businesstrip.config.data.ActionConf;
import com.suncode.businesstrip.config.data.JsonConf;
import com.suncode.businesstrip.settlement.SettlementCountry;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    public static final int kilometrowka_idx_name = 0;
    public static final int kilometrowka_idx_stawka = 1;
    public static final int srodek_transportu_idx_name = 0;
    public static final int kraje_idx_name = 0;
    private static List<JsonConf> allJsonConfigsSortedByEffectiveDate;
    private static final Cache<String, ActionConf> actionConfCache;

    public static JsonConf getActualJsonConfig(SettlementCountry settlementCountry) {
        return Configuration.getJsonConfigForDate(settlementCountry, new LocalDate());
    }

    public static JsonConf getActualJsonConfig(String delegationNr) {
        SettlementCountry settlementCountry = Configuration.getActionConf(delegationNr).getOtherParams().getSettlementCountry();
        return Configuration.getJsonConfigForDate(settlementCountry, new LocalDate());
    }

    public static JsonConf getJsonConfigForDate(String delegationNr, String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return Configuration.getActualJsonConfig(delegationNr);
        }
        return Configuration.getJsonConfigForDate(delegationNr, LocalDate.parse((String)date));
    }

    public static JsonConf getJsonConfigForDate(String delegationNr, LocalDate date) {
        SettlementCountry settlementCountry = Configuration.getActionConf(delegationNr).getOtherParams().getSettlementCountry();
        return Configuration.getJsonConfigForDate(settlementCountry, date);
    }

    public static JsonConf getJsonConfigForDate(SettlementCountry settlementCountry, String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return Configuration.getActualJsonConfig(settlementCountry);
        }
        return Configuration.getJsonConfigForDate(settlementCountry, LocalDate.parse((String)date));
    }

    public static JsonConf getJsonConfigForDate(SettlementCountry settlementCountry, LocalDate date) {
        for (JsonConf config : allJsonConfigsSortedByEffectiveDate) {
            if (config.getEffectiveDate().isAfter((ReadablePartial)date) || !Configuration.configIsForSettlementCountry(settlementCountry, config)) continue;
            return config;
        }
        if (settlementCountry != null && settlementCountry != SettlementCountry.POLAND) {
            throw new NoConfigurationForCountryException(settlementCountry);
        }
        return allJsonConfigsSortedByEffectiveDate.get(0);
    }

    private static boolean configIsForSettlementCountry(SettlementCountry settlementCountry, JsonConf config) {
        return config.getSettlementCountry() == null && settlementCountry == SettlementCountry.POLAND || settlementCountry.equals((Object)config.getSettlementCountry());
    }

    public static void setAllJsonConfigs(List<JsonConf> configs) {
        allJsonConfigsSortedByEffectiveDate = configs.stream().sorted(Comparator.comparing(JsonConf::getEffectiveDate).reversed()).collect(Collectors.toList());
    }

    @Nullable
    public static ActionConf getActionConf(String delegationNr) {
        if (StringUtils.isBlank((CharSequence)delegationNr)) {
            return null;
        }
        ActionConf actionConf = (ActionConf)actionConfCache.getIfPresent((Object)delegationNr);
        if (actionConf != null) {
            return actionConf;
        }
        throw new NoActionConfigurationForDelegationException(delegationNr);
    }

    public static void setActionConf(ActionConf actionConf) {
        String delegationNr = actionConf.getInputParams().getId();
        if (StringUtils.isBlank((CharSequence)delegationNr)) {
            log.warn("Nie mo\u017cna zapisa\u0107 ActionConf - brak id w inputParams");
            return;
        }
        actionConfCache.put((Object)delegationNr, (Object)actionConf);
    }

    static {
        actionConfCache = CacheBuilder.newBuilder().expireAfterWrite(24L, TimeUnit.HOURS).build();
    }
}

