// WALIDATORY
/*
 * sprawdza czy godzina jest mniejsza od godzina_wieksza z uwzględnieniem dat
 */
function DM_sprawdzCzyDatySaZgodneZWnioskiem(store, odjazd_wniosek, powrot_wniosek) {
  if (store.getCount() <= 1) {
    return true;
  }
  // sprawdzenie daty wyjazdu z 1 odcinka
  var wiersz = store.getAt(0);
  var roz_data_wyjazdu = wiersz.get('wyjazd_data');
  var roz_godz_wyjazdu = wiersz.get('wyjazd_godzina').split(':');

  var roz_data_razem_wyjazdu = DM_createDate(roz_data_wyjazdu, roz_godz_wyjazdu[0], roz_godz_wyjazdu[1], 0, 0);
  if (roz_data_razem_wyjazdu == null) {
    return false;
  }

  // sprawdzenie daty przyjazdu z ostatniego odcinka
  wiersz = store.getAt(store.getCount() - 1);
  var roz_data_przyjazdu = wiersz.get('przyjazd_data');
  var roz_godz_przyjazdu = wiersz.get('przyjazd_godzina').split(':');
  var roz_data_razem_przyjazdu = DM_createDate(roz_data_przyjazdu, roz_godz_przyjazdu[0], roz_godz_przyjazdu[1], 0, 0);
  if (roz_data_razem_przyjazdu == null) {
    return false;
  }

  var tab_wnioski_wyjazd = DM_createDate(odjazd_wniosek);
  if (tab_wnioski_wyjazd == null) {
    return false;
  }

  // delegacja możliwa do końca dnia
  var tab_wnioski_przyjazd = DM_createDate(powrot_wniosek, 23, 59, 59, 999);
  if (tab_wnioski_przyjazd == null) {
    return false;
  }

  if (
    tab_wnioski_wyjazd.getTime() > roz_data_razem_wyjazdu.getTime() ||
    tab_wnioski_przyjazd.getTime() < roz_data_razem_przyjazdu.getTime()
  ) {
    return false;
  }
  return true;
}

function DM_validator_godzina_mniejsza(godzina, data, godzina_wieksza, data_wieksza, txt) {
  txt = txt || '';
  if (typeof data === 'string') {
    data = DM_createDate(data);
    if (data == null) {
      return false;
    }
  }
  if (typeof data_wieksza === 'string') {
    data_wieksza = DM_createDate(data_wieksza);
    if (data_wieksza == null) {
      return false;
    }
  }
  // [godzina, minuta]
  godzina = godzina.split(':');
  godzina_wieksza = godzina_wieksza.split(':');
  // ustawienie dat z godzinami
  data.setHours(godzina[0], godzina[1], 0, 0);
  data_wieksza.setHours(godzina_wieksza[0], godzina_wieksza[1], 0, 0);

  if (data.getTime() > data_wieksza.getTime()) {
    return txt;
  }
  return true;
}

function DM_validator_nowa_data_pozniejsza_niz_wczesniejszy_odcinek(store, new_row_id, nowa_godzina, nowa_data, typ_form) {
  var nowa_godzina_split = nowa_godzina.split(':');
  var nowa_data_wyjazdu = DM_createDate(nowa_data, nowa_godzina_split[0], nowa_godzina_split[1], 0, 0);
  if (nowa_data_wyjazdu == null) {
    return false;
  }

  // maly hack by nie zmieniac calej funkcji
  // wybiera obecny odcinek do porownania - uzywane przy dodawaniu wiersza pod
  // zaznaczonych wierszem w tabeli
  if (typ_form === 'add_select') {
    new_row_id = new_row_id + 1;
  }

  if (new_row_id > 0) {
    var prev_data = store.getAt(new_row_id - 1).data.przyjazd_data;
    var prev_godz = store.getAt(new_row_id - 1).data.przyjazd_godzina.split(':');
    var prev_data_przyjazdu = DM_createDate(prev_data, prev_godz[0], prev_godz[1], 0, 0);
    if (prev_data_przyjazdu == null) {
      return false;
    }

    if (prev_data_przyjazdu.getTime() > nowa_data_wyjazdu.getTime()) {
      return DM.translator.m('route.date.validationMsg1');
    }
  }
  return true;
}

function DM_validator_nowa_data_wczesniejsza_niz_pozniejszy_odcinek(store, new_row_id, nowa_godzina, nowa_data) {
  var nowa_godzina_split = nowa_godzina.split(':');
  var nowa_data_wyjazdu = DM_createDate(nowa_data, nowa_godzina_split[0], nowa_godzina_split[1], 0, 0);
  if (nowa_data_wyjazdu == null) {
    return false;
  }

  if (new_row_id >= 0 && new_row_id < store.getCount() - 1) {
    // w przypadku modyfikacji data nie moze byc pozniejsza niz w
    // nastepnym
    // wierszu
    var next_data = store.getAt(new_row_id + 1).data.wyjazd_data;
    var next_godz = store.getAt(new_row_id + 1).data.wyjazd_godzina.split(':');
    var next_data_przyjazdu = DM_createDate(next_data, next_godz[0], next_godz[1], 0, 0);
    if (next_data_przyjazdu == null) {
      return false;
    }

    if (next_data_przyjazdu.getTime() < nowa_data_wyjazdu.getTime()) {
      return DM.translator.m('route.date.validationMsg2');
    }
  }
  return true;
}

function DM_validator_wyjazd_kraj_taki_sam_jak_wczesniej(store, new_row_id, nazwa_kraju_wyjazdu, typ_form) {
  // gdy modyfikacja nie sprawdza
  if (typ_form === 'mod') {
    return true;
  }
  // maly hack by nie zmieniac calej funkcji
  // wybiera obecny odcinek do porownania - uzywane przy dodawaniu wiersza pod
  // zaznaczonych wierszem w tabeli
  if (typ_form === 'add_select') {
    new_row_id = new_row_id + 1;
  }
  if (new_row_id === 0) {
    if (nazwa_kraju_wyjazdu.toLowerCase().indexOf('polska') === -1) {
      return DM.translator.m('route.departureCountry.validationMsg');
    }
  }
  if (new_row_id > 0) {
    var przyjazd_kraj = store.getAt(new_row_id - 1).data.przyjazd_kraj;
    if (przyjazd_kraj !== nazwa_kraju_wyjazdu) {
      return DM.translator.m('route.arrivalCountry.validationMsg1');
    }
  }
  return true;
}

function DMValidatorSelectedCountryExistsInDestinationCountries(selectedCountry) {
  if(!selectedCountry){
    return true;
  }

  let configCountryName = DM.conf.jsonConf.zagranica.kraje.find( country => country[1] == selectedCountry)[0];
  return DM.store.ilosciowe.find('kraj', configCountryName, 0, false, false) >= 0;
}

function DM_validator_przyjazd_kraj_taki_sam_jak_pozniej(store, new_row_id, nazwa_kraju_przyjazdu, typ_form) {
  // gdy modyfikacja nie sprawdza
  if (typ_form === 'mod') {
    return true;
  }
  // maly hack by nie zmieniac calej funkcji
  // wybiera obecny odcinek do porownania - uzywane przy dodawaniu wiersza pod
  // zaznaczonych wierszem w tabeli
  if (new_row_id >= 0 && new_row_id < store.getCount() - 1) {
    var wyjazdu_kraj = store.getAt(new_row_id + 1).data.wyjazd_kraj;
    if (wyjazdu_kraj !== nazwa_kraju_przyjazdu) {
      return DM.translator.m('route.arrivalCountry.validationMsg2');
    }
  }
  return true;
}

// WALIDATORY ADDMOD TRASY
function DM_addmod_trasa_valid_wyjazd_data(value) {
  if (value === '') {
    return DM.translator.m('emptyField.validationMsg');
  }

  var godzina_wyjazdu = Ext.getCmp('DM.addmod.form.wyjazd_godzina').getValue();
  var data_przyjazdu = Ext.getCmp('DM.addmod.form.przyjazd_data').getValue();
  var godzina_przyjazdu = Ext.getCmp('DM.addmod.form.przyjazd_godzina').getValue();

  var data_mniejsza_ret = DM_validator_godzina_mniejsza(
    godzina_wyjazdu,
    value,
    godzina_przyjazdu,
    data_przyjazdu,
    DM.translator.m('route.date.validationMsg3')
  );

  if (typeof data_mniejsza_ret !== 'boolean') {
    return data_mniejsza_ret;
  }

  // data wyjazdu pozniejsza niz wczesniejszy odcinek
  if (DM.typform_addmod === 'add') {
    var nowa_data_ret = DM_validator_nowa_data_pozniejsza_niz_wczesniejszy_odcinek(
      DM.store.trasa,
      DM.store.trasa.getCount(),
      godzina_wyjazdu,
      value
    );
    if (typeof nowa_data_ret !== 'boolean') {
      return nowa_data_ret;
    }
  } else {
    var sm = DM.grid.trasa.getSelectionModel();

    var nowa_data_ret = DM_validator_nowa_data_pozniejsza_niz_wczesniejszy_odcinek(
      DM.store.trasa,
      sm.lastActive,
      godzina_wyjazdu,
      value,
      DM.typform_addmod
    );

    if (typeof nowa_data_ret !== 'boolean') {
      return nowa_data_ret;
    }
  }

  // wszystko ok
  return true;
}

function DM_addmod_trasa_valid_wyjazd_godzina(value) {
  if (value === '') {
    return DM.translator.m('emptyField.validationMsg');
  }

  var data_wyjazdu = Ext.getCmp('DM.addmod.form.wyjazd_data').getValue();
  var data_przyjazdu = Ext.getCmp('DM.addmod.form.przyjazd_data').getValue();
  var godzina_przyjazdu = Ext.getCmp('DM.addmod.form.przyjazd_godzina').getValue();

  var godzina_mniejsza_ret = DM_validator_godzina_mniejsza(
    value,
    data_wyjazdu,
    godzina_przyjazdu,
    data_przyjazdu,
    DM.translator.m('route.date.validationMsg3')
  );

  if (typeof godzina_mniejsza_ret !== 'boolean') {
    return godzina_mniejsza_ret;
  }

  // data wyjazdu pozniejsza niz wczesniejszy odcinek
  if (DM.typform_addmod === 'add') {
    var nowa_godzina_ret = DM_validator_nowa_data_pozniejsza_niz_wczesniejszy_odcinek(
      DM.store.trasa,
      DM.store.trasa.getCount(),
      value,
      data_wyjazdu
    );

    if (typeof nowa_godzina_ret !== 'boolean') {
      return nowa_godzina_ret;
    }
  } else {
    var sm = DM.grid.trasa.getSelectionModel();

    var nowa_godzina_ret = DM_validator_nowa_data_pozniejsza_niz_wczesniejszy_odcinek(
      DM.store.trasa,
      sm.lastActive,
      value,
      data_wyjazdu,
      DM.typform_addmod
    );

    if (typeof nowa_godzina_ret !== 'boolean') {
      return nowa_godzina_ret;
    }
  }

  return true;
}

function DM_addmod_trasa_valid_przyjazd_data(value) {
  if (value === '') {
    return DM.translator.m('emptyField.validationMsg');
  }

  var data_wyjazdu = Ext.getCmp('DM.addmod.form.wyjazd_data').getValue();
  var godzina_wyjazdu = Ext.getCmp('DM.addmod.form.wyjazd_godzina').getValue();
  var godzina_przyjazdu = Ext.getCmp('DM.addmod.form.przyjazd_godzina').getValue();

  var data_mniejsza_ret = DM_validator_godzina_mniejsza(
    godzina_wyjazdu,
    data_wyjazdu,
    godzina_przyjazdu,
    value,
    DM.translator.m('route.date.validationMsg4')
  );

  if (typeof data_mniejsza_ret !== 'boolean') {
    return data_mniejsza_ret;
  }

  // gdy dodawanie data przyjazdu ma byc tylko pozniejsza
  // od
  // wyjazdu
  if (DM.typform_addmod !== 'add') {
    var sm = DM.grid.trasa.getSelectionModel();

    var nowa_data_mniejsza = DM_validator_nowa_data_wczesniejsza_niz_pozniejszy_odcinek(
      DM.store.trasa,
      sm.lastActive,
      godzina_przyjazdu,
      value
    );

    if (typeof nowa_data_mniejsza !== 'boolean') {
      return nowa_data_mniejsza;
    }
  }
  return true;
}

function DM_addmod_trasa_valid_przyjazd_godzina(value) {
  if (value === '') {
    return DM.translator.m('emptyField.validationMsg');
  }

  var data_wyjazdu = Ext.getCmp('DM.addmod.form.wyjazd_data').getValue();
  var godzina_wyjazdu = Ext.getCmp('DM.addmod.form.wyjazd_godzina').getValue();
  var data_przyjazdu = Ext.getCmp('DM.addmod.form.przyjazd_data').getValue();

  var godzina_mniejsza_ret = DM_validator_godzina_mniejsza(
    godzina_wyjazdu,
    data_wyjazdu,
    value,
    data_przyjazdu,
    DM.translator.m('route.date.validationMsg4')
  );

  if (typeof godzina_mniejsza_ret !== 'boolean') {
    return godzina_mniejsza_ret;
  }

  // gdy dodawanie data przyjazdu ma byc tylko pozniejsza
  // od
  // wyjazdu
  if (DM.typform_addmod !== 'add') {
    var sm = DM.grid.trasa.getSelectionModel();

    var nowa_godzina_ret = DM_validator_nowa_data_wczesniejsza_niz_pozniejszy_odcinek(DM.store.trasa, sm.lastActive, value, data_przyjazdu);

    if (typeof nowa_godzina_ret !== 'boolean') {
      return nowa_godzina_ret;
    }
  }
  return true;
}

function DM_addmod_trasa_valid_km(value) {
  var srodek_transportu = DM_get_srodek_transportu();
  if (srodek_transportu === 'Pojazd prywatny') {
    if (typeof value === 'undefined' || value === null || value === '') {
      return DM.translator.m('emptyField.validationMsg');
    } else if (parseFloat(value.replace(',', '.')) <= 0) {
      return DM.translator.m('emptyField.validationMsg');
    }
  }
  return true;
}

function DM_addmod_trasa_valid_czy_wymagana_granica(wyjazd_kraj, przyjazd_kraj) {
  if (typeof wyjazd_kraj === 'undefined' || wyjazd_kraj === null) {
    if (wyjazd_kraj === '') {
      return false;
    }
    wyjazd_kraj = DM_get_wyjazd_kraj();
  }

  if (typeof przyjazd_kraj === 'undefined' || przyjazd_kraj === null) {
    if (przyjazd_kraj === '') {
      return false;
    }
    przyjazd_kraj = DM_get_przyjazd_kraj();
  }

  var kraj_wyjazdu_docelowy = false;
  var kraj_przyjazd_docelowy = false;
  for (var i = 0; i < DM.store.ilosciowe.getCount(); ++i) {
    if (DM.store.ilosciowe.getAt(i).get('kraj').indexOf(wyjazd_kraj) !== -1) {
      kraj_wyjazdu_docelowy = true;
    }
    if (DM.store.ilosciowe.getAt(i).get('kraj').indexOf(przyjazd_kraj) !== -1) {
      kraj_przyjazd_docelowy = true;
    }
  }

  if (wyjazd_kraj === przyjazd_kraj) {
    return false;
  }

  // jezeli samolot, statek to nie wymagane przekroczenie granicy
  // granica przepisywana jest z daty wyjazdu
  var srodek_transportu = DM_get_srodek_transportu();
  if (DM_addmod_trasa_czy_samolot_statek(srodek_transportu)) {
    return false;
  }

  // ten sam kraj - nie trzeba podac granicy
  if (wyjazd_kraj === przyjazd_kraj && kraj_wyjazdu_docelowy && kraj_przyjazd_docelowy) {
    return false;
  }

  if (wyjazd_kraj.toLowerCase().indexOf('polska') >= 0) {
    return true;
  }

  if (przyjazd_kraj.toLowerCase().indexOf('polska') >= 0) {
    return true;
  }

  if (!kraj_wyjazdu_docelowy && kraj_przyjazd_docelowy) {
    return true;
  }

  if (kraj_wyjazdu_docelowy && kraj_przyjazd_docelowy) {
    return true;
  }

  return false;
}

function DM_addmod_trasa_valid_data_przekroczenia_granicy(value) {
  if (value === null || value === '') {
    return DM.translator.m('emptyField.validationMsg');
  } else {
    var data_wyjazdu = Ext.getCmp('DM.addmod.form.wyjazd_data').getValue();
    var godzina_wyjazdu = Ext.getCmp('DM.addmod.form.wyjazd_godzina').getValue();
    var data_przyjazdu = Ext.getCmp('DM.addmod.form.przyjazd_data').getValue();
    var godzina_przyjazdu = Ext.getCmp('DM.addmod.form.przyjazd_godzina').getValue();
    var godzina_przekroczenia_granicy = Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy').getValue();

    var data_wieksza_od_wyjazdu = DM_validator_godzina_mniejsza(
      godzina_wyjazdu,
      data_wyjazdu,
      godzina_przekroczenia_granicy,
      value,
      DM.translator.m('route.crossingBorderDate.validationMsg1')
    );
    if (typeof data_wieksza_od_wyjazdu !== 'boolean') {
      return data_wieksza_od_wyjazdu;
    }

    var data_mniejsza_od_przyjazdu = DM_validator_godzina_mniejsza(
      godzina_przekroczenia_granicy,
      value,
      godzina_przyjazdu,
      data_przyjazdu,
      DM.translator.m('route.crossingBorderDate.validationMsg2')
    );
    if (typeof data_mniejsza_od_przyjazdu !== 'boolean') {
      return data_mniejsza_od_przyjazdu;
    }
  }
  return true;
}

function DM_addmod_trasa_valid_godzina_przekroczenia_granicy(value) {
  if (value === null || value === '') {
    return DM.translator.m('emptyField.validationMsg');
  } else {
    var data_wyjazdu = Ext.getCmp('DM.addmod.form.wyjazd_data').getValue();
    var godzina_wyjazdu = Ext.getCmp('DM.addmod.form.wyjazd_godzina').getValue();
    var data_przyjazdu = Ext.getCmp('DM.addmod.form.przyjazd_data').getValue();
    var godzina_przyjazdu = Ext.getCmp('DM.addmod.form.przyjazd_godzina').getValue();
    var data_przekroczenia_granicy = Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy').getValue();

    var data_wieksza_od_wyjazdu = DM_validator_godzina_mniejsza(
      godzina_wyjazdu,
      data_wyjazdu,
      value,
      data_przekroczenia_granicy,
      DM.translator.m('route.crossingBorderDate.validationMsg1')
    );
    if (typeof data_wieksza_od_wyjazdu !== 'boolean') {
      return data_wieksza_od_wyjazdu;
    }

    var data_mniejsza_od_przyjazdu = DM_validator_godzina_mniejsza(
      value,
      data_przekroczenia_granicy,
      godzina_przyjazdu,
      data_przyjazdu,
      DM.translator.m('route.crossingBorderDate.validationMsg2')
    );
    if (typeof data_mniejsza_od_przyjazdu !== 'boolean') {
      return data_mniejsza_od_przyjazdu;
    }
  }
  return true;
}

// rozliczenie ilosciowe
function DM_add_ilosciowe_valid_kraj(value) {
  value = this.hiddenField.value;
  if (value === '') {
    return DM.translator.m('emptyField.validationMsg');
  }

  var store = Ext.getCmp('DM.form.add_ilosciowe.kraj').getStore();
  if (store.find('docelowy_kraj_text', value, 0, false, false) < 0) {
    return DM.translator.m('quantities.targetCountry.validationMsg1');
  }

  if (DM.store.ilosciowe.find('kraj', value, 0, false, false) >= 0) {
    return DM.translator.m('quantities.targetCountry.validationMsg2');
  }
  return true;
}

// sprawdzenie czy kraje w rozpisanych odcinkach sie zgadzaja
function DM_valid_cala_trasa_kraje() {
  var ostatni_przyjazd_kraj = null;
  for (var i = 0; i < DM.store.trasa.getCount(); ++i) {
    var wyjazd_kraj = DM.store.trasa.getAt(i).get('wyjazd_kraj');
    var przyjazd_kraj = DM.store.trasa.getAt(i).get('przyjazd_kraj');

    if (ostatni_przyjazd_kraj !== null) {
      if (ostatni_przyjazd_kraj !== wyjazd_kraj) {
        return i;
      }
    }
    ostatni_przyjazd_kraj = przyjazd_kraj;
  }
  return true;
}

function DM_valid_cala_trasa_daty() {
  var js_ostatnia_data = null;
  for (var i = 0; i < DM.store.trasa.getCount(); ++i) {
    var wyjazd_data = DM.store.trasa.getAt(i).get('wyjazd_data');
    var wyjazd_godzina = DM.store.trasa.getAt(i).get('wyjazd_godzina').split(':');
    var przyjazd_data = DM.store.trasa.getAt(i).get('przyjazd_data');
    var przyjazd_godzina = DM.store.trasa.getAt(i).get('przyjazd_godzina').split(':');

    var js_data_wyjazdu = DM_createDate(wyjazd_data, wyjazd_godzina[0], wyjazd_godzina[1], 0, 0);
    if (js_data_wyjazdu == null) {
      continue;
    }

    var js_data_przyjazdu = DM_createDate(przyjazd_data, przyjazd_godzina[0], przyjazd_godzina[1], 0, 0);
    if (js_data_przyjazdu == null) {
      return false;
    }

    if (js_data_wyjazdu.getTime() > js_data_przyjazdu.getTime()) {
      return i;
    }

    if (js_ostatnia_data !== null) {
      if (js_ostatnia_data.getTime() > js_data_wyjazdu.getTime()) {
        return i;
      }
    }
    js_ostatnia_data = js_data_przyjazdu;
  }
  return true;
}

function DM_valid_form_ewidencja_pojazdu_nie_puste() {
  var vals = DM.form.ewidencja.getForm().getValues();
  if (typeof vals === 'undefined' || vals == null) {
    return false;
  }
  if (
    vals.koszty_paliwa === '' ||
    vals.sr_lokomocji === '' ||
    vals.marka_pojazdu === '' ||
    vals.nr_rejestracyjny === '' ||
    vals.adres_uzytkownika_pojazdu === '' ||
    vals.pojemnosc_silnika === ''
  ) {
    return false;
  }
  return true;
}

function DM_valid_form_ewidencja_pojazdu_pojemnosc() {
  var vals = DM.form.ewidencja.getForm().getValues();
  if (typeof vals === 'undefined' || vals == null) {
    return false;
  }
  if (
    vals.pojemnosc_silnika == 0 ||
    (vals.sr_lokomocji === 'Samochod do 900 cm' && vals.pojemnosc_silnika > 900) ||
    (vals.sr_lokomocji === 'Samochod pow 900 cm' && vals.pojemnosc_silnika <= 900)
  ) {
    return false;
  }
  return true;
}

function DM_valid_spendings_types() {
  if(DM.store.wydatki.getCount() == 0 || DM.conf.actionConf.spendingTypes.length == 0){
    return true;
  }
  let confContainsType = false;
  Ext.each(DM.store.wydatki.getRange(), function (spending) {
    Ext.each(DM.conf.actionConf.spendingTypes, function (confSpendingType) {
      if (confSpendingType == spending.data.rodzaj_wydatku) {
        confContainsType = true;
        return;
      }
    });
  });
  return confContainsType;
}

function DM_valid_spendings_payment_methods() {
  if(DM.store.wydatki.getCount() == 0 || DM.conf.actionConf.paymentMethods.length == 0){
    return true;
  }
  let confContainsPaymentMethod = false;
  Ext.each(DM.store.wydatki.getRange(), function (spending) {
    Ext.each(DM.conf.actionConf.paymentMethods, function (confSpendingPaymentMethod) {
      if (confSpendingPaymentMethod == spending.data.paymentMethod) {
        confContainsPaymentMethod = true;
        return;
      }
    });
  });
  return confContainsPaymentMethod;
}

function DM_valid_spendings_document_types() {
  if(DM.store.wydatki.getCount() == 0 || DM.conf.actionConf.documentTypes.length == 0){
    return true;
  }
  let confContainsDocumentType = false;
  Ext.each(DM.store.wydatki.getRange(), function (spending) {
    Ext.each(DM.conf.actionConf.documentTypes, function (confSpendingDocumentType) {
      if (confSpendingDocumentType == spending.data.documentType) {
        confContainsDocumentType = true;
        return;
      }
    });
  });
  return confContainsDocumentType;
}

function DM_valid_cala_trasy_daty_przekroczenia_granic() {
  const isEmpty = (textField) => textField === undefined || textField === null || textField.trim() === '';

  for (let i = 0; i < DM.store.trasa.getCount(); i++) {
    const odcinek = DM.store.trasa.getAt(i);

    if (odcinek.get('wyjazd_kraj') === odcinek.get('przyjazd_kraj')) {
      continue;
    }

    const data_przekroczenia_granicy = odcinek.get('data_przekroczenia_granicy');
    const godzina_przekroczenia_granicy = odcinek.get('godzina_przekroczenia_granicy');
    if (isEmpty(data_przekroczenia_granicy) || isEmpty(godzina_przekroczenia_granicy)) {
      return i;
    }
  }

  return true;
}