var business_trip_routs = new (function Business_trip_routs() {
  this.business_trip_routs_add = function () {
    var panelTitle = DM.translator.m('settlement.route.panel.title');

    DM.vp.items.get(0).items.get(1).add({
      xtype: 'panel',
      hidden: true,
      layout: 'fit',
      title: panelTitle,
      header: true,
      items: DM.grid.trasa,
    });

    DM.vp.items.get(0).items.get(1).doLayout();
  };
})();

(function () {
  var isForeignTrip = DM.data.typ_delegacji == 'zagranica' ? true : false;

  DM.fields.trasa = [
    'lp',
    'wyjazd_kraj',
    'wyjazd_miejscowosc',
    'wyjazd_data',
    'wyjazd_godzina',
    'przyjazd_kraj',
    'przyjazd_miejscowosc',
    'przyjazd_data',
    'przyjazd_godzina',
    'srodek_transportu',
    'km',
    'data_przekroczenia_granicy',
    'godzina_przekroczenia_granicy',
  ];

  DM.columns.trasa = [
    {
      header: DM.translator.m('counter'),
      dataIndex: DM.fields.trasa[0],
      width: 15,
      hidden: DM_isFieldToHide(DM.fields.trasa[0]),
    },
    {
      header: DM.translator.m('route.departureCountry.column'),
      dataIndex: DM.fields.trasa[1],
      hidden: !isForeignTrip,
      renderer: function (value, metaData, record, rowIndex, colIndex, store) {
        return DM.conf.jsonConf.zagranica.krajeTranslations[value];
      },
    },
    {
      header: DM.translator.m('route.departureCity.column'),
      dataIndex: DM.fields.trasa[2],
      hidden: DM_isFieldToHide(DM.fields.trasa[2]),
    },
    {
      header: DM.translator.m('route.departureDate.column'),
      dataIndex: DM.fields.trasa[3],
      width: 60,
      xtype: 'datecolumn',
      format: 'Y-m-d',
    },
    {
      header: DM.translator.m('route.departureHour.column'),
      dataIndex: DM.fields.trasa[4],
      width: 40,
    },
    {
      header: DM.translator.m('route.arrivalCountry.column'),
      dataIndex: DM.fields.trasa[5],
      hidden: !isForeignTrip,
      renderer: function (value, metaData, record, rowIndex, colIndex, store) {
        return DM.conf.jsonConf.zagranica.krajeTranslations[value];
      },
    },
    {
      header: DM.translator.m('route.arrivalCity.column'),
      dataIndex: DM.fields.trasa[6],
      hidden: DM_isFieldToHide(DM.fields.trasa[6]),
    },
    {
      header: DM.translator.m('route.arrivalDate.column'),
      dataIndex: DM.fields.trasa[7],
      width: 60,
      xtype: 'datecolumn',
      format: 'Y-m-d',
    },
    {
      header: DM.translator.m('route.arrivalHour.column'),
      dataIndex: DM.fields.trasa[8],
      width: 40,
    },
    {
      header: DM.translator.m('route.transportType.column'),
      dataIndex: DM.fields.trasa[9],
      hidden: DM_isFieldToHide(DM.fields.trasa[9]),
      renderer: function (value, metaData, record, rowIndex, colIndex, store) {
        return DM.conf.jsonConf.srodek_transportu_translations[value];
      },
    },
    {
      header: DM.translator.m('kilometers'),
      dataIndex: DM.fields.trasa[10],
      width: 25,
      xtype: 'numbercolumn',
      format: DM.conf.getNumberViewFormat(DM.conf.decimalseparator),
      hidden: DM_isFieldToHide(DM.fields.trasa[10]),
    },
    {
      header: DM.translator.m('route.crossingBorderDate.column'),
      dataIndex: DM.fields.trasa[11],
      xtype: 'datecolumn',
      format: 'Y-m-d',
      hidden: !isForeignTrip,
    },
    {
      header: DM.translator.m('route.crossingBorderHour.column'),
      dataIndex: DM.fields.trasa[12],
      hidden: !isForeignTrip,
    },
  ];

  DM.items.addmod = [
    {
      xtype: 'label',
      text: DM.translator.m('route.departure'),
      style: {
        marginBottom: '5px',
        fontWeight: 'bold',
        display: 'block',
      },
    },
    {
      xtype: 'combo',
      fieldLabel: DM.translator.m('route.departureCountry.column'),
      id: 'DM.addmod.form.wyjazd_kraj',
      name: DM.fields.trasa[1],
      hiddenName: DM.fields.trasa[1],
      typeAhead: true,
      typeAheadDelay: 200,
      triggerAction: 'all',
      forceSelection: true,
      querymode: 'local',
      editable: true,
      lazyRender: true,
      mode: 'local',
      store: new Ext.data.ArrayStore({
        fields: ['wyjazd_kraj_text', 'display'],
        data: DM.conf.jsonConf.zagranica.kraje,
        sortInfo: {
          field: 'display',
          direction: 'ASC',
        },
      }),
      valueField: 'wyjazd_kraj_text',
      displayField: 'display',
      hidden: !isForeignTrip,
      hideLabel: !isForeignTrip,
      allowBlank: !isForeignTrip,
      validator: function (value) {
        if (!isForeignTrip) {
          return true;
        }
        if(!DMValidatorSelectedCountryExistsInDestinationCountries(value)){
          return DM.translator.m('route.destinationCountryNotExists');
        }
        if (DM.typform_addmod === 'add') {
          var kraj_ret = DM_validator_wyjazd_kraj_taki_sam_jak_wczesniej(DM.store.trasa, DM.store.trasa.getCount(), this.hiddenField.value);
          if (typeof kraj_ret !== 'boolean') {
            return kraj_ret;
          }
        } else {
          var sm = DM.grid.trasa.getSelectionModel();
          var kraj_ret = DM_validator_wyjazd_kraj_taki_sam_jak_wczesniej(
            DM.store.trasa,
            sm.lastActive,
            this.hiddenField.value,
            DM.typform_addmod
          );

          if (typeof kraj_ret !== 'boolean') {
            return kraj_ret;
          }
        }
        // wszystko ok
        return true;
      },
      listeners: {
        select: function (combo, record, index) {
          if (index === null || index === '') {
            Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy').disable();
            Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy').disable();
          }

          Ext.getCmp('DM.addmod.form.wyjazd_kraj').getStore().clearFilter();
          var kraj = Ext.getCmp('DM.addmod.form.wyjazd_kraj').getStore().getAt(index).get('wyjazd_kraj_text');

          DM_addmod_trasa_wlacz_wylacz_granice(kraj);

          var srodek_transportu = DM_get_srodek_transportu();
          DM_addmod_trasa_listener_srodek_transportu(srodek_transportu);

          Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy').validate();
          Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy').validate();
        },
        change: function (t, newValue, oldValue) {
          if (newValue === null || newValue === '') {
            Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy').disable();
            Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy').disable();
          }

          var kraj;
          if (!DM_isNumber(newValue)) {
            kraj = newValue;
          } else {
            Ext.getCmp('DM.addmod.form.wyjazd_kraj').getStore().clearFilter();
            kraj = Ext.getCmp('DM.addmod.form.wyjazd_kraj').getStore().getAt(newValue).get('wyjazd_kraj_text');
          }

          DM_addmod_trasa_wlacz_wylacz_granice(kraj);

          var srodek_transportu = DM_get_srodek_transportu();
          DM_addmod_trasa_listener_srodek_transportu(srodek_transportu);

          Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy').validate();
          Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy').validate();
        },
      },
    },
    {
      xtype: 'textfield',
      fieldLabel: DM.translator.m('route.departureCity.column'),
      name: DM.fields.trasa[2],
      allowBlank: DM_isFieldToHide(DM.fields.trasa[2]),
      validator: DM_semicolonValidation,
      hidden: DM_isFieldToHide(DM.fields.trasa[2]),
      hideLabel: DM_isFieldToHide(DM.fields.trasa[2]),
    },
    {
      xtype: 'datefield',
      format: 'Y-m-d',
      id: 'DM.addmod.form.wyjazd_data',
      fieldLabel: DM.translator.m('route.departureDate.column'),
      name: DM.fields.trasa[3],
      validator: DM_addmod_trasa_valid_wyjazd_data,
      listeners: {
        select: function (combo, record, index) {
          var srodek_transportu = DM_get_srodek_transportu();
          DM_addmod_trasa_listener_srodek_transportu(srodek_transportu);
        },
        change: function (t, newValue, oldValue) {
          var srodek_transportu = DM_get_srodek_transportu();
          DM_addmod_trasa_listener_srodek_transportu(srodek_transportu);
          Ext.getCmp('DM.addmod.form.wyjazd_data').validate();
          Ext.getCmp('DM.addmod.form.wyjazd_godzina').validate();
          Ext.getCmp('DM.addmod.form.przyjazd_data').validate();
          Ext.getCmp('DM.addmod.form.przyjazd_godzina').validate();
          Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy').validate();
          Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy').validate();
        },
      },
    },
    {
      xtype: 'timefield',
      id: 'DM.addmod.form.wyjazd_godzina',
      fieldLabel: DM.translator.m('route.departureHour.column'),
      name: DM.fields.trasa[4],
      format: 'H:i',
      increment: 15,
      regex: /^\d{1,2}:[0-5]\d$/,
      validator: DM_addmod_trasa_valid_wyjazd_godzina,
      listeners: {
        select: function (combo, record, index) {
          var srodek_transportu = DM_get_srodek_transportu();
          DM_addmod_trasa_listener_srodek_transportu(srodek_transportu);
        },
        change: function (t, newValue, oldValue) {
          var srodek_transportu = DM_get_srodek_transportu();
          DM_addmod_trasa_listener_srodek_transportu(srodek_transportu);
          Ext.getCmp('DM.addmod.form.wyjazd_data').validate();
          Ext.getCmp('DM.addmod.form.wyjazd_godzina').validate();
          Ext.getCmp('DM.addmod.form.przyjazd_data').validate();
          Ext.getCmp('DM.addmod.form.przyjazd_godzina').validate();
          Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy').validate();
          Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy').validate();
        },
      },
    },
    {
      xtype: 'label',
      text: DM.translator.m('route.arrival'),
      style: {
        marginBottom: '5px',
        marginTop: '15px',
        fontWeight: 'bold',
        display: 'block',
      },
    },
    {
      xtype: 'combo',
      fieldLabel: DM.translator.m('route.arrivalCountry.column'),
      id: 'DM.addmod.form.przyjazd_kraj',
      name: DM.fields.trasa[5],
      hiddenName: DM.fields.trasa[5],
      typeAhead: true,
      typeAheadDelay: 200,
      triggerAction: 'all',
      querymode: 'local',
      forceSelection: true,
      editable: true,
      lazyRender: true,
      mode: 'local',
      store: new Ext.data.ArrayStore({
        fields: ['przyjazd_kraj_text', 'display'],
        data: DM.conf.jsonConf.zagranica.kraje,
        sortInfo: {
          field: 'display',
          direction: 'ASC',
        },
      }),
      valueField: 'przyjazd_kraj_text',
      displayField: 'display',
      hidden: !isForeignTrip,
      hideLabel: !isForeignTrip,
      allowBlank: !isForeignTrip,
      validator: function (value) {
        if(!DMValidatorSelectedCountryExistsInDestinationCountries(value)){
          return DM.translator.m('route.destinationCountryNotExists');
        }
        if (DM.typform_addmod !== 'add' && isForeignTrip) {
          var sm = DM.grid.trasa.getSelectionModel();
          var kraj_ret = DM_validator_przyjazd_kraj_taki_sam_jak_pozniej(
            DM.store.trasa,
            sm.lastActive,
            this.hiddenField.value,
            DM.typform_addmod
          );

          if (typeof kraj_ret !== 'boolean') {
            return kraj_ret;
          }
        }
        // wszystko ok
        return true;
      },
      listeners: {
        select: function (combo, record, index) {
          if (index === null || index === '') {
            Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy').disable();
            Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy').disable();
          }

          Ext.getCmp('DM.addmod.form.przyjazd_kraj').getStore().clearFilter();
          var kraj = Ext.getCmp('DM.addmod.form.przyjazd_kraj').getStore().getAt(index).get('przyjazd_kraj_text');

          DM_addmod_trasa_wlacz_wylacz_granice(null, kraj);

          var srodek_transportu = DM_get_srodek_transportu();
          DM_addmod_trasa_listener_srodek_transportu(srodek_transportu);

          Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy').validate();
          Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy').validate();
        },
        change: function (t, newValue, oldValue) {
          if (newValue === null || newValue === '') {
            Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy').disable();
            Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy').disable();
          }

          var kraj;
          if (!DM_isNumber(newValue)) {
            kraj = newValue;
          } else {
            Ext.getCmp('DM.addmod.form.przyjazd_kraj').getStore().clearFilter();
            kraj = Ext.getCmp('DM.addmod.form.przyjazd_kraj').getStore().getAt(newValue).get('przyjazd_kraj_text');
          }

          DM_addmod_trasa_wlacz_wylacz_granice(null, kraj);

          var srodek_transportu = DM_get_srodek_transportu();
          DM_addmod_trasa_listener_srodek_transportu(srodek_transportu);

          Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy').validate();
          Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy').validate();
        },
      },
    },
    {
      xtype: 'textfield',
      fieldLabel: DM.translator.m('route.arrivalCity.column'),
      name: DM.fields.trasa[6],
      allowBlank: DM_isFieldToHide(DM.fields.trasa[6]),
      validator: DM_semicolonValidation,
      hidden: DM_isFieldToHide(DM.fields.trasa[6]),
      hideLabel: DM_isFieldToHide(DM.fields.trasa[6]),
    },
    {
      xtype: 'datefield',
      format: 'Y-m-d',
      id: 'DM.addmod.form.przyjazd_data',
      fieldLabel: DM.translator.m('route.arrivalDate.column'),
      name: DM.fields.trasa[7],
      validator: DM_addmod_trasa_valid_przyjazd_data,
      listeners: {
        select: function (combo, record, index) {
          var srodek_transportu = DM_get_srodek_transportu();
          DM_addmod_trasa_listener_srodek_transportu(srodek_transportu);
        },
        change: function (t, newValue, oldValue) {
          var srodek_transportu = DM_get_srodek_transportu();
          DM_addmod_trasa_listener_srodek_transportu(srodek_transportu);
          Ext.getCmp('DM.addmod.form.wyjazd_data').validate();
          Ext.getCmp('DM.addmod.form.wyjazd_godzina').validate();
          Ext.getCmp('DM.addmod.form.przyjazd_data').validate();
          Ext.getCmp('DM.addmod.form.przyjazd_godzina').validate();
          Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy').validate();
          Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy').validate();
        },
      },
    },
    {
      xtype: 'timefield',
      id: 'DM.addmod.form.przyjazd_godzina',
      fieldLabel: DM.translator.m('route.arrivalHour.column'),
      name: DM.fields.trasa[8],
      format: 'H:i',
      increment: 15,
      regex: /^\d{1,2}:[0-5]\d$/,
      validator: DM_addmod_trasa_valid_przyjazd_godzina,
      listeners: {
        select: function (combo, record, index) {
          var srodek_transportu = DM_get_srodek_transportu();
          DM_addmod_trasa_listener_srodek_transportu(srodek_transportu);
        },
        change: function (t, newValue, oldValue) {
          var srodek_transportu = DM_get_srodek_transportu();
          DM_addmod_trasa_listener_srodek_transportu(srodek_transportu);
          Ext.getCmp('DM.addmod.form.wyjazd_data').validate();
          Ext.getCmp('DM.addmod.form.wyjazd_godzina').validate();
          Ext.getCmp('DM.addmod.form.przyjazd_data').validate();
          Ext.getCmp('DM.addmod.form.przyjazd_godzina').validate();
          Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy').validate();
          Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy').validate();
        },
      },
    },
    {
      xtype: 'label',
      text: DM.translator.m('route.travel'),
      style: {
        marginBottom: '5px',
        marginTop: '15px',
        fontWeight: 'bold',
        display: 'block',
      },
    },
    {
      xtype: 'combo',
      fieldLabel: DM.translator.m('route.transportType.column'),
      id: 'DM.addmod.form.srodek_transportu',
      name: DM.fields.trasa[9],
      hiddenName: DM.fields.trasa[9],
      typeAhead: true,
      typeAheadDelay: 100,
      triggerAction: 'all',
      allowBlank: DM_isFieldToHide(DM.fields.trasa[9]),
      querymode: 'local',
      forceSelection: true,
      editable: true,
      lazyRender: true,
      mode: 'local',
      store: new Ext.data.ArrayStore({
        fields: ['srodek_lok_text', 'display'],
        data: DM.conf.jsonConf.srodek_transportu,
      }),
      valueField: 'srodek_lok_text',
      displayField: 'display',
      listeners: {
        select: function (combo, record, index) {
          Ext.getCmp('DM.addmod.form.km').validate();

          Ext.getCmp('DM.addmod.form.srodek_transportu').getStore().clearFilter();
          var pojazd = Ext.getCmp('DM.addmod.form.srodek_transportu').getStore().getAt(index).get('srodek_lok_text');
          DM_addmod_trasa_listener_srodek_transportu(pojazd);
        },
        change: function (combo, newValue, oldValue) {
          Ext.getCmp('DM.addmod.form.km').validate();

          var pojazd;
          if (!DM_isNumber(newValue)) {
            pojazd = newValue;
          } else {
            Ext.getCmp('DM.addmod.form.srodek_transportu').getStore().clearFilter();
            pojazd = Ext.getCmp('DM.addmod.form.srodek_transportu').getStore().getAt(newValue).get('srodek_lok_text');
          }
          DM_addmod_trasa_listener_srodek_transportu(pojazd);
        },
      },
      hidden: DM_isFieldToHide(DM.fields.trasa[9]),
      hideLabel: DM_isFieldToHide(DM.fields.trasa[9]),
    },
    {
      xtype: 'numberfield',
      fieldLabel: DM.translator.m('kilometers'),
      id: 'DM.addmod.form.km',
      name: DM.fields.trasa[10],
      allowBlank: true,
      allowNegative: false,
      decimalSeparator: DM.conf.decimalseparator,
      format: DM.conf.getNumberViewFormat(DM.conf.decimalseparator),
      validator: DM_addmod_trasa_valid_km,
      hidden: DM_isFieldToHide(DM.fields.trasa[10]),
      hideLabel: DM_isFieldToHide(DM.fields.trasa[10]),
    },
    {
      xtype: 'datefield',
      format: 'Y-m-d',
      id: 'DM.addmod.form.data_przekroczenia_granicy',
      fieldLabel: DM.translator.m('route.crossingBorderDate.column'),
      name: DM.fields.trasa[11],
      hidden: !isForeignTrip,
      hideLabel: !isForeignTrip,
      allowBlank: !isForeignTrip,
      validator: isForeignTrip ? DM_addmod_trasa_valid_data_przekroczenia_granicy : true,
      listeners: {
        change: function (t, newValue, oldValue) {
          Ext.getCmp('DM.addmod.form.wyjazd_data').validate();
          Ext.getCmp('DM.addmod.form.wyjazd_godzina').validate();
          Ext.getCmp('DM.addmod.form.przyjazd_data').validate();
          Ext.getCmp('DM.addmod.form.przyjazd_godzina').validate();
          Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy').validate();
          Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy').validate();
        },
      },
    },
    {
      xtype: 'timefield',
      id: 'DM.addmod.form.godzina_przekroczenia_granicy',
      fieldLabel: DM.translator.m('route.crossingBorderHour.column'),
      name: DM.fields.trasa[12],
      format: 'H:i',
      increment: 15,
      regex: /^\d{1,2}:[0-5]\d$/,
      hidden: !isForeignTrip,
      hideLabel: !isForeignTrip,
      allowBlank: !isForeignTrip,
      validator: isForeignTrip ? DM_addmod_trasa_valid_godzina_przekroczenia_granicy : true,
      listeners: {
        change: function (t, newValue, oldValue) {
          Ext.getCmp('DM.addmod.form.wyjazd_data').validate();
          Ext.getCmp('DM.addmod.form.wyjazd_godzina').validate();
          Ext.getCmp('DM.addmod.form.przyjazd_data').validate();
          Ext.getCmp('DM.addmod.form.przyjazd_godzina').validate();
          Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy').validate();
          Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy').validate();
        },
      },
    },
  ];

  // tabela rozliczenia trasy
  // jsonstore do gridpanel trasy
  DM.store.trasa = new Ext.data.JsonStore({
    autoSave: false,
    storeId: 'rozdel_grid_trasa_store',
    idProperty: 'lp',
    fields: DM.fields.trasa,
  });

  DM.grid.trasa = new Ext.grid.GridPanel({
    frame: false,
    columnLines: true,
    stripeRows: true,
    store: DM.store.trasa,
    border: false,
    colModel: new Ext.grid.ColumnModel({
      defaults: {
        sortable: false,
        menuDisabled: true,
        align: 'left',
        // autoWidth : true
      },
      columns: DM.columns.trasa,
    }),
    viewConfig: {
      // autoFill : true
      forceFit: true,
      getRowClass: function(record, index) {
        return DM.conf.actionConf.otherParams.isGridValuesCentered ? 'settlement-column-center' : '';
      },
    },
    buttons: [
      {
        text: DM.translator.m('route.add.button'),
        iconCls: "dvnt-icon-table-add",
        autoWidth: true,
        handler: DM_new_odcinek_trasa_handler,
        hidden: DM.conf.actionConf.otherParams.isReadOnlyMode,
      },
      {
        text: DM.translator.m('route.addBelow.button'),
        iconCls: "dvnt-icon-table-row-insert",
        autoWidth: true,
        handler: DM_new_under_odcinek_trasa_handler,
        hidden: DM.conf.actionConf.otherParams.isReadOnlyMode,
      },
      {
        text: DM.translator.m('route.change.button'),
        iconCls: "dvnt-icon-table-edit",
        autoWidth: true,
        handler: DM_mod_odcinek_trasa_handler,
        hidden: DM.conf.actionConf.otherParams.isReadOnlyMode,
      },
      {
        text: DM.translator.m('route.delete.button'),
        iconCls: "dvnt-icon-table-row-delete",
        autoWidth: true,
        handler: DM_del_odcinek_trasa_handler,
        hidden: DM.conf.actionConf.otherParams.isReadOnlyMode,
      },
    ],
    autoScroll: true,
  });

  // formularz do dodawania oraz modyfikacji trasy
  DM.form.addmod = new Ext.form.FormPanel({
    id: 'DM.addmod.form',
    autoWidth: true,
    autoHeight: true,
    labelWidth: 140,
    bodyPadding: 5,
    frame: false,
    border: false,
    style: {
      paddingLeft: '10px',
      paddingRight: '10px',
      paddingTop: '10px',
    },
    defaults: {
      allowBlank: false,
      value: '',
      width: 210,
      anchor: '99%',
    },
    items: DM.items.addmod,
    buttons: [
      {
        text: DM.translator.m('change'),
        id: 'DM.addmod.button.change',
        autoWidth: true,
        // formBind : true,
        handler: DM_addmod_change_btn_handler,
      },
      {
        text: DM.translator.m('add'),
        id: 'DM.addmod.button.add',
        formBind: true,
        handler: DM_addmod_new_btn_handler,
      },
      {
        text: DM.translator.m('cancel'),
        autoWidth: true,
        handler: function (b, e) {
          DM.win.addmod.hide();
        },
      },
    ],
  });

  // modyfikacja obecnego odcinka w trasie
  DM.win.addmod = new Ext.Window({
    layout: 'fit',
    width: 550,
    closeAction: 'hide',
    modal: true,
    items: DM.form.addmod,
    autoScroll: true,
    listeners: {
      show: function (win) {
        win.findByType('form')[0].getForm().clearInvalid();
        //obejście problemu z niezaznaczaniem całego pola datowego przy walidacji
        win.setWidth(550);
      },
      afterlayout: function () {
        DM_setHeightOnSmallerScreens(this);
      }
    },
  });
})();
