﻿(function () {
  var isForeignTrip = DM.data.typ_delegacji == 'zagranica' ? true : false;

  DM.fields.ilosciowe = [
    'kraj',
    'niezapewnione_doby_komunikacji_miejskiej',
    'niezapewnione_przejazdy_do_z_dworca',
    'niezapewnione_noclegi',
    'calodobowe_wyzywienie',
    'zapewnione_sniadania',
    'zapewnione_obiady',
    'zapewnione_kolacje',
  ];
  if (!isForeignTrip) {
    DM.object.ilosciowe = {
      niezapewnione_doby_komunikacji_miejskiej: '',
      niezapewnione_noclegi: '',
      zapewnione_sniadania: '',
      zapewnione_obiady: '',
      zapewnione_kolacje: '',
      kraj: '',
    };
  }

  DM.columns.ilosciowe = [
    {
      header: DM.translator.m('quantities.targetCountry.column'),
      dataIndex: DM.fields.ilosciowe[0],
      width: 60,
      editable: false,
      hidden: false,
      hidden: !isForeignTrip && DM_isFieldToHide(DM.fields.ilosciowe[0]),
      renderer: function (value, metaData, record, rowIndex, colIndex, store) {
        return DM.conf.jsonConf.zagranica.krajeTranslations[value];
      },
    },
    {
      header: DM.translator.m('quantities.daysByPublicTransport.column'),
      tooltip: DM.translator.m('quantities.daysByPublicTransport.column'),
      dataIndex: DM.fields.ilosciowe[1],
      width: 80,
      editor: DM.fields.numberfield_ilosciowe,
      hidden: DM_isFieldToHide(DM.fields.ilosciowe[1]) || DM.conf.jsonConf.hide_financed_public_transport == true,
    },
    {
      header: DM.translator.m('quantities.commutingToStation.column'),
      tooltip: DM.translator.m('quantities.commutingToStation.column'),
      dataIndex: DM.fields.ilosciowe[2],
      width: 80,
      editor: DM.fields.numberfield_ilosciowe_1_po_przecinku,
      xtype: 'numbercolumn',
      format: DM.conf.getNumberViewFormat(DM.conf.decimalseparator, 1),
      hidden: !isForeignTrip || DM_isFieldToHide(DM.fields.ilosciowe[2]) || DM.conf.jsonConf.hide_financed_commuting_to_from_station == true,
    },
    {
      header: DM.translator.m('quantities.accommodation.column'),
      tooltip: DM.translator.m('quantities.accommodation.column'),
      dataIndex: DM.fields.ilosciowe[3],
      width: 60,
      editor: DM.fields.numberfield_ilosciowe,
      hidden: DM_isFieldToHide(DM.fields.ilosciowe[3])  || DM.conf.jsonConf.hide_financed_accommodation == true,
    },
    {
      // xtype : 'checkcolumn',
      header: DM.translator.m('quantities.fullBoard.column'),
      tooltip: DM.translator.m('quantities.fullBoard.column'),
      dataIndex: DM.fields.ilosciowe[4],
      editor: DM.fields.combobox_ilosciowe,
      width: 100,
      hidden: DM_isFieldToHide(DM.fields.ilosciowe[4]),
      renderer: function (value, metaData, record, rowIndex, colIndex, store) {
        if (value) {
          return DM.translator.m(value);
        }
        return DM.translator.m('Nie');
      },
    },
    {
      header: DM.translator.m('quantities.breakfast.column'),
      tooltip: DM.translator.m('quantities.breakfast.column'),
      dataIndex: DM.fields.ilosciowe[5],
      width: 60,
      editor: DM.fields.numberfield_ilosciowe,
      hidden: DM_isFieldToHide(DM.fields.ilosciowe[5]),
    },
    {
      header: DM.translator.m('quantities.lunch.column'),
      tooltip: DM.translator.m('quantities.lunch.column'),
      dataIndex: DM.fields.ilosciowe[6],
      width: 60,
      editor: DM.fields.numberfield_ilosciowe,
      hidden: DM_isFieldToHide(DM.fields.ilosciowe[6]),
    },
    {
      header: DM.translator.m('quantities.supper.column'),
      tooltip: DM.translator.m('quantities.supper.column'),
      dataIndex: DM.fields.ilosciowe[7],
      width: 60,
      editor: DM.fields.numberfield_ilosciowe,
      hidden: DM_isFieldToHide(DM.fields.ilosciowe[7]),
    },
  ];

  // tabela rozliczenia ilosciowego
  DM.store.ilosciowe = new Ext.data.JsonStore({
    autoSave: false,
    storeId: 'rozdel_grid_ilosciowe_store',
    fields: DM.fields.ilosciowe,
  });

  DM.grid.ilosciowe = new Ext.grid.EditorGridPanel({
    frame: false,
    stripeRows: true,
    columnLines: true,
    store: DM.store.ilosciowe,
    border: false,
    colModel: new Ext.grid.ColumnModel({
      defaults: {
        sortable: false,
        menuDisabled: true,
        align: 'left',
        editable: !DM.conf.actionConf.otherParams.isReadOnlyMode,
        // autoWidth : true
      },
      columns: DM.columns.ilosciowe,
    }),
    viewConfig: {
      forceFit: true,
      getRowClass: function(record, index) {
        return DM.conf.actionConf.otherParams.isGridValuesCentered ? 'settlement-column-center' : '';
      },
      // markDirty : false
    },
    buttons: [
      {
        text: DM.translator.m('quantities.button.addCountry'),
        autoWidth: true,
        handler: DM_new_kraj_docelowy_ilosciowe_handler,
        hidden: !isForeignTrip || DM.conf.actionConf.otherParams.isReadOnlyMode,
      },
      {
        text: DM.translator.m('quantities.button.deleteCountry'),
        autoWidth: true,
        handler: DM_del_kraj_docelowy_ilosciowe_handler,
        hidden: !isForeignTrip || DM.conf.actionConf.otherParams.isReadOnlyMode,
      },
    ],
    listeners: {
      afteredit: function (e) {
        var record = e.record,
          field = e.field;
        if (field == 'calodobowe_wyzywienie') {
          var isFullBoard = record.get('calodobowe_wyzywienie') == 'Tak';
          if (isFullBoard) {
            record.set('zapewnione_sniadania', '');
            record.set('zapewnione_obiady', '');
            record.set('zapewnione_kolacje', '');
          }
        }
        record.commit();
      },
      beforeedit: function (e) {
        var record = e.record,
          field = e.field;
        if (field == 'zapewnione_sniadania' || field == 'zapewnione_obiady' || field == 'zapewnione_kolacje') {
          return record.get('calodobowe_wyzywienie') != 'Tak';
        }
      },
    },
    autoScroll: true,
  });

  DM.items.add_ilosciowe = [
    {
      xtype: 'combo',
      fieldLabel: DM.translator.m('quantities.targetCountry.column'),
      id: 'DM.form.add_ilosciowe.kraj',
      name: 'kraj',
      hiddenName: 'kraj',
      typeAhead: true,
      typeAheadDelay: 200,
      triggerAction: 'all',
      allowBlank: false,
      querymode: 'local',
      forceSelection: true,
      editable: true,
      lazyRender: true,
      width: 200,
      mode: 'local',
      store: new Ext.data.ArrayStore({
        fields: ['docelowy_kraj_text', 'display'],
        data: DM.conf.jsonConf.zagranica.kraje,
        sortInfo: {
          field: 'display',
          direction: 'ASC',
        },
      }),
      allowBlank: false,
      validator: DM_add_ilosciowe_valid_kraj,
      valueField: 'docelowy_kraj_text',
      displayField: 'display',
    },
  ];

  // formularz do dodawania kraju docelowego
  DM.form.add_ilosciowe = new Ext.form.FormPanel({
    id: 'DM.form.add_ilosciowe',
    width: 300,
    // height : 300,
    // autoWidth : true,
    autoHeight: true,
    labelWidth: 120,
    bodyPadding: 5,
    frame: false,
    border: false,
    style: {
      marginTop: '5px',
      marginLeft: '10px',
      paddingRight: '15px',
    },
    defaults: {
      allowBlank: false,
      value: '',
      width: 160,
      anchor: '99%',
    },
    items: DM.items.add_ilosciowe,
    buttons: [
      {
        text: DM.translator.m('add'),
        formBind: true,
        autoWidth: true,
        handler: DM_add_ilosciowe_new_btn_handler,
      },
      {
        text: DM.translator.m('cancel'),
        autoWidth: true,
        handler: function (b, e) {
          DM.win.add_ilosciowe.hide();
        },
      },
    ],
  });

  DM.win.add_ilosciowe = new Ext.Window({
    layout: 'fit',
    width: 550,
    // autoWidth : true,
    autoHeight: true,
    closeAction: 'hide',
    modal: true,
    title: DM.translator.m('quantities.add.window.tittle'),
    items: DM.form.add_ilosciowe,
  });
})();
