PWE.integrationComponent.registerFormAction("runBusinessTripAction", {
  apiVersion: 2,
  buildForm: function (form, options) {
    addSettings(form);
    addInput(form);
    addOutput(form);
  },
});

function addSettings(form) {
  var settings = form.addFieldSet({
    id: "settings-fs",
    collapsible: true,
    collapsed: false,
    title: BusinessTrip.t("dynamic-form.fieldsets.settings"),
  });
  settings.addCombobox({
    id: "settlementCountry",
    values: [
      {
        id: "POLAND",
        display: "POLAND",
      },
      {
        id: "CROATIA",
        display: "CROATIA",
      },
    ],
  });
  settings.addField("shouldVariablesBeSave");
  settings.addField("isReadOnlyMode");
  settings.addField("isWarningIfDatesNotSynchronized");
  settings.addField("itsHistoryView");
  settings.hide("itsHistoryView");
  settings.addField("isSettlementWindowVisible");
  settings.addField("spendingTypes");
  settings.addField("paymentMethods");
  settings.addField("documentTypes");
  settings.addField({
    id: "exchangeForForeignBusinessTripsSettlement.refreshExchangeRates",
    hidden: true,
  });
  settings.addCombobox({
    id: "exchangeForForeignBusinessTripsSettlement.refreshingTodayOrFromField",
    listeners: {
      change: function (value) {
        if (value == "dzisiaj") {
          settings.hide(
            "exchangeForForeignBusinessTripsSettlement.idReadFieldName"
          );
          settings.resetValue(
            "exchangeForForeignBusinessTripsSettlement.idReadFieldName"
          );
        } else {
          settings.show(
            "exchangeForForeignBusinessTripsSettlement.idReadFieldName"
          );
        }
      },
    },
    values: [
      {
        id: "dzisiaj",
        display: BusinessTrip.t(
          "dynamic-form.refreshingTodayOrFromField.today"
        ),
      },
      {
        id: "ze_zmiennej",
        display: BusinessTrip.t(
          "dynamic-form.refreshingTodayOrFromField.from_variable"
        ),
      },
    ],
    value: "ze_zmiennej",
    hidden: true,
  });
  if (
    settings.getValue(
      "exchangeForForeignBusinessTripsSettlement.refreshingTodayOrFromField"
    ) != null &&
    settings
      .getValue(
        "exchangeForForeignBusinessTripsSettlement.refreshingTodayOrFromField"
      )
      .toLowerCase() == "dzisiaj"
  ) {
    settings.setValue(
      "exchangeForForeignBusinessTripsSettlement.refreshingTodayOrFromField",
      "dzisiaj"
    );
  }
  settings.addCombobox({
    id: "exchangeForForeignBusinessTripsSettlement.exchangeRateDateType",
    listeners: {
      change: function (value) {
        if (
          value == "ACTUAL" ||
          value == "FROM_ADVANCE" ||
          value == "FROM_SETTLEMENT"
        ) {
          settings.hide(
            "exchangeForForeignBusinessTripsSettlement.idReadFieldName"
          );
          settings.resetValue(
            "exchangeForForeignBusinessTripsSettlement.idReadFieldName"
          );
        } else {
          settings.show(
            "exchangeForForeignBusinessTripsSettlement.idReadFieldName"
          );
        }
      },
    },
    values: [
      {
        id: "ACTUAL",
        display: BusinessTrip.t("dynamic-form.exchangeRateDateType.actual"),
      },
      {
        id: "FROM_FIELD",
        display: BusinessTrip.t("dynamic-form.exchangeRateDateType.fromField"),
      },
      {
        id: "FROM_ADVANCE",
        display: BusinessTrip.t(
          "dynamic-form.exchangeRateDateType.fromAdvance"
        ),
      },
      {
        id: "FROM_SETTLEMENT",
        display: BusinessTrip.t(
          "dynamic-form.exchangeRateDateType.fromSettlement"
        ),
      },
    ],
    value: "FROM_FIELD",
  });
  settings.addField({
    id: "exchangeForForeignBusinessTripsSettlement.idReadFieldName",
    hidden:
      settings.getValue(
        "exchangeForForeignBusinessTripsSettlement.refreshingTodayOrFromField"
      ) == "dzisiaj" ||
      settings.getValue(
        "exchangeForForeignBusinessTripsSettlement.exchangeRateDateType"
      ) == "ACTUAL" ||
      settings.getValue(
        "exchangeForForeignBusinessTripsSettlement.exchangeRateDateType"
      ) == "FROM_ADVANCE" ||
      settings.getValue(
        "exchangeForForeignBusinessTripsSettlement.exchangeRateDateType"
      ) == "FROM_SETTLEMENT",
  });
  settings.addCombobox({
    id: "exchangeForForeignBusinessTripsSettlement.exchangeRateSource",
    listeners: {
      change: function (value) {
        if ( value == "DATA_SOURCE" ) {
          settings.show("exchangeForForeignBusinessTripsSettlement.exchangeRateDataSourceId" );
        } else {
          settings.hide("exchangeForForeignBusinessTripsSettlement.exchangeRateDataSourceId" );
          hideDataSourceInputParameters(settings);

          settings.setValue("exchangeForForeignBusinessTripsSettlement.exchangeRateDataSourceId" , "");
          settings.resetArray("exchangeForForeignBusinessTripsSettlement.datasourceInputParametersId");
          settings.resetArray("exchangeForForeignBusinessTripsSettlement.datasourceInputParametersName");
          settings.resetArray("exchangeForForeignBusinessTripsSettlement.datasourceInputParametersValue");
        }
      },
    },
    values: [
      {
        id: "NBP",
        display: BusinessTrip.t("dynamic-form.exchangeRateSourceType.nbp"),
      },
      {
        id: "DATA_SOURCE",
        display: BusinessTrip.t("dynamic-form.exchangeRateSourceType.dataSource"),
      },
    ],
    value: "NBP",
  });

  let exchangeRateSourceIsNotDataSource = settings.getValue("exchangeForForeignBusinessTripsSettlement.exchangeRateSource") != 'DATA_SOURCE';

  settings.addCombobox({
    id: "exchangeForForeignBusinessTripsSettlement.exchangeRateDataSourceId",
    remote: {
      url: "api/datasources",
      remoteSort: true,
      fields: [
        {
          name: "id",
          type: "string"
        },
        {
          name: "name",
          type: "string"
        }
      ],
    },
    valueField: "id",
    displayField: "name",
    listeners: {
      change: function(value) {
        if (value) {
          jQuery.ajax({
            url: Suncode.getAbsolutePath('api/datasources/' + value),
            success: function(dataSource) {
              hideDataSourceInputParameters(settings);
              inputParametersTable.clear();

              let rowNr = 0;
              for (let param of dataSource.inputParameters) {
                if (param.id !== 'symbol' && param.id !== 'date') {
                  inputParametersTable.addRow([
                    { id: 'datasourceInputParametersId', hidden: true },
                    { id: 'datasourceInputParametersName' },
                    { id: 'datasourceInputParametersValue' }
                  ]);

                  settings.setFieldValueInArray('exchangeForForeignBusinessTripsSettlement.datasourceInputParametersId', rowNr, param.id);
                  settings.setFieldValueInArray('exchangeForForeignBusinessTripsSettlement.datasourceInputParametersName', rowNr, param.name);
                  rowNr++;
                }
              }

              if (dataSource.inputParameters.length > 0) {
                showDataSourceInputParameters(settings);
              }
            }
          });
        }
      }
    },
    hidden: exchangeRateSourceIsNotDataSource,
  });

  var inputParametersTable = settings.addTable({
    tableId: "exchangeForForeignBusinessTripsSettlement.dataSourceParametersTable",
    blocked: true,
  });
  inputParametersTable.addField({
    id: 'exchangeForForeignBusinessTripsSettlement.datasourceInputParametersId',
    hidden: true
  });
  inputParametersTable.addField({
    id: 'exchangeForForeignBusinessTripsSettlement.datasourceInputParametersName',
    name:  BusinessTrip.t("dynamic-form.exchangeRateSourceType.dataSource.inputParametersName"),
    description:  BusinessTrip.t("dynamic-form.exchangeRateSourceType.dataSource.inputParametersNameDesc"),
    readOnly: true,
    hidden: exchangeRateSourceIsNotDataSource
  });
  inputParametersTable.addField({
    id: 'exchangeForForeignBusinessTripsSettlement.datasourceInputParametersValue',
    hidden: exchangeRateSourceIsNotDataSource
  });

  settings.addField("isGridValuesCentered");
  addSettlementSummary(settings);
  addGeneratingCarCard(settings);
  settings.addField("fieldsToHide");
}

function showDataSourceInputParameters(form){
  form.show(
    "exchangeForForeignBusinessTripsSettlement.datasourceInputParametersName"
  );
  form.show(
    "exchangeForForeignBusinessTripsSettlement.datasourceInputParametersValue"
  );
}

function hideDataSourceInputParameters(form){
  form.hide(
    "exchangeForForeignBusinessTripsSettlement.datasourceInputParametersName"
  );
  form.hide(
    "exchangeForForeignBusinessTripsSettlement.datasourceInputParametersValue"
  );
}

function addSettlementSummary(settings) {
  var settlementSummary = settings.addFieldSet({
    id: "settlement-fs",
    collapsible: true,
    collapsed: true,
    title: BusinessTrip.t("dynamic-form.fieldsets.settings-settlementSummary"),
  });
  settlementSummary.addField({
    id: "generatingSettlementSummaryPdf.run",
    listeners: {
      change: function (value) {
        if (value) {
          settlementSummary.show(
            "generatingSettlementSummaryPdf.documentClass"
          );
          settlementSummary.show("generatingSettlementSummaryPdf.templateName");
        } else {
          settlementSummary.hide(
            "generatingSettlementSummaryPdf.documentClass"
          );
          settlementSummary.resetValue(
            "generatingSettlementSummaryPdf.documentClass"
          );
          settlementSummary.hide("generatingSettlementSummaryPdf.templateName");
          settlementSummary.resetValue(
            "generatingSettlementSummaryPdf.templateName"
          );
        }
      },
    },
  });
  settlementSummary.addField({
    id: "generatingSettlementSummaryPdf.documentClass",
    hidden: !settlementSummary.getValue("generatingSettlementSummaryPdf.run"),
  });
  settlementSummary.addField({
    id: "generatingSettlementSummaryPdf.templateName",
    hidden: !settlementSummary.getValue("generatingSettlementSummaryPdf.run"),
  });
}

function addGeneratingCarCard(settings) {
  var generatingCarCard = settings.addFieldSet({
    id: "generating-car-card-fs",
    collapsible: true,
    collapsed: true,
    title: BusinessTrip.t("dynamic-form.fieldsets.settings-generatingCarCard"),
  });
  generatingCarCard.addField({
    id: "generatingCarCardPdf.run",
    listeners: {
      change: function (value) {
        if (value) {
          generatingCarCard.show("generatingCarCardPdf.documentClass");
          generatingCarCard.show("generatingCarCardPdf.templateName");
        } else {
          generatingCarCard.hide("generatingCarCardPdf.documentClass");
          generatingCarCard.resetValue("generatingCarCardPdf.documentClass");
          generatingCarCard.hide("generatingCarCardPdf.templateName");
          generatingCarCard.resetValue("generatingCarCardPdf.templateName");
        }
      },
    },
  });
  generatingCarCard.addField({
    id: "generatingCarCardPdf.documentClass",
    hidden: !generatingCarCard.getValue("generatingCarCardPdf.run"),
  });
  generatingCarCard.addField({
    id: "generatingCarCardPdf.templateName",
    hidden: !generatingCarCard.getValue("generatingCarCardPdf.run"),
  });
}

function addInput(form) {
  var input = form.addFieldSet({
    id: "input-fs",
    collapsible: true,
    collapsed: true,
    title: BusinessTrip.t("dynamic-form.fieldsets.input"),
  });
  input.addField("id");
  input.addField("type");
  input.addField("personName");
  input.addField("goal");
  input.addField("startDate");
  input.addField("finishDate");
  input.addField("city");
  input.addField("country");
  input.addField("transportType");
  input.addField("advanceDate");
  input.addField("transport");
  input.addField("vehicleBrand");
  input.addField("registrationNumber");
  input.addField("vehicleUserAddress");
  input.addField("engineCapacity");
  addAdvanced(input);
}

function addAdvanced(input) {
  var advanced = input.addFieldSet({
    id: "advanced-fs",
    collapsible: true,
    collapsed: true,
    title: BusinessTrip.t("dynamic-form.fieldsets.advanced"),
  });
  advanced.addField("advanceAmounts");
  advanced.addField("advanceCurrencies");
  advanced.addField("activityVariableParams");
}

function addOutput(form) {
  var output = form.addFieldSet({
    title: BusinessTrip.t("dynamic-form.fieldsets.output"),
  });
  addSpendings(output);
  addSummary(output);
  addCosts(output);
}

function addSpendings(output) {
  var spendings = output.addFieldSet({
    id: "spendings-fs",
    collapsible: true,
    collapsed: true,
    title: BusinessTrip.t("dynamic-form.fieldsets.spendings"),
  });
  spendings.addField({
    id: "isSpendingTableVisible",
    listeners: {
      change: function (value) {
        if (value) {
          spendings.show("spendingsTable.nr_delegacji");
          spendings.show("spendingsTable.wydatek_id");
          spendings.show("spendingsTable.nazwa_wydatku");
          spendings.show("spendingsTable.koszt");
          spendings.show("spendingsTable.waluta");
          spendings.show("spendingsTable.data");
          spendings.show("spendingsTable.rodzaj_wydatku");
          spendings.show("spendingsTable.paymentMethod");
          spendings.show("spendingsTable.documentType");
          spendings.show("spendingsTable.kurs_waluty");
          spendings.show("spendingsTable.wspolczynnik_waluty");
        } else {
          spendings.hide("spendingsTable.nr_delegacji");
          spendings.hide("spendingsTable.wydatek_id");
          spendings.hide("spendingsTable.nazwa_wydatku");
          spendings.hide("spendingsTable.koszt");
          spendings.hide("spendingsTable.waluta");
          spendings.hide("spendingsTable.data");
          spendings.hide("spendingsTable.rodzaj_wydatku");
          spendings.hide("spendingsTable.paymentMethod");
          spendings.hide("spendingsTable.documentType");
          spendings.hide("spendingsTable.kurs_waluty");
          spendings.hide("spendingsTable.wspolczynnik_waluty");
          spendings.resetValue("spendingsTable.nr_delegacji");
          spendings.resetValue("spendingsTable.wydatek_id");
          spendings.resetValue("spendingsTable.nazwa_wydatku");
          spendings.resetValue("spendingsTable.koszt");
          spendings.resetValue("spendingsTable.waluta");
          spendings.resetValue("spendingsTable.data");
          spendings.resetValue("spendingsTable.rodzaj_wydatku");
          spendings.resetValue("spendingsTable.paymentMethod");
          spendings.resetValue("spendingsTable.documentType");
          spendings.resetValue("spendingsTable.kurs_waluty");
          spendings.resetValue("spendingsTable.wspolczynnik_waluty");
        }
      },
    },
  });
  spendings.addField({
    id: "spendingsTable.nr_delegacji",
    hidden: !spendings.getValue("isSpendingTableVisible"),
  });
  spendings.addField({
    id: "spendingsTable.wydatek_id",
    hidden: !spendings.getValue("isSpendingTableVisible"),
  });
  spendings.addField({
    id: "spendingsTable.nazwa_wydatku",
    hidden: !spendings.getValue("isSpendingTableVisible"),
  });
  spendings.addField({
    id: "spendingsTable.koszt",
    hidden: !spendings.getValue("isSpendingTableVisible"),
  });
  spendings.addField({
    id: "spendingsTable.waluta",
    hidden: !spendings.getValue("isSpendingTableVisible"),
  });
  spendings.addField({
    id: "spendingsTable.data",
    hidden: !spendings.getValue("isSpendingTableVisible"),
  });
  spendings.addField({
    id: "spendingsTable.rodzaj_wydatku",
    hidden: !spendings.getValue("isSpendingTableVisible"),
  });
  spendings.addField({
    id: "spendingsTable.paymentMethod",
    hidden: !spendings.getValue("isSpendingTableVisible"),
  });
  spendings.addField({
    id: "spendingsTable.documentType",
    hidden: !spendings.getValue("isSpendingTableVisible"),
  });
  spendings.addField({
    id: "spendingsTable.kurs_waluty",
    hidden: !spendings.getValue("isSpendingTableVisible"),
  });
  spendings.addField({
    id: "spendingsTable.wspolczynnik_waluty",
    hidden: !spendings.getValue("isSpendingTableVisible"),
  });
}

function addSummary(output) {
  var summary = output.addFieldSet({
    id: "summary-fs",
    collapsible: true,
    collapsed: true,
    title: BusinessTrip.t("dynamic-form.fieldsets.summary"),
  });
  summary.addField("summaryTable.nr_delegacji");
  summary.addField("summaryTable.wyjazd_data");
  summary.addField("summaryTable.wyjazd_godzina");
  summary.addField("summaryTable.przyjazd_data");
  summary.addField("summaryTable.przyjazd_godzina");
  summary.addField("summaryTable.wyjazd_miejscowosc");
  summary.addField("summaryTable.przyjazd_miejscowosc");
  summary.addField("summaryTable.kraj_delegacji");
  summary.addField("summaryTable.nr_rejestracyjny");
  summary.addField("summaryTable.srodek_transportu");
  summary.addField("summaryTable.cel_delegacji");
  summary.addField("summaryTable.suma_dni_w_delegacji");
  summary.addField("summaryTable.suma_ilosci_godzin_w_delegacji");
  summary.addField(
    "summaryTable.suma_ilosci_niezapewnionych_dob_komunikacji_miejskiej"
  );
  summary.addField("summaryTable.suma_ilosci_niezapewnionych_noclegow");
  summary.addField("summaryTable.suma_ilosci_niezapewnionych_sniadan");
  summary.addField("summaryTable.suma_ilosci_niezapewnionych_obiadow");
  summary.addField("summaryTable.suma_ilosci_niezapewnionych_kolacji");
  summary.addField("summaryTable.suma_ilosci_zapewnionych_dob_calodobowe_wyzywienie")
  summary.addField("summaryTable.suma_ilosci_niezapewnionych_dob_calodobowe_wyzywienie")
  summary.addField(
    "summaryTable.suma_ilosci_niezapewnionych_przejazdow_do_z_dworca"
  );
  summary.addField("summaryTable.suma_ilosci_diet_kraj");
  summary.addField("summaryTable.suma_ilosci_diet_zagranica");
  summary.addField("summaryTable.suma_wydatkow");
  summary.addField("summaryTable.miasto_docelowe");
}

function addCosts(output) {
  var costs = output.addFieldSet({
    id: "costs-fs",
    collapsible: true,
    collapsed: true,
    title: BusinessTrip.t("dynamic-form.fieldsets.costs"),
  });
  costs.addField("costsTable.nr_delegacji");
  costs.addField("costsTable.opis_linii");
  costs.addField("costsTable.kwota_w_walucie");
  costs.addField("costsTable.waluta");
  costs.addField("costsTable.kurs_waluty");
  costs.addField("costsTable.wspolczynnik_waluty");
}
