/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.util;

import com.plusmpm.database.hibernate.HibernateUtil;
import com.suncode.businesstrip.exception.DMException;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.SharkUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tools {
    private static final Logger log = LoggerFactory.getLogger(Tools.class);
    private static DecimalFormatSymbols originalDfs = new DecimalFormatSymbols();
    private static DecimalFormat originalFormat = new DecimalFormat();
    private static DecimalFormat amountFormat = new DecimalFormat();
    private static DecimalFormat integerFormat = new DecimalFormat();
    private static DecimalFormat noPrecisionFormat = new DecimalFormat();
    public static final String date_format = "yyyy-MM-dd";
    public static final String hour_format = "HH:mm";
    public static final String date_hour_format = "yyyy-MM-dd, HH:mm";
    public static final String waluta_format = "yy-MM-dd";

    private static void initializeDecimalFormat(DecimalFormat format, Integer decimalPrecision) {
        format.setRoundingMode(RoundingMode.HALF_UP);
        if (decimalPrecision != null) {
            format.setMinimumFractionDigits(decimalPrecision);
            format.setMaximumFractionDigits(decimalPrecision);
        } else {
            format.setMaximumFractionDigits(Integer.MAX_VALUE);
        }
    }

    public static String toString(Number value) {
        if (value == null) {
            return "";
        }
        return originalFormat.format(value);
    }

    public static String walidacjaTakNie(String in, String errorMsg) throws DMException {
        if (in == null) {
            return "Nie";
        }
        try {
            if (Tools.isTak(in)) {
                return "Tak";
            }
            return "Nie";
        }
        catch (NullPointerException e) {
            throw new DMException(errorMsg);
        }
    }

    public static int walidacjaInteger(Integer in, String errorMsg) throws DMException {
        if (in == null) {
            return 0;
        }
        return in;
    }

    public static double walidacjaDouble(String in, String errorMsg) throws DMException {
        if (in == null || in.trim().equalsIgnoreCase("")) {
            return 0.0;
        }
        try {
            return Tools.parseDouble(in);
        }
        catch (NullPointerException e) {
            throw new DMException(errorMsg);
        }
    }

    public static double walidacjaDouble(Double in, String errorMsg) throws DMException {
        if (in == null) {
            return 0.0;
        }
        return in;
    }

    public static boolean isTak(String in) {
        if (in == null || in.trim().equalsIgnoreCase("")) {
            return false;
        }
        return in.equalsIgnoreCase("tak");
    }

    public static String returnEmptyIfNull(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static String formatKwota(Double value, boolean useSystemPropertiesDecimalSeparator) {
        if (value == null) {
            return "";
        }
        if (useSystemPropertiesDecimalSeparator) {
            Tools.setDecimalFormatSymbols(amountFormat);
        }
        return amountFormat.format(value);
    }

    public static String formatKurs(Double value, boolean useSystemPropertiesDecimalSeparator) {
        if (value == null) {
            return "";
        }
        if (useSystemPropertiesDecimalSeparator) {
            Tools.setDecimalFormatSymbols(noPrecisionFormat);
        }
        return noPrecisionFormat.format(value);
    }

    public static String formatIlosc(Double value, boolean useSystemPropertiesDecimalSeparator) {
        if (value == null) {
            return "";
        }
        if (useSystemPropertiesDecimalSeparator) {
            Tools.setDecimalFormatSymbols(integerFormat);
        }
        return integerFormat.format(value);
    }

    public static String formatIlosc(Integer value, boolean useSystemPropertiesDecimalSeparator) {
        if (value == null) {
            return "";
        }
        if (useSystemPropertiesDecimalSeparator) {
            Tools.setDecimalFormatSymbols(integerFormat);
        }
        return integerFormat.format(value);
    }

    public static double round2(double liczba) {
        return (double)Math.round(liczba * 100.0) / 100.0;
    }

    public static double round4(Double liczba) {
        return (double)Math.round(liczba * 10000.0) / 10000.0;
    }

    public static Double convertCurrency(Double dAmount, Double dRate) {
        BigDecimal amount = new BigDecimal(dAmount);
        BigDecimal rate = new BigDecimal(dRate);
        return amount.multiply(rate).doubleValue();
    }

    public static Boolean executeInternalQueryNonSelect(String query) {
        Boolean result = true;
        Session sess = HibernateUtil.getSession();
        Transaction trans = sess.beginTransaction();
        try {
            sess.createSQLQuery(query).executeUpdate();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result = false;
        }
        trans.commit();
        return result;
    }

    public static String zmienMinutyNaGodziny(long minuty) {
        return Tools.formatKwota((double)minuty / 60.0, true);
    }

    public static String zmienMinutyNaDni(long minuty) {
        return Tools.formatKwota((double)minuty / 1440.0, true);
    }

    public static void logTraceContextMap(Map<String, Object> mapa, String msg) {
        if (log.isTraceEnabled()) {
            log.trace(msg);
            mapa.forEach((key, value) -> log.trace(key + " = " + String.valueOf(value)));
        }
    }

    public static String[] zmienDateNaString(Date data) {
        String[] data_czesci = new String[3];
        int rok = data.getYear() - 100;
        int miesiac = data.getMonth() + 1;
        int dzien = data.getDate();
        data_czesci[2] = dzien < 10 ? "0" + String.valueOf(dzien) : String.valueOf(dzien);
        data_czesci[1] = miesiac < 10 ? "0" + String.valueOf(miesiac) : String.valueOf(miesiac);
        data_czesci[0] = rok < 10 ? "0" + String.valueOf(rok) : String.valueOf(rok);
        return data_czesci;
    }

    public static String changeDateFormat(String date) {
        String formated_date = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(waluta_format);
            Date data_waluty = sdf.parse(date);
            sdf = new SimpleDateFormat(date_format);
            formated_date = sdf.format(data_waluty);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return formated_date;
    }

    public static String getDateSubstring(String dateString) {
        if (StringUtils.isBlank((CharSequence)dateString)) {
            return "";
        }
        return dateString.length() > 10 ? dateString.substring(0, 10) : dateString;
    }

    public static boolean czyProcesNaEtapie(String act_id, String def_id) {
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery("select 1 as wynik from activities where activitydefinitionid=:ACTDEFID and id=:ACTIVITYID");
        builder.addScalar("wynik", (Type)StandardBasicTypes.INTEGER);
        builder.setParameter("ACTDEFID", (Object)def_id);
        builder.setParameter("ACTIVITYID", (Object)act_id);
        SQLFinder finder = FinderFactory.getSQLFinder();
        List db_results = finder.find(builder);
        return db_results != null && !db_results.isEmpty();
    }

    public static int pobierzWersjePakietu(String proc_id) {
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery("select def.ProcessDefinitionVersion as wersja from processes prc join ProcessDefinitions def on prc.ProcessDefinition = def." + SharkUtils.getSharkIdColumn() + " where prc.Id=:PROCID");
        builder.addScalar("wersja", (Type)StandardBasicTypes.STRING);
        builder.setParameter("PROCID", (Object)proc_id);
        SQLFinder finder = FinderFactory.getSQLFinder();
        List db_results = finder.find(builder);
        if (!db_results.isEmpty()) {
            String wersja_pakietu = ((Map)db_results.get(0)).get("wersja").toString();
            log.debug("wersja_pakietu: " + wersja_pakietu);
            return Integer.parseInt(wersja_pakietu);
        }
        return 0;
    }

    public static Date zmienStringNaDate(String date) {
        String[] data_czesci = date.split("-");
        int year = Integer.parseInt(data_czesci[0]);
        if (year < 100) {
            year += 2000;
        }
        int month = Integer.parseInt(data_czesci[1]) - 1;
        int day = Integer.parseInt(data_czesci[2]);
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day);
        return cal.getTime();
    }

    public static Double parseDouble(String value) {
        return Double.parseDouble(value.replace(",", "."));
    }

    private static void setDecimalFormatSymbols(DecimalFormat format) {
        DecimalFormatSymbols ds = new DecimalFormatSymbols();
        ds.setGroupingSeparator(" ".charAt(0));
        ds.setDecimalSeparator(SystemProperties.getString((String)DefinedSystemParameter.DECIMAL_SEPARATOR.getKey(), (String)".").charAt(0));
        format.setDecimalFormatSymbols(ds);
    }

    static {
        originalDfs.setDecimalSeparator(".".charAt(0));
        originalFormat.setDecimalFormatSymbols(originalDfs);
        originalFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
        originalFormat.setGroupingUsed(false);
        Tools.initializeDecimalFormat(amountFormat, 2);
        Tools.initializeDecimalFormat(integerFormat, 0);
        Tools.initializeDecimalFormat(noPrecisionFormat, null);
    }
}

