/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.settlement;

import com.suncode.businesstrip.config.Configuration;
import com.suncode.businesstrip.config.data.JsonConf;
import com.suncode.businesstrip.database.model.BusinessTripRoute;
import com.suncode.businesstrip.settlement.SettlementCountry;
import com.suncode.businesstrip.util.RoutePartType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripTimeCalculator {
    private static final Logger log = LoggerFactory.getLogger(TripTimeCalculator.class);
    protected static String LOG_MSG_TIME_ON_ROAD_ADDED = "Dodano czas w drodze %d min dla kraju %s";
    protected static String LOG_MSG_TIME_ON_ROAD_TO_BORDER_ADDED = "Dodano czas w drodze do granicy %d min dla kraju %s";
    protected static String LOG_MSG_TIME_ON_ROAD_FROM_BORDER_ADDED = "Dodano czas w drodze od granicy %d min dla kraju %s";
    protected static String LOG_MSG_BREAK_TIME_ADDED = "Dodano czas postoju  %d min dla kraju %s";
    protected static String LOG_MSG_BUFFER_TIME_ADDED = "Dodano czas z bufora  %d min dla kraju %s";

    public static long calculateMinutesPolandDelegation(Set<BusinessTripRoute> trip) {
        try {
            if (trip.size() > 0) {
                BusinessTripRoute beginingRoute = new BusinessTripRoute();
                BusinessTripRoute finishRoute = new BusinessTripRoute();
                for (BusinessTripRoute route : trip) {
                    if (route.getLp() == 1) {
                        beginingRoute = route;
                    }
                    if (route.getLp().intValue() != trip.size()) continue;
                    finishRoute = route;
                }
                DateTime departureDate = DateTime.parse((String)(beginingRoute.getWyjazd_data() + " " + beginingRoute.getWyjazd_godzina()), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm"));
                DateTime arrivalDate = DateTime.parse((String)(finishRoute.getPrzyjazd_data() + " " + finishRoute.getPrzyjazd_godzina()), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm"));
                return Minutes.minutesBetween((ReadableInstant)departureDate, (ReadableInstant)arrivalDate).getMinutes();
            }
            return 0L;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static Map<String, List<Long>> calculateMinutesForeignDelegation(Set<BusinessTripRoute> trip, Set<String> destinationCountries, String finishDelegationDate, SettlementCountry settlementCountry) {
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>();
        try {
            HashMap<String, Long> minutesInCountries = new HashMap<String, Long>();
            DateTime lastArrivalDate = null;
            long bufforMinutes = 0L;
            String lastDestinationCountry = "";
            JsonConf config = Configuration.getJsonConfigForDate(settlementCountry, finishDelegationDate);
            String domesticCountryName = config.getDomesticCountryName();
            for (BusinessTripRoute route : trip) {
                log.debug("*********** Rozliczanie kolejnego odcinka ************");
                boolean borderOnStart = config.getZagranica().getGranica_odrazu().contains(route.getSrodek_transportu());
                log.debug("Granica liczona od razu: " + borderOnStart);
                String departureCountry = route.getWyjazd_kraj();
                DateTime departureDate = DateTime.parse((String)(route.getWyjazd_data() + " " + route.getWyjazd_godzina()), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm"));
                log.debug("Wyjazd " + departureCountry + " - " + String.valueOf(departureDate));
                String arrivalCountry = route.getPrzyjazd_kraj();
                DateTime arrivalDate = DateTime.parse((String)(route.getPrzyjazd_data() + " " + route.getPrzyjazd_godzina()), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm"));
                log.debug("Przyjazd " + arrivalCountry + " - " + String.valueOf(arrivalDate));
                boolean itsDestinationCountry = destinationCountries.contains(arrivalCountry);
                log.debug("Kraj " + arrivalCountry + (itsDestinationCountry ? " jest krajem docelowym" : " nie jest krajem docelowym"));
                long timeOnRoad = Minutes.minutesBetween((ReadableInstant)departureDate, (ReadableInstant)arrivalDate).getMinutes();
                long lastBreakTime = lastArrivalDate == null ? 0L : (long)Minutes.minutesBetween(lastArrivalDate, (ReadableInstant)departureDate).getMinutes();
                log.debug("D\u0142ugo\u015b\u0107 postoju przed ostatnim wyjazdem (min): " + lastBreakTime);
                lastArrivalDate = arrivalDate;
                if (destinationCountries.contains(departureCountry)) {
                    lastDestinationCountry = departureCountry;
                }
                if (itsDestinationCountry) {
                    if (arrivalCountry.equalsIgnoreCase(departureCountry)) {
                        minutesInCountries.merge(arrivalCountry, timeOnRoad, Long::sum);
                        log.debug(String.format(LOG_MSG_TIME_ON_ROAD_ADDED, timeOnRoad, arrivalCountry));
                        minutesInCountries.merge(arrivalCountry, lastBreakTime, Long::sum);
                        log.debug(String.format(LOG_MSG_BREAK_TIME_ADDED, lastBreakTime, arrivalCountry));
                    } else if (borderOnStart) {
                        if (arrivalCountry.equalsIgnoreCase(domesticCountryName)) {
                            minutesInCountries.merge(lastDestinationCountry, timeOnRoad, Long::sum);
                            log.debug(String.format(LOG_MSG_TIME_ON_ROAD_ADDED, timeOnRoad, lastDestinationCountry));
                            minutesInCountries.merge(lastDestinationCountry, bufforMinutes, Long::sum);
                            log.debug(String.format(LOG_MSG_BUFFER_TIME_ADDED, bufforMinutes, lastDestinationCountry));
                            bufforMinutes = 0L;
                            minutesInCountries.merge(lastDestinationCountry, lastBreakTime, Long::sum);
                            log.debug(String.format(LOG_MSG_BREAK_TIME_ADDED, lastBreakTime, lastDestinationCountry));
                        } else if (departureCountry.equalsIgnoreCase(domesticCountryName)) {
                            minutesInCountries.merge(departureCountry, lastBreakTime, Long::sum);
                            log.debug(String.format(LOG_MSG_BREAK_TIME_ADDED, lastBreakTime, departureCountry));
                            minutesInCountries.merge(arrivalCountry, timeOnRoad, Long::sum);
                            log.debug(String.format(LOG_MSG_TIME_ON_ROAD_ADDED, timeOnRoad, arrivalCountry));
                            minutesInCountries.merge(departureCountry, bufforMinutes, Long::sum);
                            log.debug(String.format(LOG_MSG_BUFFER_TIME_ADDED, bufforMinutes, departureCountry));
                            bufforMinutes = 0L;
                        } else if (lastDestinationCountry.equalsIgnoreCase(domesticCountryName)) {
                            minutesInCountries.merge(arrivalCountry, timeOnRoad, Long::sum);
                            log.debug(String.format(LOG_MSG_TIME_ON_ROAD_ADDED, timeOnRoad, arrivalCountry));
                            minutesInCountries.merge(arrivalCountry, lastBreakTime, Long::sum);
                            log.debug(String.format(LOG_MSG_BREAK_TIME_ADDED, lastBreakTime, arrivalCountry));
                            minutesInCountries.merge(arrivalCountry, bufforMinutes, Long::sum);
                            log.debug(String.format(LOG_MSG_BUFFER_TIME_ADDED, bufforMinutes, arrivalCountry));
                            bufforMinutes = 0L;
                        } else {
                            minutesInCountries.merge(lastDestinationCountry, timeOnRoad, Long::sum);
                            log.debug(String.format(LOG_MSG_TIME_ON_ROAD_ADDED, timeOnRoad, lastDestinationCountry));
                            minutesInCountries.merge(lastDestinationCountry, lastBreakTime, Long::sum);
                            log.debug(String.format(LOG_MSG_BREAK_TIME_ADDED, lastBreakTime, lastDestinationCountry));
                            minutesInCountries.merge(lastDestinationCountry, bufforMinutes, Long::sum);
                            log.debug(String.format(LOG_MSG_BUFFER_TIME_ADDED, bufforMinutes, lastDestinationCountry));
                            bufforMinutes = 0L;
                        }
                    } else {
                        splittedRouteAtBorder = TripTimeCalculator.splitRouteAtBorder(arrivalDate, departureDate, route.getData_przekroczenia_granicy(), route.getGodzina_przekroczenia_granicy());
                        if (arrivalCountry.equalsIgnoreCase(domesticCountryName)) {
                            minutesInCountries.merge(lastDestinationCountry, splittedRouteAtBorder.get((Object)RoutePartType.TO_THE_BORDER), Long::sum);
                            log.debug(String.format(LOG_MSG_TIME_ON_ROAD_TO_BORDER_ADDED, splittedRouteAtBorder.get((Object)RoutePartType.TO_THE_BORDER), lastDestinationCountry));
                            minutesInCountries.merge(arrivalCountry, splittedRouteAtBorder.get((Object)RoutePartType.FROM_THE_BORDER), Long::sum);
                            log.debug(String.format(LOG_MSG_TIME_ON_ROAD_FROM_BORDER_ADDED, splittedRouteAtBorder.get((Object)RoutePartType.FROM_THE_BORDER), arrivalCountry));
                            minutesInCountries.merge(lastDestinationCountry, bufforMinutes, Long::sum);
                            log.debug(String.format(LOG_MSG_BUFFER_TIME_ADDED, bufforMinutes, lastDestinationCountry));
                            bufforMinutes = 0L;
                            minutesInCountries.merge(lastDestinationCountry, lastBreakTime, Long::sum);
                            log.debug(String.format(LOG_MSG_BREAK_TIME_ADDED, lastBreakTime, lastDestinationCountry));
                        } else if (lastDestinationCountry.equalsIgnoreCase(departureCountry)) {
                            minutesInCountries.merge(departureCountry, lastBreakTime, Long::sum);
                            log.debug(String.format(LOG_MSG_BREAK_TIME_ADDED, lastBreakTime, departureCountry));
                            minutesInCountries.merge(departureCountry, splittedRouteAtBorder.get((Object)RoutePartType.TO_THE_BORDER), Long::sum);
                            log.debug(String.format(LOG_MSG_TIME_ON_ROAD_TO_BORDER_ADDED, splittedRouteAtBorder.get((Object)RoutePartType.TO_THE_BORDER), departureCountry));
                            minutesInCountries.merge(arrivalCountry, splittedRouteAtBorder.get((Object)RoutePartType.FROM_THE_BORDER), Long::sum);
                            log.debug(String.format(LOG_MSG_TIME_ON_ROAD_FROM_BORDER_ADDED, splittedRouteAtBorder.get((Object)RoutePartType.FROM_THE_BORDER), arrivalCountry));
                        } else if (lastDestinationCountry.equalsIgnoreCase(domesticCountryName)) {
                            minutesInCountries.merge(arrivalCountry, lastBreakTime, Long::sum);
                            log.debug(String.format(LOG_MSG_BREAK_TIME_ADDED, lastBreakTime, arrivalCountry));
                            minutesInCountries.merge(arrivalCountry, timeOnRoad, Long::sum);
                            log.debug(String.format(LOG_MSG_TIME_ON_ROAD_ADDED, timeOnRoad, arrivalCountry));
                            minutesInCountries.merge(arrivalCountry, bufforMinutes, Long::sum);
                            log.debug(String.format(LOG_MSG_BUFFER_TIME_ADDED, bufforMinutes, arrivalCountry));
                            bufforMinutes = 0L;
                        } else {
                            minutesInCountries.merge(lastDestinationCountry, lastBreakTime, Long::sum);
                            log.debug(String.format(LOG_MSG_BREAK_TIME_ADDED, lastBreakTime, lastDestinationCountry));
                            minutesInCountries.merge(lastDestinationCountry, splittedRouteAtBorder.get((Object)RoutePartType.TO_THE_BORDER), Long::sum);
                            log.debug(String.format(LOG_MSG_TIME_ON_ROAD_TO_BORDER_ADDED, splittedRouteAtBorder.get((Object)RoutePartType.TO_THE_BORDER), lastDestinationCountry));
                            minutesInCountries.merge(arrivalCountry, splittedRouteAtBorder.get((Object)RoutePartType.FROM_THE_BORDER), Long::sum);
                            log.debug(String.format(LOG_MSG_TIME_ON_ROAD_FROM_BORDER_ADDED, splittedRouteAtBorder.get((Object)RoutePartType.FROM_THE_BORDER), arrivalCountry));
                            minutesInCountries.merge(lastDestinationCountry, bufforMinutes, Long::sum);
                            log.debug(String.format(LOG_MSG_BUFFER_TIME_ADDED, bufforMinutes, lastDestinationCountry));
                            bufforMinutes = 0L;
                        }
                    }
                } else if (arrivalCountry.equalsIgnoreCase(departureCountry)) {
                    bufforMinutes += timeOnRoad;
                    bufforMinutes += lastBreakTime;
                } else if (borderOnStart) {
                    if (lastDestinationCountry.equalsIgnoreCase(departureCountry)) {
                        minutesInCountries.merge(lastDestinationCountry, lastBreakTime, Long::sum);
                        log.debug(String.format(LOG_MSG_BREAK_TIME_ADDED, lastBreakTime, lastDestinationCountry));
                    } else {
                        bufforMinutes += lastBreakTime;
                    }
                    bufforMinutes += timeOnRoad;
                } else if (lastDestinationCountry.equalsIgnoreCase(departureCountry)) {
                    if (departureCountry.equalsIgnoreCase(domesticCountryName)) {
                        splittedRouteAtBorder = TripTimeCalculator.splitRouteAtBorder(arrivalDate, departureDate, route.getData_przekroczenia_granicy(), route.getGodzina_przekroczenia_granicy());
                        minutesInCountries.merge(departureCountry, splittedRouteAtBorder.get((Object)RoutePartType.TO_THE_BORDER), Long::sum);
                        log.debug(String.format(LOG_MSG_TIME_ON_ROAD_TO_BORDER_ADDED, splittedRouteAtBorder.get((Object)RoutePartType.TO_THE_BORDER), departureCountry));
                        bufforMinutes += splittedRouteAtBorder.get((Object)RoutePartType.FROM_THE_BORDER).longValue();
                    } else {
                        minutesInCountries.merge(departureCountry, timeOnRoad, Long::sum);
                        log.debug(String.format(LOG_MSG_TIME_ON_ROAD_ADDED, timeOnRoad, departureCountry));
                    }
                    minutesInCountries.merge(departureCountry, lastBreakTime, Long::sum);
                    log.debug(String.format(LOG_MSG_BREAK_TIME_ADDED, lastBreakTime, departureCountry));
                } else {
                    bufforMinutes += lastBreakTime;
                    bufforMinutes += timeOnRoad;
                }
                minutesInCountries.keySet().forEach(country -> {
                    List domesticMinutes = (List)result.get(country);
                    if (domesticMinutes != null && domesticCountryName.equalsIgnoreCase((String)country) && !config.getZagranica().getSumowac_czas_w_kraju_do_liczenia_delegacji().booleanValue()) {
                        if (domesticCountryName.equalsIgnoreCase(arrivalCountry) && !domesticCountryName.equalsIgnoreCase(departureCountry)) {
                            ((List)result.get(country)).add((Long)minutesInCountries.get(country));
                        } else {
                            ((List)result.get(country)).set(domesticMinutes.size() - 1, (Long)((List)result.get(country)).get(domesticMinutes.size() - 1) + (Long)minutesInCountries.get(country));
                        }
                    } else {
                        if (TripTimeCalculator.notDomesticCountryWithArrivalInDomesticWithoutMinutes(country, minutesInCountries, arrivalCountry, domesticCountryName) && !config.getZagranica().getSumowac_czas_w_kraju_do_liczenia_delegacji().booleanValue() && result.get(domesticCountryName) != null) {
                            ((List)result.get(domesticCountryName)).add(0L);
                        }
                        result.compute((String)country, (key, value) -> {
                            if (value == null) {
                                ArrayList<Long> minutesArray = new ArrayList<Long>();
                                minutesArray.add((Long)minutesInCountries.get(key));
                                return minutesArray;
                            }
                            value.set(0, (Long)value.get(0) + (Long)minutesInCountries.get(key));
                            return value;
                        });
                    }
                });
                minutesInCountries.clear();
            }
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new HashMap<String, List<Long>>();
        }
    }

    private static boolean notDomesticCountryWithArrivalInDomesticWithoutMinutes(String country, Map<String, Long> minutesInCountries, String arrivalCountry, String domesticCountryName) {
        return !domesticCountryName.equalsIgnoreCase(country) && minutesInCountries.size() == 1 && domesticCountryName.equalsIgnoreCase(arrivalCountry);
    }

    private static Map<RoutePartType, Long> splitRouteAtBorder(DateTime arrivalDate, DateTime departureDate, String crossBorderDate, String crossBorderTime) {
        HashMap<RoutePartType, Long> splittedRoute = new HashMap<RoutePartType, Long>();
        DateTime dateBorderCross = DateTime.parse((String)(crossBorderDate + " " + crossBorderTime), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm"));
        long timeToBorder = Minutes.minutesBetween((ReadableInstant)departureDate, (ReadableInstant)dateBorderCross).getMinutes();
        long timeFromBorder = Minutes.minutesBetween((ReadableInstant)dateBorderCross, (ReadableInstant)arrivalDate).getMinutes();
        splittedRoute.put(RoutePartType.TO_THE_BORDER, timeToBorder);
        splittedRoute.put(RoutePartType.FROM_THE_BORDER, timeFromBorder);
        return splittedRoute;
    }
}

