/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.config.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.suncode.businesstrip.config.data.CustomDateDeserializer;
import com.suncode.businesstrip.config.data.DomesticConf;
import com.suncode.businesstrip.config.data.ForeignConf;
import com.suncode.businesstrip.config.data.LocalDateSerializer;
import com.suncode.businesstrip.settlement.SettlementCountry;
import com.suncode.businesstrip.util.Translation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.LocalDate;

public class JsonConf {
    @JsonSerialize(using=LocalDateSerializer.class)
    private LocalDate effectiveDate;
    private SettlementCountry settlement_country;
    private Map<String, String> before_save_on_map = new HashMap<String, String>();
    private Integer minimum_distance_for_diet_calculation;
    private DomesticConf kraj;
    private ForeignConf zagranica;
    private Set<String> kilometrowka_dla = new HashSet<String>();
    private Set<String> wymog_ewidencji_pojazdu = new HashSet<String>();
    private List<List<String>> kilometrowka = new ArrayList<List<String>>();
    private List<String[]> wydatki_waluty = new ArrayList<String[]>();
    private List<List<String>> srodek_transportu = new ArrayList<List<String>>();
    private String nawa_polskiej_waluty;
    private String currency_name;
    private String domesticCountryName;
    private Boolean hideFinancedPublicTransport;
    private Boolean hideFinancedCommutingToFromStation;
    private Boolean hideFinancedAccommodation;

    @JsonProperty(value="before_save_on_map")
    public Map<String, String> getBeforeSaveOnMap() {
        return this.before_save_on_map;
    }

    @JsonProperty(value="kraj")
    public DomesticConf getKraj() {
        return this.kraj;
    }

    public void setKraj(DomesticConf kraj) {
        this.kraj = kraj;
    }

    @JsonProperty(value="zagranica")
    public ForeignConf getZagranica() {
        return this.zagranica;
    }

    public void setZagranica(ForeignConf zagranica) {
        this.zagranica = zagranica;
    }

    @JsonProperty(value="kilometrowka_dla")
    public Set<String> getKilometrowkaDla() {
        return this.kilometrowka_dla;
    }

    public void setKilometrowka_dla(Set<String> kilometrowka_dla) {
        this.kilometrowka_dla = kilometrowka_dla;
    }

    public void setKilometrowka(List<List<String>> kilometrowka) {
        this.kilometrowka = kilometrowka;
    }

    @JsonProperty(value="kilometrowka")
    public List<List<String>> getKilometrowka() {
        this.kilometrowka.forEach(k -> k.add(Translation.getCustomMessage((String)k.get(0))));
        return this.kilometrowka;
    }

    public List<List<String>> getKilometrowkaWithoutTranslations() {
        return this.kilometrowka;
    }

    @JsonProperty(value="wydatki_waluty")
    public List<String[]> getWydatki_waluty() {
        return this.wydatki_waluty;
    }

    @JsonProperty(value="srodek_transportu")
    public List<List<String>> getSrodekTransportu() {
        this.srodek_transportu.forEach(k -> k.add(Translation.getCustomMessage((String)k.get(0))));
        return this.srodek_transportu;
    }

    public List<List<String>> getSrodekTransportuWithoutTranslations() {
        return this.srodek_transportu;
    }

    @JsonProperty(value="wymog_ewidencji_pojazdu")
    public Set<String> getWymogEwidencjiPojazdu() {
        return this.wymog_ewidencji_pojazdu;
    }

    @JsonProperty(value="nawa_polskiej_waluty")
    public String getNazwaPolskiejWaluty() {
        return this.nawa_polskiej_waluty;
    }

    public void setNawa_polskiej_waluty(String nawa_polskiej_waluty) {
        this.nawa_polskiej_waluty = nawa_polskiej_waluty;
    }

    @JsonProperty(value="currency_name")
    public String getCurrencyName() {
        return this.currency_name;
    }

    public void setCurrencyName(String currency_name) {
        this.currency_name = currency_name;
    }

    @JsonProperty(value="domestic_country_name_from_kraje_array")
    public String getDomesticCountryName() {
        if (this.domesticCountryName != null) {
            return this.domesticCountryName;
        }
        return "Polska";
    }

    public void setDomesticCountryName(String domesticCountryName) {
        this.domesticCountryName = domesticCountryName;
    }

    @JsonProperty(value="effective_date")
    @JsonDeserialize(using=CustomDateDeserializer.class)
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @JsonProperty(value="minimum_distance_for_diet_calculation")
    public Integer getMinimumDistanceForDietCalculation() {
        return this.minimum_distance_for_diet_calculation != null ? this.minimum_distance_for_diet_calculation : 0;
    }

    public void setMinimumDistanceForDietCalculation(Integer minimum_distance_for_diet_calculation) {
        this.minimum_distance_for_diet_calculation = minimum_distance_for_diet_calculation;
    }

    @JsonProperty(value="settlement_country")
    public SettlementCountry getSettlementCountry() {
        if (this.settlement_country == null) {
            return SettlementCountry.POLAND;
        }
        return this.settlement_country;
    }

    public void setSettlementCountry(SettlementCountry settlement_country) {
        this.settlement_country = settlement_country;
    }

    @JsonProperty(value="hide_financed_public_transport")
    public Boolean getHideFinancedPublicTransport() {
        return this.hideFinancedPublicTransport;
    }

    public void setHideFinancedPublicTransport(Boolean hideFinancedPublicTransport) {
        this.hideFinancedPublicTransport = hideFinancedPublicTransport;
    }

    @JsonProperty(value="hide_financed_commuting_to_from_station")
    public Boolean getHideFinancedCommutingToFromStation() {
        return this.hideFinancedCommutingToFromStation;
    }

    public void setHideFinancedCommutingToFromStation(Boolean hideFinancedCommutingToFromStation) {
        this.hideFinancedCommutingToFromStation = hideFinancedCommutingToFromStation;
    }

    @JsonProperty(value="hide_financed_accommodation")
    public Boolean getHideFinancedAccommodation() {
        return this.hideFinancedAccommodation;
    }

    public void setHideFinancedAccommodation(Boolean hideFinancedAccommodation) {
        this.hideFinancedAccommodation = hideFinancedAccommodation;
    }

    public void overWriteWithoutTranslations(JsonConf updatedConf) {
        if (updatedConf == null) {
            return;
        }
        if (updatedConf.getBeforeSaveOnMap() != null && updatedConf.getBeforeSaveOnMap().size() > 0) {
            this.before_save_on_map = updatedConf.getBeforeSaveOnMap();
        }
        this.kraj.overWrite(updatedConf.getKraj());
        this.zagranica.overWriteWithoutTranslations(updatedConf.getZagranica());
        if (updatedConf.getKilometrowkaDla() != null && updatedConf.getKilometrowkaDla().size() > 0) {
            this.kilometrowka_dla = updatedConf.getKilometrowkaDla();
        }
        if (updatedConf.getWymogEwidencjiPojazdu() != null && updatedConf.getWymogEwidencjiPojazdu().size() > 0) {
            this.wymog_ewidencji_pojazdu = updatedConf.getWymogEwidencjiPojazdu();
        }
        if (updatedConf.getKilometrowkaWithoutTranslations() != null && updatedConf.getKilometrowkaWithoutTranslations().size() > 0) {
            this.kilometrowka = updatedConf.getKilometrowkaWithoutTranslations();
        }
        if (updatedConf.getWydatki_waluty() != null && updatedConf.getWydatki_waluty().size() > 0) {
            this.wydatki_waluty = updatedConf.getWydatki_waluty();
        }
        if (updatedConf.getSrodekTransportuWithoutTranslations() != null && updatedConf.getSrodekTransportuWithoutTranslations().size() > 0) {
            this.srodek_transportu = updatedConf.getSrodekTransportuWithoutTranslations();
        }
        if (updatedConf.getNazwaPolskiejWaluty() != null) {
            this.nawa_polskiej_waluty = updatedConf.getNazwaPolskiejWaluty();
        }
        if (updatedConf.getCurrencyName() != null) {
            this.currency_name = updatedConf.getCurrencyName();
        }
        if (updatedConf.getSettlementCountry() != null) {
            this.settlement_country = updatedConf.getSettlementCountry();
        }
        if (updatedConf.getDomesticCountryName() != null) {
            this.domesticCountryName = updatedConf.getDomesticCountryName();
        }
        if (updatedConf.getMinimumDistanceForDietCalculation() != null) {
            this.minimum_distance_for_diet_calculation = updatedConf.getMinimumDistanceForDietCalculation();
        }
        if (updatedConf.getHideFinancedPublicTransport() != null) {
            this.hideFinancedPublicTransport = updatedConf.getHideFinancedPublicTransport();
        }
        if (updatedConf.getHideFinancedCommutingToFromStation() != null) {
            this.hideFinancedCommutingToFromStation = updatedConf.getHideFinancedCommutingToFromStation();
        }
        if (updatedConf.getHideFinancedAccommodation() != null) {
            this.hideFinancedAccommodation = updatedConf.getHideFinancedAccommodation();
        }
    }
}

