/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.businesstrip.config.Configuration;
import com.suncode.businesstrip.config.ConfigurationService;
import com.suncode.businesstrip.config.data.ActionConf;
import com.suncode.businesstrip.config.data.ExchangeSettings;
import com.suncode.businesstrip.config.data.InputParams;
import com.suncode.businesstrip.config.data.JsonConf;
import com.suncode.businesstrip.config.data.OtherParams;
import com.suncode.businesstrip.config.data.OutputParams;
import com.suncode.businesstrip.config.data.PdfConf;
import com.suncode.businesstrip.dto.ActionConfDto;
import com.suncode.businesstrip.dto.ExchangeSettingsDto;
import com.suncode.businesstrip.dto.InputParamsDto;
import com.suncode.businesstrip.dto.OtherParamsDto;
import com.suncode.businesstrip.dto.OutputParamsDto;
import com.suncode.businesstrip.dto.PdfConfDto;
import com.suncode.businesstrip.settlement.SettlementCountry;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.exception.NoSuchConfigurationException;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="configurationService")
public class ConfigurationServiceImpl
implements ConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationServiceImpl.class);
    public static final String DEFAULT_CONFIG_PATH = "config/businessTripDefaultConfig.json";
    public static final String CUSTOM_CONFIG_PATH = "config/businessTripCustomConfig.json";
    public static final String CONFIGURATION_READABLE_ID = "config";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private Plugin plugin;
    @Autowired
    private ConfigurationFileService configurationFileService;

    @Override
    public void loadConfiguration() {
        List<JsonConf> configs = this.getAllConfigs();
        configs.forEach(config -> {
            if (config.getEffectiveDate() == null) {
                config.setEffectiveDate(LocalDate.parse((String)"1999-01-01"));
            }
        });
        Configuration.setAllJsonConfigs(configs);
    }

    @Override
    public List<JsonConf> getAllConfigs() throws IOException {
        ArrayList<JsonConf> allConfigs = new ArrayList<JsonConf>();
        try {
            String[] configsFiles;
            for (String configFile : configsFiles = this.configurationFileService.getAllReadableFilesIds(this.plugin.getKey())) {
                JsonConf config = this.getJsonConfig(configFile);
                if (config == null) continue;
                allConfigs.add(config);
            }
        }
        catch (NoSuchConfigurationException ex) {
            log.warn("Configuration file does not exist");
        }
        return allConfigs;
    }

    private JsonConf getJsonConfig(String configFile) throws IOException {
        JsonConf jsonConf;
        block8: {
            InputStream inputStream = this.configurationFileService.readFile(this.plugin.getKey(), configFile);
            try {
                String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                jsonConf = (JsonConf)objectMapper.readValue(content, JsonConf.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonProcessingException e) {
                    log.error("Wrong JSON format in config file {}. Error: {}", (Object)configFile, (Object)e);
                    return null;
                }
            }
            inputStream.close();
        }
        return jsonConf;
    }

    @Override
    public void save(ActionConfDto params) {
        ActionConf actionConf = new ActionConf();
        this.saveInputParams(params.getInputParams(), actionConf);
        this.saveOutputParams(params.getOutputParams(), actionConf);
        this.saveSummaryPdfParams(params.getGeneratingSettlementSummaryPdf(), actionConf);
        this.saveCardPdfParams(params.getGeneratingCarCardPdf(), actionConf);
        this.saveExchangeParams(params.getExchangeForForeignBusinessTripsSettlement(), actionConf);
        this.saveSpendingTypesParam(params.getSpendingTypes(), actionConf);
        this.savePaymentMethodsParam(params.getPaymentMethods(), actionConf);
        this.saveDocumentTypesParam(params.getDocumentTypes(), actionConf);
        this.saveFieldsToHideParam(params.getFieldsToHide(), actionConf);
        this.saveOtherParams(params.getOtherParams(), actionConf);
        this.saveActivityVariableParams(params.getActivityVariableParams(), actionConf);
        this.saveAdvancesParams(params.getAdvanceAmounts(), params.getAdvanceCurrencies(), actionConf);
        Configuration.setActionConf(actionConf);
    }

    private void saveInputParams(InputParamsDto inputParamsDto, ActionConf actionConf) {
        InputParams inputParams = new InputParams();
        inputParams.setActivityId(inputParamsDto.getActivityId());
        inputParams.setAdvanceDate(inputParamsDto.getAdvanceDate());
        inputParams.setCity(inputParamsDto.getCity());
        inputParams.setCountry(inputParamsDto.getCountry());
        inputParams.setFinishDate(inputParamsDto.getFinishDate());
        inputParams.setGoal(inputParamsDto.getGoal());
        inputParams.setId(inputParamsDto.getId());
        inputParams.setPersonName(inputParamsDto.getPersonName());
        inputParams.setProcessId(inputParamsDto.getProcessId());
        inputParams.setStartDate(inputParamsDto.getStartDate());
        inputParams.setTransportType(inputParamsDto.getTransportType());
        inputParams.setType(inputParamsDto.getType());
        inputParams.setTransport(inputParamsDto.getTransport());
        inputParams.setVehicleBrand(inputParamsDto.getVehicleBrand());
        inputParams.setRegistrationNumber(inputParamsDto.getRegistrationNumber());
        inputParams.setVehicleUserAddress(inputParamsDto.getVehicleUserAddress());
        inputParams.setEngineCapacity(inputParamsDto.getEngineCapacity());
        actionConf.setInputParams(inputParams);
    }

    private void saveActivityVariableParams(Map<String, Object> activityVariableParams, ActionConf actionConf) {
        actionConf.setActivityVariableParams(activityVariableParams);
    }

    private void saveAdvancesParams(Double[][] advanceAmounts, String[][] advanceCurrencies, ActionConf actionConf) {
        actionConf.setAdvanceAmounts(advanceAmounts);
        actionConf.setAdvanceCurrencies(advanceCurrencies);
    }

    private void saveOutputParams(OutputParamsDto outputParamsDto, ActionConf actionConf) {
        OutputParams outputParams = new OutputParams();
        outputParams.setSpendingsTableParams(outputParamsDto.getSpendingsTableParams());
        outputParams.setSummaryTableParams(outputParamsDto.getSummaryTableParams());
        outputParams.setCostsTableParams(outputParamsDto.getCostsTableParams());
        actionConf.setOutputParams(outputParams);
    }

    private void saveSummaryPdfParams(PdfConfDto generatingSettlementSummaryPdf, ActionConf actionConf) {
        PdfConf summaryPdf = new PdfConf();
        summaryPdf.setRun(generatingSettlementSummaryPdf.getRun());
        summaryPdf.setDocumentClass(generatingSettlementSummaryPdf.getDocumentClass());
        summaryPdf.setTemplateName(generatingSettlementSummaryPdf.getTemplateName());
        actionConf.setSummaryPdf(summaryPdf);
    }

    private void saveCardPdfParams(PdfConfDto generatingCarCardPdf, ActionConf actionConf) {
        PdfConf cardPdf = new PdfConf();
        cardPdf.setRun(generatingCarCardPdf.getRun());
        cardPdf.setDocumentClass(generatingCarCardPdf.getDocumentClass());
        cardPdf.setTemplateName(generatingCarCardPdf.getTemplateName());
        actionConf.setCardPdf(cardPdf);
    }

    private void saveExchangeParams(ExchangeSettingsDto exchangeForForeignBusinessTripsSettlement, ActionConf actionConf) {
        ExchangeSettings exchangeSettings = new ExchangeSettings();
        exchangeSettings.setStageWithContinuouslyRefreshedExchange(exchangeForForeignBusinessTripsSettlement.getStageWithContinuouslyRefreshedExchange());
        exchangeSettings.setRefreshingTodayOrFromField(exchangeForForeignBusinessTripsSettlement.getRefreshingTodayOrFromField());
        exchangeSettings.setExchangeRateDateType(exchangeForForeignBusinessTripsSettlement.getExchangeRateDateType());
        exchangeSettings.setIdReadFieldName(exchangeForForeignBusinessTripsSettlement.getIdReadFieldName());
        exchangeSettings.setExchangeRateSource(exchangeForForeignBusinessTripsSettlement.getExchangeRateSource());
        exchangeSettings.setExchangeRateDataSourceId(exchangeForForeignBusinessTripsSettlement.getExchangeRateDataSourceId());
        exchangeSettings.setDatasourceInputParametersId(exchangeForForeignBusinessTripsSettlement.getDatasourceInputParametersId());
        exchangeSettings.setDatasourceInputParametersValue(exchangeForForeignBusinessTripsSettlement.getDatasourceInputParametersValue());
        actionConf.setExchangeSettings(exchangeSettings);
    }

    private void saveSpendingTypesParam(String[][] spendingTypes, ActionConf actionConf) {
        actionConf.setSpendingTypes(spendingTypes);
    }

    private void savePaymentMethodsParam(String[][] paymentMethods, ActionConf actionConf) {
        actionConf.setPaymentMethods(paymentMethods);
    }

    private void saveDocumentTypesParam(String[][] documentTypes, ActionConf actionConf) {
        actionConf.setDocumentTypes(documentTypes);
    }

    private void saveFieldsToHideParam(Set<String> fieldsToHide, ActionConf actionConf) {
        actionConf.setFieldsToHide(fieldsToHide);
    }

    private void saveOtherParams(OtherParamsDto otherParamsDto, ActionConf actionConf) {
        OtherParams otherParams = new OtherParams();
        otherParams.setIsReadOnlyMode(otherParamsDto.getIsReadOnlyMode());
        otherParams.setIsSettlementWindowVisible(otherParamsDto.getIsSettlementWindowVisible());
        otherParams.setIsSpendingTableVisible(otherParamsDto.getIsSpendingTableVisible());
        otherParams.setIsWarningIfDatesNotSynchronized(otherParamsDto.getIsWarningIfDatesNotSynchronized());
        otherParams.setItsHistoryView(otherParamsDto.getItsHistoryView());
        otherParams.setIsGridValuesCentered(otherParamsDto.getIsGridValuesCentered());
        SettlementCountry settlementCountry = null;
        if (otherParamsDto.getSettlementCountry() != null) {
            try {
                settlementCountry = SettlementCountry.valueOf(otherParamsDto.getSettlementCountry());
            }
            catch (IllegalArgumentException e) {
                log.warn("Nieznany kraj: {}, u\u017cywam domy\u015blnego {}", (Object)otherParamsDto.getSettlementCountry(), (Object)SettlementCountry.POLAND);
                settlementCountry = SettlementCountry.POLAND;
            }
        }
        otherParams.setSettlementCountry(settlementCountry);
        actionConf.setOtherParams(otherParams);
    }
}

