﻿// BUTTONY KRAJE DOCELOWE
function DM_add_ilosciowe_new_btn_handler() {
  var form = Ext.getCmp('DM.form.add_ilosciowe');
  if (!form.getForm().isValid()) {
    return;
  }

  var data = new Ext.data.Record(Ext.getCmp('DM.form.add_ilosciowe').getForm().getFieldValues());

  // dodaje wiersz
  DM.store.ilosciowe.add(data);

  DM.win.add_ilosciowe.hide();
}

function DM_new_kraj_docelowy_ilosciowe_handler() {
  Ext.getCmp('DM.form.add_ilosciowe').getForm().reset();
  DM.win.add_ilosciowe.show();
}

function DM_del_kraj_docelowy_ilosciowe_handler() {
  var sm = DM.grid.ilosciowe.getSelectionModel();
  if (
    typeof sm.selection === 'undefined' ||
    sm.selection === null ||
    typeof sm.selection.cell[0] === 'undefined' ||
    sm.selection.cell[0] === null
  ) {
    DM_infoMsg(DM.translator.m('quantities.targetCountry.validationMsg3'));
    return;
  }
  var row_usunac = DM.store.ilosciowe.getAt(sm.selection.cell[0]);

  if (row_usunac.get('kraj') === 'Polska') {
    DM_warningMsg(DM.translator.m('quantities.targetCountry.validationMsg4'));
    return;
  }

  DM.store.ilosciowe.remove(row_usunac);
  // odsiwezenie grida z panstwami docelowymi
  DM.grid.ilosciowe.getView().refresh();
}

// BUTTONY GRID TRASY
function DM_new_odcinek_trasa_handler() {
  // ustawienie typu formu z dodawaniem modyfikacja -
  // potrzebne do
  // walidacji
  DM.typform_addmod = 'add';

  // ustawia pusty formularz
  Ext.getCmp('DM.addmod.form').getForm().reset();
  Ext.getCmp('DM.addmod.form.km').setValue(0);
  if (DM.data.typ_delegacji === 'zagranica') {
    Ext.getCmp('DM.addmod.form.wyjazd_kraj').enable();
  }

  // przepisanie dat z wniosku lub z poprzedniego wiersza
  // rozliczenia trasy
  var grid_length = DM.store.trasa.getCount();
  if (grid_length === 0) {
    var odjazd_wniosek = Ext.getCmp('DM.podst.data_odjazdu').getValue();
    // var powrot_wniosek = Ext.getCmp( 'DM.podst.data_powrotu'
    // ).getValue();

    // pobranie pol
    var form_data = Ext.getCmp('DM.addmod.form').getForm().getFieldValues();
    var form_data_clone = {};
    DM_clone(form_data_clone, row_data);

    // wyczyszczenie pól
    for (var member in form_data_clone) {
      if (form_data_clone.hasOwnProperty(member)) {
        form_data_clone[member] = '';
      }
    }

    form_data_clone.wyjazd_data = odjazd_wniosek;
    // form_data_clone.przyjazd_data = powrot_wniosek;
    form_data_clone.przyjazd_data = odjazd_wniosek;

    // ustawienie kraju wyjazdu z 1 odcinka na polske w przypadku
    // zagranicznej delegacji
    if (DM.data.typ_delegacji === 'zagranica') {
      form_data_clone.wyjazd_kraj = 'Polska';
      Ext.getCmp('DM.addmod.form.wyjazd_kraj').disable();
    }

    Ext.getCmp('DM.addmod.form').getForm().setValues(form_data_clone);
  } else {
    var row_data = DM.store.trasa.getAt(grid_length - 1).data;

    // robi kopie danych tak by nie zmodyfikowac stora
    var form_data = {};
    DM_clone(form_data, row_data);
    DM_swap_wyjazd_przyjazd(form_data);
    DM_clean_przyjazd(form_data);
    form_data.km = 0;

    Ext.getCmp('DM.addmod.form').getForm().setValues(form_data);
  }

  // ukrywa buttony
  Ext.getCmp('DM.addmod.button.add').setVisible(true);
  Ext.getCmp('DM.addmod.button.change').setVisible(false);

  // zablokowanie mozliwosci wpisanie daty oraz godziny przekroczenia granicy
  if (DM.data.typ_delegacji === 'zagranica') {
    DM_addmod_trasa_wlacz_wylacz_granice();
  }

  DM.win.addmod.setTitle(DM.translator.m('route.add.window.tittle'));
  DM.win.addmod.show();
}

function DM_new_under_odcinek_trasa_handler() {
  var record,
    sm = DM.grid.trasa.getSelectionModel();
  if (sm && Ext.isNumber(sm.lastActive)) {
    record = DM.store.trasa.getAt(sm.lastActive);
  }
  if (!record) {
    DM_infoMsg(DM.translator.m('route.add.validationMsg'));
    return;
  }

  // ustawienie typu formu z dodawaniem modyfikacja -
  // potrzebne do
  // walidacji
  DM.typform_addmod = 'add_select';

  // ustawia pusty formularz i wlacza pole wyjazd_kraj
  Ext.getCmp('DM.addmod.form').getForm().reset();
  if (DM.data.typ_delegacji === 'zagranica') {
    Ext.getCmp('DM.addmod.form.wyjazd_kraj').enable();
  }

  // przepisanie danych z wybranego wiersza
  var form_data = {};
  DM_clone(form_data, record.data);
  DM_swap_wyjazd_przyjazd(form_data);
  form_data.km = 0;

  // przepisanie danych z nastepnego odcinka
  if (sm.lastActive < DM.store.trasa.getCount() - 1) {
    var nastepny_record = DM.store.trasa.getAt(sm.lastActive + 1).data;
    DM_set_przyjazd_like_wyjazd(form_data, nastepny_record);
  } else {
    DM_clean_przyjazd(form_data);
  }

  Ext.getCmp('DM.addmod.form').getForm().setValues(form_data);

  // ukrywa buttony
  Ext.getCmp('DM.addmod.button.add').setVisible(true);
  Ext.getCmp('DM.addmod.button.change').setVisible(false);

  // zablokowanie mozliwosci wpisanie daty oraz godziny przekroczenia granicy
  if (DM.data.typ_delegacji === 'zagranica') {
    DM_addmod_trasa_wlacz_wylacz_granice();
  }

  DM.win.addmod.setTitle(DM.translator.m('route.add.window.tittle'));
  DM.win.addmod.show();
}

function DM_mod_odcinek_trasa_handler() {
  // ustawienie typu formu z dodawaniem modyfikacja
  DM.typform_addmod = 'mod';

  var sm = DM.grid.trasa.getSelectionModel();
  if (typeof sm.lastActive === 'undefined' || sm.lastActive === null || sm.lastActive === false) {
    DM_infoMsg(DM.translator.m('route.change.validationMsg'));
    return;
  }
  if (DM.data.typ_delegacji === 'zagranica') {
    if (sm.lastActive === 0) {
      Ext.getCmp('DM.addmod.form.wyjazd_kraj').disable();
    } else {
      Ext.getCmp('DM.addmod.form.wyjazd_kraj').enable();
    }
  }

  Ext.getCmp('DM.addmod.button.add').setVisible(false);
  Ext.getCmp('DM.addmod.button.change').setVisible(true);

  Ext.getCmp('DM.addmod.form').getForm().reset();
  DM.win.addmod.setTitle(DM.translator.m('route.update.window.tittle'));
  DM.win.addmod.show();
  Ext.getCmp('DM.addmod.form').getForm().loadRecord(sm.getSelected());
  Ext.getCmp('DM.addmod.form').getForm().isValid();

  // zablokowanie mozliwosci wpisanie daty oraz godziny przekroczenia granicy
  if (DM.data.typ_delegacji === 'zagranica') {
    DM_addmod_trasa_wlacz_wylacz_granice();
  }
}

function DM_del_odcinek_trasa_handler() {
  var sm = DM.grid.trasa.getSelectionModel();
  if (typeof sm.lastActive === 'undefined' || sm.lastActive === null || sm.lastActive === false) {
    DM_infoMsg(DM.translator.m('route.delete.validationMsg1'));
    return;
  }

  // nie mozna usunac wyjazdu z polski (pierwszy odcinek) jezeli znajduja sie
  // inne odcinki w tabeli
  // dla zagranicy nie mozna usunac 1 wiersza (polska -> do innego panstwa)
  if (DM.data.typ_delegacji === 'zagranica') {
    if (DM.store.trasa.getCount() > 1) {
      for (var i = 0; i < sm.getSelections().length; ++i) {
        if (sm.getSelections()[i].get('lp') === 1) {
          DM_infoMsg(DM.translator.m('route.delete.validationMsg2'));
          return;
        }
      }
    }
  }
  DM.store.trasa.remove(sm.getSelections());

  // generowanie numerow lp
  var i = 1;
  for (i = 0; i < DM.store.trasa.data.length; ++i) {
    DM.store.trasa.data.items[i].data.lp = i + 1;
  }
  DM.grid.trasa.getView().refresh();
}

// BUTTONY OKNA DO DODAWANIA ODCINKOW TRASY
function DM_addmod_usun_przekroczenie_granicy_z_form(dane_z_forma) {
  // usuniecie daty oraz godziny przekroczenia granicy
  if (DM.data.typ_delegacji === 'zagranica') {
    var srodek_transportu = DM_get_srodek_transportu();
    var wyjazd_kraj = DM_get_wyjazd_kraj();
    var przyjazd_kraj = DM_get_przyjazd_kraj();

    var srodek_transportu = DM_get_srodek_transportu();
    if (DM_addmod_trasa_czy_samolot_statek(srodek_transportu) && wyjazd_kraj !== przyjazd_kraj) {
      return false;
    }

    if (!DM_addmod_trasa_valid_czy_wymagana_granica()) {
      Ext.apply(dane_z_forma, {
        data_przekroczenia_granicy: '',
        godzina_przekroczenia_granicy: '',
      });
    }
  }
}

function DM_addmod_change_btn_handler(b, e) {
  var form = Ext.getCmp('DM.addmod.form');
  if (!form.getForm().isValid()) {
    DM_warningMsg(DM.translator.m('illegalData.validationMsg'));
    return;
  }

  var sm = DM.grid.trasa.getSelectionModel();
  var record_z_grida = DM.store.trasa.getAt(sm.lastActive).data;
  var lp_z_grida = record_z_grida.lp;

  var dane_z_forma = {};
  DM_clone(dane_z_forma, Ext.getCmp('DM.addmod.form').getForm().getFieldValues());
  dane_z_forma.lp = lp_z_grida;

  if (DM.data.typ_delegacji === 'zagranica') {
    var data_przekroczenia_granicy = Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy').getValue();
    var godzina_przekroczenia_granicy = Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy').getValue();
    if (typeof data_przekroczenia_granicy !== 'string') {
      dane_z_forma.data_przekroczenia_granicy = DM_date_to_string(data_przekroczenia_granicy);
    } else {
      dane_z_forma.data_przekroczenia_granicy = data_przekroczenia_granicy;
    }
    dane_z_forma.godzina_przekroczenia_granicy = godzina_przekroczenia_granicy;
  }

  // tylko zagranica
  DM_addmod_usun_przekroczenie_granicy_z_form(dane_z_forma);

  DM.store.trasa.getAt(sm.lastActive).data = dane_z_forma;
  DM.store.trasa.getAt(sm.lastActive).commit();

  if (DM.data.typ_delegacji === 'zagranica') {
    if (sm.lastActive === 0) {
      DM.store.trasa.getAt(sm.lastActive).set('wyjazd_kraj', 'Polska');
      DM.store.trasa.getAt(sm.lastActive).commit();
    }
    // update kraju przyjazdu oraz wyjazdu
    if (sm.lastActive > 0) {
      var przyjazd_kraj = DM.store.trasa.getAt(sm.lastActive - 1).get('przyjazd_kraj');
      if (dane_z_forma.wyjazd_kraj !== przyjazd_kraj) {
        DM.store.trasa.getAt(sm.lastActive - 1).set('przyjazd_kraj', dane_z_forma.wyjazd_kraj);
        DM.store.trasa.getAt(sm.lastActive - 1).commit();
      }
    }
    if (sm.lastActive < DM.store.trasa.getCount() - 1) {
      var wyjazd_kraj = DM.store.trasa.getAt(sm.lastActive + 1).get('wyjazd_kraj');
      if (dane_z_forma.przyjazd_kraj !== wyjazd_kraj) {
        DM.store.trasa.getAt(sm.lastActive + 1).set('wyjazd_kraj', dane_z_forma.przyjazd_kraj);
        DM.store.trasa.getAt(sm.lastActive + 1).commit();
      }
    }
  }
  // odsiwezenie grida
  DM.grid.trasa.getView().refresh();

  DM_obliczLacznaIloscKm(DM.store.trasa);

  DM.win.addmod.hide();
}

function DM_addmod_new_btn_handler(b, e) {
  var form = Ext.getCmp('DM.addmod.form');
  if (!form.getForm().isValid()) {
    return;
  }

  var data = new Ext.data.Record(Ext.getCmp('DM.addmod.form').getForm().getFieldValues());

  // gdy form dodaje do ostatniego wiersza - przycisk
  // dodaj
  if (DM.typform_addmod === 'add') {
    var lp = DM.store.trasa.getRange().length + 1;

    Ext.apply(data.data, {
      lp: lp,
    });

    // gdy dodawany jako pierwszy i pole jest wylaczone trzeba dodac wiersz
    // z palca...
    if (DM.data.typ_delegacji === 'zagranica') {
      if (DM.store.trasa.getCount() === 0) {
        Ext.apply(data.data, {
          wyjazd_kraj: 'Polska',
        });
      }

      // tylko zagranica
      DM_addmod_usun_przekroczenie_granicy_z_form(data.data);

      var data_przekroczenia_granicy = Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy').getValue();
      var godzina_przekroczenia_granicy = Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy').getValue();
      if (typeof data_przekroczenia_granicy !== 'string') {
        data.data.data_przekroczenia_granicy = DM_date_to_string(data_przekroczenia_granicy);
      } else {
        data.data.data_przekroczenia_granicy = data_przekroczenia_granicy;
      }
      data.data.godzina_przekroczenia_granicy = godzina_przekroczenia_granicy;
    }

    // dodaje wiersz
    DM.store.trasa.add(data);
  }
  // gdy form dodaje pod zaznaczonych wierszem - przycisk
  // dodaj pod zaznaczonym
  if (DM.typform_addmod === 'add_select') {
    var sm = DM.grid.trasa.getSelectionModel();
    var index_choose = sm.lastActive;
    var last_idx = DM.store.trasa.getCount() - 1;

    var rows_beneath;
    if (index_choose < last_idx) {
      rows_beneath = DM.store.trasa.getRange(index_choose + 1);
      DM.store.trasa.remove(rows_beneath);
    }

    var lp = index_choose + 2;
    Ext.apply(data.data, {
      lp: lp,
    });

    // tylko zagranica
    DM_addmod_usun_przekroczenie_granicy_z_form(data.data);

    if (DM.data.typ_delegacji === 'zagranica') {
      var data_przekroczenia_granicy = Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy').getValue();
      var godzina_przekroczenia_granicy = Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy').getValue();
      if (typeof data_przekroczenia_granicy !== 'string') {
        data.data.data_przekroczenia_granicy = DM_date_to_string(data_przekroczenia_granicy);
      } else {
        data.data.data_przekroczenia_granicy = data_przekroczenia_granicy;
      }
      data.data.godzina_przekroczenia_granicy = godzina_przekroczenia_granicy;
    }

    // dodaje wiersz
    DM.store.trasa.add(data);

    // dodaje pozostale wiersze
    if (index_choose < last_idx) {
      DM.store.trasa.add(rows_beneath);
    }

    // wygenerowanie nowych lp
    var i = 1;
    for (i = 0; i < DM.store.trasa.getCount(); ++i) {
      DM.store.trasa.data.items[i].data.lp = i + 1;
    }
    DM.grid.trasa.getView().refresh();
  }

  DM.store.trasa.commitChanges();

  DM_obliczLacznaIloscKm(DM.store.trasa);

  DM.win.addmod.hide();
}

// GENEROWANIE PDF I PODLACZANIE POD PROCES
function DM_generujPDFiPodlacz(process_id, activity_id, typ_delegacji, nr_delegacji) {
  if (typeof DM.conf.actionConf.summaryPdf === 'undefined' || typeof DM.conf.actionConf.cardPdf === 'undefined') {
    DM_errorMsg(DM.translator.m('document.generate.errorMsg') + DM.translator.m('document.generate.errorMsg.blankPdfConfig'));

    return false;
  }

  var generatePDFid = 'DM_generate_pdf_mask_id';
  var isRequestError = false;
  var detailMsgKey;

  //TODO tutaj gdyby wtyczka odpalała się nie w osobnym oknie ale jako normalny formularz który ma CUF'a i inne dostępne na formularzu servisy
  //to można by skorzystać z gotowca który wygeneruje i podłaczy pdfy do procesu
  //tj. CUF.WordTemplateService.generate
  DM_showLoadingMask(generatePDFid, DM.translator.m('document.loadingText'));
  setTimeout(
    function () {
      if (DM.conf.actionConf.cardPdf.run == true || DM.conf.actionConf.summaryPdf.run == true) {
        jQuery.ajax({
          type: 'POST',
          url: 'generateAndLink',
          data: {
            processId: DM.data.zm_procesu.process_id,
            activityId: DM.data.zm_procesu.activity_id,
            type: DM.data.typ_delegacji,
            id: DM.data.zm_procesu.nr_delegacji,
          },
          async: false,
          success: function (response) {
            if (!response.success) {
              isRequestError = true;
              detailMsgKey = response.message;
            } else {
              PW.ui.Message.show(DM.translator.m('document.successText'), 'success');
            }
          },
          error: function () {
            isRequestError = true;
          },
        });
      }

      if (isRequestError) {
        var detailMessage = '';
        if (detailMsgKey != undefined) {
          detailMessage = ' ' + DM.translator.m(detailMsgKey);
        }
        DM_errorMsg(DM.translator.m('document.generate.errorMsg') + detailMessage);
      } else {
        DM_goToActivity(DM.data.zm_procesu.activity_id, DM.data.zm_procesu.process_id);
      }
      DM_removeLoadingMask(generatePDFid);
    },
    1,
    this
  );
}

// ODCZYT ZAPIS DANYCH
// funkcja odpalajaca servlet zapisujacy i rozliczajacy delegacje
function DM_zapisanieDanych(DM, oblicz) {
  // sprawdzenie czy komentarz jest valid
  if (!Ext.getCmp('DM.form.inne.uwagi').isValid()) {
    DM_errorMsg(DM.translator.m('comments.validatorMsg'));
    return false;
  }
  // sprawdzenie czy kraje sa zgodne (ostatni przyjazd = obecny wyjazd)
  if (DM.data.typ_delegacji === 'zagranica') {
    var valid_kraje = DM_valid_cala_trasa_kraje();
    if (typeof valid_kraje === 'number' && valid_kraje >= 0) {
      valid_kraje = valid_kraje + 1;
      DM_errorMsg(DM.translator.m('route.countries.validationMsg', valid_kraje));
      return false;
    }
  }
  if (DM_addmod_trasa_czy_wymog_ewidencji_pojazdu()) {
    if (!DM_valid_form_ewidencja_pojazdu_pojemnosc()) {
      DM_errorMsg(DM.translator.m('main.panel.button.settle.wrong.engine.capacity'));
      return false;
    }
  }
  var valid_daty = DM_valid_cala_trasa_daty();
  if (typeof valid_daty === 'number' && valid_daty >= 0) {
    valid_daty = valid_daty + 1;
    DM_errorMsg(DM.translator.m('route.date.validationMsg5', valid_daty));
    return false;
  }

  // sprawdzenie czy data przekroczenia granic jest wprowadzona w wymaganych odcinkach
  var valid_daty_przekroczenia_granic = DM_valid_cala_trasy_daty_przekroczenia_granic();
  if (typeof valid_daty_przekroczenia_granic === 'number' && valid_daty_przekroczenia_granic >= 0) {
    valid_daty_przekroczenia_granic = valid_daty_przekroczenia_granic + 1;
    DM_errorMsg(DM.translator.m('route.date.validationMsg6', valid_daty_przekroczenia_granic));
    return false;
  }

  var trasa_store_data = [];
  Ext.each(DM.store.trasa.getRange(), function (aRecord) {
    aRecord.data.przyjazd_data = DM.conf.formatDate(aRecord.data.przyjazd_data);
    aRecord.data.wyjazd_data = DM.conf.formatDate(aRecord.data.wyjazd_data);
    aRecord.data.data_przekroczenia_granicy = DM.conf.formatDate(aRecord.data.data_przekroczenia_granicy);
    trasa_store_data.push(aRecord.data);
  });

  var ilosciowe_store_data = [];
  Ext.each(DM.store.ilosciowe.getRange(), function (aRecord) {
    ilosciowe_store_data.push(aRecord.data);
  });

  var wydatki_store_data = [];
  Ext.each(DM.store.wydatki.getRange(), function (aRecord) {
    aRecord.data.data = DM.conf.formatDate(aRecord.data.data);
    if (aRecord.json) {
      aRecord.data.wydatek_id = aRecord.json.id;
    }
    wydatki_store_data.push(aRecord.data);
  });

  // odblokowanie na chwile danych inaczej getValues() nie działa bo są disabled (na readonly działałoby)
  DM.form.podstawowe.getForm().items.each(function (f) {
    f.enable();
  });
  var podstawowe_dane = DM.form.podstawowe.getForm().getFieldValues();
  DM.form.podstawowe.getForm().items.each(function (f) {
    if (f.name !== 'czy_przekroczono_dystans_dla_diety') {
      f.disable();
    }
  });

  var responseJsonData;
  var isRequestError = false;
  var detailMsgKey;

  var dataToSave = {
    processId: DM.data.zm_procesu.process_id,
    activityId: DM.data.zm_procesu.activity_id,
    type: DM.data.typ_delegacji,
    calculate: oblicz === true ? 'TAK' : 'NIE',
    settlementCountry: DM.conf.actionConf.otherParams.settlementCountry,
    baseData: podstawowe_dane,
    transportData: DM.form.ewidencja.getForm().getValues(),
    quantitiesData: ilosciowe_store_data,
    routeData: trasa_store_data,
    spendingsData: wydatki_store_data,
    comments: DM.form.uwagi.getForm().getFieldValues().uwagi,
    advanceAmounts: DM.conf.actionConf.advanceAmounts,
    advanceCurrencies: DM.conf.actionConf.advanceCurrencies,
    activityVariableParams: DM.conf.actionConf.activityVariableParams,
  };
  jQuery.ajax({
    type: 'POST',
    url: 'settle',
    contentType: 'application/json; charset=utf-8',
    cache: false,
    data: JSON.stringify(dataToSave),
    async: false,
    success: function (response) {
      if (!response.success) {
        isRequestError = true;
        detailMsgKey = response.message;
      } else {
        //TODO tu zmienić aby zwrócony został BusinessTrip w resp. To wymaga też zmian we back-endzie
        responseJsonData = response.data;
      }
    },
    error: function () {
      isRequestError = true;
    },
  });
  if (isRequestError) {
    var detailMessage = '';
    if (detailMsgKey != undefined) {
      detailMessage = ' ' + DM.translator.m(detailMsgKey);
    }
    DM_errorMsg(DM.translator.m('settlement.settle.errorMsg') + detailMessage);
    return false;
  }

  if (oblicz === true) {
    DM.store.rozliczenie_kraj.loadData([
      {
        nazwa: DM.translator.m('settlement.diet.item'),
        wartosc: DM.conf.formatNumber(DM_set_default_to_zero(responseJsonData.dieta_kraj)) + ' ' + getUnitTranslation(),
      },
      {
        nazwa: DM.translator.m('settlement.localTransportLumpSum.item'),
        wartosc:
          DM.conf.formatNumber(DM_set_default_to_zero(responseJsonData.ryczalt_srodki_miejskie_kraj)) + ' ' + getUnitTranslation(),
      },
      {
        nazwa: DM.translator.m('settlement.accomodationLumpSum.item'),
        wartosc: DM.conf.formatNumber(DM_set_default_to_zero(responseJsonData.ryczalt_noclegi_kraj)) + ' ' + getUnitTranslation(),
      },
    ]);

    DM.store.rozliczenie_ogolne.loadData([
      {
        nazwa: DM.translator.m('settlement.general.targetCity.item'),
        wartosc: DM.data.zm_procesu.miasto_docelowe,
      },
      {
        nazwa: DM.translator.m('settlement.general.journeyLumpSum.item'),
        wartosc: DM.conf.formatNumber(DM_set_default_to_zero(responseJsonData.kilometrowka)) + ' ' + getUnitTranslation(),
      },
    ]);
    if (DM.data.typ_delegacji === 'kraj') {
      DM.store.rozliczenie_wydatkow.loadData([
        {
          nazwa: DM.translator.m('spendings.poland.title'),
          wartosc: DM.conf.formatNumber(DM_set_default_to_zero(responseJsonData.suma_wydatki)) + ' ' + getUnitTranslation(),
        },
      ]);
    } else {
      DM.store.rozliczenie_wydatkow.loadData([
        {
          nazwa: DM.translator.m('spendings.foreign.title'),
          wartosc: DM.conf.formatNumber(DM_set_default_to_zero(responseJsonData.suma_wydatki)) + ' ' + getUnitTranslation(),
        },
      ]);
    }

    if (DM.data.typ_delegacji === 'zagranica') {
      DM.store.rozliczenie_zagranica.loadData([
        {
          nazwa: DM.translator.m('settlement.diet.item'),
          wartosc: DM.conf.formatNumber(DM_set_default_to_zero(responseJsonData.dieta_zagranica)) + ' ' + getUnitTranslation(),
        },
        {
          nazwa: DM.translator.m('settlement.localTransportLumpSum.item'),
          wartosc:
            DM.conf.formatNumber(DM_set_default_to_zero(responseJsonData.ryczalt_srodki_miejskie_zagranica)) +
            ' ' +
            getUnitTranslation(),
        },
        {
          nazwa: DM.translator.m('settlement.accomodationLumpSum.item'),
          wartosc:
            DM.conf.formatNumber(DM_set_default_to_zero(responseJsonData.ryczalt_noclegi_zagranica)) + ' ' + getUnitTranslation(),
        },
        {
          nazwa: DM.translator.m('settlement.foreign.commutingToStationLumpSum.item'),
          wartosc:
            DM.conf.formatNumber(DM_set_default_to_zero(responseJsonData.niezapewnione_przejazdy_do_z_dworca)) +
            ' ' +
            getUnitTranslation(),
        },
      ]);
    }

    var suma =
      parseFloat(DM_set_default_to_zero(responseJsonData.dieta_kraj)) +
      parseFloat(DM_set_default_to_zero(responseJsonData.ryczalt_srodki_miejskie_kraj)) +
      parseFloat(DM_set_default_to_zero(responseJsonData.ryczalt_noclegi_kraj)) +
      parseFloat(DM_set_default_to_zero(responseJsonData.kilometrowka)) +
      parseFloat(DM_set_default_to_zero(responseJsonData.suma_wydatki));

    if (DM.data.typ_delegacji === 'zagranica') {
      suma =
        suma +
        parseFloat(DM_set_default_to_zero(responseJsonData.dieta_zagranica)) +
        parseFloat(DM_set_default_to_zero(responseJsonData.ryczalt_srodki_miejskie_zagranica)) +
        parseFloat(DM_set_default_to_zero(responseJsonData.ryczalt_noclegi_zagranica)) +
        parseFloat(DM_set_default_to_zero(responseJsonData.niezapewnione_przejazdy_do_z_dworca));
    }

    suma = suma * 100.0;
    suma = Math.round(suma);
    suma = suma / 100.0;

    Ext.getCmp('DM.rozliczenie.win.label.suma').setText(DM.translator.m('settlement.summary.text', suma, getUnitTranslation()));

    if (responseJsonData.minuty_w_delegacji > 0) {
      DM_setButtonsForSettledDelegation();
    }
  }

  return responseJsonData;
}

function getUnitTranslation() {
  if (DM.conf.jsonConf.currency_name == undefined || DM.conf.jsonConf.currency_name == 'PLN') {
    return DM.translator.m('pln.unit')
  }

  return DM.conf.jsonConf.currency_name;
}
// funkcja odczytujaca dane zapisane przy pomoca hibernate
function DM_odczytanieDanych(DM) {
  var resp_obj = '';
  var isRequestError = false;
  var detailMessage;

  jQuery.ajax({
    type: 'POST',
    url: 'load',
    data: {
      processId: DM.data.zm_procesu.process_id,
      activityId: DM.data.zm_procesu.activity_id,
      type: DM.data.typ_delegacji,
      id: DM.data.zm_procesu.nr_delegacji,
    },
    async: false,
    success: function (response) {
      if (!response.success) {
        isRequestError = true;
        detailMessage = response.message;
      } else {
        resp_obj = response.data;
      }
    },
    error: function () {
      isRequestError = true;
    },
  });
  // obsluga błędów
  if (isRequestError) {
    DM_errorMsg(DM.translator.m('load.errorMsg') + ' ' + detailMessage);
    return false;
  }
  // obsługa gdy dane jeszcze nie istnieja w bazie danych
  else if (!resp_obj) {
    return false;
  }

  DM.form.podstawowe.getForm().findField('czy_przekroczono_dystans_dla_diety').setValue(resp_obj.czy_przekroczono_dystans_dla_diety);

  // zapis do ewidencja form
  var ewid_dane_form = DM.form.ewidencja.getForm();
  ewid_dane_form.findField('koszty_paliwa').setValue(resp_obj.koszty_paliwa);

  const sr_lokomocji = ewid_dane_form.findField('sr_lokomocji');
  if (!sr_lokomocji.value) {
    sr_lokomocji.setValue(resp_obj.sr_lokomocji);
  }

  const nr_rejestracyjny = ewid_dane_form.findField('nr_rejestracyjny');
  if (!nr_rejestracyjny.value) {
    nr_rejestracyjny.setValue(resp_obj.nr_rejestracyjny);
  }

  const marka_pojazdu = ewid_dane_form.findField('marka_pojazdu');
  if (!marka_pojazdu.value) {
    marka_pojazdu.setValue(resp_obj.marka_pojazdu);
  }

  const adres_uzytkownika_pojazdu = ewid_dane_form.findField('adres_uzytkownika_pojazdu');
  if (!adres_uzytkownika_pojazdu.value) {
    adres_uzytkownika_pojazdu.setValue(resp_obj.adres_uzytkownika_pojazdu);
  }

  const pojemnosc_silnika = ewid_dane_form.findField('pojemnosc_silnika');
  if (!pojemnosc_silnika.value || pojemnosc_silnika.value == 0) {
    if (resp_obj.pojemnosc_silnika == null || resp_obj.pojemnosc_silnika === '' || resp_obj.pojemnosc_silnika === 0) {
      pojemnosc_silnika.setValue('');
    } else {
      pojemnosc_silnika.setValue(resp_obj.pojemnosc_silnika);
    }
  }

  ewid_dane_form.findField('stawka_za_1_km').setValue(resp_obj.stawka_za_1_km);

  var uwagi_form = DM.form.uwagi.getForm();
  uwagi_form.findField('uwagi').setValue(resp_obj.uwagi);

  // zapis do jsonstore - trasa
  DM.store.trasa.loadData(resp_obj.trasa);

  // zapis do jsonstore - ilosciowe dane
  DM.store.ilosciowe.loadData(resp_obj.ilosci);

  DM.store.wydatki.loadData(resp_obj.wydatki);

  DM.store.przeliczona = resp_obj.minuty_w_delegacji > 0;

  return resp_obj;
}

// funkcja zapisujaca zmienne na mapie procesu
function DM_zapiszRozliczenieNaMapie(data) {
  var isRequestError = false;
  var detailMsgKey;
  jQuery.ajax({
    type: 'POST',
    url: 'saveToProcess',
    data: {
      processId: data.zm_procesu.process_id,
      activityId: data.zm_procesu.activity_id,
      type: data.typ_delegacji,
      id: data.zm_procesu.nr_delegacji,
    },
    async: false,
    success: function (resp) {
      if (!resp.success) {
        isRequestError = true;
        detailMsgKey = resp.message;
      }
    },
    error: function (resp) {
      isRequestError = true;
    },
  });
  if (isRequestError) {
    var detailMessage = '';
    if (detailMsgKey != undefined) {
      detailMessage = ' ' + DM.translator.m(detailMsgKey);
    }
    DM_errorMsg(DM.translator.m('settlement.saveToProcess.errorMsg') + detailMessage);
    return false;
  }

  return true;
}

// funkcje pomocnicze
function DM_ustawienieStawkiZaKm() {
  // ustawienie stawki za 1 km
  var combo_val = Ext.getCmp('DM.ewidencja.form.sr_lokomocji').getValue();
  for (var i = 0; i < DM.conf.jsonConf.kilometrowka.length; ++i) {
    var val = DM.conf.jsonConf.kilometrowka[i];
    if (val[0] === combo_val) {
      var stawka = val[1].replace('.', DM.conf.decimalseparator);
      Ext.getCmp('DM.ewidencja.form.stawka_za_1_km').setValue(stawka);
      break;
    }
  }
}

function DM_dodaj_polske_ilosciowa(store_ilosciowy) {
  var query = store_ilosciowy.query('kraj', 'Polska');
  if (typeof query.items === 'undefined' || query.items === null || query.getCount() > 0) {
    return false;
  }

  var data = {
    kraj: 'Polska',
  };
  var record = new Ext.data.Record(data);
  store_ilosciowy.add(record);
}

function DM_obliczLacznaIloscKm(store) {
  var rows = store.getRange();

  var ilosc_km = 0;
  for (var i = 0; i < rows.length; ++i) {
    var row = rows[i];
    var srodek_transportu = row.get('srodek_transportu');
    if (srodek_transportu === 'Pojazd prywatny') {
      ilosc_km += parseFloat(row.get('km'));
    }
  }
  Ext.getCmp('DM.ewidencja.form.laczna_ilosc_przejechanych_km').setValue(DM.conf.formatNumber(ilosc_km));
}

// pobranie kraju wyjazdu
function DM_get_wyjazd_kraj() {
  var combo = Ext.getCmp('DM.addmod.form.wyjazd_kraj');
  var idx = combo.getValue();
  var wyjazd_kraj = '';
  if (typeof idx === 'undefined' || idx == null || idx === '') {
    // gdy pierwszy dodawany odcinek
    return '';
  }
  if (!DM_isNumber(idx)) {
    wyjazd_kraj = idx;
  } else {
    Ext.getCmp('DM.addmod.form.wyjazd_kraj').getStore().clearFilter();
    if (Ext.getCmp('DM.addmod.form.wyjazd_kraj').getStore().getCount() === 0) {
      return '';
    } else if (Ext.getCmp('DM.addmod.form.wyjazd_kraj').getStore().getCount() === DM.conf.jsonConf.zagranica.kraje.length) {
      wyjazd_kraj = Ext.getCmp('DM.addmod.form.wyjazd_kraj').getStore().getAt(idx).get('wyjazd_kraj_text');
    } else {
      wyjazd_kraj = Ext.getCmp('DM.addmod.form.wyjazd_kraj').getStore().getAt(0).get('wyjazd_kraj_text');
    }
  }
  return wyjazd_kraj;
}

function DM_get_przyjazd_kraj() {
  var combo = Ext.getCmp('DM.addmod.form.przyjazd_kraj');
  var idx = combo.getValue();
  var przyjazd_kraj = '';
  if (typeof idx === 'undefined' || idx == null || idx === '') {
    return '';
  }
  if (!DM_isNumber(idx)) {
    przyjazd_kraj = idx;
  } else {
    Ext.getCmp('DM.addmod.form.przyjazd_kraj').getStore().clearFilter();
    if (Ext.getCmp('DM.addmod.form.wyjazd_kraj').getStore().getCount() === 0) {
      return '';
    } else if (Ext.getCmp('DM.addmod.form.wyjazd_kraj').getStore().getCount() === DM.conf.jsonConf.zagranica.kraje.length) {
      przyjazd_kraj = Ext.getCmp('DM.addmod.form.przyjazd_kraj').getStore().getAt(idx).get('przyjazd_kraj_text');
    } else {
      przyjazd_kraj = Ext.getCmp('DM.addmod.form.przyjazd_kraj').getStore().getAt(0).get('przyjazd_kraj_text');
    }
  }
  return przyjazd_kraj;
}

function DM_get_srodek_transportu() {
  var combo = Ext.getCmp('DM.addmod.form.srodek_transportu');
  var idx = combo.getValue();
  var srodek_transportu = '';
  if (typeof idx === 'undefined' || idx == null || idx === '') {
    return false;
  }
  if (!DM_isNumber(idx)) {
    srodek_transportu = idx;
  } else {
    Ext.getCmp('DM.addmod.form.srodek_transportu').getStore().clearFilter();
    if (Ext.getCmp('DM.addmod.form.srodek_transportu').getStore().getCount() === 0) {
      return false;
    } else if (Ext.getCmp('DM.addmod.form.srodek_transportu').getStore().getCount() === DM.conf.jsonConf.srodek_transportu.length) {
      srodek_transportu = Ext.getCmp('DM.addmod.form.srodek_transportu').getStore().getAt(idx).get('srodek_lok_text');
    } else {
      srodek_transportu = Ext.getCmp('DM.addmod.form.srodek_transportu').getStore().getAt(0).get('srodek_lok_text');
    }
  }
  return srodek_transportu;
}

// listeners
function DM_addmod_trasa_wlacz_wylacz_granice(wyjazd_kraj, przyjazd_kraj) {
  wyjazd_kraj = wyjazd_kraj || DM_get_wyjazd_kraj();
  przyjazd_kraj = przyjazd_kraj || DM_get_przyjazd_kraj();

  var data_przekroczenia_granicy = Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy');
  var godzina_przekroczenia_granicy = Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy');

  if (!DM_addmod_trasa_listener_srodek_transportu(Ext.getCmp('DM.addmod.form.srodek_transportu').getValue())) {
    return;
  }

  if (wyjazd_kraj === null || wyjazd_kraj === '' || przyjazd_kraj === null || przyjazd_kraj === '') {
    data_przekroczenia_granicy.setValue('');
    godzina_przekroczenia_granicy.setValue('');
    data_przekroczenia_granicy.disable();
    godzina_przekroczenia_granicy.disable();
    return;
  }

  if (DM_addmod_trasa_valid_czy_wymagana_granica()) {
    data_przekroczenia_granicy.enable();
    godzina_przekroczenia_granicy.enable();
  } else {
    var srodek_transportu = DM_get_srodek_transportu();

    if (!DM_addmod_trasa_czy_samolot_statek(srodek_transportu) && wyjazd_kraj !== przyjazd_kraj) {
      data_przekroczenia_granicy.setValue('');
      godzina_przekroczenia_granicy.setValue('');
    }

    data_przekroczenia_granicy.disable();
    godzina_przekroczenia_granicy.disable();
  }
}

// przepisanie granicy gdy statek lub samolot
function DM_addmod_trasa_listener_srodek_transportu(pojazd) {
  var data_przekroczenia_granicy = Ext.getCmp('DM.addmod.form.data_przekroczenia_granicy');
  var godzina_przekroczenia_granicy = Ext.getCmp('DM.addmod.form.godzina_przekroczenia_granicy');
  var wyjazd_kraj = DM_get_wyjazd_kraj();
  var przyjazd_kraj = DM_get_przyjazd_kraj();

  // na odcinku krajowym brak granicy
  if (wyjazd_kraj === null || wyjazd_kraj === '' || przyjazd_kraj === null || przyjazd_kraj === '' || wyjazd_kraj === przyjazd_kraj) {
    data_przekroczenia_granicy.setValue('');
    godzina_przekroczenia_granicy.setValue('');
    data_przekroczenia_granicy.disable();
    godzina_przekroczenia_granicy.disable();
    return false;
  }

  var is_samolot = false;
  if (DM_addmod_trasa_czy_samolot_statek(pojazd)) {
    // MODPLWRKFL-280
    // Data przekroczenia granicy to data lądowania w pierwszym lotnisku w kraju
    // Analogicznie w przypadku statków

    var startLocation = DM.store.trasa.getAt(0);
    var data;
    var godzina;

    // jeżeli wracamy do kraju początkowego, przekroczenie granicy to czas przyjazdu
    if (!Ext.isEmpty(startLocation) && startLocation.get('wyjazd_kraj') == przyjazd_kraj) {
      data = Ext.getCmp('DM.addmod.form.przyjazd_data').getValue();
      godzina = Ext.getCmp('DM.addmod.form.przyjazd_godzina').getValue();
    } else {
      data = Ext.getCmp('DM.addmod.form.wyjazd_data').getValue();
      godzina = Ext.getCmp('DM.addmod.form.wyjazd_godzina').getValue();
    }

    data_przekroczenia_granicy.setValue(data);
    godzina_przekroczenia_granicy.setValue(godzina);
    data_przekroczenia_granicy.disable();
    godzina_przekroczenia_granicy.disable();
    is_samolot = true;
  } else {
    data_przekroczenia_granicy.enable();
    godzina_przekroczenia_granicy.enable();
  }

  if (DM_addmod_trasa_valid_czy_wymagana_granica() && is_samolot) {
    data_przekroczenia_granicy.disable();
    godzina_przekroczenia_granicy.disable();
  } else if (DM_addmod_trasa_valid_czy_wymagana_granica() && !is_samolot) {
    data_przekroczenia_granicy.enable();
    godzina_przekroczenia_granicy.enable();
  } else {
    data_przekroczenia_granicy.disable();
    godzina_przekroczenia_granicy.disable();
  }

  return true;
}

function DM_addmod_trasa_czy_samolot_statek(pojazd) {
  for (var i = 0; i < DM.conf.jsonConf.zagranica.granica_odrazu.length; i++) {
    if (DM.conf.jsonConf.zagranica.granica_odrazu[i] === pojazd) {
      return true;
    }
  }
  return false;
}

function DM_addmod_trasa_czy_pojazd_z_kilometrowka(pojazd) {
  for (var i = 0; i < DM.conf.jsonConf.zagranica.granica_odrazu.length; i++) {
    if (DM.conf.jsonConf.kilometrowka_dla[i] === pojazd) {
      return true;
      break;
    }
  }
  return false;
}

function DM_addmod_trasa_czy_wymog_ewidencji_pojazdu() {
  for (var j = 0; j < DM.store.trasa.getCount(); ++j) {
    var pojazd = DM.store.trasa.getAt(j).get('srodek_transportu');
    for (var i = 0; i < DM.conf.jsonConf.zagranica.granica_odrazu.length; i++) {
      if (DM.conf.jsonConf.wymog_ewidencji_pojazdu[i] === pojazd) {
        return true;
        break;
      }
    }
  }
  return false;
}

function DM_del_kraj_docelowy_wymog_min_dwoch_krajow() {
  var store_count = DM.store.ilosciowe.getCount();
  if (store_count >= 2) {
    return true;
  }
  return false;
}

function DM_del_polska_nie_ma_komunikacji_z_do_dworca() {
  let valid = true;
  Ext.each(DM.store.ilosciowe.getRange(), function (record) {
    if (record.data.kraj == "Polska" && record.data.niezapewnione_przejazdy_do_z_dworca > 0){
      valid = false
      return;
    }
  });
  return valid;
}

function DM_zapisz_rozl_na_mapie_generujPdf_i_przejdz_do_procesu() {
  var saveOnMapMaskId = 'DM_save_on_map_mask_id';
  DM_showLoadingMask(saveOnMapMaskId, DM.translator.m('settlement.saveToProcess.loadingText'));
  var nr_delegacji = Ext.getCmp('DM.podst.nr_delegacji').getValue();
  // servlet - zapis na mapie
  if (!DM_zapiszRozliczenieNaMapie(DM.data)) {
    DM_removeLoadingMask(saveOnMapMaskId);
    return false;
  }
  DM_removeLoadingMask(saveOnMapMaskId);

  // z pliku konfiguracyjnego - ostrzezenie
  // gdy daty sa niezgodne z wnioskowanym terminem
  var odjazd_wniosek = Ext.getCmp('DM.podst.data_odjazdu').getValue();
  var powrot_wniosek = Ext.getCmp('DM.podst.data_powrotu').getValue();
  var daty_zgodne = DM_sprawdzCzyDatySaZgodneZWnioskiem(DM.store.trasa, odjazd_wniosek, powrot_wniosek);
  if (daty_zgodne === false && DM.conf.actionConf.otherParams.isWarningIfDatesNotSynchronized) {
    Ext.Msg.show({
      title: DM.translator.m('warning'),
      msg: DM.translator.m('settlement.saveToProcess.warningMsg1'),
      buttons: {
        yes: DM.translator.m('Tak'),
        no: DM.translator.m('Nie'),
      },
      fn: function (buttonId) {
        if (buttonId === 'yes') {
          DM_generujPDFiPodlacz(DM.data.zm_procesu.process_id, DM.data.zm_procesu.activity_id, DM.data.typ_delegacji, nr_delegacji);
        } else {
          DM_infoMsg(DM.translator.m('settlement.saveToProcess.warningMsg2'));
        }
      },
      icon: Ext.Msg.ERROR,
    });
  } else {
    DM_generujPDFiPodlacz(DM.data.zm_procesu.process_id, DM.data.zm_procesu.activity_id, DM.data.typ_delegacji, nr_delegacji);
  }
}

function DM_isFieldToHide(fieldId) {
  return jQuery.inArray(fieldId, DM.conf.actionConf.fieldsToHide) >= 0 ? true : false;
}

function DM_semicolonValidation(value) {
  if (value.indexOf(';') > -1) {
    return DM.translator.m('spendings.name.validatorMsg');
  }
  return true;
}

function DM_setButtonsForSettledDelegation() {
  Ext.getCmp('settleSaveBtn').hide();
  Ext.getCmp('settleCalcBtn').setText(DM.translator.m('settleAndSave'));
}

function DM_closeModule(){
    jQuery.ajax({
        type: 'POST',
        url: 'close',
        async: false,
    });
}

function DM_setHeightOnSmallerScreens(element) {
  var height = Ext.getBody().getViewSize().height;
  if (element.getHeight() > height) {
    element.setHeight(height);
  }
  element.center();
}
