PW.FormActions.create("runBusinessTripAction", {
  defaultActions: {
    button: function (button) {
      this.buttonClick();
    },
    dtButton: function (button) {
      this.buttonClick();
    },
  },

  buttonClick: function(){
    if (this.get("shouldVariablesBeSave")) {
      ServiceFactory.getFormService().save({
        scope: this,
        success: this.openBusinessTrip,
      });
    } else {
      this.openBusinessTrip();
    }
  },

  openBusinessTrip: function () {
    var url = "plugin/com.suncode.plugin-business-trip/businessTrip/open";
    var pdfItems = ["run", "documentClass", "templateName"];
    var refreshExchangeItems = [
      "stageWithContinuouslyRefreshedExchange",
      "refreshingTodayOrFromField",
      "idReadFieldName",
      "refreshExchangeRates",
      "exchangeRateDateType",
      "exchangeRateSource",
      "exchangeRateDataSourceId",
      "datasourceInputParametersId",
      "datasourceInputParametersValue",
    ];
    var otherParamsItems = [
      "isReadOnlyMode",
      "isSpendingTableVisible",
      "isWarningIfDatesNotSynchronized",
      "isSettlementWindowVisible",
      "itsHistoryView",
      "isGridValuesCentered",
      "settlementCountry",
    ];
    var actionConfDto = {
      inputParams: this.getInputParametersValues(),
      outputParams: this.getOutputParameters(),
      generatingSettlementSummaryPdf: this.getParamsSetting(
        pdfItems,
        "generatingSettlementSummaryPdf"
      ),
      generatingCarCardPdf: this.getParamsSetting(
        pdfItems,
        "generatingCarCardPdf"
      ),
      exchangeForForeignBusinessTripsSettlement:
        this.getExchangeForForeignBusinessTripsSettlement(refreshExchangeItems),
      spendingTypes: this.getArrayParamSetting("spendingTypes"),
      paymentMethods: this.getArrayParamSetting("paymentMethods"),
      documentTypes: this.getArrayParamSetting("documentTypes"),
      otherParams: this.getParamsSetting(otherParamsItems),
      fieldsToHide: this.get("fieldsToHide"),
      advanceAmounts: this.getParamCurrentArrayValues("advanceAmounts"),
      advanceCurrencies: this.getParamCurrentArrayValues("advanceCurrencies"),
      activityVariableParams: this.getArrayParamCurrentValues(
        "activityVariableParams"
      ),
    };

    if (window.isHistory) {
      actionConfDto.otherParams.isReadOnlyMode = true;
      actionConfDto.otherParams.itsHistoryView = true;
    }

    DM = {
      translator: {
        m: PW.I18N.createT("com.suncode.plugin-business-trip"),
      },
    };

    if (!actionConfDto.inputParams.id) {
      this.msgError("action.runDelegation.variable.id.error");
      return false;
    }
    if (
      actionConfDto.inputParams.startDate > actionConfDto.inputParams.finishDate
    ) {
      this.msgError(
        "action.runDelegation.variable.startDateAndFinishDate.error"
      );
      return false;
    }

    var $form = jQuery("<form>").attr({
      method: "POST",
      action: url,
      "accept-charset": "utf-8",
    });
    var $input = jQuery("<input>").attr({
      type: "hidden",
      name: "actionConf",
      value: JSON.stringify(actionConfDto),
    });
    $form.append($input);

    var $csrfToken = jQuery("<input>").attr({
      type: "hidden",
      name: Suncode.getCsrfParameterName(),
      value: Suncode.getCsrfToken(),
    });
    $form.append($csrfToken);

    jQuery("body").append($form);
    $form.submit();
  },

  getInputParametersValues: function () {
    var paramNames = [
      "type",
      "id",
      "personName",
      "goal",
      "startDate",
      "finishDate",
      "city",
      "country",
      "transportType",
      "advanceDate",
      "transport",
      "vehicleBrand",
      "registrationNumber",
      "vehicleUserAddress",
      "engineCapacity",
    ];
    var result = this.getCurrentInputParametersValues(paramNames);
    var activityInfoService = ServiceFactory.getActivityInfoService();
    result["processId"] = activityInfoService.getProcessId();
    result["activityId"] = activityInfoService.getActivityId();

    return result;
  },

  getCurrentInputParametersValues: function (paramNames) {
    var result = {};
    PW.each(
      paramNames,
      function (param) {
        var value = this.get(param);
        if (Ext.isDate(value)) {
          value = Ext4.Date.format(value, "Y-m-d");
        }
        result[param] = value;
      },
      this
    );

    return result;
  },

  getOutputParameters: function () {
    var spendingsTableItems = [
      "nr_delegacji",
      "wydatek_id",
      "nazwa_wydatku",
      "koszt",
      "waluta",
      "data",
      "rodzaj_wydatku",
      "paymentMethod",
      "documentType",
      "kurs_waluty",
      "wspolczynnik_waluty",
    ];
    var summaryTableParamItems = [
      "nr_delegacji",
      "wyjazd_data",
      "wyjazd_godzina",
      "przyjazd_data",
      "przyjazd_godzina",
      "wyjazd_miejscowosc",
      "przyjazd_miejscowosc",
      "kraj_delegacji",
      "nr_rejestracyjny",
      "srodek_transportu",
      "cel_delegacji",
      "suma_dni_w_delegacji",
      "suma_ilosci_godzin_w_delegacji",
      "suma_ilosci_niezapewnionych_dob_komunikacji_miejskiej",
      "suma_ilosci_niezapewnionych_noclegow",
      "suma_ilosci_niezapewnionych_sniadan",
      "suma_ilosci_niezapewnionych_obiadow",
      "suma_ilosci_niezapewnionych_kolacji",
      "suma_ilosci_zapewnionych_dob_calodobowe_wyzywienie",
      "suma_ilosci_niezapewnionych_dob_calodobowe_wyzywienie",
      "suma_ilosci_niezapewnionych_przejazdow_do_z_dworca",
      "suma_ilosci_diet_kraj",
      "suma_ilosci_diet_zagranica",
      "suma_wydatkow",
      "miasto_docelowe",
    ];
    var costsTableParamItems = [
      "nr_delegacji",
      "opis_linii",
      "kwota_w_walucie",
      "waluta",
      "kurs_waluty",
      "wspolczynnik_waluty",
    ];
    var result = {
      spendingsTableParams: this.getTableItemsIds(
        "spendingsTable",
        spendingsTableItems
      ),
      summaryTableParams: this.getTableItemsIds(
        "summaryTable",
        summaryTableParamItems
      ),
      costsTableParams: this.getTableItemsIds(
        "costsTable",
        costsTableParamItems
      ),
    };
    return result;
  },

  getTableItemsIds: function (tableName, tableItems) {
    var result = {};
    PW.each(
      tableItems,
      function (param) {
        var v = this.get(tableName + "." + param);
        if (v) {
          result[param] = v.id;
        }
      },
      this
    );

    return result;
  },

  getParamsSetting: function (items, groupName) {
    var result = {};
    PW.each(
      items,
      function (param) {
        var v =
          groupName == undefined
            ? this.get(param)
            : this.get(groupName + "." + param);
        if (v != null) {
          result[param] = v;
        }
      },
      this
    );

    return result;
  },

  getArrayParamSetting: function (item) {
    var result = [];
    var values = this.get(item);
    if (values && values[0]) {
      PW.each(
        values,
        function (value) {
          result.push([value]);
        },
        this
      );
    }

    return result;
  },

  getParamCurrentArrayValues: function (paramName) {
    var result = [];
    var values = this.get(paramName);
    PW.each(
      values,
      function (value) {
        PW.each(
          value.getValue(),
          function (v) {
            result.push([v]);
          },
          this
        );
      },
      this
    );

    return result;
  },

  getArrayParamCurrentValues: function (arrayParamName) {
    var values = {};
    var types = {};
    var params = this.get(arrayParamName);
    PW.each(
      params,
      function (param) {
        if (param) {
          types[param.id] = param.getType().name;
          values[param.id] = this.getArrayValues(
            param.getValue(),
            param.getType()
          );
        }
      },
      this
    );
    return { values: values, types: types };
  },

  getArrayValues: function (values, type) {
    var result = [];
    PW.each(
      values,
      function (v) {
        if (
          type.is("date") ||
          type.is("date[]") ||
          type.is("datetime") ||
          type.is("datetime[]")
        ) {
          result.push(v ? v.getTime() : null);
        } else {
          result.push(v);
        }
      },
      this
    );
    if (result.length == 0) {
      result = [null];
    }
    return result;
  },

  msgError: function (msgKey) {
    Ext.Msg.show({
      title: DM.translator.m("error"),
      msg: DM.translator.m(msgKey),
      buttons: Ext.Msg.OK,
      icon: Ext.Msg.ERROR,
    });
  },

  getExchangeForForeignBusinessTripsSettlement: function (items) {
    var result = {};
    PW.each(
      items,
      function (param) {
        var v = this.get(
          "exchangeForForeignBusinessTripsSettlement" + "." + param
        );
        if (v != null) {
          result[param] = v;
        }
      },
      this
    );
    if (
      result["exchangeForForeignBusinessTripsSettlement.refreshExchangeRates"]
    ) {
      result[
        "exchangeForForeignBusinessTripsSettlement.stageWithContinuouslyRefreshedExchange"
      ] = activityInfoService.getActivityDefId();
    }
    return result;
  },
});
