/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.settlement.poland;

import com.suncode.businesstrip.config.Configuration;
import com.suncode.businesstrip.config.data.ActionConf;
import com.suncode.businesstrip.config.data.JsonConf;
import com.suncode.businesstrip.database.model.BusinessTrip;
import com.suncode.businesstrip.database.model.BusinessTripQuantities;
import com.suncode.businesstrip.dto.RateDto;
import com.suncode.businesstrip.exception.DMException;
import com.suncode.businesstrip.settlement.SettlementCountry;
import com.suncode.businesstrip.settlement.TripTimeCalculator;
import com.suncode.businesstrip.settlement.poland.PolandAbstractSettlementService;
import com.suncode.businesstrip.util.Exchange;
import com.suncode.businesstrip.util.ExchangeRateSource;
import com.suncode.businesstrip.util.Tools;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="polandForeignSettlementService")
public class PolandForeignSettlementServiceImpl
extends PolandAbstractSettlementService {
    private static final Logger log = LoggerFactory.getLogger(PolandForeignSettlementServiceImpl.class);

    @Override
    public void calculate(BusinessTrip businessTrip, String currencyExchangeDate) throws Exception {
        HashMap<String, RateDto> exchangeRates;
        JsonConf config = Configuration.getJsonConfigForDate(SettlementCountry.POLAND, businessTrip.getData_powrotu());
        ActionConf actionConfig = Configuration.getActionConf(businessTrip.getNr_delegacji());
        Set<String> destinationCountries = businessTrip.getIlosci().stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getKraj())).map(c -> c.getKraj()).collect(Collectors.toSet());
        Set<String> currencyNames = Exchange.getCurrencyNamesForTrip(businessTrip, config);
        String exchangeRateSource = actionConfig.getExchangeSettings().getExchangeRateSource();
        if (ExchangeRateSource.DATA_SOURCE.name().equals(exchangeRateSource)) {
            String dataSourceId = actionConfig.getExchangeSettings().getExchangeRateDataSourceId();
            exchangeRates = this.exchangeService.getRateFromDataSource(dataSourceId, this.getDataSourceInputParameters(businessTrip.getNr_delegacji()), currencyNames, PolandForeignSettlementServiceImpl.parseDate(currencyExchangeDate));
        } else {
            exchangeRates = this.exchangeService.getLastNbpExchanges(currencyNames, PolandForeignSettlementServiceImpl.parseDate(currencyExchangeDate));
        }
        Map<String, List<Long>> minutesInCountries = TripTimeCalculator.calculateMinutesForeignDelegation(businessTrip.getTrasa(), destinationCountries, businessTrip.getData_powrotu(), SettlementCountry.POLAND);
        for (String country : minutesInCountries.keySet()) {
            if (!destinationCountries.contains(country)) {
                log.debug("UWAGA ZOSTAL ROZLICZONY KRAJ KTORY NIE JEST DOCELOWYM. KRAJ " + country);
            }
            log.debug("Kraj = " + country + ", ilosc minut = " + minutesInCountries.get(country).stream().mapToLong(l -> l).sum());
        }
        long minutesInDelegation = 0L;
        double foreignDiet = 0.0;
        double foreignPublicTransport = 0.0;
        double foreignAccommodation = 0.0;
        double foreignCommutingToStation = 0.0;
        for (BusinessTripQuantities destinationCountry : businessTrip.getIlosci()) {
            String countryName = destinationCountry.getKraj();
            if (StringUtils.isBlank((CharSequence)countryName)) continue;
            log.debug("Rozliczenia kraju " + countryName);
            List<Long> minutes = minutesInCountries.get(countryName);
            if (CollectionUtils.isEmpty(minutes)) {
                minutes = Arrays.asList(0L);
            }
            Long minutesInCountry = minutes.stream().mapToLong(l -> l).sum();
            destinationCountry.setMinuty_w_delegacji(minutesInCountry);
            minutesInDelegation += minutesInCountry.longValue();
            Boolean distanceForDietExceeded = businessTrip.getCzy_przekroczono_dystans_dla_diety();
            log.debug("Rozliczenie diety dla kraju " + countryName + " ilosc minut " + String.valueOf(minutes));
            if (!countryName.equalsIgnoreCase("Polska")) {
                String currencyName = config.getZagranica().getDieta().get(countryName)[0];
                if (exchangeRates.get(currencyName) == null) {
                    throw new DMException("Brak kursu potrzebnego do rozliczenia waluty " + currencyName);
                }
                RateDto exchangeRate = exchangeRates.get(currencyName);
                log.debug("Rozliczenie kraju zagranicznego, nazwa waluty: " + currencyName + " kurs walutowy: " + exchangeRate.getMid());
                destinationCountry.setWaluta(currencyName);
                destinationCountry.setKurs_walutowy(exchangeRate.getMid());
                destinationCountry.setData_kursu(exchangeRate.getEffectiveDate());
                double dietRateInCurrency = Tools.round2(Tools.parseDouble(config.getZagranica().getDieta().get(countryName)[1]));
                destinationCountry.setStawka_diety(dietRateInCurrency);
                log.debug("Stawka diety zagranicznej dla kraju " + countryName + " stawka = " + dietRateInCurrency);
                double foreignDietFullReward = 0.0;
                if (distanceForDietExceeded == null || distanceForDietExceeded.booleanValue()) {
                    foreignDietFullReward = this.calculateForeignCountryFullAmount(destinationCountry, minutesInCountry, dietRateInCurrency);
                }
                destinationCountry.setTripFullReward(Tools.round2(foreignDietFullReward));
                double foreignDietRewardDeductions = this.calculateForeignCountryDeductions(config, destinationCountry, foreignDietFullReward, dietRateInCurrency);
                destinationCountry.setTripRewardDeductions(Tools.round2(foreignDietRewardDeductions));
                double foreignDietInCurrency = this.calculateDiet(destinationCountry, foreignDietFullReward, foreignDietRewardDeductions, dietRateInCurrency);
                log.debug("Dieta w walucie " + foreignDietInCurrency + ", dieta w pln " + (foreignDiet += Tools.convertCurrency(foreignDietInCurrency, exchangeRate.getMid()).doubleValue()));
                double accommodationRate = Tools.parseDouble(config.getZagranica().getDieta().get(countryName)[2]);
                double accommodationAllowanceInCurrency = this.calculateForeignAccommodationAllowance(destinationCountry.getNiezapewnione_noclegi(), accommodationRate);
                destinationCountry.setRyczalt_noclegi(accommodationAllowanceInCurrency);
                foreignAccommodation += Tools.round2(Tools.convertCurrency(accommodationAllowanceInCurrency, exchangeRate.getMid()));
                double publicTransportAllowanceInCurrency = this.calculateForeignPublicTransportAllowance(destinationCountry.getNiezapewnione_doby_komunikacji_miejskiej(), dietRateInCurrency);
                destinationCountry.setRyczalt_doby_kom_miejskiej(publicTransportAllowanceInCurrency);
                foreignPublicTransport += Tools.round2(Tools.convertCurrency(publicTransportAllowanceInCurrency, exchangeRate.getMid()));
                double commutingToStationAllowanceInCurrency = this.calculateForeignCommutingToStationAllowance(destinationCountry.getNiezapewnione_przejazdy_do_z_dworca(), dietRateInCurrency);
                destinationCountry.setRyczalt_przejazdy_do_z_dworca(commutingToStationAllowanceInCurrency);
                foreignCommutingToStation += Tools.round2(Tools.convertCurrency(commutingToStationAllowanceInCurrency, exchangeRate.getMid()));
                continue;
            }
            double dietRate = config.getKraj().getDieta();
            destinationCountry.setStawka_diety(dietRate);
            double tripFullReward = 0.0;
            if (distanceForDietExceeded == null || distanceForDietExceeded.booleanValue()) {
                tripFullReward = minutes.stream().mapToDouble(time -> this.calculateDomesticDietFullAmount((long)time, businessTrip.getData_powrotu())).sum();
            }
            double tripRewardDeductions = this.calculateDomesticDietDeductions(destinationCountry, tripFullReward, businessTrip.getData_powrotu());
            double diet = this.calculateDiet(destinationCountry, tripFullReward, tripRewardDeductions, dietRate);
            log.debug("Dieta krajowa " + diet + " stawka " + dietRate);
            businessTrip.setDieta_kraj(Tools.round2(diet));
            destinationCountry.setTripFullReward(Tools.round2(tripFullReward));
            destinationCountry.setTripRewardDeductions(Tools.round2(tripRewardDeductions));
            String waluta = config.getCurrencyName();
            if (StringUtils.isBlank((CharSequence)waluta)) {
                waluta = config.getNazwaPolskiejWaluty();
            }
            destinationCountry.setWaluta(waluta);
            double publicTransportAllowance = this.calculateDomesticPublicTransportAllowance(destinationCountry, businessTrip.getData_powrotu());
            destinationCountry.setRyczalt_doby_kom_miejskiej(publicTransportAllowance);
            double accommodationAllowance = this.calculateDomesticAccommodationAllowance(destinationCountry, businessTrip.getData_powrotu());
            destinationCountry.setRyczalt_noclegi(accommodationAllowance);
            businessTrip.setRyczalt_srodki_miejskie_kraj(Tools.round2(publicTransportAllowance));
            businessTrip.setRyczalt_noclegi_kraj(Tools.round2(accommodationAllowance));
        }
        log.debug("Obliczona dieta zagraniczna = " + foreignDiet + " dieta krajowa " + businessTrip.getDieta_kraj());
        log.debug("Ryczalt srodki miejskie " + foreignPublicTransport + "  ryczalt za noclegi " + foreignAccommodation + " ryczalt za dojazdy do z dworca " + foreignCommutingToStation);
        double kilometrageAllowance = this.calculateKilometrageAllowance(businessTrip);
        businessTrip.setMinuty_w_delegacji(minutesInDelegation);
        businessTrip.setKraje_minuty(minutesInCountries.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().mapToLong(Long::longValue).sum())));
        businessTrip.setDieta_zagranica(Tools.round2(foreignDiet));
        businessTrip.setRyczalt_noclegi_zagranica(Tools.round2(foreignAccommodation));
        businessTrip.setRyczalt_srodki_miejskie_zagranica(Tools.round2(foreignPublicTransport));
        businessTrip.setRyczalt_za_przejazdy_do_z_dworca(Tools.round2(foreignCommutingToStation));
        businessTrip.setKilometrowka(Tools.round2(kilometrageAllowance));
        double sumOfSpendings = businessTrip.getWydatki().stream().mapToDouble(s -> {
            if (s.getWaluta().equalsIgnoreCase("PLN")) {
                s.setKurs(1.0);
                s.setKoszt_pln(s.getKoszt());
            } else {
                Double exchangeRate;
                if (s.getRateFromDayBefore() != null && s.getRateFromDayBefore().booleanValue()) {
                    if (ExchangeRateSource.DATA_SOURCE.name().equals(exchangeRateSource)) {
                        String dataSourceId = Configuration.getActionConf(businessTrip.getNr_delegacji()).getExchangeSettings().getExchangeRateDataSourceId();
                        exchangeRate = this.exchangeService.getRateFromDataSource(dataSourceId, this.getDataSourceInputParameters(businessTrip.getNr_delegacji()), currencyNames, PolandForeignSettlementServiceImpl.parseDate(s.getData()).minusDays(1L)).get(s.getWaluta()).getMid();
                    } else {
                        try {
                            HashMap<String, RateDto> rates = this.exchangeService.getLastNbpExchanges(currencyNames, PolandForeignSettlementServiceImpl.parseDate(s.getData()).minusDays(1L));
                            if (rates == null || rates.isEmpty()) {
                                throw new DMException("Brak kursu potrzebnego do rozliczenia");
                            }
                            exchangeRate = rates.get(s.getWaluta()).getMid();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e.getMessage());
                        }
                    }
                } else {
                    exchangeRate = ((RateDto)exchangeRates.get(s.getWaluta())).getMid();
                }
                s.setKurs(exchangeRate);
                s.setKoszt_pln(Tools.convertCurrency(s.getKoszt(), exchangeRate));
            }
            return s.getKoszt_pln();
        }).sum();
        businessTrip.setSuma_wydatki(Tools.round2(sumOfSpendings));
    }

    private static LocalDate parseDate(String date) {
        try {
            return LocalDate.parse(date, DateTimeFormatter.ofPattern("yy-MM-dd"));
        }
        catch (Exception e) {
            return LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
    }

    private Double calculateForeignCountryFullAmount(BusinessTripQuantities targetCountry, long countryTripMinutes, double rate) throws DMException {
        if (targetCountry.getKraj().equalsIgnoreCase("polska")) {
            throw new DMException("Polska nie jest rozliczana tak samo jak delegacja zagraniczna.");
        }
        return this.calculateForeignDietAmount(countryTripMinutes, rate);
    }

    public Double calculateForeignCountryDeductions(JsonConf config, BusinessTripQuantities bt, double tripFullReward, double dietRate) {
        double deductions = 0.0;
        if (Tools.isTak(bt.getCalodobowe_wyzywienie())) {
            log.debug("Pracodawaca zapewni\u0142 ca\u0142odobowe wyzywyenie dla kraju " + String.valueOf(bt));
            Double wysokosc_diety_gdy_zapewniony_posilek = config.getZagranica().getWysokosc_diety_gdy_pracodawca_zapewnil_posilek();
            deductions = (double)Math.round(tripFullReward * (1.0 - wysokosc_diety_gdy_zapewniony_posilek) * 100.0) / 100.0;
        } else {
            log.debug("Standardowe odliczenie ilo\u015bci zapewnionych posi\u0142k\u00f3w dla kraju " + String.valueOf(bt));
            Integer percentageReductionForBreakfast = config.getZagranica().getProcentowe_zmniejszenie_diety_za_zapewnione_sniadanie();
            if (percentageReductionForBreakfast == null) {
                percentageReductionForBreakfast = 15;
            }
            deductions = (double)bt.getZapewnione_sniadania().intValue() * Tools.round2((double)percentageReductionForBreakfast.intValue() / 100.0 * dietRate);
            Integer percentageReductionForDinner = config.getZagranica().getProcentowe_zmniejszenie_diety_za_zapewniony_obiad();
            if (percentageReductionForDinner == null) {
                percentageReductionForDinner = 30;
            }
            deductions += (double)bt.getZapewnione_obiady().intValue() * Tools.round2((double)percentageReductionForDinner.intValue() / 100.0 * dietRate);
            Integer percentageReductionForSupper = config.getZagranica().getProcentowe_zmniejszenie_diety_za_zapewniona_kolacje();
            if (percentageReductionForSupper == null) {
                percentageReductionForSupper = 30;
            }
            deductions += (double)bt.getZapewnione_kolacje().intValue() * Tools.round2((double)percentageReductionForSupper.intValue() / 100.0 * dietRate);
        }
        return deductions;
    }

    private double calculateForeignDietAmount(long minutes, double rate) {
        long allDays = minutes / 1440L;
        long remainingMinutes = minutes % 1440L;
        double diet = (double)allDays * rate;
        if (remainingMinutes > 0L && remainingMinutes <= 480L) {
            diet += Tools.round2(rate / 3.0);
        } else if (remainingMinutes > 480L && remainingMinutes <= 720L) {
            diet += Tools.round2(rate / 2.0);
        } else if (remainingMinutes > 720L) {
            diet += rate;
        }
        return Tools.round2(diet);
    }

    private double calculateForeignPublicTransportAllowance(int nonProvidedDays, double rate) {
        double amount = (double)nonProvidedDays * 0.1 * rate;
        return Tools.round2(amount);
    }

    private double calculateForeignAccommodationAllowance(int nonProvidedAccommodations, double limit) {
        double amount = (double)nonProvidedAccommodations * limit * 0.25;
        return Tools.round2(amount);
    }

    private double calculateForeignCommutingToStationAllowance(Double nonProvidedCommuting, double rate) {
        double amount = nonProvidedCommuting * rate;
        return Tools.round2(amount);
    }
}

