/**
 * Pobranie aktualnej konfiguracji z serwera.
 */

DM = {
  conf: {},
};

(function DM_odczytajConfig() {
  jQuery.ajax({
    type: "POST",
    async: false,
    url: "config/load",
    data: {
      delegationId: typeof inputParamsId !== 'undefined' ? inputParamsId : null
    },
    success: function (response) {
      DM.conf = response;
      DM.conf.jsonConf.zagranica.krajeTranslations = {};
      Ext.each(DM.conf.jsonConf.zagranica.kraje, function (kraj) {
        DM.conf.jsonConf.zagranica.krajeTranslations[kraj[0]] = kraj[1];
      });
      DM.conf.jsonConf.srodek_transportu_translations = {};
      Ext.each(DM.conf.jsonConf.srodek_transportu, function (transport) {
        DM.conf.jsonConf.srodek_transportu_translations[transport[0]] =
          transport[1];
      });
    },
  });

  // format wszystkich licz
  DM.conf.formatNumber = function (value) {
    if (Ext.isString(value)) {
      value = value.replace(",", ".");
    }
    return Ext.util.Format.number(value, "0.00").replace(
      ".",
      DM.conf.decimalseparator
    );
  };

  DM.conf.getNumberViewFormat = function (decimalSeparator, decimalPrecision) {
    var precisionFormat = "00";
    if (decimalPrecision) {
      precisionFormat = "";
      for (i = 0; i < decimalPrecision; i++) {
        precisionFormat += "0";
      }
    }
    if (decimalSeparator === ".") {
      return "0." + precisionFormat;
    }
    return "0," + precisionFormat + "/i";
  };

  DM.conf.formatDate = function (value) {
    if (!value) {
      return;
    }
    return Ext.util.Format.date(value, "Y-m-d");
  };

  // if ( !DM.conf.success ) {
  // 	DM_removeLoadingMask( loadingConfMaskId );
  //
  // 	Ext.Msg.show( {
  // 		title : 'Błąd odczytu konfiguracji',
  // 		msg : 'Wystąpił błąd podczas konfigurowania modułu delegacji.',
  // 		buttons : {
  // 			yes : 'Zamknij',
  // 			no : 'Szczegóły >>'
  // 		},
  // 		fn : function( buttonId ) {
  // 			if ( buttonId === 'no' ) {
  // 				Ext.Msg.show( {
  // 					title : 'Błąd odczytu konfiguracji',
  // 					msg : DM.conf.message,
  // 					buttons : Ext.Msg.OK,
  // 					icon : Ext.Msg.INFO
  // 				} );
  // 			}
  // 		},
  // 		icon : Ext.Msg.ERROR
  // 	} );
  // }
})();
