/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip.util;

import com.suncode.businesstrip.config.Configuration;
import com.suncode.businesstrip.config.data.JsonConf;
import com.suncode.businesstrip.database.model.BusinessTripRoute;
import com.suncode.businesstrip.exception.DMException;
import com.suncode.businesstrip.settlement.SettlementCountry;
import com.suncode.businesstrip.util.RouteCostDetails;
import com.suncode.businesstrip.util.Tools;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessTripUtil {
    private static final Logger log = LoggerFactory.getLogger(BusinessTripUtil.class);

    public static List<RouteCostDetails> getRoutesCostDetails(Set<BusinessTripRoute> routes, String vehicleType, SettlementCountry settlementCountry) throws DMException {
        ArrayList<RouteCostDetails> routesCostDetails = new ArrayList<RouteCostDetails>();
        for (BusinessTripRoute route : routes) {
            JsonConf configForRoute = Configuration.getJsonConfigForDate(settlementCountry, route.getPrzyjazd_data());
            if (!configForRoute.getKilometrowkaDla().contains(route.getSrodek_transportu())) continue;
            double rate = 0.0;
            for (List<String> vehicleRate : configForRoute.getKilometrowka()) {
                if (!vehicleRate.get(0).equalsIgnoreCase(vehicleType)) continue;
                rate = Tools.walidacjaDouble(vehicleRate.get(1), "Niepoprawna warto\u015b\u0107 stawki kilometr\u00f3wki.");
                break;
            }
            RouteCostDetails routeCostDetails = new RouteCostDetails(route.getKm(), rate);
            routesCostDetails.add(routeCostDetails);
        }
        return routesCostDetails;
    }

    public static double obliczIloscKmPrzejechanychWlasnymPojazdem(Set<BusinessTripRoute> trasa, String finishDelegationDate, String delegationNr) {
        long kmy = 0L;
        for (BusinessTripRoute odcinek : trasa) {
            if (!Configuration.getJsonConfigForDate(delegationNr, finishDelegationDate).getKilometrowkaDla().contains(odcinek.getSrodek_transportu())) continue;
            kmy += Math.round(odcinek.getKm() * 1000.0);
        }
        return (double)kmy / 1000.0;
    }

    public static double getStawkaKilometrowkiDlaPojazdu(String sr_lokomocji, String finishDelegationDate, SettlementCountry settlementCountry) throws DMException {
        double stawka = 0.0;
        for (List<String> kilometrowka : Configuration.getJsonConfigForDate(settlementCountry, finishDelegationDate).getKilometrowka()) {
            if (!kilometrowka.get(0).equalsIgnoreCase(sr_lokomocji)) continue;
            stawka = Tools.walidacjaDouble(kilometrowka.get(1), "Niepoprawna warto\u015b\u0107 stawki kilometr\u00f3wki.");
            break;
        }
        return stawka;
    }

    public static boolean sprawdzCzyPojazdKilometrowkaNaTrasie(Set<BusinessTripRoute> trasa, String finishDelegationDate, String delegationNr) {
        for (BusinessTripRoute odcinek : trasa) {
            if (!Configuration.getJsonConfigForDate(delegationNr, finishDelegationDate).getKilometrowkaDla().contains(odcinek.getSrodek_transportu())) continue;
            return true;
        }
        return false;
    }
}

