/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.businesstrip;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.businesstrip.BusinessTripService;
import com.suncode.businesstrip.audit.AuditTypes;
import com.suncode.businesstrip.config.Configuration;
import com.suncode.businesstrip.config.ConfigurationService;
import com.suncode.businesstrip.config.data.ActionConf;
import com.suncode.businesstrip.config.data.InputParams;
import com.suncode.businesstrip.config.data.JsonConf;
import com.suncode.businesstrip.config.data.OtherParams;
import com.suncode.businesstrip.config.data.OutputParams;
import com.suncode.businesstrip.database.model.BusinessTrip;
import com.suncode.businesstrip.database.model.BusinessTripQuantities;
import com.suncode.businesstrip.database.model.BusinessTripRoute;
import com.suncode.businesstrip.database.model.BusinessTripSpendings;
import com.suncode.businesstrip.document.BusinessTripDocumentService;
import com.suncode.businesstrip.dto.ActionConfDto;
import com.suncode.businesstrip.dto.BusinessTripDto;
import com.suncode.businesstrip.exception.DMException;
import com.suncode.businesstrip.module.BusinessTripListeners;
import com.suncode.businesstrip.settlement.SettlementCountry;
import com.suncode.businesstrip.settlement.SettlementService;
import com.suncode.businesstrip.settlement.SettlementServiceFactory;
import com.suncode.businesstrip.user.context.UserContext;
import com.suncode.businesstrip.util.Exchange;
import com.suncode.businesstrip.util.Tools;
import com.suncode.businesstrip.util.Translation;
import com.suncode.plugin.framework.Module;
import com.suncode.plugin.framework.ModuleAccessor;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.transaction.SharkTransactionManager;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.process.ProcessService;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"businessTrip"})
public class BusinessTripController {
    private static final Logger log = LoggerFactory.getLogger(BusinessTripController.class);
    @Autowired
    public BusinessTripService businessTripService;
    @Autowired
    public SettlementServiceFactory settlementServiceFactory;
    @Autowired
    public BusinessTripDocumentService businessTripDocumentService;
    @Autowired
    @Qualifier(value="configurationService")
    public ConfigurationService configurationService;
    @Autowired
    private ModuleAccessor moduleAccessor;
    @Autowired
    private UserContext userContext;

    @RequestMapping(value={"open"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public String openBusinessTrip(Model model, @RequestBody MultiValueMap<String, Object> actionConf, HttpServletRequest request) throws Exception {
        Date start = new Date();
        this.configurationService.loadConfiguration();
        ActionConfDto actionConfDto = this.convertParams(actionConf);
        this.configurationService.save(actionConfDto);
        ActionConf savedActionConf = Configuration.getActionConf(actionConfDto.getInputParams().getId());
        if (savedActionConf == null || savedActionConf.getInputParams() == null) {
            throw new RuntimeException("Nie mo\u017cna pobra\u0107 inputParams z zapisanego actionConf");
        }
        String delegationNr = savedActionConf.getInputParams().getId();
        InputParams inputParams = Configuration.getActionConf(delegationNr).getInputParams();
        this.setRateDate(inputParams, delegationNr, model);
        model.addAttribute("inputParams", (Object)inputParams);
        model.addAttribute("activityVariableParams", Configuration.getActionConf(delegationNr).getActivityVariableParams());
        request.setAttribute("decorator", (Object)"empty");
        this.logAudit(AuditTypes.AUDIT_OPEN_MODULE, true, new HashMap<String, Object>(), start);
        return "businessTripBody";
    }

    @RequestMapping(value={"close"}, method={RequestMethod.POST})
    public ResponseEntity<Void> auditCloseBusinessTrip() {
        this.logAudit(AuditTypes.AUDIT_CLOSE_MODULE, true, new HashMap<String, Object>(), new Date());
        return ResponseEntity.noContent().build();
    }

    private void setRateDate(InputParams inputParams, String delegationNr, Model model) throws Exception {
        try {
            Date rateDate = null;
            if ("zagranica".equals(inputParams.getType())) {
                BusinessTrip busnTrip = (BusinessTrip)this.businessTripService.get((Serializable)((Object)inputParams.getId()));
                rateDate = Exchange.selectExchangeRateDate(busnTrip, inputParams.getAdvanceDate(), inputParams.getProcessId(), inputParams.getActivityId(), inputParams.getId());
                inputParams.setRateDate(rateDate);
            } else {
                ActionConf actionConf = Configuration.getActionConf(delegationNr);
                if (actionConf != null && actionConf.getFieldsToHide() != null) {
                    actionConf.getFieldsToHide().add("data_kursu");
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            model.addAttribute("success", (Object)"false");
            model.addAttribute("message", (Object)e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"load"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> loadBusinessTrip(@RequestParam String processId, @RequestParam String activityId, @RequestParam String type, @RequestParam String id) {
        log.trace("************************* OdczytDelegacji ****************************");
        log.debug("Odczytanie danych rozliczenia delegacji dla process_id" + processId + " activity_id " + activityId + " typ delegacji " + type + " nr_delegacji " + id);
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            response.put("data", this.businessTripService.get((Serializable)((Object)id)));
            response.put("success", true);
        }
        catch (Exception e) {
            response.put("success", false);
            response.put("message", e.getLocalizedMessage());
            log.error("Nie mo\u017cna pobra\u0107 zapisanych danych z bazy danych poniewa\u017c : ", (Throwable)e);
        }
        return response;
    }

    @RequestMapping(value={"saveToProcess"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> saveBusinessTripToProcessCtx(final @RequestParam String processId, final @RequestParam String activityId, final @RequestParam String type, final @RequestParam String id) {
        log.trace("************************* ZapisNaMapieProcesu ****************************");
        final HashMap<String, Object> response_object = new HashMap<String, Object>();
        log.debug("Odczytanie danych rozliczenia delegacji dla process_id" + processId + " activity_id " + activityId + " typ delegacji " + type + " nr_delegacji " + id);
        final SharkTransactionManager mgr = TransactionManagerFactory.getSharkTransactionManager();
        TransactionTemplate tt = new TransactionTemplate((PlatformTransactionManager)mgr);
        tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    SharkTransaction st = mgr.getSharkTransaction();
                    BusinessTrip delegacja = (BusinessTrip)BusinessTripController.this.businessTripService.get((Serializable)((Object)id));
                    OutputParams outputParams = Configuration.getActionConf(id).getOutputParams();
                    JsonConf jsonConf = Configuration.getJsonConfigForDate(delegacja.getNr_delegacji(), delegacja.getData_powrotu());
                    String waluta = jsonConf.getCurrencyName();
                    if (StringUtils.isBlank((CharSequence)waluta)) {
                        waluta = jsonConf.getNazwaPolskiejWaluty();
                    }
                    boolean bSplitCountries = jsonConf.getZagranica().getRozdziel_ryczalty();
                    if (delegacja == null) {
                        throw new DMException("read.errorMsg");
                    }
                    ProcessService processService = ServiceFactory.getProcessService();
                    ActivityService activityService = ServiceFactory.getActivityService();
                    Map<String, Object> mapa = activityService.getActivityContext(processId, activityId);
                    Tools.logTraceContextMap(mapa, "Warto\u015bci mapy zadania przed aktualizacj\u0105 : ");
                    List<ExtendedAttribute> variableSets = BusinessTripController.this.getVariableSets(st, processId, activityId);
                    String[] summaryTableVariables = BusinessTripController.this.getAllColumnsFromTable(outputParams.getSummaryTableParams().values(), variableSets, mapa.keySet());
                    String[] costsTableVariables = BusinessTripController.this.getAllColumnsFromTable(outputParams.getCostsTableParams().values(), variableSets, mapa.keySet());
                    String[] spendingsTableVariables = BusinessTripController.this.getAllColumnsFromTable(outputParams.getSpendingsTableParams().values(), variableSets, mapa.keySet());
                    Map<String, Object> summaryTable = BusinessTripController.this.clearSummaryTable(id, outputParams.getSummaryTableParams(), summaryTableVariables, delegacja, mapa);
                    Map<String, Object> costsTable = BusinessTripController.this.clearCostsTable(id, outputParams.getCostsTableParams(), costsTableVariables, bSplitCountries, delegacja, mapa);
                    Map<String, Object> spendingsTable = BusinessTripController.this.clearSpendingsTable(type, id, outputParams.getSpendingsTableParams(), spendingsTableVariables, delegacja, mapa);
                    Map<String, Object> allTables = BusinessTripController.this.mergeTablesAndRemoveDuplicates(mapa, summaryTable, costsTable, spendingsTable);
                    Tools.logTraceContextMap(allTables, "Warto\u015bci mapy zadania po wyczyszczeniu : ");
                    BusinessTripController.this.addSummary(allTables, outputParams.getSummaryTableParams(), summaryTableVariables, delegacja, id, jsonConf.getDomesticCountryName());
                    BusinessTripController.this.addCosts(allTables, outputParams.getCostsTableParams(), costsTableVariables, delegacja, waluta, bSplitCountries, jsonConf.getDomesticCountryName());
                    BusinessTripController.this.addSpendings(allTables, outputParams.getSpendingsTableParams(), spendingsTableVariables, delegacja, mapa);
                    mapa.putAll(allTables);
                    Tools.logTraceContextMap(mapa, "Warto\u015bci mapy zadania po dodaniu aktualnych : ");
                    for (Module module : BusinessTripController.this.moduleAccessor.getModules(BusinessTripListeners.class)) {
                        mapa = ((BusinessTripListeners)module.getObject()).beforeWriteToProcess(mapa, delegacja);
                    }
                    Tools.logTraceContextMap(mapa, "Warto\u015bci mapy zadania po wykonaniu CustomClass : ");
                    processService.setProcessContext(processId, (Map)mapa);
                    if (log.isTraceEnabled()) {
                        Tools.logTraceContextMap(processService.getProcessContext(processId), "Warto\u015bci zapisanej mapy procesu : ");
                    }
                    activityService.setActivityContext(processId, activityId, mapa);
                    if (log.isTraceEnabled()) {
                        Tools.logTraceContextMap(activityService.getActivityContext(processId, activityId), "Warto\u015bci zapisanej mapy zadania : ");
                    }
                    response_object.put("success", true);
                }
                catch (Exception e) {
                    response_object.put("success", false);
                    response_object.put("message", e.getLocalizedMessage());
                    log.error("Nie mo\u017cna zapisa\u0107 danych na formularzu procesu poniewa\u017c : ", (Throwable)e);
                }
            }
        });
        return response_object;
    }

    private List<ExtendedAttribute> getVariableSets(SharkTransaction st, String processId, String activityId) {
        Activity activity = this.getActivityDefinition(st, processId, activityId);
        ArrayList editableTables = activity.getExtendedAttributes().getElementsForName("VARIABLE_SET");
        ArrayList notEditableTables = activity.getExtendedAttributes().getElementsForName("VARIABLE_SET_VIEW");
        ArrayList<ExtendedAttribute> variableSets = new ArrayList<ExtendedAttribute>();
        Optional.ofNullable(editableTables).ifPresent(variableSets::addAll);
        Optional.ofNullable(notEditableTables).ifPresent(variableSets::addAll);
        return variableSets;
    }

    private Activity getActivityDefinition(SharkTransaction st, String processId, String activityId) {
        Package pack = XpdlPackageManager.getInstance().getPackageByProcessId(processId);
        String processDefId = SharkFunctions.getProcessDefId((String)processId);
        String activityDefId = SharkFunctions.getActivityDefId((String)processId, (String)activityId);
        return pack.getWorkflowProcess(processDefId).getActivity(activityDefId);
    }

    private String[] getAllColumnsFromTable(Collection<String> partialTableColumns, List<ExtendedAttribute> variableSets, Set<String> activityVariables) {
        for (String column : partialTableColumns) {
            for (ExtendedAttribute attribute : variableSets) {
                ArrayList<String> elements = new ArrayList<String>();
                String value = attribute.getVValue();
                Optional.ofNullable(value).ifPresent(v -> elements.addAll(Arrays.asList(value.split("\\r?\\n"))));
                if (!elements.contains(column)) continue;
                Set<String> variables = this.filterVariables(elements, activityVariables);
                variables.addAll(partialTableColumns);
                return variables.toArray(new String[0]);
            }
        }
        return partialTableColumns.toArray(new String[0]);
    }

    private Set<String> filterVariables(List<String> variableSetElements, Set<String> activityVariables) {
        return variableSetElements.stream().filter(activityVariables::contains).collect(Collectors.toSet());
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"settle"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> settleAndSaveBusinessTrip(@RequestBody BusinessTripDto settleRequest) {
        log.trace("************************* RozliczDelegacje ****************************");
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            BusinessTrip busnTrip;
            boolean settleNew;
            OtherParams otherParams;
            String delegationNr;
            ActionConf actionConf;
            if (!settleRequest.getType().equalsIgnoreCase("kraj") && !settleRequest.getType().equalsIgnoreCase("zagranica")) {
                response.put("success", false);
                response.put("message", "settlement.settle.errorMsg.incorrectType");
                log.error("B\u0142\u0119dny typ delegacji : " + settleRequest.getType());
                return response;
            }
            log.debug("Zapisywanie danych rozliczenia delegacji dla process_id" + settleRequest.getProcessId() + " activity_id " + settleRequest.getActivityId() + " typ delegacji " + settleRequest.getType());
            if (settleRequest.getSettlementCountry() == null && (actionConf = Configuration.getActionConf(delegationNr = settleRequest.getBaseData().getNr_delegacji())) != null && (otherParams = actionConf.getOtherParams()) != null && otherParams.getSettlementCountry() != null) {
                settleRequest.setSettlementCountry(otherParams.getSettlementCountry());
                log.debug("Ustawiono settlementCountry z konfiguracji: {}", (Object)otherParams.getSettlementCountry());
            }
            boolean bl = settleNew = (busnTrip = (BusinessTrip)this.businessTripService.get((Serializable)((Object)settleRequest.getBaseData().getNr_delegacji()))) == null || !busnTrip.getTyp_delegacji().equalsIgnoreCase(settleRequest.getType());
            if (settleNew) {
                if (busnTrip != null) {
                    this.businessTripService.delete(busnTrip);
                }
                BusinessTrip newBusnTrip = new BusinessTrip();
                newBusnTrip = this.settle(newBusnTrip, settleRequest, response);
                this.businessTripService.save(newBusnTrip);
            } else {
                busnTrip = this.settle(busnTrip, settleRequest, response);
                this.businessTripService.update(busnTrip);
            }
            response.put("success", true);
        }
        catch (Exception e) {
            response.put("success", false);
            response.put("message", e.getLocalizedMessage());
            log.error("Nie mo\u017cna rozliczy\u0107 delegacji poniewa\u017c : ", (Throwable)e);
        }
        return response;
    }

    @RequestMapping(value={"generateAndLink"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> generateDocumentAndLinkToProcess(@RequestParam String processId, @RequestParam String activityId, @RequestParam String type, @RequestParam String id) {
        log.trace("************************* GenerowaniePDFPodlaczeniePodProces ****************************");
        log.debug("Generowania pdf rozliczenia delegacji i pod\u0142\u0105czanie pod proces process_id" + processId + " activity_id " + activityId + " typ delegacji " + type + " nr_delegacji " + id);
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            this.businessTripDocumentService.prepareAndAttachPdfs(processId, activityId, id);
            response.put("success", true);
        }
        catch (Exception e) {
            response.put("success", false);
            response.put("message", e.getLocalizedMessage());
            log.error("Nie mo\u017cna wygenerowa\u0107 dokumentu pdf i pod\u0142\u0105czy\u0107 do procesu poniewa\u017c : ", (Throwable)e);
        }
        return response;
    }

    private Map<String, Object> clearSpendingsTable(String type, String delegationNr, Map<String, String> mapping_wydatkow, String[] allTableVariables, BusinessTrip delegacja, Map<String, Object> mapa) throws DMException, Exception {
        ActionConf actionConf = Configuration.getActionConf(delegationNr);
        if (actionConf != null && actionConf.getOtherParams() != null && actionConf.getOtherParams().getIsSpendingTableVisible().booleanValue() && StringUtils.isNotBlank((CharSequence)mapping_wydatkow.get("nr_delegacji"))) {
            log.trace("Mapowanie wydatk\u00f3w");
            HashMap<String, String> warunek = new HashMap<String, String>();
            String map_wydatkow_nr_delegacji = mapping_wydatkow.get("nr_delegacji");
            if (map_wydatkow_nr_delegacji == null || map_wydatkow_nr_delegacji.equals("")) {
                throw new DMException("settlement.saveToProcess.errorMsg.noIdInSpendingsTab");
            }
            if (!mapa.containsKey(map_wydatkow_nr_delegacji)) {
                log.error("Brak " + map_wydatkow_nr_delegacji + " zmiennej w mapie procesu.");
                throw new DMException("settlement.saveToProcess.errorMsg.spendingsTab.noIdOnProcessMap");
            }
            warunek.put(map_wydatkow_nr_delegacji, delegationNr);
            log.debug("Usuwanie wydatk\u00f3w dla nr delegacji " + delegationNr);
            Map wyczyszczona_tabela_wydatkow = DynamicTableFunctions.deleteRecordsAllConditions(mapa, (String[])allTableVariables, warunek);
            this.sprawdzWyczyszczonaTabele(wyczyszczona_tabela_wydatkow, allTableVariables, mapping_wydatkow);
            return wyczyszczona_tabela_wydatkow;
        }
        return null;
    }

    private Map<String, Object> clearCostsTable(String id, Map<String, String> mapping_kosztow, String[] allTableVariables, boolean bSplitCountries, BusinessTrip delegacja, Map<String, Object> mapa) throws DMException, Exception {
        HashMap<String, String> warunek = new HashMap<String, String>();
        String map_kosztow_nr_delegacji = mapping_kosztow.get("nr_delegacji");
        if (map_kosztow_nr_delegacji == null || map_kosztow_nr_delegacji.equals("")) {
            throw new DMException("settlement.saveToProcess.errorMsg.noIdInCostsTab");
        }
        if (!mapa.containsKey(map_kosztow_nr_delegacji)) {
            log.error("Brak " + map_kosztow_nr_delegacji + " zmiennej w mapie procesu.");
            throw new DMException("settlement.saveToProcess.errorMsg.costsTab.noIdOnProcessMap");
        }
        warunek.put(map_kosztow_nr_delegacji, id);
        log.debug("Usuwa kosztow rozliczenia dla nr delegacji " + id);
        Map wyczyszczona_tabela_kosztow = DynamicTableFunctions.deleteRecordsAllConditions(mapa, (String[])allTableVariables, warunek);
        this.sprawdzWyczyszczonaTabele(wyczyszczona_tabela_kosztow, allTableVariables, mapping_kosztow);
        return wyczyszczona_tabela_kosztow;
    }

    private void addCosts(Map<String, Object> wyczyszczona_tabela_kosztow, Map<String, String> mapping_kosztow, String[] ids_tabeli_kosztow, BusinessTrip delegacja, String waluta, boolean bSplitCountries, String domesticCountryName) throws Exception {
        this.synchroniseColumnsValuesNumber(wyczyszczona_tabela_kosztow, ids_tabeli_kosztow);
        if (delegacja.getDieta_kraj() != null && delegacja.getDieta_kraj() >= 0.0) {
            log.trace("Dodawanie diety krajowej do tabeli koszt\u00f3w " + delegacja.getDieta_kraj());
            this.dodajWierszKosztow(wyczyszczona_tabela_kosztow, ids_tabeli_kosztow, mapping_kosztow, delegacja, Translation.getCustomMessage("dieta_krajowa"), delegacja.getDieta_kraj(), waluta, 1.0);
        }
        if (delegacja.getDieta_zagranica() != null && delegacja.getDieta_zagranica() >= 0.0) {
            for (BusinessTripQuantities kraj : delegacja.getIlosci()) {
                if (kraj.getKraj().equalsIgnoreCase(domesticCountryName)) continue;
                log.trace("Dodawanie diety zagranicznej do tabeli koszt\u00f3w dla kraju " + kraj.getKraj() + " dieta " + kraj.getDieta_w_walucie_kraju() + " w walucie" + kraj.getWaluta());
                this.dodajWierszKosztow(wyczyszczona_tabela_kosztow, ids_tabeli_kosztow, mapping_kosztow, delegacja, Translation.getCustomMessage("dieta_zagraniczna") + " - " + Translation.getCustomMessage(kraj.getKraj()), kraj.getDieta_w_walucie_kraju(), kraj.getWaluta(), kraj.getKurs_walutowy());
            }
        }
        if (delegacja.getRyczalt_srodki_miejskie_kraj() != null && delegacja.getRyczalt_srodki_miejskie_kraj() > 0.0) {
            log.trace("Dodawanie ryczaltu za srodki miejskie (kraj) do tabeli koszt\u00f3w " + delegacja.getRyczalt_srodki_miejskie_kraj());
            this.dodajWierszKosztow(wyczyszczona_tabela_kosztow, ids_tabeli_kosztow, mapping_kosztow, delegacja, Translation.getCustomMessage("ryczalt_srodki_miejskie") + " - " + Translation.getCustomMessage("kraj"), delegacja.getRyczalt_srodki_miejskie_kraj(), waluta, 1.0);
        }
        if ("zagranica".equalsIgnoreCase(delegacja.getTyp_delegacji()) && !bSplitCountries && delegacja.getRyczalt_srodki_miejskie_zagranica() != null && delegacja.getRyczalt_srodki_miejskie_zagranica() > 0.0) {
            log.trace("Dodawanie ryczaltu za srodki miejskie (zagranica) do tabeli koszt\u00f3w " + delegacja.getRyczalt_srodki_miejskie_zagranica());
            this.dodajWierszKosztow(wyczyszczona_tabela_kosztow, ids_tabeli_kosztow, mapping_kosztow, delegacja, Translation.getCustomMessage("ryczalt_srodki_miejskie") + " - " + Translation.getCustomMessage("zagranica"), delegacja.getRyczalt_srodki_miejskie_zagranica(), waluta, 1.0);
        }
        if (delegacja.getRyczalt_noclegi_kraj() != null && delegacja.getRyczalt_noclegi_kraj() > 0.0) {
            log.trace("Dodawanie ryczaltu za noclegi (kraj) do tabeli koszt\u00f3w " + delegacja.getRyczalt_noclegi_kraj());
            this.dodajWierszKosztow(wyczyszczona_tabela_kosztow, ids_tabeli_kosztow, mapping_kosztow, delegacja, Translation.getCustomMessage("ryczalt_noclegi") + " - " + Translation.getCustomMessage("kraj"), delegacja.getRyczalt_noclegi_kraj(), waluta, 1.0);
        }
        if ("zagranica".equalsIgnoreCase(delegacja.getTyp_delegacji()) && !bSplitCountries && delegacja.getRyczalt_noclegi_zagranica() != null && delegacja.getRyczalt_noclegi_zagranica() > 0.0) {
            log.trace("Dodawanie ryczaltu za noclegi (zagranica) do tabeli koszt\u00f3w " + delegacja.getRyczalt_noclegi_zagranica());
            this.dodajWierszKosztow(wyczyszczona_tabela_kosztow, ids_tabeli_kosztow, mapping_kosztow, delegacja, Translation.getCustomMessage("ryczalt_noclegi") + " - " + Translation.getCustomMessage("zagranica"), delegacja.getRyczalt_noclegi_zagranica(), waluta, 1.0);
        }
        if (bSplitCountries) {
            for (BusinessTripQuantities kraj : delegacja.getIlosci()) {
                if (!kraj.getKraj().equalsIgnoreCase(domesticCountryName)) {
                    if (kraj.getRyczalt_noclegi() != null && kraj.getRyczalt_noclegi() > 0.0) {
                        this.dodajWierszKosztow(wyczyszczona_tabela_kosztow, ids_tabeli_kosztow, mapping_kosztow, delegacja, Translation.getCustomMessage("ryczalt_noclegi") + " - " + Translation.getCustomMessage(kraj.getKraj()), kraj.getRyczalt_noclegi(), kraj.getWaluta(), kraj.getKurs_walutowy());
                    }
                    if (kraj.getRyczalt_doby_kom_miejskiej() != null && kraj.getRyczalt_doby_kom_miejskiej() > 0.0) {
                        this.dodajWierszKosztow(wyczyszczona_tabela_kosztow, ids_tabeli_kosztow, mapping_kosztow, delegacja, Translation.getCustomMessage("ryczalt_srodki_miejskie") + " - " + Translation.getCustomMessage(kraj.getKraj()), kraj.getRyczalt_doby_kom_miejskiej(), kraj.getWaluta(), kraj.getKurs_walutowy());
                    }
                }
                if (kraj.getRyczalt_przejazdy_do_z_dworca() == null || !(kraj.getRyczalt_przejazdy_do_z_dworca() > 0.0)) continue;
                this.dodajWierszKosztow(wyczyszczona_tabela_kosztow, ids_tabeli_kosztow, mapping_kosztow, delegacja, Translation.getCustomMessage("ryczalt_przejazdy_dworzec") + " - " + Translation.getCustomMessage(kraj.getKraj()), kraj.getRyczalt_przejazdy_do_z_dworca(), kraj.getWaluta(), kraj.getKurs_walutowy());
            }
        }
        if (!bSplitCountries && delegacja.getRyczalt_za_przejazdy_do_z_dworca() != null && delegacja.getRyczalt_za_przejazdy_do_z_dworca() > 0.0) {
            log.trace("Dodawanie ryczaltu za dojazdy z do dworca " + delegacja.getRyczalt_za_przejazdy_do_z_dworca());
            this.dodajWierszKosztow(wyczyszczona_tabela_kosztow, ids_tabeli_kosztow, mapping_kosztow, delegacja, Translation.getCustomMessage("ryczalt_przejazdy_dworzec"), delegacja.getRyczalt_za_przejazdy_do_z_dworca(), waluta, 1.0);
        }
        if (delegacja.getKilometrowka() != null && delegacja.getKilometrowka() > 0.0) {
            log.trace("Dodawanie kilometrowki do tabeli koszt\u00f3w " + delegacja.getKilometrowka());
            this.dodajWierszKosztow(wyczyszczona_tabela_kosztow, ids_tabeli_kosztow, mapping_kosztow, delegacja, Translation.getCustomMessage("ryczalt_dojazdy"), delegacja.getKilometrowka(), waluta, 1.0);
        }
    }

    private Map<String, Object> clearSummaryTable(String id, Map<String, String> mapping_podsumowan, String[] allTableVariables, BusinessTrip delegacja, Map<String, Object> mapa) throws DMException, Exception {
        HashMap<String, String> warunek = new HashMap<String, String>();
        String map_podsumowan_nr_delegacji = mapping_podsumowan.get("nr_delegacji");
        if (map_podsumowan_nr_delegacji == null || map_podsumowan_nr_delegacji.equals("")) {
            throw new DMException("settlement.saveToProcess.errorMsg.noIdInSummaryTab");
        }
        if (!mapa.containsKey(map_podsumowan_nr_delegacji)) {
            log.error("Brak " + map_podsumowan_nr_delegacji + " zmiennej w mapie procesu.");
            throw new DMException("settlement.saveToProcess.errorMsg.summaryTab.noIdOnProcessMap");
        }
        warunek.put(map_podsumowan_nr_delegacji, id);
        log.debug("Usuwa podsumowanie rozliczenia dla nr delegacji " + id);
        Map wyczyszczona_tabela_podsumowan = DynamicTableFunctions.deleteRecordsAllConditions(mapa, (String[])allTableVariables, warunek);
        this.sprawdzWyczyszczonaTabele(wyczyszczona_tabela_podsumowan, allTableVariables, mapping_podsumowan);
        return wyczyszczona_tabela_podsumowan;
    }

    private void sprawdzWyczyszczonaTabele(Map<String, Object> tabela, String[] identifykatoryKosztow, Map<String, String> mapping) {
        int i;
        if (tabela.isEmpty()) {
            for (i = 0; i < identifykatoryKosztow.length; ++i) {
                tabela.put(identifykatoryKosztow[i], "");
            }
        }
        if (tabela.get(mapping.get("nr_delegacji")) == null) {
            for (i = 0; i < identifykatoryKosztow.length; ++i) {
                tabela.put(identifykatoryKosztow[i], "");
            }
        }
        if (((String)tabela.get(mapping.get("nr_delegacji"))).toLowerCase().contains("null")) {
            for (i = 0; i < identifykatoryKosztow.length; ++i) {
                tabela.put(identifykatoryKosztow[i], "");
            }
        }
    }

    private void dodajWierszKosztow(Map<String, Object> tabela, String[] identifykatoryKosztow, Map<String, String> mapping, BusinessTrip delegacja, String opis, Double kwota, String waluta, Double kurs_waluty) throws Exception {
        String t_waluta;
        String t_waluta_key;
        String t_kwota_w_walucie_key;
        String t_opis_linii_key;
        String t_nr_delegacji_key;
        if (this.hasAnyRow(tabela, identifykatoryKosztow)) {
            for (int i = 0; i < identifykatoryKosztow.length; ++i) {
                String wartosc = (String)tabela.get(identifykatoryKosztow[i]);
                tabela.put(identifykatoryKosztow[i], wartosc.concat(";"));
            }
        }
        if ((t_nr_delegacji_key = mapping.get("nr_delegacji")) != null && !t_nr_delegacji_key.equals("")) {
            String t_nr_delegacji = (String)tabela.get(t_nr_delegacji_key);
            tabela.put(t_nr_delegacji_key, t_nr_delegacji.concat(delegacja.getNr_delegacji()));
        }
        if ((t_opis_linii_key = mapping.get("opis_linii")) != null && !t_opis_linii_key.equals("")) {
            String t_opis_linii = (String)tabela.get(t_opis_linii_key);
            tabela.put(t_opis_linii_key, t_opis_linii.concat(opis));
        }
        if ((t_kwota_w_walucie_key = mapping.get("kwota_w_walucie")) != null && !t_kwota_w_walucie_key.equals("")) {
            String t_kwota_w_walucie = (String)tabela.get(t_kwota_w_walucie_key);
            tabela.put(t_kwota_w_walucie_key, t_kwota_w_walucie.concat(Tools.toString(kwota)));
        }
        if ((t_waluta_key = mapping.get("waluta")) != null && !t_waluta_key.equals("")) {
            t_waluta = (String)tabela.get(t_waluta_key);
            tabela.put(t_waluta_key, t_waluta.concat(waluta));
        }
        if ((t_waluta_key = mapping.get("kurs_waluty")) != null && !t_waluta_key.equals("")) {
            t_waluta = (String)tabela.get(t_waluta_key);
            tabela.put(t_waluta_key, t_waluta.concat(Tools.formatKurs(kurs_waluty, false)));
        }
        if ((t_waluta_key = mapping.get("wspolczynnik_waluty")) != null && !t_waluta_key.equals("")) {
            t_waluta = (String)tabela.get(t_waluta_key);
            tabela.put(t_waluta_key, t_waluta.concat(Tools.toString(1.0)));
        }
    }

    private boolean hasAnyRow(Map<String, ?> tabela, String[] allTableVariables) {
        for (String column : allTableVariables) {
            if (tabela.get(column) == null || tabela.get(column).toString().length() <= 0) continue;
            return true;
        }
        return false;
    }

    private void addSpendings(Map<String, Object> results, Map<String, String> mapping, String[] spendingsTableVariables, BusinessTrip trip, Map<String, Object> map) throws Exception {
        this.synchroniseColumnsValuesNumber(results, spendingsTableVariables);
        Map<String, StringBuilder> newResults = this.copyPreviousResults(results);
        this.addNewSpendingsRows(newResults, mapping, spendingsTableVariables, trip, map);
        this.updateResults(results, newResults);
    }

    private Map<String, StringBuilder> copyPreviousResults(Map<String, Object> results) {
        HashMap<String, StringBuilder> newRows = new HashMap<String, StringBuilder>();
        results.forEach((k, v) -> newRows.put((String)k, new StringBuilder(results.get(k).toString())));
        return newRows;
    }

    private void synchroniseColumnsValuesNumber(Map<String, Object> tabela, String[] allTableVariables) {
        int maxColumnsValuesCount = 0;
        int columnValueCount = 0;
        for (String column : allTableVariables) {
            if (tabela.get(column) == null || (columnValueCount = this.countColumnValues(tabela.get(column).toString())) <= maxColumnsValuesCount) continue;
            maxColumnsValuesCount = columnValueCount;
        }
        for (String column : allTableVariables) {
            String columnValue;
            int missedColumnValuesNumber;
            if (tabela.get(column) == null || (missedColumnValuesNumber = maxColumnsValuesCount - (columnValueCount = this.countColumnValues(columnValue = tabela.get(column).toString()))) <= 0) continue;
            missedColumnValuesNumber = columnValueCount > 0 ? missedColumnValuesNumber : missedColumnValuesNumber - 1;
            String valuesToAdd = this.getEmptyColValues(missedColumnValuesNumber);
            tabela.put(column, columnValue.concat(valuesToAdd));
        }
    }

    private int countColumnValues(String columnValue) {
        int count = StringUtils.countMatches((CharSequence)columnValue, (CharSequence)";");
        return columnValue.length() > 0 ? count + 1 : count;
    }

    private void addNewSpendingsRows(Map<String, StringBuilder> newResults, Map<String, String> mapping, String[] spendingsTableVariables, BusinessTrip trip, Map<String, Object> map) {
        String addString = this.hasAnyRow(newResults, spendingsTableVariables) ? ";" : "";
        String tripId = trip.getNr_delegacji();
        List<String> otherSpendingParameters = Arrays.stream(spendingsTableVariables).filter(var -> !mapping.containsValue(var)).toList();
        String spendingProcessVariableName = mapping.get("wydatek_id");
        Map<String, Map<String, String>> otherParametersForSpendingRowId = this.getOtherParametersMapForSpendingRowId(map, otherSpendingParameters, spendingProcessVariableName);
        for (BusinessTripSpendings spending : trip.getWydatki()) {
            Map<String, String> rowToAdd = this.buildNewSpendingRow(mapping, tripId, spending);
            this.addNewSpendingRow(newResults, rowToAdd, addString, otherParametersForSpendingRowId, spendingProcessVariableName);
            addString = ";";
        }
    }

    private Map<String, Map<String, String>> getOtherParametersMapForSpendingRowId(Map<String, Object> map, List<String> spendingTableVariables, String spendingProcessVariableName) {
        LinkedHashMap<String, Map<String, String>> rowMap = new LinkedHashMap<String, Map<String, String>>();
        if (!map.containsKey(spendingProcessVariableName)) {
            return rowMap;
        }
        String[] ids = map.get(spendingProcessVariableName).toString().split(";");
        for (String id : ids) {
            rowMap.put(id, new LinkedHashMap());
        }
        for (String key : spendingTableVariables) {
            String[] values;
            if (!map.containsKey(key) || (values = map.get(key).toString().split(";", -1)).length != ids.length) continue;
            for (int i = 0; i < ids.length; ++i) {
                ((Map)rowMap.get(ids[i])).put(key, values[i]);
            }
        }
        return rowMap;
    }

    private String getEmptyColValues(int diff) {
        Object result = "";
        for (int i = 1; i <= diff; ++i) {
            result = (String)result + ";";
        }
        return result;
    }

    private Map<String, String> buildNewSpendingRow(Map<String, String> mapping, String tripId, BusinessTripSpendings spending) {
        HashMap<String, String> rowToAdd = new HashMap<String, String>();
        mapping.forEach((k, v) -> rowToAdd.put((String)v, this.buildSpendingsValue((String)k, tripId, spending)));
        return rowToAdd;
    }

    private String buildSpendingsValue(String spendingsValueKey, String tripId, BusinessTripSpendings spending) {
        switch (spendingsValueKey) {
            case "nr_delegacji": {
                return tripId;
            }
            case "wydatek_id": {
                return spending.getId().toString();
            }
            case "nazwa_wydatku": {
                return spending.getNazwa_wydatku();
            }
            case "rodzaj_wydatku": {
                return Tools.returnEmptyIfNull(spending.getRodzaj_wydatku());
            }
            case "paymentMethod": {
                return Tools.returnEmptyIfNull(spending.getPaymentMethod());
            }
            case "documentType": {
                return Tools.returnEmptyIfNull(spending.getDocumentType());
            }
            case "koszt": {
                return Tools.toString(spending.getKoszt());
            }
            case "waluta": {
                return spending.getWaluta();
            }
            case "data": {
                return spending.getData();
            }
            case "kurs_waluty": {
                return Tools.formatKurs(spending.getKurs(), false);
            }
            case "wspolczynnik_waluty": {
                return Tools.toString(1.0);
            }
        }
        return "";
    }

    private void addNewSpendingRow(Map<String, StringBuilder> newRows, Map<String, String> rowToAdd, String addString, Map<String, Map<String, String>> otherParametersForSpendingRowId, String spendingProcessVariableName) {
        rowToAdd.forEach((k, v) -> ((StringBuilder)newRows.get(k)).append(addString).append((String)v));
        if (CollectionUtils.isEmpty(otherParametersForSpendingRowId)) {
            return;
        }
        Map<String, String> otherParameters = otherParametersForSpendingRowId.get(rowToAdd.get(spendingProcessVariableName));
        if (CollectionUtils.isEmpty(otherParameters)) {
            return;
        }
        otherParameters.forEach((k, v) -> ((StringBuilder)newRows.get(k)).append(addString).append((String)v));
    }

    private void updateResults(Map<String, Object> results, Map<String, StringBuilder> newResults) {
        newResults.forEach((k, v) -> results.put((String)k, v.toString()));
    }

    private void addSummary(Map<String, Object> tabela, Map<String, String> mapping, String[] allTableVariables, BusinessTrip delegacja, String delegationNr, String domesticCountryName) throws Exception {
        String t_suma_wydatkow;
        ActionConf actionConfForSummary;
        String t_suma_ilosci_diet_zagranica;
        Object t_suma_ilosci_niezapewnionych_przejazdow_do_z_dworca;
        String t_suma_ilosci_diet_kraj;
        String t_suma_ilosci_niezapewnionych_przejazdow_do_z_dworca_key;
        String t_suma_ilosci_niezapewnionych_kolacji_key;
        String t_suma_ilosci_niezapewnionych_dob_calodobowe_wyzywienie_key;
        String t_suma_ilosci_zapewnionych_dob_calodobowe_wyzywienie_key;
        String t_suma_ilosci_niezapewnionych_obiadow_key;
        String t_suma_ilosci_niezapewnionych_sniadan_key;
        String t_suma_ilosci_niezapewnionych_noclegow_key;
        String t_suma_ilosci_niezapewnionych_dob_komunikacji_miejskiej_key;
        String t_suma_ilosci_godzin_w_delegacji_key;
        String t_cel_delegacji_key;
        String t_dni_w_delegacji_key;
        String t_nr_rejestracyjny_key;
        String t_srodek_transportu_key;
        String t_kraj_delegacji_key;
        String t_nr_delegacji_key;
        String t_miasto_docelowe_key;
        if (this.hasAnyRow(tabela, allTableVariables)) {
            log.debug("Dodawanie kolejnego wiersza");
            for (int i = 0; i < allTableVariables.length; ++i) {
                String wartosc = (String)tabela.get(allTableVariables[i]);
                tabela.put(allTableVariables[i], wartosc.concat(";"));
            }
        }
        if (!delegacja.getTrasa().isEmpty()) {
            String t_przyjazd_godzina_key;
            String t_przyjazd_data_key;
            String t_przyjazd_miejscowosc_key;
            String t_wyjazd_godzina_key;
            String t_wyjazd_data_key;
            BusinessTripRoute beginingPoint = null;
            BusinessTripRoute finishPoint = new BusinessTripRoute();
            for (BusinessTripRoute routePoint : delegacja.getTrasa()) {
                if (beginingPoint == null) {
                    beginingPoint = new BusinessTripRoute();
                    beginingPoint = routePoint;
                }
                finishPoint = routePoint;
            }
            int trasa_size = delegacja.getTrasa().size();
            String t_miejsce_wyjazdu_key = mapping.get("wyjazd_miejscowosc");
            if (t_miejsce_wyjazdu_key != null && !t_miejsce_wyjazdu_key.equals("")) {
                String t_miejsce_wyjazdu = (String)tabela.get(t_miejsce_wyjazdu_key);
                tabela.put(t_miejsce_wyjazdu_key, t_miejsce_wyjazdu.concat(beginingPoint.getWyjazd_miejscowosc()));
            }
            if ((t_wyjazd_data_key = mapping.get("wyjazd_data")) != null && !t_wyjazd_data_key.equals("")) {
                String t_data_od = (String)tabela.get(t_wyjazd_data_key);
                tabela.put(t_wyjazd_data_key, t_data_od.concat(beginingPoint.getWyjazd_data()));
            }
            if ((t_wyjazd_godzina_key = mapping.get("wyjazd_godzina")) != null && !t_wyjazd_godzina_key.equals("")) {
                String t_godz_od = (String)tabela.get(t_wyjazd_godzina_key);
                tabela.put(t_wyjazd_godzina_key, t_godz_od.concat(beginingPoint.getWyjazd_godzina()));
            }
            if ((t_przyjazd_miejscowosc_key = mapping.get("przyjazd_miejscowosc")) != null && !t_przyjazd_miejscowosc_key.equals("")) {
                String t_miejsce_przyjazdu = (String)tabela.get(t_przyjazd_miejscowosc_key);
                tabela.put(t_przyjazd_miejscowosc_key, t_miejsce_przyjazdu.concat(finishPoint.getPrzyjazd_miejscowosc()));
            }
            if ((t_przyjazd_data_key = mapping.get("przyjazd_data")) != null && !t_przyjazd_data_key.equals("")) {
                String t_data_do = (String)tabela.get(t_przyjazd_data_key);
                tabela.put(t_przyjazd_data_key, t_data_do.concat(finishPoint.getPrzyjazd_data()));
            }
            if ((t_przyjazd_godzina_key = mapping.get("przyjazd_godzina")) != null && !t_przyjazd_godzina_key.equals("")) {
                String t_godz_do = (String)tabela.get(t_przyjazd_godzina_key);
                tabela.put(t_przyjazd_godzina_key, t_godz_do.concat(finishPoint.getPrzyjazd_godzina()));
            }
        }
        if ((t_miasto_docelowe_key = mapping.get("miasto_docelowe")) != null && !t_miasto_docelowe_key.equals("")) {
            String miastoDoceloweg = delegacja.getMiasto_docelowe();
            String t_miasto_docelowe = (String)tabela.get(t_miasto_docelowe_key);
            tabela.put(t_miasto_docelowe_key, t_miasto_docelowe.concat(miastoDoceloweg));
        }
        if ((t_nr_delegacji_key = mapping.get("nr_delegacji")) != null && !t_nr_delegacji_key.equals("")) {
            String t_nr_del = (String)tabela.get(t_nr_delegacji_key);
            tabela.put(t_nr_delegacji_key, t_nr_del.concat(delegacja.getNr_delegacji()));
        }
        if ((t_kraj_delegacji_key = mapping.get("kraj_delegacji")) != null && !t_kraj_delegacji_key.equals("")) {
            String t_kraj = (String)tabela.get(t_kraj_delegacji_key);
            tabela.put(t_kraj_delegacji_key, t_kraj.concat(delegacja.getKraje_docelowe()));
        }
        if ((t_srodek_transportu_key = mapping.get("srodek_transportu")) != null && !t_srodek_transportu_key.equals("")) {
            String t_srodek_transportu = (String)tabela.get(t_srodek_transportu_key);
            tabela.put(t_srodek_transportu_key, t_srodek_transportu.concat(delegacja.getSr_lokomocji()));
        }
        if ((t_nr_rejestracyjny_key = mapping.get("nr_rejestracyjny")) != null && !t_nr_rejestracyjny_key.equals("")) {
            String t_nr_rejestracyjny = (String)tabela.get(t_nr_rejestracyjny_key);
            tabela.put(t_nr_rejestracyjny_key, t_nr_rejestracyjny.concat(delegacja.getNr_rejestracyjny()));
        }
        if ((t_dni_w_delegacji_key = mapping.get("suma_dni_w_delegacji")) != null && !t_dni_w_delegacji_key.equals("")) {
            String t_dni_del = (String)tabela.get(t_dni_w_delegacji_key);
            tabela.put(t_dni_w_delegacji_key, t_dni_del.concat(Tools.toString((double)delegacja.getMinuty_w_delegacji().longValue() / 1440.0)));
        }
        if ((t_cel_delegacji_key = mapping.get("cel_delegacji")) != null && !t_cel_delegacji_key.equals("")) {
            String t_cel_delegacji = (String)tabela.get(t_cel_delegacji_key);
            tabela.put(t_cel_delegacji_key, t_cel_delegacji.concat(delegacja.getCel_delegacji()));
        }
        if ((t_suma_ilosci_godzin_w_delegacji_key = mapping.get("suma_ilosci_godzin_w_delegacji")) != null && !t_suma_ilosci_godzin_w_delegacji_key.equals("")) {
            String t_suma_ilosci_godzin_w_delegacji = (String)tabela.get(t_suma_ilosci_godzin_w_delegacji_key);
            tabela.put(t_suma_ilosci_godzin_w_delegacji_key, t_suma_ilosci_godzin_w_delegacji.concat(Tools.toString((double)delegacja.getMinuty_w_delegacji().longValue() / 60.0)));
        }
        if ((t_suma_ilosci_niezapewnionych_dob_komunikacji_miejskiej_key = mapping.get("suma_ilosci_niezapewnionych_dob_komunikacji_miejskiej")) != null && !t_suma_ilosci_niezapewnionych_dob_komunikacji_miejskiej_key.equals("")) {
            String t_suma_ilosci_niezapewnionych_dob_komunikacji_miejskiej = (String)tabela.get(t_suma_ilosci_niezapewnionych_dob_komunikacji_miejskiej_key);
            tabela.put(t_suma_ilosci_niezapewnionych_dob_komunikacji_miejskiej_key, t_suma_ilosci_niezapewnionych_dob_komunikacji_miejskiej.concat(this.sumaZTabeliKrajowDocelowych(delegacja.getIlosci(), "suma_ilosci_niezapewnionych_dob_komunikacji_miejskiej")));
        }
        if ((t_suma_ilosci_niezapewnionych_noclegow_key = mapping.get("suma_ilosci_niezapewnionych_noclegow")) != null && !t_suma_ilosci_niezapewnionych_noclegow_key.equals("")) {
            String t_suma_ilosci_niezapewnionych_noclegow = (String)tabela.get(t_suma_ilosci_niezapewnionych_noclegow_key);
            tabela.put(t_suma_ilosci_niezapewnionych_noclegow_key, t_suma_ilosci_niezapewnionych_noclegow.concat(this.sumaZTabeliKrajowDocelowych(delegacja.getIlosci(), "suma_ilosci_niezapewnionych_noclegow")));
        }
        if ((t_suma_ilosci_niezapewnionych_sniadan_key = mapping.get("suma_ilosci_niezapewnionych_sniadan")) != null && !t_suma_ilosci_niezapewnionych_sniadan_key.equals("")) {
            String t_suma_ilosci_niezapewnionych_sniadan = (String)tabela.get(t_suma_ilosci_niezapewnionych_sniadan_key);
            tabela.put(t_suma_ilosci_niezapewnionych_sniadan_key, t_suma_ilosci_niezapewnionych_sniadan.concat(this.sumaZTabeliKrajowDocelowych(delegacja.getIlosci(), "suma_ilosci_niezapewnionych_sniadan")));
        }
        if ((t_suma_ilosci_niezapewnionych_obiadow_key = mapping.get("suma_ilosci_niezapewnionych_obiadow")) != null && !t_suma_ilosci_niezapewnionych_obiadow_key.equals("")) {
            String t_t_suma_ilosci_niezapewnionych_obiadow = (String)tabela.get(t_suma_ilosci_niezapewnionych_obiadow_key);
            tabela.put(t_suma_ilosci_niezapewnionych_obiadow_key, t_t_suma_ilosci_niezapewnionych_obiadow.concat(this.sumaZTabeliKrajowDocelowych(delegacja.getIlosci(), "suma_ilosci_niezapewnionych_obiadow")));
        }
        if ((t_suma_ilosci_zapewnionych_dob_calodobowe_wyzywienie_key = mapping.get("suma_ilosci_zapewnionych_dob_calodobowe_wyzywienie")) != null && !t_suma_ilosci_zapewnionych_dob_calodobowe_wyzywienie_key.equals("")) {
            String t_suma_ilosci_zapewnionych_dob_calodobowe_wyzywienie = (String)tabela.get(t_suma_ilosci_zapewnionych_dob_calodobowe_wyzywienie_key);
            tabela.put(t_suma_ilosci_zapewnionych_dob_calodobowe_wyzywienie_key, t_suma_ilosci_zapewnionych_dob_calodobowe_wyzywienie.concat(this.sumaZTabeliKrajowDocelowych(delegacja.getIlosci(), "suma_ilosci_zapewnionych_dob_calodobowe_wyzywienie")));
        }
        if ((t_suma_ilosci_niezapewnionych_dob_calodobowe_wyzywienie_key = mapping.get("suma_ilosci_niezapewnionych_dob_calodobowe_wyzywienie")) != null && !t_suma_ilosci_niezapewnionych_dob_calodobowe_wyzywienie_key.equals("")) {
            String t_suma_ilosci_niezapewnionych_dob_calodobowe_wyzywienie = (String)tabela.get(t_suma_ilosci_niezapewnionych_dob_calodobowe_wyzywienie_key);
            tabela.put(t_suma_ilosci_niezapewnionych_dob_calodobowe_wyzywienie_key, t_suma_ilosci_niezapewnionych_dob_calodobowe_wyzywienie.concat(this.sumaZTabeliKrajowDocelowych(delegacja.getIlosci(), "suma_ilosci_niezapewnionych_dob_calodobowe_wyzywienie")));
        }
        if ((t_suma_ilosci_niezapewnionych_kolacji_key = mapping.get("suma_ilosci_niezapewnionych_kolacji")) != null && !t_suma_ilosci_niezapewnionych_kolacji_key.equals("")) {
            String t_suma_ilosci_niezapewnionych_kolacji = (String)tabela.get(t_suma_ilosci_niezapewnionych_kolacji_key);
            tabela.put(t_suma_ilosci_niezapewnionych_kolacji_key, t_suma_ilosci_niezapewnionych_kolacji.concat(this.sumaZTabeliKrajowDocelowych(delegacja.getIlosci(), "suma_ilosci_niezapewnionych_kolacji")));
        }
        if ((t_suma_ilosci_niezapewnionych_przejazdow_do_z_dworca_key = mapping.get("suma_ilosci_niezapewnionych_przejazdow_do_z_dworca")) != null && !t_suma_ilosci_niezapewnionych_przejazdow_do_z_dworca_key.equals("")) {
            String t_suma_ilosci_niezapewnionych_przejazdow_do_z_dworca2 = (String)tabela.get(t_suma_ilosci_niezapewnionych_przejazdow_do_z_dworca_key);
            tabela.put(t_suma_ilosci_niezapewnionych_przejazdow_do_z_dworca_key, t_suma_ilosci_niezapewnionych_przejazdow_do_z_dworca2.concat(this.sumaZTabeliKrajowDocelowych(delegacja.getIlosci(), "suma_ilosci_niezapewnionych_przejazdow_do_z_dworca")));
        }
        if ((t_suma_ilosci_diet_kraj = mapping.get("suma_ilosci_diet_kraj")) != null && !t_suma_ilosci_diet_kraj.equals("")) {
            double ilosci_diet = 0.0;
            for (BusinessTripQuantities k : delegacja.getIlosci()) {
                if (!k.getKraj().equalsIgnoreCase(domesticCountryName)) continue;
                ilosci_diet = k.getIlosc_diet();
                break;
            }
            t_suma_ilosci_niezapewnionych_przejazdow_do_z_dworca = (String)tabela.get(t_suma_ilosci_diet_kraj);
            tabela.put(t_suma_ilosci_diet_kraj, ((String)t_suma_ilosci_niezapewnionych_przejazdow_do_z_dworca).concat(Tools.toString(ilosci_diet)));
        }
        if ((t_suma_ilosci_diet_zagranica = mapping.get("suma_ilosci_diet_zagranica")) != null && !t_suma_ilosci_diet_zagranica.equals("")) {
            long suma_ilosci_diet = 0L;
            for (BusinessTripQuantities k : delegacja.getIlosci()) {
                if (k.getKraj().equalsIgnoreCase(domesticCountryName)) continue;
                suma_ilosci_diet += Math.round(k.getIlosc_diet() * 100.0);
            }
            t_suma_ilosci_niezapewnionych_przejazdow_do_z_dworca = (String)tabela.get(t_suma_ilosci_diet_zagranica);
            tabela.put(t_suma_ilosci_diet_zagranica, ((String)t_suma_ilosci_niezapewnionych_przejazdow_do_z_dworca).concat(Tools.toString((double)Math.round(suma_ilosci_diet) / 100.0)));
        }
        if ((actionConfForSummary = Configuration.getActionConf(delegationNr)) != null && actionConfForSummary.getOtherParams() != null && actionConfForSummary.getOtherParams().getIsSpendingTableVisible().booleanValue() && (t_suma_wydatkow = mapping.get("suma_wydatkow")) != null && !t_suma_wydatkow.equals("")) {
            String previousValue = (String)tabela.get(t_suma_wydatkow);
            long suma_ilosci_wydatkow = 0L;
            tabela.put(t_suma_wydatkow, previousValue.concat(Tools.toString((double)Math.round(suma_ilosci_wydatkow += Math.round(delegacja.getSuma_wydatki() * 100.0)) / 100.0)));
        }
    }

    private String sumaZTabeliKrajowDocelowych(Set<BusinessTripQuantities> kraje_docelowe, String typ) throws Exception {
        long suma = 0L;
        for (BusinessTripQuantities kraj : kraje_docelowe) {
            long do_dodania = 0L;
            if (typ.equals("suma_ilosci_niezapewnionych_dob_komunikacji_miejskiej")) {
                do_dodania = Math.round(kraj.getNiezapewnione_doby_komunikacji_miejskiej() * 10);
            } else if (typ.equals("suma_ilosci_niezapewnionych_noclegow")) {
                do_dodania = Math.round(kraj.getNiezapewnione_noclegi() * 10);
            } else if (typ.equals("suma_ilosci_niezapewnionych_przejazdow_do_z_dworca")) {
                do_dodania = Math.round(kraj.getNiezapewnione_przejazdy_do_z_dworca() * 10.0);
            } else if (typ.equals("suma_ilosci_niezapewnionych_sniadan")) {
                do_dodania = Math.round(kraj.getZapewnione_sniadania() * 10);
            } else if (typ.equals("suma_ilosci_niezapewnionych_obiadow")) {
                do_dodania = Math.round(kraj.getZapewnione_obiady() * 10);
            } else if (typ.equals("suma_ilosci_zapewnionych_dob_calodobowe_wyzywienie")) {
                if (kraj.getCalodobowe_wyzywienie() != null && kraj.getCalodobowe_wyzywienie().equalsIgnoreCase("tak")) {
                    do_dodania = 10L;
                }
            } else if (typ.equals("suma_ilosci_niezapewnionych_dob_calodobowe_wyzywienie")) {
                if (kraj.getCalodobowe_wyzywienie() == null || kraj.getCalodobowe_wyzywienie().equalsIgnoreCase("nie")) {
                    do_dodania = 10L;
                }
            } else if (typ.equals("suma_ilosci_niezapewnionych_kolacji")) {
                do_dodania = Math.round(kraj.getZapewnione_kolacje() * 10);
            } else {
                return "";
            }
            suma += do_dodania;
        }
        return Tools.toString(Math.floor(suma / 10L));
    }

    private Map<String, Object> mergeTablesAndRemoveDuplicates(Map<String, Object> mapa, Map<String, Object> summaryTable, Map<String, Object> costsTable, Map<String, Object> spendingsTable) throws Exception {
        HashMap allTables = new HashMap();
        if (summaryTable != null) {
            summaryTable.forEach((k, v) -> allTables.put(k, v.toString()));
        }
        if (costsTable != null) {
            costsTable.forEach((k, v) -> allTables.put(k, v.toString()));
        }
        if (spendingsTable != null) {
            spendingsTable.forEach((k, v) -> allTables.put(k, v.toString()));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(allTables);
        return result;
    }

    private BusinessTrip settle(BusinessTrip delegacja, BusinessTripDto settleRequest, Map<String, Object> resp) throws Exception {
        HashMap<String, String> data = new HashMap<String, String>();
        String delegationNr = settleRequest.getBaseData().getNr_delegacji();
        ActionConf actionConfForSettle = Configuration.getActionConf(delegationNr);
        SettlementCountry countryCode = settleRequest.getSettlementCountry() != null ? settleRequest.getSettlementCountry() : (actionConfForSettle != null && actionConfForSettle.getOtherParams() != null ? actionConfForSettle.getOtherParams().getSettlementCountry() : null);
        log.debug("U\u017cywany kod kraju prawa: {}", (Object)countryCode);
        SettlementService settlementService = this.settlementServiceFactory.getSettlementService(settleRequest.getType(), countryCode);
        delegacja = settlementService.settle(delegacja, settleRequest);
        data.put("dieta_zagranica", String.valueOf(delegacja.getDieta_zagranica()));
        data.put("ryczalt_srodki_miejskie_zagranica", String.valueOf(delegacja.getRyczalt_srodki_miejskie_zagranica()));
        data.put("ryczalt_noclegi_zagranica", String.valueOf(delegacja.getRyczalt_noclegi_zagranica()));
        data.put("niezapewnione_przejazdy_do_z_dworca", String.valueOf(delegacja.getRyczalt_za_przejazdy_do_z_dworca()));
        data.put("dieta_kraj", String.valueOf(delegacja.getDieta_kraj()));
        data.put("ryczalt_srodki_miejskie_kraj", String.valueOf(delegacja.getRyczalt_srodki_miejskie_kraj()));
        data.put("ryczalt_noclegi_kraj", String.valueOf(delegacja.getRyczalt_noclegi_kraj()));
        data.put("kilometrowka", String.valueOf(delegacja.getKilometrowka()));
        data.put("daty_zgodne_z_wnioskiem", String.valueOf(delegacja.getDaty_zgodne_z_wnioskiem()));
        data.put("suma_wydatki", String.valueOf(delegacja.getSuma_wydatki()));
        data.put("minuty_w_delegacji", String.valueOf(delegacja.getMinuty_w_delegacji()));
        resp.put("data", data);
        return delegacja;
    }

    private void logAudit(AuditTypes type, boolean success, Map<String, Object> auditParams, Date start) {
        ManualAuditBuilder.getInstance().type(type.getValue()).username(this.userContext.userName()).success(success).params(auditParams).started(start).stopped(new Date()).build().log();
    }

    private ActionConfDto convertParams(MultiValueMap<String, Object> actionConf) {
        String sParams = actionConf.getFirst((Object)"actionConf").toString();
        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd").create();
        return (ActionConfDto)gson.fromJson(sParams, ActionConfDto.class);
    }
}

