/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.biofarm.scheduledtask;

import com.suncode.plugin.biofarm.db.services.SAP_SynchDateService;
import com.suncode.plugin.biofarm.sap.BAPI.BAPI_GET;
import com.suncode.plugin.biofarm.sap.services.SAPSynchronization;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class SynchSapScheduledTask {
    private static final Logger log = LoggerFactory.getLogger(SynchSapScheduledTask.class);
    public org.apache.log4j.Logger taskLog;
    @Autowired
    SAPSynchronization sapSynchronization;
    @Autowired
    SAP_SynchDateService sapSynchData;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("biofarm-load-sap")).name("biofarm-load-sap.name")).description("biofarm-load-sap.desc")).cancelable().parameter().id("funcName").name("biofarm-load-sap.param.funcName.name").description("biofarm-load-sap.param.funcName.desc").type((Type)Types.STRING).create();
    }

    public void execute(@Param String funcName, org.apache.log4j.Logger taskLog) throws Exception {
        this.taskLog = taskLog;
        this.log("Use BAPI: " + funcName);
        BAPI_GET BAPI = BAPI_GET.getBAPI(funcName.trim());
        if (BAPI == null) {
            this.log("Unsupported function:\t" + funcName);
            throw new Exception("Unsupported function:\t" + funcName);
        }
        Date dateParam = this.sapSynchData.getDate(BAPI.getFuncName());
        this.log("Last run:" + String.valueOf(dateParam));
        Date date = new Date();
        this.log("Synch data from SAP");
        this.sapSynchronization.synchDataByFuncName(funcName, dateParam);
        this.sapSynchData.saveOrUpdate(BAPI.getFuncName(), date);
    }

    private void log(String msg) {
        log.debug(msg);
        this.taskLog.debug((Object)msg);
    }
}

