/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.biofarm.scheduledtask;

import com.suncode.plugin.biofarm.db.services.SAP_SynchDateService;
import com.suncode.plugin.biofarm.sap.services.SAPSynchronization;
import com.suncode.plugin.biofarm.tools.CreatorSettings;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class SapBuforTaskBapi_POST_STATUS {
    private static final Logger log = LoggerFactory.getLogger(SapBuforTaskBapi_POST_STATUS.class);
    private static final String FUNC_NAME = "ZIBC_IF_RFC_GET_POST_STATUS";
    public org.apache.log4j.Logger taskLog;
    @Autowired
    SAPSynchronization sapSynchronization;
    @Autowired
    SAP_SynchDateService sapSynchData;
    @Autowired
    ActivityFinder activityFinder;
    @Autowired
    ActivityService activityService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("biofarm-bufor-taks.post_status")).name("biofarm-bufor-taks.post_status.name")).description("biofarm-bufor-taks.post_status.desc")).cancelable().parameter().id("awkey_id").name("biofarm-bufor-taks.post_status.param.awkey_id.name").description("biofarm-bufor-taks.post_status.param.awkey_id.desc").type((Type)Types.STRING).create()).parameter().id("fi_awkey_id").name("biofarm-bufor-taks.post_status.param.fi_awkey_id.name").description("biofarm-bufor-taks.post_status.param.fi_awkey_id.desc").type((Type)Types.STRING).create()).parameter().id("pstng_date_id").name("biofarm-bufor-taks.post_status.param.pstng_date_id.name").description("biofarm-bufor-taks.post_status.param.pstng_date_id.desc").type((Type)Types.STRING).create()).parameter().id("process-def-id").name("biofarm-bufor-taks.param.process-def-id.name").description("biofarm-bufor-taks.param.process-def-id.desc").type((Type)Types.STRING).create()).parameter().id("activity-def-id").name("biofarm-bufor-taks.param.activity-def-id.name").description("biofarm-bufor-taks.param.activity-def-id.desc").type((Type)Types.STRING).create()).parameter().id("action").name("biofarm-bufor-taks.param.action.name").description("biofarm-bufor-taks.param.action.desc").type((Type)Types.STRING).create();
    }

    public void execute(@Param(value="awkey_id") String awkey_id, @Param(value="fi_awkey_id") String fi_awkey_id, @Param(value="pstng_date_id") String pstng_date_id, @Param(value="process-def-id") String sProcessDefId, @Param(value="activity-def-id") String sActivityDefId, @Param(value="action") String sAction, org.apache.log4j.Logger taskLog) throws Exception {
        this.taskLog = taskLog;
        this.log("Bufor task for BAPI ZIBC_IF_RFC_GET_POST_STATUS");
        Date dateParam = this.sapSynchData.getDate(FUNC_NAME);
        this.log("Last run:" + String.valueOf(dateParam));
        Date date = new Date();
        this.run(awkey_id, fi_awkey_id, pstng_date_id, sActivityDefId, sProcessDefId, sAction);
        this.sapSynchData.saveOrUpdate(FUNC_NAME, date);
    }

    private void log(String msg) {
        log.debug(msg);
        this.taskLog.debug((Object)msg);
    }

    private void run(String awkey_id, String fi_awkey_id, String pstng_date_id, String sActivityDefId, String sProcessDefId, String sAction) throws Exception {
        this.log("Retrieving user data about the 'Buffer' role");
        CreatorSettings creatorSet = new CreatorSettings();
        String userName = creatorSet.getUser();
        String userPwd = creatorSet.getPassword();
        this.log("User:\t" + userName);
        List activities = this.activityFinder.findActivitiesAssignedToUser(userName, new String[]{"process", "process.processDefinition"});
        this.log("Number task for user:" + userName + " is:" + activities.size());
        for (Activity activity : activities) {
            if (activity.getActivityDefinitionId().compareToIgnoreCase(sActivityDefId) == 0 && activity.getProcess().getProcessDefinition().getProcessDefinitionId().compareToIgnoreCase(sProcessDefId) == 0) {
                String activityId = activity.getActivityId();
                String processId = activity.getProcessId();
                this.activityService.openActivity(userName, userPwd, processId, activityId);
                Map activityContext = this.activityService.getActivityContext(processId, activityId);
                Map<String, Object> map = this.useBAPI(awkey_id, fi_awkey_id, pstng_date_id, activityContext);
                this.acceptActivity(sAction, userName, activityId, processId, map, pstng_date_id);
                continue;
            }
            this.log("Wrong activity of id:\t" + activity.getActivityId());
        }
    }

    private void acceptActivity(String sAction, String userName, String activityId, String processId, Map<String, Object> map, String checkID) {
        this.log("Attempt to accept the task  of id:" + activityId);
        if (map.get(checkID) == null || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{map.get(checkID).toString()})) {
            this.log("PSTNG_DATE is empty. No activity acceptance");
        } else {
            AcceptationDefinition acceptation = new AcceptationDefinition(processId, activityId, userName, sAction);
            acceptation.setContextMap(map);
            this.activityService.acceptActivity(acceptation);
            this.log("Success");
        }
    }

    private Map<String, Object> useBAPI(String awkey_id, String fi_awkey_id, String pstng_date_id, Map<String, Object> activityContext) throws Exception {
        this.log("Imput param:");
        HashMap<String, Object> importParameters = new HashMap<String, Object>();
        importParameters.put("AWKEY", activityContext.get(awkey_id));
        this.logMap(importParameters);
        this.log("Use BAPI:\tZIBC_IF_RFC_GET_POST_STATUS");
        Map<String, Object> sapExportData = this.sapSynchronization.getDataForBuforTask(FUNC_NAME, importParameters);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(fi_awkey_id, sapExportData.get("FI_AWKEY"));
        map.put(pstng_date_id, sapExportData.get("PSTNG_DATE"));
        this.log("Return Param");
        this.logMap(map);
        return map;
    }

    private void logMap(Map<String, Object> map) {
        for (String key : map.keySet()) {
            this.log(key + ":\t" + String.valueOf(map.get(key)));
        }
    }
}

