/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.biofarm.sap.services;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.suncode.plugin.biofarm.db.services.DBSAP_CostCenterService;
import com.suncode.plugin.biofarm.db.services.DBSAP_OrdersService;
import com.suncode.plugin.biofarm.db.services.DBSAP_PSPService;
import com.suncode.plugin.biofarm.db.services.DBSAP_TPaymentsService;
import com.suncode.plugin.biofarm.db.services.DBSAP_VatService;
import com.suncode.plugin.biofarm.db.services.DBSAP_VendorsService;
import com.suncode.plugin.biofarm.db.services.DBSAP_ZIKZVendorsService;
import com.suncode.plugin.biofarm.db.services.SAP_SynchDateService;
import com.suncode.plugin.biofarm.dto.DocumentHeader;
import com.suncode.plugin.biofarm.dto.DocumentPosition;
import com.suncode.plugin.biofarm.dto.DocumentReturn;
import com.suncode.plugin.biofarm.sap.BAPI.BAPI_GET;
import com.suncode.plugin.biofarm.sap.RfcBapiBiofarmManager;
import com.suncode.plugin.biofarm.sap.services.SAPConnConfig;
import com.suncode.plugin.biofarm.sap.services.SAPSynchronization;
import com.suncode.pwfl.search.CountedResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sapSynchronization")
public class SAPSynchronizationImpl
implements SAPSynchronization {
    private static final Logger log = LoggerFactory.getLogger(SAPSynchronizationImpl.class);
    private static final String PAYMENT_STATUS = "PAYMENT_STATUS";
    private static final String FI_AWKEY = "FI_AWKEY";
    private static final String PSTNG_DATE = "PSTNG_DATE";
    private static final String AWKEY = "AWKEY";
    private static final String ERROR_MSG_TBL = "ERROR_MSG_TBL";
    private static final String DOCUMENT_POSITIONS_T = "DOCUMENT_POSITIONS_T";
    private static final String ZIBC_IF_RFC_PARK_DOCUMENT = "ZIBC_IF_RFC_PARK_DOCUMENT";
    private static final String DOCUMENT_HEADER = "DOCUMENT_HEADER";
    @Autowired
    SAPConnConfig sapConnConfig;
    @Autowired
    DBSAP_CostCenterService dbSAP_CostCenterService;
    @Autowired
    DBSAP_VendorsService dbSAP_VendorsService;
    @Autowired
    DBSAP_TPaymentsService dbSAP_TPaymentsService;
    @Autowired
    DBSAP_OrdersService dbSAP_OrdersService;
    @Autowired
    DBSAP_PSPService dbSAP_PSPService;
    @Autowired
    DBSAP_VatService dbSAP_VatService;
    @Autowired
    DBSAP_ZIKZVendorsService dbSAP_ZIKZVatService;
    @Autowired
    SAP_SynchDateService sapSynchDate;
    private BAPI_GET bapiType;

    @Override
    public CountedResult<Map<String, String>> getBankAccounts(String iLIFNR) throws Exception {
        this.bapiType = BAPI_GET.ZIBC_IF_RFC_GET_BANK_ACCOUNTS;
        CountedResult<Map<String, String>> cResults = this.loadData(iLIFNR);
        this.logResults(this.bapiType.getFuncName(), this.bapiType.getTableName(), cResults);
        CountedResult<Map<String, String>> countedResult = cResults;
        return countedResult;
    }

    @Override
    public Map<String, Object> getDataForBuforTask(String functionName, Map<String, Object> inputParam) throws Exception {
        String destName = this.sapConnConfig.getDestName();
        Properties connectProperties = this.connectProperties();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        JCoParameterList exportParam = null;
        switch (functionName) {
            case "ZIBC_IF_RFC_GET_POST_STATUS": {
                exportParam = RfcBapiBiofarmManager.getExportParamUsedBAPI(connectProperties, destName, functionName, inputParam);
                Object objDate = exportParam.getValue(PSTNG_DATE);
                String yyyymmdd = exportParam.getString(PSTNG_DATE);
                resultMap.put(FI_AWKEY, exportParam.getValue(FI_AWKEY));
                resultMap.put(PSTNG_DATE, objDate == null ? null : yyyymmdd);
                log.debug(exportParam.toString());
                break;
            }
            case "ZIBC_IF_RFC_GET_PAYMENT_STATUS": {
                exportParam = RfcBapiBiofarmManager.getExportParamUsedBAPI(connectProperties, destName, functionName, inputParam);
                resultMap.put(PAYMENT_STATUS, exportParam.getString(PAYMENT_STATUS));
                log.debug(exportParam.toString());
                break;
            }
            case "ZIBC_IF_RFC_MANUAL_POSTING": {
                exportParam = RfcBapiBiofarmManager.getExportParamUsedBAPI(connectProperties, destName, functionName, inputParam);
                Object objDate2 = exportParam.getValue(PSTNG_DATE);
                String yyyymmdd2 = exportParam.getString(PSTNG_DATE);
                resultMap.put(FI_AWKEY, exportParam.getValue(FI_AWKEY));
                resultMap.put(PSTNG_DATE, objDate2 == null ? null : yyyymmdd2);
                log.debug(exportParam.toString());
                break;
            }
            default: {
                throw new Exception("Unsupported function:\t" + functionName);
            }
        }
        return resultMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CountedResult<Map<String, String>> synchDataByFuncName(String functionName, Object inputParamValue) throws Exception {
        this.bapiType = BAPI_GET.getBAPI(functionName);
        switch (this.bapiType) {
            case ZIBC_IF_RFC_GET_COST_CENTERS: {
                return this.synchCostCenter(inputParamValue);
            }
            case ZIBC_IF_RFC_GET_ORDERS: {
                return this.synchOrders(inputParamValue);
            }
            case ZIBC_IF_RFC_GET_PSP: {
                return this.synchPSP(inputParamValue);
            }
            case ZIBC_IF_RFC_GET_T_PAYMENTS: {
                return this.synchTPayments(inputParamValue);
            }
            case ZIBC_IF_RFC_GET_VAT: {
                return this.synchVat(inputParamValue);
            }
            case ZIBC_IF_RFC_GET_VENDORS: {
                return this.synchVendors(inputParamValue);
            }
            case ZIKZ_IF_RFC_GET_VENDORS: {
                return this.synchZIKZ_Vendors(inputParamValue);
            }
        }
        throw new Exception("Unsupported function:\t" + functionName);
    }

    private CountedResult<Map<String, String>> synchZIKZ_Vendors(Object inputParamValue) throws JCoException, Exception {
        CountedResult<Map<String, String>> cResult = this.loadDataWithImportParameters((Map)inputParamValue);
        this.dbSAP_ZIKZVatService.updateTable(cResult.getData());
        this.logResults(this.bapiType.getFuncName(), this.bapiType.getTableName(), cResult);
        return cResult;
    }

    @Override
    public DocumentReturn sendBAPI_ZIBC_IF_RFC_PARK_DOCUMENT(DocumentHeader documentHeader, List<DocumentPosition> positions) throws Exception {
        DocumentReturn docReturn = new DocumentReturn();
        String destName = this.sapConnConfig.getDestName();
        HashMap<String, Object> importParam = new HashMap<String, Object>();
        Properties connectProperties = this.connectProperties();
        JCoStructure structHeader = RfcBapiBiofarmManager.getBAPIFunctionImportStructureWithDestinationDataProvider(connectProperties, destName, ZIBC_IF_RFC_PARK_DOCUMENT, DOCUMENT_HEADER);
        SAPSynchronizationImpl.buildStructureDocumentheader(structHeader, documentHeader);
        importParam.put(DOCUMENT_HEADER, structHeader);
        if (positions != null) {
            JCoTable tablePositions = RfcBapiBiofarmManager.getBAPIFunctionImportTableWithDestinationDataProvider(connectProperties, destName, ZIBC_IF_RFC_PARK_DOCUMENT, DOCUMENT_POSITIONS_T);
            this.buildTablePositions(tablePositions, positions);
            importParam.put(DOCUMENT_POSITIONS_T, tablePositions);
        }
        JCoParameterList exportParam = RfcBapiBiofarmManager.getExportParamUsedBAPI(connectProperties, destName, ZIBC_IF_RFC_PARK_DOCUMENT, importParam);
        log.debug(exportParam.toString());
        List<Map<String, Object>> tableError = RfcBapiBiofarmManager.convertJCoTable(exportParam.getTable(ERROR_MSG_TBL));
        String awkey = exportParam.getString(AWKEY);
        log.debug("AWKEY: \t" + awkey);
        this.logTable(tableError, ERROR_MSG_TBL);
        docReturn.setErrorMSG_TBL(tableError);
        docReturn.setAwkey(awkey);
        DocumentReturn documentReturn = docReturn;
        return documentReturn;
    }

    private void buildTablePositions(JCoTable tablePositions, List<DocumentPosition> positions) {
        for (DocumentPosition documentPosition : positions) {
            tablePositions.appendRow();
            tablePositions.setValue("AUFNR", documentPosition.getAufnr());
            tablePositions.setValue("GL_ACCOUNT", documentPosition.getGl_account());
            tablePositions.setValue("ITEM_TEXT", documentPosition.getItem_text());
            tablePositions.setValue("KOSTL", documentPosition.getKostl());
            tablePositions.setValue("MWSKZ", documentPosition.getMwskz());
            tablePositions.setValue("WBS_ELEMENT", documentPosition.getWbs_element());
            tablePositions.setValue("ZUONR", documentPosition.getZuonr());
            tablePositions.setValue("AMT_DOCCUR", (Object)documentPosition.getAmt_doccur());
        }
    }

    private void logTable(List<Map<String, Object>> table, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("\nTabela:\t" + name);
        if (table.isEmpty()) {
            sb.append("\n\tTabela pusta");
        } else {
            int index = 0;
            Map<String, Object> mapOne = table.get(0);
            sb.append("\nindex\t");
            for (String string : mapOne.keySet()) {
                sb.append(string + "\t");
            }
            for (Map map : table) {
                sb.append("\n" + ++index + "\t");
                for (String key : map.keySet()) {
                    sb.append(map.get(key)).append("\t");
                }
            }
        }
        log.debug(sb.toString());
    }

    private CountedResult<Map<String, String>> synchVat(Object inputParamValue) throws JCoException, Exception {
        CountedResult<Map<String, String>> cResult = this.loadData(inputParamValue);
        this.dbSAP_VatService.updateTable(cResult.getData());
        this.logResults(this.bapiType.getFuncName(), this.bapiType.getTableName(), cResult);
        return cResult;
    }

    private CountedResult<Map<String, String>> synchVendors(Object inputParamValue) throws JCoException, Exception {
        CountedResult<Map<String, String>> cResult = this.loadData(inputParamValue);
        this.dbSAP_VendorsService.updateTable(cResult.getData());
        this.logResults(this.bapiType.getFuncName(), this.bapiType.getTableName(), cResult);
        return cResult;
    }

    private CountedResult<Map<String, String>> synchTPayments(Object inputParamValue) throws JCoException, Exception {
        CountedResult<Map<String, String>> cResult = this.loadData(inputParamValue);
        this.dbSAP_TPaymentsService.updateTable(cResult.getData());
        this.logResults(this.bapiType.getFuncName(), this.bapiType.getTableName(), cResult);
        return cResult;
    }

    private CountedResult<Map<String, String>> synchPSP(Object inputParamValue) throws JCoException, Exception {
        CountedResult<Map<String, String>> cResult = this.loadData(inputParamValue);
        this.dbSAP_PSPService.updateTable(cResult.getData());
        this.logResults(this.bapiType.getFuncName(), this.bapiType.getTableName(), cResult);
        return cResult;
    }

    private CountedResult<Map<String, String>> synchOrders(Object inputParamValue) throws JCoException, Exception {
        CountedResult<Map<String, String>> cResult = this.loadData(inputParamValue);
        this.dbSAP_OrdersService.updateTable(cResult.getData());
        this.logResults(this.bapiType.getFuncName(), this.bapiType.getTableName(), cResult);
        return cResult;
    }

    private CountedResult<Map<String, String>> synchCostCenter(Object inputParamValue) throws IllegalStateException, JCoException, Exception {
        CountedResult<Map<String, String>> cResult = this.loadData(inputParamValue);
        this.dbSAP_CostCenterService.updateTable(cResult.getData());
        this.logResults(this.bapiType.getFuncName(), this.bapiType.getTableName(), cResult);
        return cResult;
    }

    private CountedResult<Map<String, String>> loadData(Object inputParamValue) throws Exception, JCoException {
        String destName = this.sapConnConfig.getDestName();
        Map<String, Object> importPrameters = this.setImportParam(inputParamValue);
        return RfcBapiBiofarmManager.useBAPIWithDestinationDataProvider(this.connectProperties(), destName, this.bapiType.getFuncName(), this.bapiType.getTableName(), importPrameters);
    }

    private CountedResult<Map<String, String>> loadDataWithImportParameters(Map<String, Object> importPrameters) throws Exception, JCoException {
        String destName = this.sapConnConfig.getDestName();
        return RfcBapiBiofarmManager.useBAPIWithDestinationDataProvider(this.connectProperties(), destName, this.bapiType.getFuncName(), this.bapiType.getTableName(), importPrameters);
    }

    private Properties connectProperties() throws Exception {
        String hostName = this.sapConnConfig.getHostName();
        String sysNr = this.sapConnConfig.getSysNr();
        String client = this.sapConnConfig.getClient();
        String user = this.sapConnConfig.getUser();
        String password = this.sapConnConfig.getPswd();
        String language = this.sapConnConfig.getLang();
        Properties connectProperties = RfcBapiBiofarmManager.getDestinationPropertiesFromUI(hostName, sysNr, client, user, password, language);
        return connectProperties;
    }

    private Map<String, Object> setImportParam(Object param) {
        HashMap<String, Object> importParameters = new HashMap<String, Object>();
        String pramName = this.bapiType.getImportParamName();
        if (pramName == null) {
            return null;
        }
        importParameters.put(pramName, param);
        return importParameters;
    }

    private void logResults(String funcName, String tableName, CountedResult<Map<String, String>> cResukt) {
        if (this.sapConnConfig.debugMode().booleanValue()) {
            Long numberRow = 0L;
            StringBuilder sb = new StringBuilder();
            sb.append("\n\n\nFor Func:\t" + funcName);
            sb.append("\nTable:\t" + tableName.toUpperCase());
            sb.append("Total result: " + cResukt.getTotal());
            sb.append("\n");
            for (Map row : cResukt.getData()) {
                Long l = numberRow;
                numberRow = numberRow + 1L;
                sb.append("\n[" + numberRow + "]\t");
                for (String key : row.keySet()) {
                    sb.append(key).append(":\t").append((String)row.get(key)).append("\t");
                }
            }
            sb.append("\n\n\n");
            log.debug(sb.toString());
        }
    }

    private static void buildStructureDocumentheader(JCoStructure structure, DocumentHeader docHeaderDto) {
        structure.setValue("BUKRS", docHeaderDto.getBukrs());
        structure.setValue("DOCUMENT_ID", docHeaderDto.getDocuentId());
        structure.setValue("FI_MM_FLAG", docHeaderDto.getFi_mm_flag());
        structure.setValue("DOC_DATE", (Object)docHeaderDto.getDoc_date());
        structure.setValue("PMNTTRMS", docHeaderDto.getPmnttrms());
        structure.setValue("CURRENCY", docHeaderDto.getCurrency());
        structure.setValue("EXCH_RATE", (Object)docHeaderDto.getExch_rate());
        structure.setValue("GROSS_AMOUNT", (Object)docHeaderDto.getGross_amount());
        structure.setValue("REF_DOC_NO", docHeaderDto.getRef_doc_no());
        structure.setValue("ORGIN_REF_DOC_NO", docHeaderDto.getOrgin_ref_doc_no());
        structure.setValue("DOC_TYPE", docHeaderDto.getDoc_type());
        structure.setValue(PSTNG_DATE, (Object)docHeaderDto.getPstng_date());
        structure.setValue("INVOICE_IND", docHeaderDto.getInvoice_ind());
        structure.setValue("LIFNR", docHeaderDto.getLifnr());
        structure.setValue("BVTYP", docHeaderDto.getBvtyp());
        structure.setValue("PMNT_BLOCK", docHeaderDto.getPmnt_block());
        structure.setValue("ITEM_TEXT", docHeaderDto.getItem_text());
        structure.setValue("BLINE_DATE", (Object)docHeaderDto.getBline_Date());
        structure.setValue("VATDATE", (Object)docHeaderDto.getVatdate());
        structure.setValue("LIFNR_PRAC", docHeaderDto.getLifnrPrac() == null ? "" : docHeaderDto.getLifnrPrac().substring(0, Math.min(10, docHeaderDto.getLifnrPrac().length())));
        structure.setValue("PYMT_METH", docHeaderDto.getPymtmeth());
    }
}

