/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.biofarm.sap.services;

import com.suncode.plugin.biofarm.sap.services.SAPConnConfig;
import com.suncode.pwfl.administration.configuration.Category;
import com.suncode.pwfl.administration.configuration.ParameterType;
import com.suncode.pwfl.administration.configuration.SystemParameter;
import com.suncode.pwfl.administration.configuration.SystemParameterFinder;
import com.suncode.pwfl.administration.configuration.SystemParameterService;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sapConnConfig")
public class SAPConnConfigImpl
implements SAPConnConfig {
    private static final Logger log = LoggerFactory.getLogger(SAPConnConfigImpl.class);
    @Autowired
    SystemParameterFinder systemParameterFinder;
    @Autowired
    SystemParameterService systemParameterService;
    private static final String CATEGORY_PARAMETERS = "SAP";
    private static final String PARAM_DESTNAME_KEY = "SAP.Name";
    private static final String PARAM_HOSTNAME_KEY = "SAP.IP";
    private static final String PARAM_SYSNR_KEY = "SAP.InstanceNo";
    private static final String PARAM_CLIENT_KEY = "SAP.Mandant";
    private static final String PARAM_USER_KEY = "SAP.Login";
    private static final String PARAM_PASSWORD_KEY = "SAP.Password";
    private static final String PARAM_LANGUAGE_KEY = "SAP.Language";
    private static final String DEBUG_MODE_KEY = "SAP.Debug";

    public SAPConnConfigImpl() {
        if (this.systemParameterFinder == null) {
            this.systemParameterFinder = FinderFactory.getSystemParameterFinder();
        }
        if (this.systemParameterService == null) {
            this.systemParameterService = ServiceFactory.getSystemParameterService();
        }
        this.initSystemParameters();
    }

    @Override
    public String getDestName() {
        return SystemProperties.getString((String)PARAM_DESTNAME_KEY);
    }

    @Override
    public String getHostName() {
        return SystemProperties.getString((String)PARAM_HOSTNAME_KEY);
    }

    @Override
    public String getSysNr() {
        return SystemProperties.getString((String)PARAM_SYSNR_KEY);
    }

    @Override
    public String getClient() {
        return SystemProperties.getString((String)PARAM_CLIENT_KEY);
    }

    @Override
    public String getUser() {
        return SystemProperties.getString((String)PARAM_USER_KEY);
    }

    @Override
    public String getPswd() {
        return SystemProperties.getPassword((String)PARAM_PASSWORD_KEY);
    }

    @Override
    public String getLang() {
        return SystemProperties.getString((String)PARAM_LANGUAGE_KEY);
    }

    @Override
    public Boolean debugMode() {
        return SystemProperties.getBoolean((String)DEBUG_MODE_KEY);
    }

    private void initSystemParameters() {
        try {
            SystemParameter parameter = null;
            Category cat = this.systemParameterFinder.findCategory(CATEGORY_PARAMETERS, new String[0]);
            if (cat == null) {
                cat = new Category(CATEGORY_PARAMETERS);
            }
            if (this.systemParameterService.getParameter(PARAM_DESTNAME_KEY) == null) {
                parameter = new SystemParameter(cat, ParameterType.TEXT, PARAM_DESTNAME_KEY);
                this.systemParameterService.create(parameter);
            }
            if (this.systemParameterService.getParameter(PARAM_HOSTNAME_KEY) == null) {
                parameter = new SystemParameter(cat, ParameterType.TEXT, PARAM_HOSTNAME_KEY);
                this.systemParameterService.create(parameter);
            }
            if (this.systemParameterService.getParameter(PARAM_SYSNR_KEY) == null) {
                parameter = new SystemParameter(cat, ParameterType.TEXT, PARAM_SYSNR_KEY);
                this.systemParameterService.create(parameter);
            }
            if (this.systemParameterService.getParameter(PARAM_CLIENT_KEY) == null) {
                parameter = new SystemParameter(cat, ParameterType.TEXT, PARAM_CLIENT_KEY);
                this.systemParameterService.create(parameter);
            }
            if (this.systemParameterService.getParameter(PARAM_USER_KEY) == null) {
                parameter = new SystemParameter(cat, ParameterType.TEXT, PARAM_USER_KEY);
                this.systemParameterService.create(parameter);
            }
            if (this.systemParameterService.getParameter(PARAM_PASSWORD_KEY) == null) {
                parameter = new SystemParameter(cat, ParameterType.PASSWORD, PARAM_PASSWORD_KEY);
                this.systemParameterService.create(parameter);
            }
            if (this.systemParameterService.getParameter(PARAM_LANGUAGE_KEY) == null) {
                parameter = new SystemParameter(cat, ParameterType.TEXT, PARAM_LANGUAGE_KEY);
                parameter.setValue((Object)"pl");
                this.systemParameterService.create(parameter);
            }
            if (this.systemParameterService.getParameter(DEBUG_MODE_KEY) == null) {
                parameter = new SystemParameter(cat, ParameterType.BOOLEAN, DEBUG_MODE_KEY);
                parameter.setValue((Object)false);
                this.systemParameterService.create(parameter);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

