/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.biofarm.sap;

import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFieldIterator;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.suncode.plugin.biofarm.hook.MyDestinationDataProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RfcBapiManager {
    private static final Logger log = LoggerFactory.getLogger(RfcBapiManager.class);
    public static List<HashMap<String, Object>> RETURNTABLE;
    public static MyDestinationDataProvider destinationDataProvider;

    protected static JCoDestination executeCalls(String destName) throws JCoException {
        log.trace("************ executeCalls(destName=" + destName + ") ************");
        JCoDestination dest = null;
        dest = JCoDestinationManager.getDestination((String)destName);
        dest.ping();
        log.info("Destination " + destName + " is ok");
        return dest;
    }

    protected static JCoFunction getJCoFunction(JCoDestination dest, String funcName) throws JCoException {
        log.trace("************ getJCoFunction(dest, funcName=" + funcName + ") ************");
        JCoFunction function = null;
        function = dest.getRepository().getFunction(funcName);
        return function;
    }

    protected static String RFCExecutionDuration(long duration) {
        log.trace("************ RFCExecutionDuration(duration=" + String.valueOf(duration) + ") ************");
        Object res = "";
        try {
            long days = TimeUnit.MILLISECONDS.toDays(duration);
            long hours = TimeUnit.MILLISECONDS.toHours(duration) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(duration));
            long minutes = TimeUnit.MILLISECONDS.toMinutes(duration) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duration));
            long seconds = TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration));
            long miliseconds = TimeUnit.MILLISECONDS.toMillis(duration) - TimeUnit.SECONDS.toMillis(TimeUnit.MILLISECONDS.toSeconds(duration));
            res = days > 0L ? days + " dni, " + hours + " godzin, " + minutes + " minut, " + seconds + " sekund, " + miliseconds + " milisekund" : (hours > 0L ? hours + " godzin, " + minutes + " minut, " + seconds + " sekund, " + miliseconds + " milisekund" : (minutes > 0L ? minutes + " minut, " + seconds + " sekund, " + miliseconds + " milisekund" : (seconds > 0L ? seconds + " sekund, " + miliseconds + " milisekund" : (miliseconds > 0L ? miliseconds + " milisekund" : "ponizej jednej milisekundy"))));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            res = "Blad podczas obliczania czasu";
        }
        return res;
    }

    protected static void commitTransaction(JCoDestination dest) throws JCoException {
        log.trace("************ commitTransaction(dest) ************");
        JCoFunction function = null;
        String funcName = "BAPI_TRANSACTION_COMMIT";
        JCoParameterList parameters = null;
        JCoStructure structure = null;
        function = RfcBapiManager.getJCoFunction(dest, funcName);
        function.execute(dest);
        parameters = function.getExportParameterList();
        if (parameters != null) {
            structure = parameters.getStructure("RETURN");
            if (structure != null) {
                log.info("Wyswietlanie zawartosci parametru RETURN dla operacji commit");
                JCoFieldIterator iter = structure.getFieldIterator();
                while (iter.hasNextField()) {
                    JCoField field = iter.nextField();
                    if (field == null) continue;
                    String sName = field.getName();
                    Object oValue = field.getValue();
                    String sValue = "";
                    if (oValue != null) {
                        sValue = oValue.toString();
                    }
                    log.info(sName + "=" + sValue);
                }
            } else {
                log.info("Brak struktury RETURN w wynikach funkcji " + funcName);
            }
        } else {
            log.info("Brak struktury RETURN w wynikach funkcji " + funcName);
        }
        log.info("Zakonczono operacje komitowania transakcji");
    }

    protected static void rollbackTransaction(JCoDestination dest) throws JCoException {
        log.trace("************ rollbackTransaction(dest) ************");
        JCoFunction function = null;
        String funcName = "BAPI_TRANSACTION_ROLLBACK";
        JCoParameterList parameters = null;
        JCoStructure structure = null;
        function = RfcBapiManager.getJCoFunction(dest, funcName);
        function.execute(dest);
        parameters = function.getExportParameterList();
        if (parameters != null) {
            structure = parameters.getStructure("RETURN");
            if (structure != null) {
                log.info("Wyswietlanie zawartosci parametru RETURN dla operacji rollback");
                JCoFieldIterator iter = structure.getFieldIterator();
                while (iter.hasNextField()) {
                    JCoField field = iter.nextField();
                    if (field == null) continue;
                    String sName = field.getName();
                    Object oValue = field.getValue();
                    String sValue = "";
                    if (oValue != null) {
                        sValue = oValue.toString();
                    }
                    log.info(sName + "=" + sValue);
                }
            } else {
                log.info("Brak struktury RETURN w wynikach funkcji " + funcName);
            }
        } else {
            log.info("Brak struktury RETURN w wynikach funkcji " + funcName);
        }
        log.info("Zakonczono operacje rollback'u transakcji");
    }

    protected static void setReturnTable(JCoFunction function, String funcName) {
        log.trace("************ setReturnTable(function, funcName=" + funcName + ") ************");
        JCoParameterList returnParam = null;
        JCoTable returnTab = null;
        HashMap<String, Object> oneRow = null;
        try {
            log.info("Pobieranie tabeli RETURN");
            returnParam = function.getTableParameterList();
            if (returnParam != null) {
                returnTab = returnParam.getTable("RETURN");
                if (returnTab.getNumRows() > 0) {
                    returnTab.firstRow();
                    for (int i = 0; i < returnTab.getNumRows(); ++i) {
                        oneRow = new HashMap<String, Object>();
                        try {
                            returnTab.setRow(i);
                            JCoFieldIterator iterator = returnTab.getFieldIterator();
                            while (iterator.hasNextField()) {
                                JCoField field = iterator.nextField();
                                if (field == null) continue;
                                String fieldName = field.getName();
                                Object fieldValue = returnTab.getValue(fieldName);
                                oneRow.put(fieldName, fieldValue);
                            }
                            RETURNTABLE.add(oneRow);
                            continue;
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                } else {
                    log.info("Brak bledow zalogowanych w RETURN podczas wykonania funkcji " + funcName);
                }
            }
        }
        catch (Exception e) {
            log.info("Brak tabeli RETURN w funkcji " + funcName);
        }
    }

    public static Properties getDestinationPropertiesFromUI(String hostName, String sysNr, String client, String user, String password, String language) throws Exception {
        log.trace("************ getDestinationPropertiesFromUI(hostName=" + hostName + ", sysNr=" + sysNr + ", client, user, password, language=" + language + ") ************");
        Properties connectProperties = new Properties();
        connectProperties.setProperty("jco.client.ashost", hostName);
        connectProperties.setProperty("jco.client.sysnr", sysNr);
        connectProperties.setProperty("jco.client.client", client);
        connectProperties.setProperty("jco.client.user", user);
        connectProperties.setProperty("jco.client.passwd", password);
        connectProperties.setProperty("jco.client.lang", language);
        return connectProperties;
    }

    public static HashMap<String, String> getBAPIFunctionParamsWithDestinationDataProvider(Properties connectProperties, String destName, String funcName) throws Exception, JCoException, IllegalStateException {
        log.trace("************ getBAPIFunctionParamsWithDestinationDataProvider(connectProperties, destName=" + destName + ", funcName=" + funcName + ") ************");
        HashMap<String, String> functionParams = new HashMap<String, String>();
        MyDestinationDataProvider myProvider = destinationDataProvider;
        JCoDestination dest = null;
        JCoFunction function = null;
        JCoParameterList parametersList = null;
        try {
            if (destinationDataProvider == null) {
                throw new IllegalStateException("DestinationDataProvider nie zosta\u0142 zarejestrowany");
            }
            myProvider = destinationDataProvider;
            myProvider.changeProperties(destName, connectProperties);
            dest = RfcBapiManager.executeCalls(destName);
            log.info("Pobieranie funkcji " + funcName);
            function = RfcBapiManager.getJCoFunction(dest, funcName);
            log.info("Pobieranie parametrow funkcji " + funcName);
            parametersList = function.getImportParameterList();
            if (parametersList != null) {
                JCoFieldIterator fieldIterator = parametersList.getFieldIterator();
                while (fieldIterator.hasNextField()) {
                    JCoField field = fieldIterator.nextField();
                    if (field == null) continue;
                    String name = field.getName();
                    String type = field.getTypeAsString();
                    if (StringUtils.isEmpty((CharSequence)name) || StringUtils.isEmpty((CharSequence)type)) continue;
                    functionParams.put(name, type);
                }
            }
            return functionParams;
        }
        catch (JCoException e) {
            throw e;
        }
        catch (IllegalStateException providerAlreadyRegisteredException) {
            throw providerAlreadyRegisteredException;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static HashMap<String, String> getBAPIFunctionExportsWithDestinationDataProvider(Properties connectProperties, String destName, String funcName) throws Exception, JCoException, IllegalStateException {
        log.trace("************ getBAPIFunctionExportsWithDestinationDataProvider(connectProperties, destName=" + destName + ", funcName=" + funcName + ") ************");
        HashMap<String, String> functionParams = new HashMap<String, String>();
        MyDestinationDataProvider myProvider = null;
        JCoDestination dest = null;
        JCoFunction function = null;
        JCoParameterList parametersList = null;
        try {
            if (destinationDataProvider == null) {
                throw new IllegalStateException("DestinationDataProvider nie zosta\u0142 zarejestrowany");
            }
            myProvider = destinationDataProvider;
            myProvider.changeProperties(destName, connectProperties);
            dest = RfcBapiManager.executeCalls(destName);
            log.info("Pobieranie funkcji " + funcName);
            function = RfcBapiManager.getJCoFunction(dest, funcName);
            log.info("Pobieranie parametrow funkcji " + funcName);
            parametersList = function.getExportParameterList();
            if (parametersList != null) {
                JCoFieldIterator fieldIterator = parametersList.getFieldIterator();
                while (fieldIterator.hasNextField()) {
                    JCoField field = fieldIterator.nextField();
                    if (field == null) continue;
                    String name = field.getName();
                    String type = field.getTypeAsString();
                    if (StringUtils.isEmpty((CharSequence)name) || StringUtils.isEmpty((CharSequence)type)) continue;
                    functionParams.put(name, type);
                }
            }
            return functionParams;
        }
        catch (JCoException e) {
            throw e;
        }
        catch (IllegalStateException providerAlreadyRegisteredException) {
            throw providerAlreadyRegisteredException;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static JCoStructure getBAPIFunctionImportStructureWithDestinationDataProvider(Properties connectProperties, String destName, String funcName, String structName) throws Exception, JCoException, IllegalStateException {
        log.trace("************ getBAPIFunctionImportStructureWithDestinationDataProvider(connectProperties, destName=" + destName + ", funcName=" + funcName + ", structName=" + structName + ") ************");
        JCoStructure structure = null;
        MyDestinationDataProvider myProvider = null;
        JCoDestination dest = null;
        JCoFunction function = null;
        JCoParameterList parametersList = null;
        try {
            if (destinationDataProvider == null) {
                throw new IllegalStateException("DestinationDataProvider nie zosta\u0142 zarejestrowany");
            }
            myProvider = destinationDataProvider;
            myProvider.changeProperties(destName, connectProperties);
            dest = RfcBapiManager.executeCalls(destName);
            log.info("Pobieranie funkcji " + funcName);
            function = RfcBapiManager.getJCoFunction(dest, funcName);
            log.info("Pobieranie parametrow funkcji " + funcName);
            parametersList = function.getImportParameterList();
            log.info("Pobieranie struktury " + structName);
            structure = parametersList.getStructure(structName);
            return structure;
        }
        catch (JCoException e) {
            throw e;
        }
        catch (IllegalStateException providerAlreadyRegisteredException) {
            throw providerAlreadyRegisteredException;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static JCoStructure getBAPIFunctionExportStructureWithDestinationDataProvider(Properties connectProperties, String destName, String funcName, String structName) throws Exception, JCoException, IllegalStateException {
        log.trace("************ getBAPIFunctionExportStructureWithDestinationDataProvider(connectProperties, destName=" + destName + ", funcName=" + funcName + ", structName=" + structName + ") ************");
        JCoStructure structure = null;
        MyDestinationDataProvider myProvider = null;
        JCoDestination dest = null;
        JCoFunction function = null;
        JCoParameterList parametersList = null;
        try {
            if (destinationDataProvider == null) {
                throw new IllegalStateException("DestinationDataProvider nie zosta\u0142 zarejestrowany");
            }
            myProvider = destinationDataProvider;
            myProvider.changeProperties(destName, connectProperties);
            dest = RfcBapiManager.executeCalls(destName);
            log.info("Pobieranie funkcji " + funcName);
            function = RfcBapiManager.getJCoFunction(dest, funcName);
            log.info("Pobieranie parametrow funkcji " + funcName);
            parametersList = function.getExportParameterList();
            log.info("Pobieranie struktury " + structName);
            structure = parametersList.getStructure(structName);
            return structure;
        }
        catch (JCoException e) {
            throw e;
        }
        catch (IllegalStateException providerAlreadyRegisteredException) {
            throw providerAlreadyRegisteredException;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static List<String> getBAPIFunctionTablesNamesWithDestinationDataProvider(Properties connectProperties, String destName, String funcName) throws Exception, JCoException, IllegalStateException {
        log.trace("************ getBAPIFunctionTablesNamesWithDestinationDataProvider(connectProperties, destName=" + destName + ", funcName=" + funcName + ") ************");
        ArrayList<String> funcTablesNames = new ArrayList<String>();
        MyDestinationDataProvider myProvider = null;
        JCoDestination dest = null;
        JCoFunction function = null;
        JCoParameterList results = null;
        try {
            if (destinationDataProvider == null) {
                throw new IllegalStateException("DestinationDataProvider nie zosta\u0142 zarejestrowany");
            }
            myProvider = destinationDataProvider;
            myProvider.changeProperties(destName, connectProperties);
            dest = RfcBapiManager.executeCalls(destName);
            log.info("Downloading functions " + funcName);
            function = RfcBapiManager.getJCoFunction(dest, funcName);
            log.info("Retrieve table names for function results " + funcName);
            results = function.getTableParameterList();
            if (results != null) {
                JCoFieldIterator tablesIter = results.getFieldIterator();
                while (tablesIter.hasNextField()) {
                    String funcTableName;
                    JCoField table = tablesIter.nextField();
                    if (table == null || StringUtils.isEmpty((CharSequence)(funcTableName = table.getName()))) continue;
                    funcTablesNames.add(funcTableName);
                }
            }
            return funcTablesNames;
        }
        catch (JCoException e) {
            throw e;
        }
        catch (IllegalStateException providerAlreadyRegisteredException) {
            throw providerAlreadyRegisteredException;
        }
        catch (Exception e) {
            throw e;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getBAPITableColumnNamesWithDestinationDataProvider(Properties connectProperties, String destName, String funcName, String tableName) throws Exception, JCoException, IllegalStateException {
        JCoFieldIterator columnIter;
        log.trace("************ getBAPITableColumnNamesWithDestinationDataProvider(connectProperties, destName=" + destName + ", funcName=" + funcName + ", tableName=" + tableName + ") ************");
        JCoFieldIterator columnNames = new ArrayList();
        MyDestinationDataProvider myProvider = null;
        JCoDestination dest = null;
        JCoFunction function = null;
        JCoParameterList results = null;
        JCoTable table = null;
        try {
            if (destinationDataProvider == null) {
                throw new IllegalStateException("DestinationDataProvider nie zosta\u0142 zarejestrowany");
            }
            myProvider = destinationDataProvider;
            myProvider.changeProperties(destName, connectProperties);
            dest = RfcBapiManager.executeCalls(destName);
            JCoContext.begin((JCoDestination)dest);
            log.info("Downloading functions " + funcName);
            function = RfcBapiManager.getJCoFunction(dest, funcName);
            log.info("Execute function" + funcName);
            function.execute(dest);
            RfcBapiManager.commitTransaction(dest);
            log.info("Retrieve table names for function results " + funcName);
            results = function.getTableParameterList();
            if (results != null) {
                results = function.getTableParameterList();
                log.info("Table download " + tableName);
                table = results.getTable(tableName);
                log.info("Retrieving table column names " + tableName);
                columnIter = table.getFieldIterator();
                while (columnIter.hasNextField()) {
                    String columnName;
                    JCoField column = columnIter.nextField();
                    if (column == null || StringUtils.isEmpty((CharSequence)(columnName = column.getName()))) continue;
                    columnNames.add(columnName);
                }
            }
            columnIter = columnNames;
        }
        catch (JCoException e) {
            try {
                if (dest == null) throw e;
                RfcBapiManager.rollbackTransaction(dest);
                throw e;
                catch (IllegalStateException providerAlreadyRegisteredException) {
                    throw providerAlreadyRegisteredException;
                }
                catch (Exception e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                if (dest == null) throw throwable;
                JCoContext.end(dest);
                throw throwable;
            }
        }
        if (dest == null) return columnIter;
        JCoContext.end((JCoDestination)dest);
        return columnIter;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String showBAPITableWithDestinationDataProvider(Properties connectProperties, String destName, String funcName, String tableName, HashMap<String, Object> importParameters, HashMap<String, Object> tableParameters) throws Exception, JCoException, IllegalStateException {
        String paramsIter;
        log.trace("************ showBAPITableWithDestinationDataProvider(connectProperties, destName=" + destName + ", funcName=" + funcName + ", tableName=" + tableName + ", importParameters, tableParameters) ************");
        String tableContent = "";
        MyDestinationDataProvider myProvider = null;
        JCoDestination dest = null;
        JCoFunction function = null;
        JCoParameterList importParametersList = null;
        JCoParameterList tableParametersList = null;
        JCoParameterList results = null;
        JCoTable table = null;
        try {
            Object paramValue;
            if (destinationDataProvider == null) {
                throw new IllegalStateException("DestinationDataProvider nie zosta\u0142 zarejestrowany");
            }
            myProvider = destinationDataProvider;
            myProvider.changeProperties(destName, connectProperties);
            dest = RfcBapiManager.executeCalls(destName);
            JCoContext.begin((JCoDestination)dest);
            log.info("Downloading functions " + funcName);
            function = RfcBapiManager.getJCoFunction(dest, funcName);
            if (importParameters != null && importParameters.size() > 0) {
                log.info("Downloading function parameters " + funcName);
                importParametersList = function.getImportParameterList();
                log.info("Supplementing the function parameters " + funcName);
                for (String paramName : importParameters.keySet()) {
                    paramValue = importParameters.get(paramName);
                    importParametersList.setValue(paramName, paramValue);
                }
            }
            if (tableParameters != null && tableParameters.size() > 0) {
                log.info("Retrieving tabular parameters of functions" + funcName);
                tableParametersList = function.getTableParameterList();
                log.info("Supplementing the tabular parameters of the function " + funcName);
                for (String paramName : tableParameters.keySet()) {
                    paramValue = tableParameters.get(paramName);
                    tableParametersList.setValue(paramName, paramValue);
                }
            }
            log.info("Execute function " + funcName);
            function.execute(dest);
            RfcBapiManager.commitTransaction(dest);
            results = function.getTableParameterList();
            log.info("Table download " + tableName);
            table = results.getTable(tableName);
            tableContent = table.toString();
            paramsIter = tableContent;
        }
        catch (JCoException e) {
            try {
                if (dest == null) throw e;
                RfcBapiManager.rollbackTransaction(dest);
                throw e;
                catch (IllegalStateException providerAlreadyRegisteredException) {
                    throw providerAlreadyRegisteredException;
                }
                catch (Exception e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                if (dest == null) throw throwable;
                JCoContext.end(dest);
                throw throwable;
            }
        }
        if (dest == null) return paramsIter;
        JCoContext.end((JCoDestination)dest);
        return paramsIter;
    }

    public static JCoTable getBAPITableParamWithDestinationDataProvider(Properties connectProperties, String destName, String funcName, String tableName) throws Exception, JCoException, IllegalStateException {
        log.trace("************ getBAPITableParamWithDestinationDataProvider(connectProperties, destName=" + destName + ", funcName=" + funcName + ", tableName=" + tableName + ") ************");
        MyDestinationDataProvider myProvider = null;
        JCoDestination dest = null;
        JCoFunction function = null;
        JCoParameterList results = null;
        JCoTable table = null;
        try {
            if (destinationDataProvider == null) {
                throw new IllegalStateException("DestinationDataProvider nie zosta\u0142 zarejestrowany");
            }
            myProvider = destinationDataProvider;
            myProvider.changeProperties(destName, connectProperties);
            dest = RfcBapiManager.executeCalls(destName);
            log.info("Downloading function " + funcName);
            function = RfcBapiManager.getJCoFunction(dest, funcName);
            results = function.getTableParameterList();
            log.info("Table download " + tableName);
            table = results.getTable(tableName);
        }
        catch (JCoException e) {
            throw e;
        }
        catch (IllegalStateException providerAlreadyRegisteredException) {
            throw providerAlreadyRegisteredException;
        }
        catch (Exception e) {
            throw e;
        }
        return table;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<HashMap<String, Object>> useBAPIWithDestinationDataProvider(Properties connectProperties, String destName, String funcName, String resultType, String tableName, HashMap<String, Object> importParameters, HashMap<String, Object> tableParameters, List<String> whatToGet) throws Exception, JCoException, IllegalStateException {
        log.trace("************ useBAPIWithDestinationDataProvider(connectProperties, destName=" + destName + ", funcName=" + funcName + ", resultType=" + resultType + ", tableName=" + tableName + ", importParameters, tableParameters, whatToGet) ************");
        long startTime = new Date().getTime();
        ArrayList<HashMap<String, Object>> resultsList = new ArrayList<HashMap<String, Object>>();
        HashMap<String, Object> oneResult = null;
        MyDestinationDataProvider myProvider = null;
        JCoDestination dest = null;
        JCoFunction function = null;
        JCoParameterList importParametersList = null;
        JCoParameterList tableParametersList = null;
        JCoParameterList results = null;
        JCoTable table = null;
        RETURNTABLE = new ArrayList<HashMap<String, Object>>();
        try {
            Object paramValue;
            if (destinationDataProvider == null) {
                throw new IllegalStateException("DestinationDataProvider nie zosta\u0142 zarejestrowany");
            }
            myProvider = destinationDataProvider;
            myProvider.changeProperties(destName, connectProperties);
            dest = RfcBapiManager.executeCalls(destName);
            JCoContext.begin((JCoDestination)dest);
            log.info("Downloading function " + funcName);
            function = RfcBapiManager.getJCoFunction(dest, funcName);
            if (importParameters != null && importParameters.size() > 0) {
                log.info("Downloading function parameters " + funcName);
                importParametersList = function.getImportParameterList();
                log.info("Supplementing the function parameters " + funcName);
                for (String string : importParameters.keySet()) {
                    paramValue = importParameters.get(string);
                    importParametersList.setValue(string, paramValue);
                }
            }
            if (tableParameters != null && tableParameters.size() > 0) {
                log.info("Retrieving tabular parameters of functions " + funcName);
                tableParametersList = function.getTableParameterList();
                log.info("Supplementing the tabular parameters of the function " + funcName);
                for (String string : tableParameters.keySet()) {
                    paramValue = tableParameters.get(string);
                    tableParametersList.setValue(string, paramValue);
                }
            }
            log.info("Execute function " + funcName);
            function.execute(dest);
            RfcBapiManager.commitTransaction(dest);
            RfcBapiManager.setReturnTable(function, funcName);
            log.info("Downloading the results of the function execution " + funcName);
            if (resultType != null && resultType.equalsIgnoreCase("TABLE")) {
                results = function.getTableParameterList();
                log.info("Table download " + tableName);
                table = results.getTable(tableName);
                table.firstRow();
                log.info("Downloading next table records " + tableName);
                for (int i = 0; i < table.getNumRows(); ++i) {
                    try {
                        table.setRow(i);
                        oneResult = new HashMap();
                        if (whatToGet != null && whatToGet.size() > 0) {
                            for (String resultName : whatToGet) {
                                Object resultValue = table.getValue(resultName);
                                oneResult.put(resultName, resultValue);
                            }
                        } else {
                            JCoFieldIterator jCoFieldIterator = table.getFieldIterator();
                            while (jCoFieldIterator.hasNextField()) {
                                JCoField field = jCoFieldIterator.nextField();
                                if (field == null) continue;
                                String fieldName = field.getName();
                                Object fieldValue = table.getValue(fieldName);
                                oneResult.put(fieldName, fieldValue);
                            }
                        }
                        resultsList.add(oneResult);
                        continue;
                    }
                    catch (Exception exception) {
                        log.error(exception.getMessage());
                    }
                }
            } else if (resultType != null && resultType.equalsIgnoreCase("FIELDS")) {
                results = function.getExportParameterList();
                oneResult = new HashMap<String, Object>();
                if (whatToGet != null && whatToGet.size() > 0) {
                    for (String string : whatToGet) {
                        Object resultValue = results.getValue(string);
                        oneResult.put(string, resultValue);
                    }
                } else {
                    JCoFieldIterator iterator = results.getFieldIterator();
                    while (iterator.hasNextField()) {
                        JCoField jCoField = iterator.nextField();
                        if (jCoField == null) continue;
                        String fieldName = jCoField.getName();
                        Object fieldValue = jCoField.getValue();
                        oneResult.put(fieldName, fieldValue);
                    }
                }
                resultsList.add(oneResult);
            } else {
                if (resultType != null) throw new Exception("Unknown expected type of function execution result " + funcName);
                log.info("The type of result to be downloaded has not been defined");
            }
            long stopTime = new Date().getTime();
            log.info("Execute function " + funcName + " ended. Duration: " + RfcBapiManager.RFCExecutionDuration(stopTime - startTime));
        }
        catch (JCoException e) {
            try {
                RfcBapiManager.setReturnTable(function, funcName);
                if (dest == null) throw e;
                RfcBapiManager.rollbackTransaction(dest);
                throw e;
                catch (IllegalStateException providerAlreadyRegisteredException) {
                    RfcBapiManager.setReturnTable(function, funcName);
                    throw providerAlreadyRegisteredException;
                }
                catch (Exception e2) {
                    RfcBapiManager.setReturnTable(function, funcName);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                if (dest == null) throw throwable;
                JCoContext.end(dest);
                throw throwable;
            }
        }
        if (dest == null) return resultsList;
        JCoContext.end((JCoDestination)dest);
        return resultsList;
    }
}

