/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.biofarm.sap;

import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFieldIterator;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.suncode.plugin.biofarm.dto.DocumentHeader;
import com.suncode.plugin.biofarm.hook.MyDestinationDataProvider;
import com.suncode.plugin.biofarm.sap.RfcBapiManager;
import com.suncode.pwfl.search.CountedResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RfcBapiBiofarmManager
extends RfcBapiManager {
    private static final Logger log = LoggerFactory.getLogger(RfcBapiBiofarmManager.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CountedResult<Map<String, String>> useBAPIWithDestinationDataProvider(Properties connectProperties, String destName, String funcName, String tableName, Map<String, Object> importParameters) throws Exception, JCoException, IllegalStateException {
        log.trace("************ useBAPIWithDestinationDataProvider(connectProperties, destName=" + destName + ", funcName=" + funcName + ", tableName=" + tableName + ", importParameters) ************");
        long startTime = new Date().getTime();
        CountedResult cResults = new CountedResult();
        ArrayList results = new ArrayList();
        HashMap<String, String> oneResult = null;
        MyDestinationDataProvider myProvider = destinationDataProvider;
        JCoDestination dest = null;
        JCoFunction function = null;
        JCoParameterList importParametersList = null;
        JCoTable table = null;
        JCoParameterList exportParametersList = null;
        RETURNTABLE = new ArrayList();
        try {
            if (destinationDataProvider == null) {
                throw new IllegalStateException("DestinationDataProvider nie zosta\u0142 zarejestrowany");
            }
            myProvider = destinationDataProvider;
            myProvider.changeProperties(destName, connectProperties);
            dest = RfcBapiBiofarmManager.executeCalls(destName);
            JCoContext.begin((JCoDestination)dest);
            log.info("Pobieranie funkcji " + funcName);
            function = RfcBapiBiofarmManager.getJCoFunction(dest, funcName);
            if (importParameters != null && importParameters.size() > 0) {
                log.info("Pobieranie parametrow funkcji " + funcName);
                importParametersList = function.getImportParameterList();
                log.info("Uzupelnianie parametrow funkcji " + funcName);
                for (String paramName : importParameters.keySet()) {
                    Object paramValue = importParameters.get(paramName);
                    log.debug("paramName=" + paramName + " paramValue=" + String.valueOf(paramValue));
                    importParametersList.setValue(paramName, paramValue);
                }
            }
            log.info("Wykonanie funkcji " + funcName);
            function.execute(dest);
            RfcBapiBiofarmManager.commitTransaction(dest);
            RfcBapiBiofarmManager.setReturnTable(function, funcName);
            log.info("Pobieranie wynikow wykonania funkcji " + funcName);
            log.info("\n" + function.toString());
            exportParametersList = function.getExportParameterList();
            AbapException[] exceptionList = function.getExceptionList();
            if (exportParametersList != null) {
                table = exportParametersList.getTable(tableName);
                table.firstRow();
                log.info("Pobieranie kolejnych rekordow tablicy " + tableName);
                for (int i = 0; i < table.getNumRows(); ++i) {
                    table.setRow(i);
                    oneResult = new HashMap<String, String>();
                    JCoFieldIterator iterator = table.getFieldIterator();
                    while (iterator.hasNextField()) {
                        String fieldName;
                        JCoField field = iterator.nextField();
                        if (field == null || !StringUtils.isNotBlank((CharSequence)(fieldName = field.getName()))) continue;
                        String fieldValue = table.getString(fieldName);
                        oneResult.put(fieldName, fieldValue);
                    }
                    if (oneResult.isEmpty()) continue;
                    results.add(oneResult);
                }
            }
            if (exceptionList != null) {
                for (AbapException abapException : exceptionList) {
                    log.error("SAP exception for " + funcName);
                    log.error(abapException.getMessage(), (Throwable)abapException);
                }
            }
            long stopTime = new Date().getTime();
            log.info("Wykonywanie funkcji " + funcName + " zakonczone. Czas trwania: " + RfcBapiBiofarmManager.RFCExecutionDuration(stopTime - startTime));
        }
        catch (JCoException e) {
            try {
                RfcBapiBiofarmManager.setReturnTable(function, funcName);
                if (dest == null) throw e;
                RfcBapiBiofarmManager.rollbackTransaction(dest);
                throw e;
                catch (IllegalStateException providerAlreadyRegisteredException) {
                    RfcBapiBiofarmManager.setReturnTable(function, funcName);
                    throw providerAlreadyRegisteredException;
                }
                catch (Exception e2) {
                    RfcBapiBiofarmManager.setReturnTable(function, funcName);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                if (dest == null) throw throwable;
                JCoContext.end(dest);
                throw throwable;
            }
        }
        if (dest != null) {
            JCoContext.end((JCoDestination)dest);
        }
        cResults.setData(results);
        cResults.setTotal((long)results.size());
        return cResults;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JCoParameterList getExportParamUsedBAPI(Properties connectProperties, String destName, String funcName, Map<String, Object> importParameters) throws Exception, JCoException, IllegalStateException {
        log.trace("************ getExportParamUsedBAPI(connectProperties, destName=" + destName + ", funcName=" + funcName + ", importParameters) ************");
        long startTime = new Date().getTime();
        MyDestinationDataProvider myProvider = null;
        JCoDestination dest = null;
        JCoFunction function = null;
        JCoParameterList importParametersList = null;
        JCoParameterList exportParametersList = null;
        RETURNTABLE = new ArrayList();
        try {
            if (destinationDataProvider == null) {
                throw new IllegalStateException("DestinationDataProvider nie zosta\u0142 zarejestrowany");
            }
            myProvider = destinationDataProvider;
            myProvider.changeProperties(destName, connectProperties);
            dest = RfcBapiBiofarmManager.executeCalls(destName);
            JCoContext.begin((JCoDestination)dest);
            log.info("Pobieranie funkcji " + funcName);
            function = RfcBapiBiofarmManager.getJCoFunction(dest, funcName);
            if (importParameters != null && importParameters.size() > 0) {
                log.info("Pobieranie parametrow funkcji " + funcName);
                importParametersList = function.getImportParameterList();
                log.info("Uzupelnianie parametrow funkcji " + funcName);
                for (String paramName : importParameters.keySet()) {
                    Object paramValue = importParameters.get(paramName);
                    log.debug("paramName=" + paramName + " paramValue=" + String.valueOf(paramValue));
                    importParametersList.setValue(paramName, paramValue);
                }
                log.debug("Improt parameter lsit for FUNC:\t" + funcName);
                log.debug(function.getImportParameterList().toString());
            }
            log.info("Wykonanie funkcji " + funcName);
            function.execute(dest);
            RfcBapiBiofarmManager.commitTransaction(dest);
            RfcBapiBiofarmManager.setReturnTable(function, funcName);
            log.info("Pobieranie wynikow wykonania funkcji " + funcName);
            exportParametersList = function.getExportParameterList();
            long stopTime = new Date().getTime();
            log.info("Wykonywanie funkcji " + funcName + " zakonczone. Czas trwania: " + RfcBapiBiofarmManager.RFCExecutionDuration(stopTime - startTime));
            log.debug("Return param");
            JCoFieldIterator iterator = exportParametersList.getFieldIterator();
            while (iterator.hasNextField()) {
                JCoField field = iterator.nextField();
                if (field == null) continue;
                log.debug(field.getName() + "\t" + field.getDescription() + "\t" + String.valueOf(field.getValue()));
            }
        }
        catch (JCoException e) {
            try {
                RfcBapiBiofarmManager.setReturnTable(function, funcName);
                if (dest == null) throw e;
                RfcBapiBiofarmManager.rollbackTransaction(dest);
                throw e;
                catch (IllegalStateException providerAlreadyRegisteredException) {
                    RfcBapiBiofarmManager.setReturnTable(function, funcName);
                    throw providerAlreadyRegisteredException;
                }
                catch (Exception e2) {
                    RfcBapiBiofarmManager.setReturnTable(function, funcName);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                if (dest == null) throw throwable;
                JCoContext.end(dest);
                throw throwable;
            }
        }
        if (dest == null) return exportParametersList;
        JCoContext.end((JCoDestination)dest);
        return exportParametersList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void test(Properties connectProperties, String destName, String funcName, String tableName, DocumentHeader importParamDocHeader) throws JCoException {
        log.trace("************ useBAPIWithDestinationDataProvider(connectProperties, destName=" + destName + ", funcName=" + funcName + ", tableName=" + tableName + ", importParameters) ************");
        long startTime = new Date().getTime();
        CountedResult cResults = new CountedResult();
        ArrayList results = new ArrayList();
        Object oneResult = null;
        MyDestinationDataProvider myProvider = null;
        JCoDestination dest = null;
        JCoFunction function = null;
        JCoParameterList importParametersList = null;
        Object table = null;
        JCoParameterList exportParametersList = null;
        RETURNTABLE = new ArrayList();
        try {
            if (destinationDataProvider == null) {
                throw new IllegalStateException("DestinationDataProvider nie zosta\u0142 zarejestrowany");
            }
            myProvider = destinationDataProvider;
            myProvider.changeProperties(destName, connectProperties);
            dest = RfcBapiBiofarmManager.executeCalls(destName);
            JCoContext.begin((JCoDestination)dest);
            log.info("Pobieranie funkcji " + funcName);
            function = RfcBapiBiofarmManager.getJCoFunction(dest, funcName);
            log.info("Pobieranie parametrow funkcji " + funcName);
            importParametersList = function.getImportParameterList();
            JCoStructure structureHeader = importParametersList.getStructure("DOCUMENT_HEADER");
            RfcBapiBiofarmManager.buildStructureDocumentheader(structureHeader, importParamDocHeader);
            importParametersList.setValue("DOCUMENT_HEADER", structureHeader);
            log.info("Wykonanie funkcji " + funcName);
            function.execute(dest);
            RfcBapiBiofarmManager.commitTransaction(dest);
            RfcBapiBiofarmManager.setReturnTable(function, funcName);
            log.info("Pobieranie wynikow wykonania funkcji " + funcName);
            exportParametersList = function.getExportParameterList();
            Object awkey = exportParametersList.getValue("AWKEY");
            log.debug("AWKEY:" + String.valueOf(awkey));
            JCoTable tableErrorMsg = exportParametersList.getTable("ERROR_MSG_TBL");
            tableErrorMsg.firstRow();
            log.info("Pobieranie kolejnych rekordow tablicy ERROR_MSG_TBL");
            for (int i = 0; i < tableErrorMsg.getNumRows(); ++i) {
                tableErrorMsg.setRow(i);
                JCoFieldIterator iterator = tableErrorMsg.getFieldIterator();
                while (iterator.hasNextField()) {
                    String fieldName;
                    JCoField field = iterator.nextField();
                    if (field == null || !StringUtils.isNotBlank((CharSequence)(fieldName = field.getName()))) continue;
                    String fieldValue = tableErrorMsg.getString(fieldName);
                    log.debug(fieldName + " :\t" + fieldValue);
                }
            }
            log.debug("\n\nEND TEST\n");
        }
        catch (JCoException e) {
            try {
                RfcBapiBiofarmManager.setReturnTable(function, funcName);
                if (dest == null) throw e;
                RfcBapiBiofarmManager.rollbackTransaction(dest);
                throw e;
                catch (IllegalStateException providerAlreadyRegisteredException) {
                    RfcBapiBiofarmManager.setReturnTable(function, funcName);
                    throw providerAlreadyRegisteredException;
                }
                catch (Exception e2) {
                    RfcBapiBiofarmManager.setReturnTable(function, funcName);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                if (dest == null) throw throwable;
                JCoContext.end(dest);
                throw throwable;
            }
        }
        if (dest == null) return;
        JCoContext.end((JCoDestination)dest);
        return;
    }

    public static List<Map<String, Object>> convertJCoTable(JCoTable table) {
        log.debug("ExportParameter Table:");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        table.firstRow();
        for (int i = 0; i < table.getNumRows(); ++i) {
            table.setRow(i);
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            JCoFieldIterator iterator = table.getFieldIterator();
            while (iterator.hasNextField()) {
                String fieldName;
                JCoField field = iterator.nextField();
                if (field == null || !StringUtils.isNotBlank((CharSequence)table.getString(fieldName = field.getName()))) continue;
                Object fieldValue = table.getValue(fieldName);
                log.debug(fieldName + " :\t" + table.getString(fieldName));
                oneRow.put(fieldName, fieldValue);
            }
            result.add(oneRow);
        }
        return result;
    }

    private static void showStructure(JCoStructure structureHeader) {
        if (structureHeader != null) {
            JCoFieldIterator structIter = structureHeader.getFieldIterator();
            while (structIter.hasNextField()) {
                JCoField field = structIter.nextField();
                if (field == null) continue;
                log.info("Structure field name: " + field.getName() + " value: " + String.valueOf(field.getValue()) + " type: " + field.getTypeAsString());
            }
        } else {
            log.warn("Nie znaleziono struktury ");
        }
    }

    private static void buildStructureDocumentheader(JCoStructure structure, DocumentHeader docHeaderDto) {
        structure.setValue("BUKRS", docHeaderDto.getBukrs());
        structure.setValue("DOCUMENT_ID", docHeaderDto.getDocuentId());
        structure.setValue("FI_MM_FLAG", docHeaderDto.getFi_mm_flag());
        structure.setValue("DOC_DATE", (Object)docHeaderDto.getDoc_date());
        structure.setValue("PMNTTRMS", docHeaderDto.getPmnttrms());
        structure.setValue("CURRENCY", docHeaderDto.getCurrency());
        structure.setValue("EXCH_RATE", (Object)docHeaderDto.getExch_rate());
        structure.setValue("GROSS_AMOUNT", (Object)docHeaderDto.getGross_amount());
        structure.setValue("REF_DOC_NO", docHeaderDto.getRef_doc_no());
        structure.setValue("ORGIN_REF_DOC_NO", docHeaderDto.getOrgin_ref_doc_no());
        structure.setValue("DOC_TYPE", docHeaderDto.getDoc_type());
        structure.setValue("PSTNG_DATE", (Object)docHeaderDto.getPstng_date());
        structure.setValue("INVOICE_IND", docHeaderDto.getInvoice_ind());
        structure.setValue("LIFNR", docHeaderDto.getLifnr());
        structure.setValue("BVTYP", docHeaderDto.getBvtyp());
        structure.setValue("PMNT_BLOCK", docHeaderDto.getPmnt_block());
        structure.setValue("ITEM_TEXT", docHeaderDto.getItem_text());
        structure.setValue("BLINE_DATE", (Object)docHeaderDto.getBline_Date());
        structure.setValue("VATDATE", (Object)docHeaderDto.getVatdate());
        structure.setValue("PYMT_METH", docHeaderDto.getPymtmeth());
    }

    public static JCoTable getBAPIFunctionImportTableWithDestinationDataProvider(Properties connectProperties, String destName, String funcName, String structName) throws Exception, JCoException, IllegalStateException {
        log.trace("************ getBAPIFunctionImportStructureWithDestinationDataProvider(connectProperties, destName=" + destName + ", funcName=" + funcName + ", structName=" + structName + ") ************");
        JCoTable table = null;
        MyDestinationDataProvider myProvider = null;
        JCoDestination dest = null;
        JCoFunction function = null;
        JCoParameterList parametersList = null;
        try {
            if (destinationDataProvider == null) {
                throw new IllegalStateException("DestinationDataProvider nie zosta\u0142 zarejestrowany");
            }
            myProvider = destinationDataProvider;
            myProvider.changeProperties(destName, connectProperties);
            dest = RfcBapiBiofarmManager.executeCalls(destName);
            log.info("Pobieranie funkcji " + funcName);
            function = RfcBapiBiofarmManager.getJCoFunction(dest, funcName);
            log.info("Pobieranie parametrow funkcji " + funcName);
            parametersList = function.getImportParameterList();
            log.info("Pobieranie struktury " + structName);
            table = parametersList.getTable(structName);
            return table;
        }
        catch (JCoException e) {
            throw e;
        }
        catch (IllegalStateException providerAlreadyRegisteredException) {
            throw providerAlreadyRegisteredException;
        }
        catch (Exception e) {
            throw e;
        }
    }
}

