/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.biofarm.hook;

import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import com.suncode.plugin.biofarm.hook.MyDestinationDataProvider;
import com.suncode.plugin.biofarm.sap.RfcBapiManager;
import com.suncode.plugin.framework.PluginsException;
import com.suncode.plugin.framework.support.PluginHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapProviderHook
implements PluginHook {
    private static final Logger log = LoggerFactory.getLogger(SapProviderHook.class);

    public void start() throws PluginsException {
        if (RfcBapiManager.destinationDataProvider == null) {
            try {
                RfcBapiManager.destinationDataProvider = new MyDestinationDataProvider();
                Environment.registerDestinationDataProvider((DestinationDataProvider)RfcBapiManager.destinationDataProvider);
                log.info("Registered DestinationDataProvider");
            }
            catch (IllegalStateException providerAlreadyRegisteredException) {
                throw new IllegalStateException("DestinationDataProvider has not been checked out");
            }
        }
        log.debug("\n\n\n\n");
    }

    public void stop() throws PluginsException {
        log.debug("Unregister Destination Data Provider");
        if (RfcBapiManager.destinationDataProvider != null) {
            try {
                Environment.unregisterDestinationDataProvider((DestinationDataProvider)RfcBapiManager.destinationDataProvider);
                if (!Environment.isDestinationDataProviderRegistered()) {
                    RfcBapiManager.destinationDataProvider = null;
                }
                log.debug("Unregistered connection to SAP");
            }
            catch (IllegalStateException e) {
                log.error("Failed to unregister connection to SAP: ", (Throwable)e);
            }
        } else {
            log.debug("Failed to unregister connection to SAP: destinationDataProvider is null");
        }
    }
}

