/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.biofarm.hook;

import com.sap.conn.jco.ext.DataProviderException;
import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import java.util.HashMap;
import java.util.Properties;

public class MyDestinationDataProvider
implements DestinationDataProvider {
    private DestinationDataEventListener eL;
    private HashMap<String, Properties> secureDBStorage = new HashMap();

    public Properties getDestinationProperties(String destinationName) {
        try {
            Properties p = this.secureDBStorage.get(destinationName);
            if (p != null) {
                if (p.isEmpty()) {
                    throw new DataProviderException(DataProviderException.Reason.INVALID_CONFIGURATION, "Destination configuration is incorrect", null);
                }
                return p;
            }
            return null;
        }
        catch (RuntimeException re) {
            throw new DataProviderException(DataProviderException.Reason.INTERNAL_ERROR, (Throwable)re);
        }
    }

    public void setDestinationDataEventListener(DestinationDataEventListener eventListener) {
        this.eL = eventListener;
    }

    public boolean supportsEvents() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeProperties(String destName, Properties properties) {
        HashMap<String, Properties> hashMap = this.secureDBStorage;
        synchronized (hashMap) {
            if (properties == null) {
                if (this.secureDBStorage.remove(destName) != null) {
                    this.eL.deleted(destName);
                }
            } else {
                this.secureDBStorage.put(destName, properties);
                this.eL.updated(destName);
            }
        }
    }
}

