/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.biofarm.db.services;

import com.suncode.plugin.biofarm.db.dao.SAP_SynchDateDao;
import com.suncode.plugin.biofarm.db.services.SAP_SynchDateService;
import com.suncode.plugin.biofarm.db.tables.SAP_SynchDate;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sapSynchDate")
public class SAP_SynchDateServiceImpl
implements SAP_SynchDateService {
    private static final String FORMATDATE = "yyyyMMdd";
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private SAP_SynchDateDao dao;

    @Override
    @Transactional
    public Date getDate(String functionName) {
        SAP_SynchDate row = this.getEntityByfunctionName(functionName.toUpperCase());
        Date untilDate = new Date(0L);
        if (row == null) {
            this.saveOrUpdate(functionName, untilDate);
        } else {
            java.sql.Date date = row.getDate();
            untilDate = new Date(date.getTime());
        }
        return untilDate;
    }

    @Override
    @Transactional
    public String getFormaterDate(String functionName) {
        SAP_SynchDate row = this.getEntityByfunctionName(functionName.toUpperCase());
        Date untilDate = new Date(0L);
        if (row == null) {
            this.saveOrUpdate(functionName, untilDate);
        } else {
            java.sql.Date date = row.getDate();
            untilDate = new Date(date.getTime());
        }
        SimpleDateFormat f = new SimpleDateFormat(FORMATDATE);
        return f.format(untilDate);
    }

    @Override
    @Transactional
    public void saveOrUpdate(String functionName) {
        Date date = new Date();
        this.saveOrUpdate(functionName, date);
    }

    private SAP_SynchDate getEntityByfunctionName(String functionName) {
        return (SAP_SynchDate)this.sessionFactory.getCurrentSession().byNaturalId(SAP_SynchDate.class).using("bapiName", (Object)functionName).load();
    }

    @Override
    @Transactional
    public void saveOrUpdate(String functionName, Date date) {
        SAP_SynchDate entity = this.getEntityByfunctionName(functionName);
        java.sql.Date sqlDate = new java.sql.Date(date.getTime());
        if (entity == null) {
            entity = new SAP_SynchDate();
            entity.setBapiName(functionName.toUpperCase());
            entity.setDate(sqlDate);
            this.dao.save(entity);
        } else {
            entity.setDate(sqlDate);
            this.dao.update(entity);
        }
    }
}

