/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.biofarm.db.services;

import com.suncode.plugin.biofarm.db.dao.DBSAP_ZIKZVendorsDao;
import com.suncode.plugin.biofarm.db.services.DBSAP_ZIKZVendorsService;
import com.suncode.plugin.biofarm.db.tables.DBSAP_Vendors;
import com.suncode.plugin.biofarm.db.tables.DBSAP_ZIKZVendors;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dbSAP_ZIKZVendorsService")
@Transactional
public class DBSAP_ZIKZVendorsServiceImpl
extends EditableServiceImpl<DBSAP_ZIKZVendors, Long, DBSAP_ZIKZVendorsDao>
implements DBSAP_ZIKZVendorsService {
    private static final Logger log = LoggerFactory.getLogger(DBSAP_ZIKZVendorsServiceImpl.class);
    private static final String BUKR = "BUKR";
    private static final String LIFNR = "LIFNR";
    private static final String NAME1 = "NAME1";
    private static final String NAME2 = "NAME2";
    @Autowired
    private SessionFactory sessionFactory;

    @Autowired
    public void setDao(DBSAP_ZIKZVendorsDao dao) {
        this.dao = dao;
    }

    @Override
    public void saveAll(List<DBSAP_ZIKZVendors> entities) {
        log.debug("SaveOrUpdate Data");
        for (DBSAP_ZIKZVendors dbsap_Vendors : entities) {
            this.sessionFactory.getCurrentSession().saveOrUpdate((Object)dbsap_Vendors);
        }
    }

    @Override
    public DBSAP_ZIKZVendors build(Map<String, String> data) {
        String lifnr = data.get(LIFNR);
        String bukr = data.get(BUKR);
        String name1 = data.get(NAME1);
        String name2 = data.get(NAME2);
        DBSAP_ZIKZVendors entity = this.getEntityByfield(lifnr, bukr);
        if (entity == null) {
            entity = new DBSAP_ZIKZVendors();
            entity.setLifnr(lifnr);
            entity.setBukr(bukr);
        }
        entity.setName1(name1);
        entity.setName2(name2);
        return entity;
    }

    @Override
    public List<DBSAP_ZIKZVendors> buildAll(List<Map<String, String>> datas) {
        log.debug("Data conversion");
        ArrayList<DBSAP_ZIKZVendors> returnEntites = new ArrayList<DBSAP_ZIKZVendors>();
        for (Map<String, String> data : datas) {
            returnEntites.add(this.build(data));
        }
        return returnEntites;
    }

    @Override
    public void updateTable(List<Map<String, String>> datas) {
        this.saveAll(this.buildAll(datas));
    }

    @Override
    public void deleteAll() {
        log.debug("Clear table: " + DBSAP_Vendors.class.getName());
        String stringQuery = "DELETE FROM " + DBSAP_Vendors.class.getName();
        Query query = this.sessionFactory.getCurrentSession().createQuery(stringQuery);
        query.executeUpdate();
    }

    private DBSAP_ZIKZVendors getEntityByfield(String lifnr, String bukr) {
        return (DBSAP_ZIKZVendors)this.sessionFactory.getCurrentSession().byNaturalId(DBSAP_ZIKZVendors.class).using("lifnr", (Object)lifnr).using("bukr", (Object)bukr).load();
    }
}

